/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.demo.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DemoComputeTask
implements ComputeTask<Void, Integer> {
    private static final long serialVersionUID = 0L;
    private static final Random rnd = new Random();

    @NotNull
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Void arg) throws IgniteException {
        HashMap<DemoComputeJob, ClusterNode> map = new HashMap<DemoComputeJob, ClusterNode>(subgrid.size());
        for (ClusterNode node : subgrid) {
            for (int i = 0; i < Math.max(1, rnd.nextInt(5)); ++i) {
                map.put(new DemoComputeJob(), node);
            }
        }
        return map;
    }

    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
        return ComputeJobResultPolicy.REDUCE;
    }

    @Nullable
    public Integer reduce(List<ComputeJobResult> results) throws IgniteException {
        int sum = 0;
        for (ComputeJobResult r : results) {
            if (r.isCancelled() || r.getException() != null) continue;
            int jobRes = (Integer)r.getData();
            sum += jobRes;
        }
        return sum;
    }

    private static class DemoComputeJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;

        private DemoComputeJob() {
        }

        public Object execute() throws IgniteException {
            try {
                Thread.sleep(rnd.nextInt(50));
                return rnd.nextInt(10000);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }

        public String toString() {
            return S.toString(DemoComputeJob.class, (Object)((Object)this));
        }
    }
}

