/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.demo.service;

import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.console.demo.AgentDemoUtils;
import org.apache.ignite.console.demo.service.DemoCachesLoadService;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceContext;

public class DemoRandomCacheLoadService
implements Service {
    @IgniteInstanceResource
    private Ignite ignite;
    private ScheduledExecutorService cachePool;
    public static final String RANDOM_CACHE_NAME = "RandomCache";
    private static final int RND_CNT = 1024;
    private static final Random rnd = new Random();
    private final int cnt;

    public DemoRandomCacheLoadService(int cnt) {
        this.cnt = cnt;
    }

    public void cancel(ServiceContext ctx) {
        if (this.cachePool != null) {
            this.cachePool.shutdownNow();
        }
    }

    public void init(ServiceContext ctx) {
        this.ignite.getOrCreateCache(DemoRandomCacheLoadService.cacheRandom());
        this.cachePool = AgentDemoUtils.newScheduledThreadPool(2, "demo-sql-random-load-cache-tasks");
    }

    public void execute(ServiceContext ctx) {
        this.cachePool.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        for (String cacheName : DemoRandomCacheLoadService.this.ignite.cacheNames()) {
                            IgniteCache cache = DemoRandomCacheLoadService.this.ignite.cache(cacheName);
                            if (cache == null || DemoCachesLoadService.DEMO_CACHES.contains(cacheName) || "PUBLIC".equalsIgnoreCase(((CacheConfiguration)cache.getConfiguration(CacheConfiguration.class)).getSqlSchema())) continue;
                            int i = 0;
                            int n = 1;
                            while (i < DemoRandomCacheLoadService.this.cnt) {
                                Integer key = rnd.nextInt(1024);
                                Integer val = rnd.nextInt(1024);
                                cache.put((Object)key, (Object)val);
                                if (rnd.nextInt(100) < 30) {
                                    cache.remove((Object)key);
                                }
                                ++i;
                                ++n;
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (e.getMessage().contains("cache is stopped")) break block5;
                        DemoRandomCacheLoadService.this.ignite.log().error("Cache write task execution error", e);
                    }
                }
            }
        }, 10L, 3L, TimeUnit.SECONDS);
    }

    private static <K, V> CacheConfiguration<K, V> cacheRandom() {
        CacheConfiguration ccfg = new CacheConfiguration(RANDOM_CACHE_NAME);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setQueryDetailMetricsSize(10);
        ccfg.setStatisticsEnabled(true);
        ccfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        return ccfg;
    }
}

