/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.demo.service;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.compute.ComputeTaskCancelledException;
import org.apache.ignite.console.demo.AgentDemoUtils;
import org.apache.ignite.console.demo.task.DemoCancellableTask;
import org.apache.ignite.console.demo.task.DemoComputeTask;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceContext;

public class DemoComputeLoadService
implements Service {
    @IgniteInstanceResource
    private Ignite ignite;
    private ScheduledExecutorService computePool;

    public void cancel(ServiceContext ctx) {
        if (this.computePool != null) {
            this.computePool.shutdownNow();
        }
    }

    public void init(ServiceContext ctx) {
        this.computePool = AgentDemoUtils.newScheduledThreadPool(2, "demo-compute-load-tasks");
    }

    public void execute(ServiceContext ctx) {
        this.computePool.scheduleWithFixedDelay(() -> {
            try {
                this.ignite.compute().withNoFailover().execute(DemoComputeTask.class, null);
            }
            catch (ComputeTaskCancelledException computeTaskCancelledException) {
            }
            catch (Throwable e) {
                this.ignite.log().error("Task execution error", e);
            }
        }, 10L, 3L, TimeUnit.SECONDS);
        this.computePool.scheduleWithFixedDelay(() -> {
            try {
                this.ignite.compute().withNoFailover().execute(DemoCancellableTask.class, null);
            }
            catch (ComputeTaskCancelledException computeTaskCancelledException) {
            }
            catch (Throwable e) {
                this.ignite.log().error("DemoCancellableTask execution error", e);
            }
        }, 10L, 30L, TimeUnit.SECONDS);
    }
}

