/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.demo.service;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.console.demo.AgentDemoUtils;
import org.apache.ignite.console.demo.model.Car;
import org.apache.ignite.console.demo.model.Country;
import org.apache.ignite.console.demo.model.Department;
import org.apache.ignite.console.demo.model.Employee;
import org.apache.ignite.console.demo.model.Parking;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceContext;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public class DemoCachesLoadService
implements Service {
    @IgniteInstanceResource
    private Ignite ignite;
    private ScheduledExecutorService cachePool;
    private static final String COUNTRY_CACHE_NAME = "CountryCache";
    private static final String DEPARTMENT_CACHE_NAME = "DepartmentCache";
    private static final String EMPLOYEE_CACHE_NAME = "EmployeeCache";
    private static final String PARKING_CACHE_NAME = "ParkingCache";
    public static final String CAR_CACHE_NAME = "CarCache";
    static final Set<String> DEMO_CACHES = new HashSet<String>(Arrays.asList("CountryCache", "DepartmentCache", "EmployeeCache", "ParkingCache", "CarCache"));
    private static final int CNTR_CNT = 10;
    private static final int DEP_CNT = 100;
    private static final int EMPL_CNT = 1000;
    private static final int CAR_CNT = 100;
    private static final int PARK_CNT = 10;
    private static final Random rnd = new Random();
    private final int cnt;
    private final long range;

    public DemoCachesLoadService(int cnt) {
        this.cnt = cnt;
        this.range = new java.util.Date().getTime();
    }

    public void cancel(ServiceContext ctx) {
        if (this.cachePool != null) {
            this.cachePool.shutdownNow();
        }
    }

    public void init(ServiceContext ctx) {
        this.ignite.getOrCreateCaches(Arrays.asList(DemoCachesLoadService.cacheCountry(), DemoCachesLoadService.cacheDepartment(), DemoCachesLoadService.cacheEmployee(), DemoCachesLoadService.cacheCar(), DemoCachesLoadService.cacheParking()));
        this.populateCacheEmployee();
        this.populateCacheCar();
        this.cachePool = AgentDemoUtils.newScheduledThreadPool(2, "demo-sql-load-cache-tasks");
    }

    public void execute(ServiceContext ctx) {
        this.cachePool.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                block17: {
                    try {
                        IgniteCache cacheEmployee = DemoCachesLoadService.this.ignite.cache(DemoCachesLoadService.EMPLOYEE_CACHE_NAME);
                        if (cacheEmployee == null) break block17;
                        try (Transaction tx = DemoCachesLoadService.this.ignite.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                            int i = 0;
                            int n = 1;
                            while (i < DemoCachesLoadService.this.cnt) {
                                int id = rnd.nextInt(1000);
                                int depId = rnd.nextInt(100);
                                double r = rnd.nextDouble();
                                cacheEmployee.put((Object)id, (Object)new Employee(id, depId, depId, "First name employee #" + n, "Last name employee #" + n, "Email employee #" + n, "Phone number employee #" + n, new Date((long)(r * (double)DemoCachesLoadService.this.range)), "Job employee #" + n, 500.0 + AgentDemoUtils.round(r * 2000.0, 2)));
                                if (rnd.nextBoolean()) {
                                    cacheEmployee.remove((Object)rnd.nextInt(1000));
                                }
                                cacheEmployee.get((Object)rnd.nextInt(1000));
                                ++i;
                                ++n;
                            }
                            if (rnd.nextInt(100) > 20) {
                                tx.commit();
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (e.getMessage().contains("cache is stopped")) break block17;
                        DemoCachesLoadService.this.ignite.log().error("Cache write task execution error", e);
                    }
                }
            }
        }, 10L, 3L, TimeUnit.SECONDS);
        this.cachePool.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        IgniteCache cache = DemoCachesLoadService.this.ignite.cache(DemoCachesLoadService.CAR_CACHE_NAME);
                        if (cache != null) {
                            for (int i = 0; i < DemoCachesLoadService.this.cnt; ++i) {
                                int carId = rnd.nextInt(100);
                                cache.put((Object)carId, (Object)new Car(carId, rnd.nextInt(10), "Car #" + (i + 1)));
                                if (!rnd.nextBoolean()) continue;
                                cache.remove((Object)rnd.nextInt(100));
                            }
                        }
                    }
                    catch (IllegalStateException cache) {
                    }
                    catch (Throwable e) {
                        if (e.getMessage().contains("cache is stopped")) break block5;
                        DemoCachesLoadService.this.ignite.log().error("Cache write task execution error", e);
                    }
                }
            }
        }, 10L, 3L, TimeUnit.SECONDS);
    }

    private static CacheConfiguration cacheConfiguration(String name) {
        CacheConfiguration ccfg = new CacheConfiguration(name);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setQueryDetailMetricsSize(10);
        ccfg.setStatisticsEnabled(true);
        ccfg.setSqlFunctionClasses(new Class[]{SQLFunctions.class});
        return ccfg;
    }

    private static CacheConfiguration cacheCountry() {
        CacheConfiguration ccfg = DemoCachesLoadService.cacheConfiguration(COUNTRY_CACHE_NAME);
        ArrayList<QueryEntity> qryEntities = new ArrayList<QueryEntity>();
        QueryEntity type = new QueryEntity();
        qryEntities.add(type);
        type.setKeyType(Integer.class.getName());
        type.setValueType(Country.class.getName());
        LinkedHashMap<String, String> qryFlds = new LinkedHashMap<String, String>();
        qryFlds.put("id", "java.lang.Integer");
        qryFlds.put("name", "java.lang.String");
        qryFlds.put("population", "java.lang.Integer");
        type.setFields(qryFlds);
        ccfg.setQueryEntities(qryEntities);
        return ccfg;
    }

    private static CacheConfiguration cacheDepartment() {
        CacheConfiguration ccfg = DemoCachesLoadService.cacheConfiguration(DEPARTMENT_CACHE_NAME);
        ArrayList<QueryEntity> qryEntities = new ArrayList<QueryEntity>();
        QueryEntity type = new QueryEntity();
        qryEntities.add(type);
        type.setKeyType(Integer.class.getName());
        type.setValueType(Department.class.getName());
        LinkedHashMap<String, String> qryFlds = new LinkedHashMap<String, String>();
        qryFlds.put("id", "java.lang.Integer");
        qryFlds.put("countryId", "java.lang.Integer");
        qryFlds.put("name", "java.lang.String");
        type.setFields(qryFlds);
        ArrayList<QueryIndex> indexes = new ArrayList<QueryIndex>();
        indexes.add(new QueryIndex("countryId", QueryIndexType.SORTED, false, "DEP_COUNTRY"));
        type.setIndexes(indexes);
        ccfg.setQueryEntities(qryEntities);
        return ccfg;
    }

    private static CacheConfiguration cacheEmployee() {
        CacheConfiguration ccfg = DemoCachesLoadService.cacheConfiguration(EMPLOYEE_CACHE_NAME);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setBackups(1);
        ArrayList<QueryEntity> qryEntities = new ArrayList<QueryEntity>();
        QueryEntity type = new QueryEntity();
        qryEntities.add(type);
        type.setKeyType(Integer.class.getName());
        type.setValueType(Employee.class.getName());
        LinkedHashMap<String, String> qryFlds = new LinkedHashMap<String, String>();
        qryFlds.put("id", "java.lang.Integer");
        qryFlds.put("departmentId", "java.lang.Integer");
        qryFlds.put("managerId", "java.lang.Integer");
        qryFlds.put("firstName", "java.lang.String");
        qryFlds.put("lastName", "java.lang.String");
        qryFlds.put("email", "java.lang.String");
        qryFlds.put("phoneNumber", "java.lang.String");
        qryFlds.put("hireDate", "java.sql.Date");
        qryFlds.put("job", "java.lang.String");
        qryFlds.put("salary", "java.lang.Double");
        type.setFields(qryFlds);
        ArrayList<QueryIndex> indexes = new ArrayList<QueryIndex>();
        indexes.add(new QueryIndex("departmentId", QueryIndexType.SORTED, false, "EMP_DEPARTMENT"));
        indexes.add(new QueryIndex("managerId", QueryIndexType.SORTED, false, "EMP_MANAGER"));
        QueryIndex idx = new QueryIndex();
        idx.setName("EMP_NAMES");
        idx.setIndexType(QueryIndexType.SORTED);
        LinkedHashMap<String, Boolean> indFlds = new LinkedHashMap<String, Boolean>();
        indFlds.put("firstName", Boolean.FALSE);
        indFlds.put("lastName", Boolean.FALSE);
        idx.setFields(indFlds);
        idx.setInlineSize(80);
        indexes.add(idx);
        indexes.add(new QueryIndex("salary", QueryIndexType.SORTED, false, "EMP_SALARY"));
        type.setIndexes(indexes);
        ccfg.setQueryEntities(qryEntities);
        return ccfg;
    }

    private static CacheConfiguration cacheParking() {
        CacheConfiguration ccfg = DemoCachesLoadService.cacheConfiguration(PARKING_CACHE_NAME);
        ArrayList<QueryEntity> qryEntities = new ArrayList<QueryEntity>();
        QueryEntity type = new QueryEntity();
        qryEntities.add(type);
        type.setKeyType(Integer.class.getName());
        type.setValueType(Parking.class.getName());
        LinkedHashMap<String, String> qryFlds = new LinkedHashMap<String, String>();
        qryFlds.put("id", "java.lang.Integer");
        qryFlds.put("name", "java.lang.String");
        qryFlds.put("capacity", "java.lang.Integer");
        type.setFields(qryFlds);
        ccfg.setQueryEntities(qryEntities);
        return ccfg;
    }

    private static CacheConfiguration cacheCar() {
        CacheConfiguration ccfg = DemoCachesLoadService.cacheConfiguration(CAR_CACHE_NAME);
        ArrayList<QueryEntity> qryEntities = new ArrayList<QueryEntity>();
        QueryEntity type = new QueryEntity();
        qryEntities.add(type);
        type.setKeyType(Integer.class.getName());
        type.setValueType(Car.class.getName());
        LinkedHashMap<String, String> qryFlds = new LinkedHashMap<String, String>();
        qryFlds.put("id", "java.lang.Integer");
        qryFlds.put("parkingId", "java.lang.Integer");
        qryFlds.put("name", "java.lang.String");
        type.setFields(qryFlds);
        ArrayList<QueryIndex> indexes = new ArrayList<QueryIndex>();
        indexes.add(new QueryIndex("parkingId", QueryIndexType.SORTED, false, "CAR_PARKING"));
        type.setIndexes(indexes);
        ccfg.setQueryEntities(qryEntities);
        return ccfg;
    }

    private void populateCacheEmployee() {
        if (this.ignite.log().isDebugEnabled()) {
            this.ignite.log().debug("DEMO: Start employees population with data...");
        }
        IgniteCache cacheCountry = this.ignite.cache(COUNTRY_CACHE_NAME);
        int i = 0;
        int n = 1;
        while (i < 10) {
            cacheCountry.put((Object)i, (Object)new Country(i, "Country #" + n, n * 10000000));
            ++i;
            ++n;
        }
        IgniteCache cacheDepartment = this.ignite.cache(DEPARTMENT_CACHE_NAME);
        IgniteCache cacheEmployee = this.ignite.cache(EMPLOYEE_CACHE_NAME);
        int i2 = 0;
        int n2 = 1;
        while (i2 < 100) {
            cacheDepartment.put((Object)i2, (Object)new Department(n2, rnd.nextInt(10), "Department #" + n2));
            double r = rnd.nextDouble();
            cacheEmployee.put((Object)i2, (Object)new Employee(i2, rnd.nextInt(100), null, "First name manager #" + n2, "Last name manager #" + n2, "Email manager #" + n2, "Phone number manager #" + n2, new Date((long)(r * (double)this.range)), "Job manager #" + n2, 1000.0 + AgentDemoUtils.round(r * 4000.0, 2)));
            ++i2;
            ++n2;
        }
        i2 = 0;
        n2 = 1;
        while (i2 < 1000) {
            int depId = rnd.nextInt(100);
            double r = rnd.nextDouble();
            cacheEmployee.put((Object)i2, (Object)new Employee(i2, depId, depId, "First name employee #" + n2, "Last name employee #" + n2, "Email employee #" + n2, "Phone number employee #" + n2, new Date((long)(r * (double)this.range)), "Job employee #" + n2, 500.0 + AgentDemoUtils.round(r * 2000.0, 2)));
            ++i2;
            ++n2;
        }
        if (this.ignite.log().isDebugEnabled()) {
            this.ignite.log().debug("DEMO: Finished employees population.");
        }
    }

    private void populateCacheCar() {
        if (this.ignite.log().isDebugEnabled()) {
            this.ignite.log().debug("DEMO: Start cars population...");
        }
        IgniteCache cacheParking = this.ignite.cache(PARKING_CACHE_NAME);
        int i = 0;
        int n = 1;
        while (i < 10) {
            cacheParking.put((Object)i, (Object)new Parking(i, "Parking #" + n, n * 10));
            ++i;
            ++n;
        }
        IgniteCache cacheCar = this.ignite.cache(CAR_CACHE_NAME);
        int i2 = 0;
        int n2 = 1;
        while (i2 < 100) {
            cacheCar.put((Object)i2, (Object)new Car(i2, rnd.nextInt(10), "Car #" + n2));
            ++i2;
            ++n2;
        }
        if (this.ignite.log().isDebugEnabled()) {
            this.ignite.log().debug("DEMO: Finished cars population.");
        }
    }

    public static class SQLFunctions {
        @QuerySqlFunction
        public static long sleep(long x) {
            if (x >= 0L) {
                try {
                    Thread.sleep(x);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return x;
        }
    }
}

