/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.demo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.console.agent.AgentUtils;
import org.apache.log4j.Logger;
import org.h2.tools.RunScript;
import org.h2.tools.Server;

public class AgentMetadataDemo {
    private static final Logger log = Logger.getLogger((String)AgentMetadataDemo.class.getName());
    private static final AtomicBoolean initLatch = new AtomicBoolean();
    private static final String DEMO_SCRIPT_PATH = "demo/db-init.sql";

    public static boolean isTestDriveUrl(String jdbcUrl) {
        return "jdbc:h2:mem:demo-db".equals(jdbcUrl);
    }

    public static Connection testDrive() throws SQLException {
        if (initLatch.compareAndSet(false, true)) {
            log.info((Object)"DEMO: Prepare in-memory H2 database...");
            try {
                Class.forName("org.h2.Driver");
                Connection conn = DriverManager.getConnection("jdbc:h2:mem:demo-db;DB_CLOSE_DELAY=-1", "sa", "");
                File sqlScript = AgentUtils.resolvePath(DEMO_SCRIPT_PATH);
                if (sqlScript == null) {
                    throw new FileNotFoundException(DEMO_SCRIPT_PATH);
                }
                RunScript.execute((Connection)conn, (Reader)new FileReader(sqlScript));
                log.info((Object)"DEMO: Sample tables created.");
                conn.close();
                Server.createTcpServer((String[])new String[]{"-tcpDaemon"}).start();
                log.info((Object)"DEMO: TcpServer stared.");
                log.info((Object)"DEMO: JDBC URL for test drive metadata load: jdbc:h2:mem:demo-db");
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"DEMO: Failed to load H2 driver!", (Throwable)e);
                throw new SQLException("Failed to load H2 driver", e);
            }
            catch (SQLException e) {
                log.error((Object)"DEMO: Failed to start test drive for metadata!", (Throwable)e);
                throw e;
            }
            catch (FileNotFoundException e) {
                log.error((Object)"DEMO: Failed to find demo database initialization script file: demo/db-init.sql");
                throw new SQLException("Failed to start demo for metadata", e);
            }
        }
        return DriverManager.getConnection("jdbc:h2:mem:demo-db;DB_CLOSE_DELAY=-1", "sa", "");
    }
}

