/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.demo;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteServices;
import org.apache.ignite.Ignition;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.console.demo.AgentDemoUtils;
import org.apache.ignite.console.demo.service.DemoCachesLoadService;
import org.apache.ignite.console.demo.service.DemoComputeLoadService;
import org.apache.ignite.console.demo.service.DemoRandomCacheLoadService;
import org.apache.ignite.console.demo.service.DemoServiceClusterSingleton;
import org.apache.ignite.console.demo.service.DemoServiceKeyAffinity;
import org.apache.ignite.console.demo.service.DemoServiceMultipleInstances;
import org.apache.ignite.console.demo.service.DemoServiceNodeSingleton;
import org.apache.ignite.events.EventType;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.apache.ignite.services.Service;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.spi.eventstorage.EventStorageSpi;
import org.apache.ignite.spi.eventstorage.memory.MemoryEventStorageSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentClusterDemo {
    private static final Logger log = LoggerFactory.getLogger(AgentClusterDemo.class);
    private static final AtomicBoolean initGuard = new AtomicBoolean();
    public static final String SRV_NODE_NAME = "demo-server-";
    private static final String CLN_NODE_NAME = "demo-client-";
    private static final int NODE_CNT = 3;
    private static final int WAL_SEGMENTS = 5;
    private static final int WAL_SEGMENT_SZ = 0x1000000;
    private static CountDownLatch initLatch = new CountDownLatch(1);
    private static volatile String demoUrl;

    private static IgniteConfiguration igniteConfiguration(int basePort, int gridIdx, boolean client) throws IgniteCheckedException {
        IgniteConfiguration cfg = new IgniteConfiguration();
        cfg.setGridLogger((IgniteLogger)new Slf4jLogger());
        cfg.setIgniteInstanceName((client ? CLN_NODE_NAME : SRV_NODE_NAME) + gridIdx);
        cfg.setLocalHost("127.0.0.1");
        cfg.setEventStorageSpi((EventStorageSpi)new MemoryEventStorageSpi());
        cfg.setConsistentId((Serializable)((Object)cfg.getIgniteInstanceName()));
        File workDir = new File(U.workDirectory(null, null), "demo-work");
        cfg.setWorkDirectory(workDir.getAbsolutePath());
        int[] evts = new int[EventType.EVTS_DISCOVERY.length + VisorTaskUtils.VISOR_TASK_EVTS.length];
        System.arraycopy(EventType.EVTS_DISCOVERY, 0, evts, 0, EventType.EVTS_DISCOVERY.length);
        System.arraycopy(VisorTaskUtils.VISOR_TASK_EVTS, 0, evts, EventType.EVTS_DISCOVERY.length, VisorTaskUtils.VISOR_TASK_EVTS.length);
        cfg.setIncludeEventTypes(evts);
        cfg.getConnectorConfiguration().setPort(basePort);
        System.setProperty("IGNITE_JETTY_PORT", String.valueOf(basePort + 10 + gridIdx));
        TcpDiscoveryVmIpFinder ipFinder = new TcpDiscoveryVmIpFinder();
        int discoPort = basePort + 20;
        ipFinder.setAddresses(Collections.singletonList("127.0.0.1:" + discoPort + ".." + (discoPort + 3 - 1)));
        TcpDiscoverySpi discoSpi = new TcpDiscoverySpi();
        discoSpi.setLocalPort(discoPort);
        discoSpi.setIpFinder((TcpDiscoveryIpFinder)ipFinder);
        cfg.setDiscoverySpi((DiscoverySpi)discoSpi);
        TcpCommunicationSpi commSpi = new TcpCommunicationSpi();
        commSpi.setSharedMemoryPort(-1);
        commSpi.setMessageQueueLimit(10);
        int commPort = basePort + 30;
        commSpi.setLocalPort(commPort);
        cfg.setCommunicationSpi((CommunicationSpi)commSpi);
        cfg.setGridLogger((IgniteLogger)new Slf4jLogger(log));
        cfg.setMetricsLogFrequency(0L);
        DataRegionConfiguration dataRegCfg = new DataRegionConfiguration();
        dataRegCfg.setName("demo");
        dataRegCfg.setMetricsEnabled(true);
        dataRegCfg.setMaxSize(0x10000000L);
        dataRegCfg.setPersistenceEnabled(true);
        DataStorageConfiguration dataStorageCfg = new DataStorageConfiguration();
        dataStorageCfg.setMetricsEnabled(true);
        dataStorageCfg.setStoragePath("db");
        dataStorageCfg.setDefaultDataRegionConfiguration(dataRegCfg);
        dataStorageCfg.setSystemRegionMaxSize(0x10000000L);
        dataStorageCfg.setWalMode(WALMode.LOG_ONLY);
        dataStorageCfg.setWalSegments(5);
        dataStorageCfg.setWalSegmentSize(0x1000000);
        cfg.setDataStorageConfiguration(dataStorageCfg);
        cfg.setClientMode(client);
        return cfg;
    }

    private static void deployServices(IgniteServices services) {
        services.deployMultiple("Demo service: Multiple instances", (Service)new DemoServiceMultipleInstances(), 7, 3);
        services.deployNodeSingleton("Demo service: Node singleton", (Service)new DemoServiceNodeSingleton());
        services.deployClusterSingleton("Demo service: Cluster singleton", (Service)new DemoServiceClusterSingleton());
        services.deployClusterSingleton("Demo caches load service", (Service)new DemoCachesLoadService(20));
        services.deployKeyAffinitySingleton("Demo service: Key affinity singleton", (Service)new DemoServiceKeyAffinity(), "CarCache", (Object)"id");
        services.deployNodeSingleton("RandomCache load service", (Service)new DemoRandomCacheLoadService(20));
        services.deployMultiple("Demo service: Compute load", (Service)new DemoComputeLoadService(), 2, 1);
    }

    public static String getDemoUrl() {
        return demoUrl;
    }

    public static CountDownLatch tryStart() {
        if (initGuard.compareAndSet(false, true)) {
            log.info("DEMO: Starting embedded nodes for demo...");
            System.setProperty("IGNITE_NO_ASCII", "true");
            System.setProperty("IGNITE_QUIET", "false");
            System.setProperty("IGNITE_UPDATE_NOTIFIER", "false");
            System.setProperty("IGNITE_ATOMIC_CACHE_DELETE_HISTORY_SIZE", "20");
            System.setProperty("IGNITE_PERFORMANCE_SUGGESTIONS_DISABLED", "true");
            AtomicInteger basePort = new AtomicInteger(60700);
            AtomicInteger cnt = new AtomicInteger(-1);
            ScheduledExecutorService execSrv = AgentDemoUtils.newScheduledThreadPool(1, "demo-nodes-start");
            execSrv.scheduleWithFixedDelay(() -> {
                int idx = cnt.incrementAndGet();
                int port = basePort.get();
                boolean first = idx == 0;
                try {
                    IgniteConfiguration cfg = AgentClusterDemo.igniteConfiguration(port, idx, false);
                    if (first) {
                        U.delete((Path)Paths.get(cfg.getWorkDirectory(), new String[0]));
                        U.resolveWorkDirectory((String)cfg.getWorkDirectory(), (String)cfg.getDataStorageConfiguration().getStoragePath(), (boolean)true);
                    }
                    Ignite ignite = Ignition.start((IgniteConfiguration)cfg);
                    if (first) {
                        ClusterNode node = ignite.cluster().localNode();
                        Collection jettyAddrs = (Collection)node.attribute("org.apache.ignite.rest.jetty.addrs");
                        if (jettyAddrs == null) {
                            Ignition.stopAll((boolean)true);
                            throw new IgniteException("DEMO: Failed to start Jetty REST server on embedded node");
                        }
                        String jettyHost = (String)jettyAddrs.iterator().next();
                        Integer jettyPort = (Integer)node.attribute("org.apache.ignite.rest.jetty.port");
                        if (F.isEmpty((String)jettyHost) || jettyPort == null) {
                            throw new IgniteException("DEMO: Failed to start Jetty REST handler on embedded node");
                        }
                        log.info("DEMO: Started embedded node for demo purpose [TCP binary port={}, Jetty REST port={}]", (Object)port, (Object)jettyPort);
                        demoUrl = String.format("http://%s:%d", jettyHost, jettyPort);
                        initLatch.countDown();
                    }
                }
                catch (Throwable e) {
                    if (first) {
                        basePort.getAndAdd(50);
                        log.warn("DEMO: Failed to start embedded node.", e);
                    } else {
                        log.error("DEMO: Failed to start embedded node.", e);
                    }
                }
                finally {
                    if (idx == 3) {
                        try {
                            Ignite ignite = Ignition.ignite((String)"demo-server-0");
                            if (ignite != null) {
                                ignite.cluster().active(true);
                                AgentClusterDemo.deployServices(ignite.services(ignite.cluster().forServers()));
                            }
                            log.info("DEMO: All embedded nodes for demo successfully started");
                        }
                        catch (Throwable ignored) {
                            log.info("DEMO: Failed to launch demo load");
                        }
                        execSrv.shutdown();
                    }
                }
            }, 1L, 5L, TimeUnit.SECONDS);
        }
        return initLatch;
    }

    public static void stop() {
        demoUrl = null;
        Ignition.stopAll((boolean)true);
        initLatch = new CountDownLatch(1);
        initGuard.compareAndSet(true, false);
    }
}

