/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.agent.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.console.json.JsonObject;
import org.apache.ignite.console.rest.RestResult;
import org.apache.ignite.console.utils.Utils;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.FormContentProvider;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.LoggerFactory;

public class RestExecutor
implements AutoCloseable {
    private static final IgniteLogger log = new Slf4jLogger(LoggerFactory.getLogger(RestExecutor.class));
    private final long restTimeout = IgniteSystemProperties.getLong((String)"WEB_AGENT_NODE_REST_TIMEOUT", (long)TimeUnit.MINUTES.toMillis(3L));
    private final HttpClient httpClient;

    public RestExecutor(SslContextFactory sslCtxFactory) {
        this.httpClient = new HttpClient(sslCtxFactory);
        this.httpClient.setConnectBlocking(true);
    }

    @Override
    public void close() {
        try {
            this.httpClient.stop();
        }
        catch (Throwable e) {
            log.error("Failed to close HTTP client", e);
        }
    }

    private RestResult parseResponse(Response res, InputStream in) throws IOException {
        int code = res.getStatus();
        if (code == 200) {
            return (RestResult)Utils.fromJson((Reader)new InputStreamReader(in), RestResult.class);
        }
        if (code == 401) {
            return RestResult.fail((int)2, (String)"Failed to authenticate in cluster. Please check agent's login and password or node port.");
        }
        if (code == 404) {
            return RestResult.fail((int)1, (String)"Failed connect to cluster.");
        }
        return RestResult.fail((int)1, (String)("Failed to execute REST command [code=" + code + ", msg=" + res.getReason() + "]"));
    }

    public RestResult sendRequest(String url, JsonObject params) throws Throwable {
        if (!this.httpClient.isRunning()) {
            this.httpClient.start();
        }
        Fields fields = new Fields();
        params.forEach((k, v) -> fields.add(k, String.valueOf(v)));
        InputStreamResponseListener lsnr = new InputStreamResponseListener();
        this.httpClient.newRequest(url).path("/ignite").method(HttpMethod.POST).content((ContentProvider)new FormContentProvider(fields)).send((Response.CompleteListener)lsnr);
        try {
            Response res = lsnr.get(this.restTimeout, TimeUnit.MILLISECONDS);
            return this.parseResponse(res, lsnr.getInputStream());
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }
}

