/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.agent.handlers;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.console.agent.AgentConfiguration;
import org.apache.ignite.console.agent.AgentUtils;
import org.apache.ignite.console.agent.handlers.ClusterHandler;
import org.apache.ignite.console.agent.handlers.ClustersWatcher;
import org.apache.ignite.console.agent.handlers.DatabaseHandler;
import org.apache.ignite.console.agent.handlers.DemoClusterHandler;
import org.apache.ignite.console.demo.AgentClusterDemo;
import org.apache.ignite.console.json.JsonObject;
import org.apache.ignite.console.rest.RestRequest;
import org.apache.ignite.console.rest.RestResult;
import org.apache.ignite.console.utils.Utils;
import org.apache.ignite.console.websocket.AgentHandshakeRequest;
import org.apache.ignite.console.websocket.AgentHandshakeResponse;
import org.apache.ignite.console.websocket.WebSocketRequest;
import org.apache.ignite.console.websocket.WebSocketResponse;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketFrame;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.LoggerFactory;

@WebSocket(maxTextMessageSize=0xA00000, maxBinaryMessageSize=0xA00000)
public class WebSocketRouter
implements AutoCloseable {
    private static final IgniteLogger log = new Slf4jLogger(LoggerFactory.getLogger(WebSocketRouter.class));
    private static final ByteBuffer PONG_MSG = StandardCharsets.UTF_8.encode("PONG");
    private static final Map<String, String> ERROR_MSGS = Collections.unmodifiableMap(Stream.of(AgentUtils.entry("schemaImport:drivers", "Failed to collect list of JDBC drivers"), AgentUtils.entry("schemaImport:schemas", "Failed to collect database schemas"), AgentUtils.entry("schemaImport:metadata", "Failed to collect database metadata"), AgentUtils.entry("node:rest", "Failed to handle REST request"), AgentUtils.entry("node:visor", "Failed to handle Visor task request")).collect(AgentUtils.entriesToMap()));
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private final AgentConfiguration cfg;
    private WebSocketClient client;
    private final DatabaseHandler dbHnd;
    private final ClusterHandler clusterHnd;
    private final DemoClusterHandler demoClusterHnd;
    private final ClustersWatcher watcher;
    private AtomicInteger reconnectCnt = new AtomicInteger();
    private Collection<String> validTokens;
    private ExecutorService connectorPool = Executors.newSingleThreadExecutor(r -> new Thread(r, "Connect thread"));

    public WebSocketRouter(AgentConfiguration cfg) {
        this.cfg = cfg;
        this.dbHnd = new DatabaseHandler(cfg);
        this.clusterHnd = new ClusterHandler(cfg);
        this.demoClusterHnd = new DemoClusterHandler(cfg);
        this.watcher = new ClustersWatcher(cfg, this.clusterHnd, this.demoClusterHnd);
    }

    private static SslContextFactory createServerSslFactory(AgentConfiguration cfg) {
        boolean trustAll = Boolean.getBoolean("trust.all");
        if (trustAll && !F.isEmpty((String)cfg.serverTrustStore())) {
            log.warning("Options contains both '--server-trust-store' and '-Dtrust.all=true'. Option '-Dtrust.all=true' will be ignored on connect to Web server.");
            trustAll = false;
        }
        return AgentUtils.sslContextFactory(cfg.serverKeyStore(), cfg.serverKeyStorePassword(), trustAll, cfg.serverTrustStore(), cfg.serverTrustStorePassword(), cfg.cipherSuites());
    }

    public void start() {
        log.info("Starting Web Console Agent...");
        Runtime.getRuntime().addShutdownHook(new Thread(this.closeLatch::countDown));
        this.connect();
    }

    private void stopClient() {
        LT.clear();
        this.watcher.stop();
        if (this.client != null) {
            try {
                this.client.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        log.info("Stopping Web Console Agent...");
        this.stopClient();
        this.watcher.close();
    }

    private void connect0() {
        block7: {
            boolean connecting = this.reconnectCnt.getAndIncrement() == 0;
            try {
                this.stopClient();
                if (!this.isRunning()) {
                    return;
                }
                if (connecting) {
                    log.info("Connecting to server: " + this.cfg.serverUri());
                }
                Thread.sleep(Math.min(10, this.reconnectCnt.get() - 1) * 1000);
                if (!this.isRunning()) {
                    return;
                }
                HttpClient httpClient = new HttpClient(WebSocketRouter.createServerSslFactory(this.cfg));
                httpClient.setName("http-client");
                httpClient.addBean((Object)httpClient.getExecutor());
                AgentUtils.configureProxy(httpClient, this.cfg.serverUri());
                this.client = new WebSocketClient(httpClient);
                this.client.addBean((Object)httpClient);
                this.client.start();
                this.client.connect((Object)this, URI.create(this.cfg.serverUri()).resolve("/agents")).get(5L, TimeUnit.SECONDS);
                this.reconnectCnt.set(0);
            }
            catch (InterruptedException e) {
                this.closeLatch.countDown();
            }
            catch (CancellationException | ExecutionException | TimeoutException e) {
            }
            catch (Exception e) {
                if (!connecting) break block7;
                log.error("Failed to establish websocket connection with server: " + this.cfg.serverUri(), (Throwable)e);
            }
        }
    }

    private void connect() {
        this.connectorPool.submit(this::connect0);
    }

    public void awaitClose() throws InterruptedException {
        this.closeLatch.await();
        AgentClusterDemo.stop();
    }

    private boolean isRunning() {
        return this.closeLatch.getCount() > 0L;
    }

    @OnWebSocketConnect
    public void onConnect(Session ses) {
        AgentHandshakeRequest req = new AgentHandshakeRequest("2019_12_00", this.cfg.tokens());
        try {
            AgentUtils.send(ses, new WebSocketResponse("agent:handshake", (Object)req), 10L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            log.error("Failed to send handshake to server", e);
            this.connect();
        }
    }

    private void processHandshakeResponse(AgentHandshakeResponse res) {
        if (F.isEmpty((String)res.getError())) {
            this.validTokens = res.getTokens();
            ArrayList<String> missedTokens = new ArrayList<String>(this.cfg.tokens());
            missedTokens.removeAll(this.validTokens);
            if (!F.isEmpty(missedTokens)) {
                log.warning("Failed to validate token(s): " + AgentUtils.secured(missedTokens) + ". Please reload agent archive or check settings");
            }
            if (F.isEmpty(this.validTokens)) {
                log.warning("Valid tokens not found. Stopping agent...");
                this.closeLatch.countDown();
            }
            log.info("Successfully completes handshake with server");
        } else {
            log.error(res.getError() + " Please reload agent or check settings");
            this.closeLatch.countDown();
        }
    }

    private void processRevokeToken(String tok) {
        log.warning("Security token has been revoked: " + tok);
        this.validTokens.remove(tok);
        if (F.isEmpty(this.validTokens)) {
            log.warning("Web Console Agent will be stopped because no more valid tokens available");
            this.closeLatch.countDown();
        }
    }

    @OnWebSocketMessage
    public void onMessage(Session ses, String msg) {
        try {
            WebSocketRequest evt = (WebSocketRequest)Utils.fromJson((String)msg, WebSocketRequest.class);
            if ("agent:handshake".equals(evt.getEventType())) {
                AgentHandshakeResponse req0 = (AgentHandshakeResponse)Utils.fromJson((String)evt.getPayload(), AgentHandshakeResponse.class);
                this.processHandshakeResponse(req0);
                if (this.closeLatch.getCount() > 0L) {
                    this.watcher.startWatchTask(ses);
                }
                return;
            }
            this.client.getExecutor().execute(() -> this.onMessage0(ses, evt));
        }
        catch (IOException e) {
            log.error("Failed to process message: " + msg, (Throwable)e);
        }
    }

    private void onMessage0(Session ses, WebSocketRequest evt) {
        try {
            switch (evt.getEventType()) {
                case "agent:revoke:token": {
                    this.processRevokeToken(evt.getPayload());
                    return;
                }
                case "schemaImport:drivers": {
                    WebSocketRouter.send(ses, evt.response(this.dbHnd.collectJdbcDrivers()));
                    break;
                }
                case "schemaImport:schemas": {
                    WebSocketRouter.send(ses, evt.response((Object)this.dbHnd.collectDbSchemas(evt)));
                    break;
                }
                case "schemaImport:metadata": {
                    WebSocketRouter.send(ses, evt.response(this.dbHnd.collectDbMetadata(evt)));
                    break;
                }
                case "node:rest": 
                case "node:visor": {
                    RestResult res;
                    if (log.isDebugEnabled()) {
                        log.debug("Processing REST request: " + evt);
                    }
                    RestRequest reqRest = (RestRequest)Utils.fromJson((String)evt.getPayload(), RestRequest.class);
                    JsonObject params = reqRest.getParams();
                    try {
                        res = DemoClusterHandler.DEMO_CLUSTER_ID.equals(reqRest.getClusterId()) ? this.demoClusterHnd.restCommand(params) : this.clusterHnd.restCommand(params);
                    }
                    catch (Throwable e) {
                        res = RestResult.fail((int)500, (String)e.getMessage());
                    }
                    WebSocketRouter.send(ses, evt.response((Object)res));
                    break;
                }
                default: {
                    log.warning("Unknown event: " + evt);
                    break;
                }
            }
        }
        catch (Throwable e) {
            log.error("Failed to process message: " + evt, e);
            try {
                WebSocketRouter.send(ses, evt.withError(ERROR_MSGS.get(evt.getEventType()), e));
            }
            catch (Exception ex) {
                log.error("Failed to send response with error", e);
                this.connect();
            }
        }
    }

    @OnWebSocketFrame
    public void onFrame(Session ses, Frame frame) {
        if (this.isRunning() && frame.getType() == Frame.Type.PING) {
            if (log.isTraceEnabled()) {
                log.trace("Received ping message [socket=" + ses + ", msg=" + frame + "]");
            }
            try {
                ses.getRemote().sendPong(PONG_MSG);
            }
            catch (Throwable e) {
                log.error("Failed to send pong to: " + ses, e);
            }
        }
    }

    @OnWebSocketError
    public void onError(Throwable ignored) {
        if (this.reconnectCnt.get() == 1) {
            log.error("Failed to establish websocket connection with server: " + this.cfg.serverUri());
        }
        if (this.reconnectCnt.get() >= 1) {
            this.connect();
        }
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        if (this.reconnectCnt.get() == 0) {
            log.info("Websocket connection closed with code: " + statusCode);
            this.connect();
        }
    }

    private static void send(Session ses, WebSocketResponse evt) throws Exception {
        AgentUtils.send(ses, evt, 60L, TimeUnit.SECONDS);
    }
}

