/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.agent.handlers;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.Ignition;
import org.apache.ignite.console.agent.AgentConfiguration;
import org.apache.ignite.console.agent.handlers.AbstractClusterHandler;
import org.apache.ignite.console.demo.AgentClusterDemo;
import org.apache.ignite.console.json.JsonObject;
import org.apache.ignite.console.rest.RestResult;
import org.apache.ignite.console.websocket.TopologySnapshot;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientNodeBean;
import org.apache.ignite.internal.processors.rest.handlers.top.GridTopologyCommandHandler;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestTopologyRequest;
import org.apache.ignite.internal.util.typedef.F;

public class DemoClusterHandler
extends AbstractClusterHandler {
    static final String DEMO_CLUSTER_ID = UUID.randomUUID().toString();
    private static final String DEMO_CLUSTER_NAME = "demo-cluster";

    DemoClusterHandler(AgentConfiguration cfg) {
        super(cfg, null);
    }

    @Override
    public RestResult restCommand(JsonObject params) throws Throwable {
        if (AgentClusterDemo.getDemoUrl() == null) {
            if (this.cfg.disableDemo()) {
                return RestResult.fail((int)404, (String)"Demo mode disabled by administrator.");
            }
            AgentClusterDemo.tryStart().await();
            if (AgentClusterDemo.getDemoUrl() == null) {
                return RestResult.fail((int)404, (String)"Failed to send request because of embedded node for demo mode is not started yet.");
            }
        }
        return this.restExecutor.sendRequest(AgentClusterDemo.getDemoUrl(), params);
    }

    TopologySnapshot topologySnapshot() {
        TopologySnapshot top;
        if (this.cfg.disableDemo()) {
            return null;
        }
        if (AgentClusterDemo.getDemoUrl() != null) {
            IgniteEx ignite = (IgniteEx)F.first((List)Ignition.allGrids());
            Collection<GridClientNodeBean> nodes = this.collectNodes(ignite.context());
            top = new TopologySnapshot(nodes);
            top.setActive(ignite.cluster().active());
        } else {
            top = new TopologySnapshot();
            top.setClusterVersion(IgniteVersionUtils.VER_STR);
        }
        top.setId(DEMO_CLUSTER_ID);
        top.setName(DEMO_CLUSTER_NAME);
        top.setDemo(true);
        return top;
    }

    private Collection<GridClientNodeBean> collectNodes(GridKernalContext ctx) {
        try {
            GridTopologyCommandHandler hnd = new GridTopologyCommandHandler(ctx);
            GridRestTopologyRequest req = new GridRestTopologyRequest();
            req.command(GridRestCommand.TOPOLOGY);
            req.includeAttributes(true);
            GridRestResponse res = (GridRestResponse)hnd.handleAsync((GridRestRequest)req).getUninterruptibly();
            return (Collection)res.getResponse();
        }
        catch (IgniteCheckedException e) {
            return Collections.emptyList();
        }
    }
}

