/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.agent.handlers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.console.agent.AgentConfiguration;
import org.apache.ignite.console.agent.AgentUtils;
import org.apache.ignite.console.agent.db.DbMetadataReader;
import org.apache.ignite.console.agent.db.DbSchema;
import org.apache.ignite.console.agent.db.DbTable;
import org.apache.ignite.console.demo.AgentMetadataDemo;
import org.apache.ignite.console.json.JsonObject;
import org.apache.ignite.console.utils.Utils;
import org.apache.ignite.console.websocket.WebSocketRequest;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.slf4j.LoggerFactory;

public class DatabaseHandler {
    private static final IgniteLogger log = new Slf4jLogger(LoggerFactory.getLogger(DatabaseHandler.class));
    private static final String IMPLEMENTATION_VERSION = "Implementation-Version";
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private final File driversFolder;
    private final DbMetadataReader dbMetaReader;

    public DatabaseHandler(AgentConfiguration cfg) {
        this.driversFolder = AgentUtils.resolvePath(F.isEmpty((String)cfg.driversFolder()) ? "jdbc-drivers" : cfg.driversFolder());
        this.dbMetaReader = new DbMetadataReader();
    }

    private Map<String, String> driver(String jdbcDriverJar, String jdbcDriverCls, String jdbcDriverImplVer) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("jdbcDriverJar", jdbcDriverJar);
        map.put("jdbcDriverClass", jdbcDriverCls);
        map.put("jdbcDriverImplVersion", jdbcDriverImplVer);
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Map<String, String>> collectJdbcDrivers() {
        ArrayList<Map<String, String>> drivers = new ArrayList<Map<String, String>>();
        if (this.driversFolder == null) throw new IllegalStateException("JDBC drivers folder not specified");
        if (!this.driversFolder.exists()) {
            throw new IllegalStateException("JDBC drivers folder does not exist");
        }
        log.info("Collecting JDBC drivers in folder: " + this.driversFolder.getPath());
        File[] list = this.driversFolder.listFiles((dir, name) -> name.endsWith(".jar"));
        if (list == null) throw new IllegalStateException("JDBC drivers folder has no files");
        for (File file : list) {
            try {
                boolean win = System.getProperty("os.name").contains("win");
                URL url = new URL("jar", null, "file:" + (win ? "/" : "") + file.getPath() + "!/META-INF/services/java.sql.Driver");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                     JarFile jar = new JarFile(file.getPath());){
                    Manifest m = jar.getManifest();
                    String ver = m.getMainAttributes().getValue(IMPLEMENTATION_VERSION);
                    if (ver == null) {
                        ver = m.getMainAttributes().getValue(BUNDLE_VERSION);
                    }
                    String jdbcDriverCls = reader.readLine();
                    drivers.add(this.driver(file.getName(), jdbcDriverCls, ver != null ? ver.toString() : null));
                    log.info("Found: [driver=" + file + ", class=" + jdbcDriverCls + "]");
                }
            }
            catch (IOException e) {
                drivers.add(this.driver(file.getName(), null, null));
                log.info("Found: [driver=" + file + "]");
                log.error("Failed to detect driver class: " + e.getMessage());
            }
        }
        return drivers;
    }

    public DbSchema collectDbSchemas(WebSocketRequest evt) throws SQLException {
        log.info("Collecting database schemas...");
        JsonObject args = Utils.fromJson((String)evt.getPayload());
        try (Connection conn = this.connect(args);){
            String catalog = conn.getCatalog();
            if (catalog == null) {
                String jdbcUrl = args.getString("jdbcUrl", "");
                String[] parts = jdbcUrl.split("[/:=]");
                catalog = parts.length > 0 ? parts[parts.length - 1] : "NONE";
            }
            Collection<String> schemas = this.dbMetaReader.schemas(conn, args.getBoolean("importSamples", false));
            log.info("Collected database schemas:" + schemas.size());
            DbSchema dbSchema = new DbSchema(catalog, schemas);
            return dbSchema;
        }
    }

    public Collection<DbTable> collectDbMetadata(WebSocketRequest evt) throws SQLException {
        log.info("Collecting database metadata...");
        JsonObject args = Utils.fromJson((String)evt.getPayload());
        if (!args.containsKey((Object)"schemas")) {
            throw new IllegalArgumentException("Missing schemas in arguments: " + args);
        }
        List schemas = (List)args.get((Object)"schemas");
        if (!args.containsKey((Object)"tablesOnly")) {
            throw new IllegalArgumentException("Missing tablesOnly in arguments: " + args);
        }
        boolean tblsOnly = args.getBoolean("tablesOnly", false);
        try (Connection conn = this.connect(args);){
            Collection<DbTable> metadata = this.dbMetaReader.metadata(conn, schemas, tblsOnly);
            log.info("Collected database metadata: " + metadata.size());
            Collection<DbTable> collection = metadata;
            return collection;
        }
    }

    private Connection connect(JsonObject args) throws SQLException {
        String jdbcUrl = args.getString("jdbcUrl", "");
        if (AgentMetadataDemo.isTestDriveUrl(jdbcUrl)) {
            return AgentMetadataDemo.testDrive();
        }
        String jdbcDriverJarPath = args.getString("jdbcDriverJar", "");
        if (F.isEmpty((String)jdbcDriverJarPath)) {
            throw new IllegalArgumentException("Path to JDBC driver not found in arguments");
        }
        String jdbcDriverCls = args.getString("jdbcDriverClass", "");
        if (F.isEmpty((String)jdbcDriverCls)) {
            throw new IllegalArgumentException("JDBC driver class not found in arguments");
        }
        if (F.isEmpty((String)jdbcUrl)) {
            throw new IllegalArgumentException("JDBC URL not found in arguments");
        }
        if (!args.containsKey((Object)"info")) {
            throw new IllegalArgumentException("Connection parameters not found in arguments");
        }
        Properties jdbcInfo = new Properties();
        jdbcInfo.putAll((Map<?, ?>)((Map)args.get((Object)"info")));
        if (!new File(jdbcDriverJarPath).isAbsolute() && this.driversFolder != null) {
            jdbcDriverJarPath = new File(this.driversFolder, jdbcDriverJarPath).getPath();
        }
        log.info("Connecting to database[drvJar=" + jdbcDriverJarPath + ", drvCls=" + jdbcDriverCls + ", jdbcUrl=" + jdbcUrl + "]");
        return this.dbMetaReader.connect(jdbcDriverJarPath, jdbcDriverCls, jdbcUrl, jdbcInfo);
    }
}

