/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.agent.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Closeable;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.console.agent.AgentConfiguration;
import org.apache.ignite.console.agent.AgentUtils;
import org.apache.ignite.console.agent.handlers.ClusterHandler;
import org.apache.ignite.console.agent.handlers.DemoClusterHandler;
import org.apache.ignite.console.json.JsonObject;
import org.apache.ignite.console.rest.RestResult;
import org.apache.ignite.console.utils.Utils;
import org.apache.ignite.console.websocket.TopologySnapshot;
import org.apache.ignite.console.websocket.WebSocketResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientNodeBean;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.eclipse.jetty.websocket.api.Session;
import org.slf4j.LoggerFactory;

public class ClustersWatcher
implements Closeable {
    private static final IgniteLogger log = new Slf4jLogger(LoggerFactory.getLogger(ClustersWatcher.class));
    private static final IgniteProductVersion IGNITE_2_0 = IgniteProductVersion.fromString((String)"2.0.0");
    private static final IgniteProductVersion IGNITE_2_1 = IgniteProductVersion.fromString((String)"2.1.0");
    private static final IgniteProductVersion IGNITE_2_3 = IgniteProductVersion.fromString((String)"2.3.0");
    private static final String EVT_LAST_ORDER_KEY = "WEB_AGENT_" + UUID.randomUUID().toString();
    private static final String EVT_THROTTLE_CNTR_KEY = "WEB_AGENT_" + UUID.randomUUID().toString();
    private static final long REFRESH_FREQ = 3000L;
    private static final String EXPIRED_SES_ERROR_MSG = "Failed to handle request - unknown session token (maybe expired session)";
    private AgentConfiguration cfg;
    private ClusterHandler clusterHnd;
    private DemoClusterHandler demoClusterHnd;
    private TopologySnapshot latestTop;
    private static final ScheduledExecutorService pool = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> refreshTask;
    private String sesTok;

    ClustersWatcher(AgentConfiguration cfg, ClusterHandler clusterHnd, DemoClusterHandler demoClusterHnd) {
        this.cfg = cfg;
        this.clusterHnd = clusterHnd;
        this.demoClusterHnd = demoClusterHnd;
    }

    private void sendTopology(Session ses, List<TopologySnapshot> tops) {
        try {
            AgentUtils.send(ses, new WebSocketResponse("cluster:topology", tops), 10L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            log.error("Failed to send topology to server");
        }
    }

    void startWatchTask(Session ses) {
        if (this.refreshTask != null && !this.refreshTask.isCancelled()) {
            log.warning("Detected that watch task already running");
            this.refreshTask.cancel(true);
        }
        this.refreshTask = pool.scheduleWithFixedDelay(() -> {
            ArrayList<TopologySnapshot> tops = new ArrayList<TopologySnapshot>(F.asList((Object)this.demoClusterHnd.topologySnapshot()));
            try {
                RestResult res = this.topology();
                if (res.getSuccessStatus() != 0) {
                    throw new IllegalStateException(res.getError());
                }
                List nodes = (List)Utils.fromJson((String)res.getResponse(), (TypeReference)new TypeReference<List<GridClientNodeBean>>(){});
                TopologySnapshot newTop = new TopologySnapshot((Collection)nodes);
                if (!newTop.sameNodes(this.latestTop)) {
                    log.info("Connection successfully established to cluster with nodes: " + AgentUtils.nid8(newTop.nids()));
                } else if (!Objects.equals(this.latestTop.nids(), newTop.nids())) {
                    log.info("Cluster topology changed, new topology: " + AgentUtils.nid8(newTop.nids()));
                }
                boolean active = this.active(IgniteProductVersion.fromString((String)newTop.getClusterVersion()), (UUID)F.first((Iterable)newTop.nids()));
                newTop.setDemo(false);
                newTop.setActive(active);
                newTop.setSecured(!F.isEmpty((String)res.getSessionToken()));
                this.latestTop = newTop;
                tops.add(newTop);
                this.sendTopology(ses, tops);
            }
            catch (Throwable e) {
                this.onFailedClusterRequest(e);
                this.latestTop = null;
                this.sendTopology(ses, tops);
            }
        }, 0L, 3000L, TimeUnit.MILLISECONDS);
    }

    void stop() {
        if (this.refreshTask != null) {
            this.refreshTask.cancel(true);
            this.refreshTask = null;
            log.info("Topology watch process was suspended");
        }
    }

    public RestResult restCommand(JsonObject params) throws Throwable {
        if (!F.isEmpty((String)this.sesTok)) {
            params.put((Object)"sessionToken", (Object)this.sesTok);
        } else if (!F.isEmpty((String)this.cfg.nodeLogin()) && !F.isEmpty((String)this.cfg.nodePassword())) {
            params.put((Object)"user", (Object)this.cfg.nodeLogin());
            params.put((Object)"password", (Object)this.cfg.nodePassword());
        }
        RestResult res = this.clusterHnd.restCommand(params);
        switch (res.getSuccessStatus()) {
            case 0: {
                this.sesTok = res.getSessionToken();
                return res;
            }
            case 1: {
                if (!res.getError().startsWith(EXPIRED_SES_ERROR_MSG)) break;
                this.sesTok = null;
                params.remove((Object)"sessionToken");
                return this.restCommand(params);
            }
        }
        return res;
    }

    private RestResult topology() throws Throwable {
        JsonObject params = new JsonObject().add("cmd", (Object)"top").add("attr", (Object)true).add("mtr", (Object)false).add("caches", (Object)false);
        return this.restCommand(params);
    }

    private boolean active(IgniteProductVersion ver, UUID nid) throws Throwable {
        boolean v23;
        if (ver.compareTo(IGNITE_2_0) < 0) {
            return true;
        }
        JsonObject params = new JsonObject();
        boolean bl = v23 = ver.compareTo(IGNITE_2_3) >= 0;
        if (v23) {
            params.put((Object)"cmd", (Object)"currentState");
        } else {
            params.put((Object)"cmd", (Object)"exe");
            params.put((Object)"name", (Object)"org.apache.ignite.internal.visor.compute.VisorGatewayTask");
            params.put((Object)"p1", (Object)nid);
            params.put((Object)"p2", (Object)"org.apache.ignite.internal.visor.node.VisorNodeDataCollectorTask");
            params.put((Object)"p3", (Object)"org.apache.ignite.internal.visor.node.VisorNodeDataCollectorTaskArg");
            params.put((Object)"p4", (Object)false);
            params.put((Object)"p5", (Object)EVT_LAST_ORDER_KEY);
            params.put((Object)"p6", (Object)EVT_THROTTLE_CNTR_KEY);
            if (ver.compareTo(IGNITE_2_1) >= 0) {
                params.put((Object)"p7", (Object)false);
            } else {
                params.put((Object)"p7", (Object)10);
                params.put((Object)"p8", (Object)false);
            }
        }
        RestResult res = this.restCommand(params);
        if (res.getSuccessStatus() == 0) {
            return v23 ? Boolean.valueOf(res.getResponse()).booleanValue() : res.getResponse().contains("\"active\":true");
        }
        return false;
    }

    private void onFailedClusterRequest(Throwable e) {
        String msg = this.latestTop == null ? "Failed to establish connection to node" : "Connection to cluster was lost";
        boolean failed = X.hasCause((Throwable)e, (Class[])new Class[]{IllegalStateException.class});
        if (X.hasCause((Throwable)e, (Class[])new Class[]{ConnectException.class})) {
            LT.info((IgniteLogger)log, (String)msg);
        } else if (failed && "Failed to handle request - session token not found or invalid".equals(e.getMessage())) {
            LT.error((IgniteLogger)log, null, (String)"Failed to establish connection to secured cluster - missing credentials. Please pass '--node-login' and '--node-password' options");
        } else if (failed && e.getMessage().startsWith("Failed to authenticate remote client (invalid credentials?):")) {
            LT.error((IgniteLogger)log, null, (String)"Failed to establish connection to secured cluster - invalid credentials. Please check '--node-login' and '--node-password' options");
        } else if (failed) {
            LT.error((IgniteLogger)log, null, (String)(msg + ". " + e.getMessage()));
        } else {
            LT.error((IgniteLogger)log, (Throwable)e, (String)msg);
        }
    }

    @Override
    public void close() {
        if (this.refreshTask != null) {
            this.refreshTask.cancel(true);
        }
        pool.shutdownNow();
    }
}

