/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.agent.handlers;

import java.net.ConnectException;
import java.nio.channels.AsynchronousCloseException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.console.agent.AgentConfiguration;
import org.apache.ignite.console.agent.AgentUtils;
import org.apache.ignite.console.agent.handlers.AbstractClusterHandler;
import org.apache.ignite.console.json.JsonObject;
import org.apache.ignite.console.rest.RestResult;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.LoggerFactory;

public class ClusterHandler
extends AbstractClusterHandler {
    private static final IgniteLogger log = new Slf4jLogger(LoggerFactory.getLogger(ClusterHandler.class));
    private final Map<List<String>, Integer> startIdxs = U.newHashMap((int)2);

    public ClusterHandler(AgentConfiguration cfg) {
        super(cfg, ClusterHandler.createNodeSslFactory(cfg));
    }

    private static SslContextFactory createNodeSslFactory(AgentConfiguration cfg) {
        boolean trustAll = Boolean.getBoolean("trust.all");
        if (trustAll && !F.isEmpty((String)cfg.nodeTrustStore())) {
            log.warning("Options contains both '--node-trust-store' and '-Dtrust.all=true'. Option '-Dtrust.all=true' will be ignored on connect to cluster.");
            trustAll = false;
        }
        return AgentUtils.sslContextFactory(cfg.nodeKeyStore(), cfg.nodeKeyStorePassword(), trustAll, cfg.nodeTrustStore(), cfg.nodeTrustStorePassword(), cfg.cipherSuites());
    }

    @Override
    public RestResult restCommand(JsonObject params) throws Throwable {
        List<String> nodeURIs = this.cfg.nodeURIs();
        Integer startIdx = this.startIdxs.getOrDefault(nodeURIs, 0);
        int urlsCnt = nodeURIs.size();
        for (int i = 0; i < urlsCnt; ++i) {
            int currIdx = (startIdx + i) % urlsCnt;
            String nodeUrl = nodeURIs.get(currIdx);
            try {
                RestResult res = this.restExecutor.sendRequest(nodeUrl, params);
                if (i > 0 || !this.startIdxs.containsKey(nodeURIs)) {
                    log.info("Connected to node [url=" + nodeUrl + "]");
                }
                this.startIdxs.put(nodeURIs, currIdx);
                return res;
            }
            catch (InterruptedException | ConnectException | AsynchronousCloseException | TimeoutException | HttpResponseException res) {
                continue;
            }
            catch (Throwable e) {
                LT.error((IgniteLogger)log, (Throwable)e, (String)("Failed execute request on node [url=" + nodeUrl + ", parameters=" + params + "]"));
                if (!(e instanceof SSLException)) continue;
                LT.warn((IgniteLogger)log, (String)"Check that connection to cluster node configured correctly.");
                LT.warn((IgniteLogger)log, (String)"Options to check: --node-uri, --node-key-store, --node-key-store-password, --node-trust-store, --node-trust-store-password.");
            }
        }
        LT.warn((IgniteLogger)log, (String)"Failed to connect to cluster.");
        LT.warn((IgniteLogger)log, (String)"Check that '--node-uri' configured correctly.");
        LT.warn((IgniteLogger)log, (String)"Ensure that cluster nodes have [ignite-rest-http] module in classpath (was copied from libs/optional to libs folder).");
        throw new ConnectException("Failed connect to cluster [urls=" + nodeURIs + ", parameters=" + params + "]");
    }
}

