/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.agent.db.dialect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.console.agent.db.DbColumn;
import org.apache.ignite.console.agent.db.DbTable;
import org.apache.ignite.console.agent.db.dialect.DatabaseMetadataDialect;

public class OracleMetadataDialect
extends DatabaseMetadataDialect {
    private static final String SQL_COLUMNS = "SELECT a.owner, a.table_name, a.column_name, a.nullable, a.data_type, a.data_precision, a.data_scale FROM all_tab_columns a %s %s  ORDER BY a.owner, a.table_name, a.column_id";
    private static final String SQL_PRIMARY_KEYS = "SELECT b.column_name FROM all_constraints a  INNER JOIN all_cons_columns b   ON a.owner = b.owner  AND a.constraint_name = b.constraint_name WHERE a.owner = ? and a.table_name = ? AND a.constraint_type = 'P'";
    private static final String SQL_UNIQUE_INDEXES_KEYS = "SELECT a.index_name, b.column_name FROM all_indexes a INNER JOIN all_ind_columns b   ON a.index_name = b.index_name  AND a.table_owner = b.table_owner  AND a.table_name = b.table_name  AND a.owner = b.index_owner WHERE a.owner = ? AND a.table_name = ? AND a.uniqueness = 'UNIQUE' ORDER BY b.column_position";
    private static final String SQL_INDEXES = "SELECT i.index_name, u.column_expression, i.column_name, i.descend FROM all_ind_columns i LEFT JOIN user_ind_expressions u   ON u.index_name = i.index_name  AND i.table_name = u.table_name WHERE i.index_owner = ? and i.table_name = ? ORDER BY i.index_name, i.column_position";
    private static final int OWNER_IDX = 1;
    private static final int TBL_NAME_IDX = 2;
    private static final int COL_NAME_IDX = 3;
    private static final int NULLABLE_IDX = 4;
    private static final int DATA_TYPE_IDX = 5;
    private static final int DATA_PRECISION_IDX = 6;
    private static final int DATA_SCALE_IDX = 7;
    private static final int UNQ_IDX_NAME_IDX = 1;
    private static final int UNQ_IDX_COL_NAME_IDX = 2;
    private static final int IDX_NAME_IDX = 1;
    private static final int IDX_EXPR_IDX = 2;
    private static final int IDX_COL_NAME_IDX = 3;
    private static final int IDX_COL_DESCEND_IDX = 4;

    @Override
    public Set<String> systemSchemas() {
        return new HashSet<String>(Arrays.asList("ANONYMOUS", "APPQOSSYS", "CTXSYS", "DBSNMP", "EXFSYS", "LBACSYS", "MDSYS", "MGMT_VIEW", "OLAPSYS", "OWBSYS", "ORDPLUGINS", "ORDSYS", "OUTLN", "SI_INFORMTN_SCHEMA", "SYS", "SYSMAN", "SYSTEM", "TSMSYS", "WK_TEST", "WKSYS", "WKPROXY", "WMSYS", "XDB", "APEX_040000", "APEX_PUBLIC_USER", "DIP", "FLOWS_30000", "FLOWS_FILES", "MDDATA", "ORACLE_OCM", "SPATIAL_CSW_ADMIN_USR", "SPATIAL_WFS_ADMIN_USR", "XS$NULL"));
    }

    @Override
    public Set<String> sampleSchemas() {
        return new HashSet<String>(Arrays.asList("BI", "HR", "OE", "PM", "IX", "SH"));
    }

    @Override
    public Collection<String> schemas(Connection conn, boolean importSamples) throws SQLException {
        ArrayList<String> schemas = new ArrayList<String>();
        ResultSet rs = this.getSchemas(conn);
        Set<String> sysSchemas = this.systemSchemas();
        Set<String> samples = this.sampleSchemas();
        while (rs.next()) {
            String schema = rs.getString(1);
            if (!importSamples && samples.contains(schema) || sysSchemas.contains(schema) || schema.startsWith("FLOWS_")) continue;
            schemas.add(schema);
        }
        return schemas;
    }

    private int decodeType(ResultSet rs) throws SQLException {
        String type = rs.getString(5);
        if (type.startsWith("TIMESTAMP")) {
            return 93;
        }
        switch (type) {
            case "CHAR": 
            case "NCHAR": {
                return 1;
            }
            case "VARCHAR2": 
            case "NVARCHAR2": {
                return 12;
            }
            case "LONG": {
                return -1;
            }
            case "LONG RAW": {
                return -4;
            }
            case "FLOAT": {
                return 6;
            }
            case "NUMBER": {
                int precision = rs.getInt(6);
                int scale = rs.getInt(7);
                if (scale > 0) {
                    if (scale < 4 && precision < 19) {
                        return 6;
                    }
                    if (scale > 4 || precision > 19) {
                        return 8;
                    }
                } else {
                    if (precision < 1) {
                        return 2;
                    }
                    if (precision < 3) {
                        return -6;
                    }
                    if (precision < 5) {
                        return 5;
                    }
                    if (precision < 10) {
                        return 4;
                    }
                    if (precision < 19) {
                        return -5;
                    }
                }
                return 2;
            }
            case "DATE": {
                return 91;
            }
            case "BFILE": 
            case "BLOB": {
                return 2004;
            }
            case "CLOB": 
            case "NCLOB": {
                return 2005;
            }
            case "XMLTYPE": {
                return 2009;
            }
        }
        return 1111;
    }

    private Set<String> primaryKeys(PreparedStatement stmt, String owner, String tbl) throws SQLException {
        stmt.setString(1, owner);
        stmt.setString(2, tbl);
        LinkedHashSet<String> pkCols = new LinkedHashSet<String>();
        try (ResultSet pkRs = stmt.executeQuery();){
            while (pkRs.next()) {
                pkCols.add(pkRs.getString(1));
            }
        }
        return pkCols;
    }

    private Map<String, Set<String>> uniqueIndexes(PreparedStatement stmt, String owner, String tbl) throws SQLException {
        stmt.setString(1, owner);
        stmt.setString(2, tbl);
        LinkedHashMap<String, Set<String>> uniqueIdxs = new LinkedHashMap<String, Set<String>>();
        try (ResultSet idxsRs = stmt.executeQuery();){
            while (idxsRs.next()) {
                String idxName = idxsRs.getString(1);
                String colName = idxsRs.getString(2);
                Set idxCols = uniqueIdxs.computeIfAbsent(idxName, k -> new LinkedHashSet());
                idxCols.add(colName);
            }
        }
        return uniqueIdxs;
    }

    private Collection<QueryIndex> indexes(PreparedStatement stmt, String owner, String tbl, String uniqueIdxAsPk) throws SQLException {
        stmt.setString(1, owner);
        stmt.setString(2, tbl);
        LinkedHashMap<String, QueryIndex> idxs = new LinkedHashMap<String, QueryIndex>();
        try (ResultSet idxsRs = stmt.executeQuery();){
            while (idxsRs.next()) {
                String expr;
                String idxName = idxsRs.getString(1);
                if (idxName.equals(uniqueIdxAsPk)) continue;
                QueryIndex idx = (QueryIndex)idxs.get(idxName);
                if (idx == null) {
                    idx = this.index(idxName);
                    idxs.put(idxName, idx);
                }
                String col = (expr = idxsRs.getString(2)) == null ? idxsRs.getString(3) : expr.replaceAll("\"", "");
                idx.getFields().put(col, !"DESC".equals(idxsRs.getString(4)));
            }
        }
        return idxs.values();
    }

    @Override
    public Collection<DbTable> tables(Connection conn, List<String> schemas, boolean tblsOnly) throws SQLException {
        ArrayList<DbTable> tbls = new ArrayList<DbTable>();
        try (PreparedStatement pkStmt = conn.prepareStatement(SQL_PRIMARY_KEYS);
             PreparedStatement uniqueIdxsStmt = conn.prepareStatement(SQL_UNIQUE_INDEXES_KEYS);
             PreparedStatement idxStmt = conn.prepareStatement(SQL_INDEXES);
             Statement colsStmt = conn.createStatement();){
            if (schemas.isEmpty()) {
                schemas.add(null);
            }
            Set<String> sysSchemas = this.systemSchemas();
            for (String schema : schemas) {
                if (this.systemSchemas().contains(schema) || schema != null && schema.startsWith("FLOWS_")) continue;
                String sql = String.format(SQL_COLUMNS, tblsOnly ? "INNER JOIN all_tables b on a.table_name = b.table_name and a.owner = b.owner" : "", schema != null ? String.format(" WHERE a.owner = '%s' ", schema) : "");
                ResultSet colsRs = colsStmt.executeQuery(sql);
                Throwable throwable = null;
                try {
                    String prevSchema = "";
                    String prevTbl = "";
                    boolean first = true;
                    Set<Object> pkCols = Collections.emptySet();
                    ArrayList<DbColumn> cols = new ArrayList<DbColumn>();
                    Collection<QueryIndex> idxs = Collections.emptyList();
                    while (colsRs.next()) {
                        boolean changed;
                        String owner = colsRs.getString(1);
                        String tbl = colsRs.getString(2);
                        if (sysSchemas.contains(owner) || schema != null && schema.startsWith("FLOWS_")) continue;
                        boolean bl = changed = !owner.equals(prevSchema) || !tbl.equals(prevTbl);
                        if (changed) {
                            if (first) {
                                first = false;
                            } else {
                                tbls.add(this.table(prevSchema, prevTbl, cols, idxs));
                            }
                            prevSchema = owner;
                            prevTbl = tbl;
                            cols = new ArrayList();
                            pkCols = this.primaryKeys(pkStmt, owner, tbl);
                            Map.Entry<String, Set<String>> uniqueIdxAsPk = null;
                            if (pkCols.isEmpty() && (uniqueIdxAsPk = this.uniqueIndexAsPk(this.uniqueIndexes(uniqueIdxsStmt, owner, tbl))) != null) {
                                pkCols.addAll((Collection<Object>)uniqueIdxAsPk.getValue());
                            }
                            idxs = this.indexes(idxStmt, owner, tbl, uniqueIdxAsPk != null ? uniqueIdxAsPk.getKey() : null);
                        }
                        String colName = colsRs.getString(3);
                        cols.add(new DbColumn(colName, this.decodeType(colsRs), pkCols.contains(colName), !"N".equals(colsRs.getString(4)), false));
                    }
                    if (cols.isEmpty()) continue;
                    tbls.add(this.table(prevSchema, prevTbl, cols, idxs));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (colsRs == null) continue;
                    if (throwable != null) {
                        try {
                            colsRs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    colsRs.close();
                }
            }
        }
        return tbls;
    }
}

