/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.agent.db.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.console.agent.db.dialect.JdbcMetadataDialect;

public class MySQLMetadataDialect
extends JdbcMetadataDialect {
    private static final int TYPE_NAME_IDX = 1;

    @Override
    public Set<String> systemSchemas() {
        return new HashSet<String>(Arrays.asList("information_schema", "mysql", "performance_schema", "sys"));
    }

    @Override
    protected ResultSet getSchemas(Connection conn) throws SQLException {
        return conn.getMetaData().getCatalogs();
    }

    @Override
    protected boolean useCatalog() {
        return true;
    }

    @Override
    protected boolean useSchema() {
        return false;
    }

    @Override
    public Set<String> unsignedTypes(DatabaseMetaData dbMeta) throws SQLException {
        HashSet<String> unsignedTypes = new HashSet<String>();
        try (ResultSet typeRs = dbMeta.getTypeInfo();){
            while (typeRs.next()) {
                String typeName = typeRs.getString(1);
                if (!typeName.contains("UNSIGNED")) continue;
                unsignedTypes.add(typeName);
            }
        }
        return unsignedTypes;
    }
}

