/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.agent.db.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.console.agent.db.DbColumn;
import org.apache.ignite.console.agent.db.DbTable;
import org.apache.ignite.console.agent.db.dialect.DatabaseMetadataDialect;

public class JdbcMetadataDialect
extends DatabaseMetadataDialect {
    private static final String[] TABLES_ONLY = new String[]{"TABLE"};
    private static final String[] TABLES_AND_VIEWS = new String[]{"TABLE", "VIEW"};
    private static final int TBL_CATALOG_IDX = 1;
    private static final int TBL_SCHEMA_IDX = 2;
    private static final int TBL_NAME_IDX = 3;
    private static final int PK_COL_NAME_IDX = 4;
    private static final int COL_NAME_IDX = 4;
    private static final int COL_DATA_TYPE_IDX = 5;
    private static final int COL_TYPE_NAME_IDX = 6;
    private static final int COL_NULLABLE_IDX = 11;
    private static final int IDX_NAME_IDX = 6;
    private static final int IDX_COL_NAME_IDX = 9;
    private static final int IDX_ASC_OR_DESC_IDX = 10;

    @Override
    public Collection<String> schemas(Connection conn, boolean importSamples) throws SQLException {
        ArrayList<String> schemas = new ArrayList<String>();
        ResultSet rs = this.getSchemas(conn);
        Set<String> sys = this.systemSchemas();
        Set<String> samples = this.sampleSchemas();
        while (rs.next()) {
            String schema = rs.getString(1);
            if (sys.contains(schema) || !importSamples && samples.contains(schema)) continue;
            schemas.add(schema);
        }
        return schemas;
    }

    protected boolean useCatalog() {
        return false;
    }

    protected boolean useSchema() {
        return true;
    }

    @Override
    public Collection<DbTable> tables(Connection conn, List<String> schemas, boolean tblsOnly) throws SQLException {
        DatabaseMetaData dbMeta = conn.getMetaData();
        Set<String> sys = this.systemSchemas();
        Set<String> unsignedTypes = this.unsignedTypes(dbMeta);
        if (schemas.isEmpty()) {
            schemas.add(null);
        }
        ArrayList<DbTable> tbls = new ArrayList<DbTable>();
        for (String toSchema : schemas) {
            ResultSet tblsRs = dbMeta.getTables(this.useCatalog() ? toSchema : null, this.useSchema() ? toSchema : null, "%", tblsOnly ? TABLES_ONLY : TABLES_AND_VIEWS);
            Throwable throwable = null;
            try {
                while (tblsRs.next()) {
                    Object colName;
                    Throwable throwable2;
                    String schema;
                    String tblCatalog = tblsRs.getString(1);
                    String tblSchema = tblsRs.getString(2);
                    String tblName = tblsRs.getString(3);
                    String string = schema = tblSchema != null ? tblSchema : tblCatalog;
                    if (sys.contains(schema)) continue;
                    LinkedHashSet<String> pkCols = new LinkedHashSet<String>();
                    try (ResultSet pkRs = dbMeta.getPrimaryKeys(tblCatalog, tblSchema, tblName);){
                        while (pkRs.next()) {
                            pkCols.add(pkRs.getString(4));
                        }
                    }
                    Map.Entry<String, Set<String>> uniqueIdxAsPk = null;
                    if (pkCols.isEmpty()) {
                        LinkedHashMap<String, Set<String>> uniqueIdxs = new LinkedHashMap<String, Set<String>>();
                        throwable2 = null;
                        try (ResultSet idxRs = dbMeta.getIndexInfo(tblCatalog, tblSchema, tblName, true, true);){
                            while (idxRs.next()) {
                                String idxName = idxRs.getString(6);
                                colName = idxRs.getString(9);
                                if (idxName == null || colName == null) continue;
                                Set idxCols = uniqueIdxs.computeIfAbsent(idxName, k -> new LinkedHashSet());
                                idxCols.add(colName);
                            }
                        }
                        catch (Throwable idxName) {
                            throwable2 = idxName;
                            throw idxName;
                        }
                        uniqueIdxAsPk = this.uniqueIndexAsPk(uniqueIdxs);
                        if (uniqueIdxAsPk != null) {
                            pkCols.addAll((Collection)uniqueIdxAsPk.getValue());
                        }
                    }
                    ArrayList<DbColumn> cols = new ArrayList<DbColumn>();
                    throwable2 = null;
                    try (ResultSet colsRs = dbMeta.getColumns(tblCatalog, tblSchema, tblName, null);){
                        while (colsRs.next()) {
                            String colName2 = colsRs.getString(4);
                            cols.add(new DbColumn(colName2, colsRs.getInt(5), pkCols.contains(colName2), colsRs.getInt(11) == 1, unsignedTypes.contains(colsRs.getString(6))));
                        }
                    }
                    catch (Throwable colName2) {
                        throwable2 = colName2;
                        throw colName2;
                    }
                    String uniqueIdxAsPkName = uniqueIdxAsPk != null ? (String)uniqueIdxAsPk.getKey() : null;
                    LinkedHashMap<String, QueryIndex> idxs = new LinkedHashMap<String, QueryIndex>();
                    ResultSet idxRs = dbMeta.getIndexInfo(tblCatalog, tblSchema, tblName, false, true);
                    colName = null;
                    try {
                        while (idxRs.next()) {
                            String askOrDesc;
                            String idxName = idxRs.getString(6);
                            String colName3 = idxRs.getString(9);
                            if (idxName == null || colName3 == null || idxName.equals(uniqueIdxAsPkName)) continue;
                            QueryIndex idx = (QueryIndex)idxs.get(idxName);
                            if (idx == null) {
                                idx = this.index(idxName);
                                idxs.put(idxName, idx);
                            }
                            Boolean asc = (askOrDesc = idxRs.getString(10)) == null || "A".equals(askOrDesc);
                            idx.getFields().put(colName3, asc);
                        }
                    }
                    catch (Throwable idxName) {
                        colName = idxName;
                        throw idxName;
                    }
                    finally {
                        if (idxRs != null) {
                            if (colName != null) {
                                try {
                                    idxRs.close();
                                }
                                catch (Throwable idxName) {
                                    ((Throwable)colName).addSuppressed(idxName);
                                }
                            } else {
                                idxRs.close();
                            }
                        }
                    }
                    if (!pkCols.isEmpty()) {
                        for (Map.Entry entry : idxs.entrySet()) {
                            QueryIndex idx = (QueryIndex)entry.getValue();
                            if (!pkCols.equals(idx.getFields().keySet())) continue;
                            idxs.remove(entry.getKey());
                            break;
                        }
                    }
                    tbls.add(this.table(schema, tblName, cols, idxs.values()));
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (tblsRs == null) continue;
                if (throwable != null) {
                    try {
                        tblsRs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    continue;
                }
                tblsRs.close();
            }
        }
        return tbls;
    }
}

