/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.agent.db.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.console.agent.db.DbColumn;
import org.apache.ignite.console.agent.db.DbTable;
import org.apache.ignite.internal.visor.query.VisorQueryIndex;

public abstract class DatabaseMetadataDialect {
    public abstract Collection<String> schemas(Connection var1, boolean var2) throws SQLException;

    protected ResultSet getSchemas(Connection conn) throws SQLException {
        return conn.getMetaData().getSchemas();
    }

    public abstract Collection<DbTable> tables(Connection var1, List<String> var2, boolean var3) throws SQLException;

    public Set<String> systemSchemas() {
        return Collections.singleton("INFORMATION_SCHEMA");
    }

    public Set<String> sampleSchemas() {
        return Collections.emptySet();
    }

    public Set<String> unsignedTypes(DatabaseMetaData dbMeta) throws SQLException {
        return Collections.emptySet();
    }

    protected DbTable table(String schema, String tbl, Collection<DbColumn> cols, Collection<QueryIndex> idxs) {
        ArrayList<VisorQueryIndex> res = new ArrayList<VisorQueryIndex>(idxs.size());
        for (QueryIndex idx : idxs) {
            res.add(new VisorQueryIndex(idx));
        }
        return new DbTable(schema, tbl, cols, res);
    }

    protected QueryIndex index(String idxName) {
        QueryIndex idx = new QueryIndex();
        idx.setName(idxName);
        idx.setIndexType(QueryIndexType.SORTED);
        idx.setFields(new LinkedHashMap());
        return idx;
    }

    protected Map.Entry<String, Set<String>> uniqueIndexAsPk(Map<String, Set<String>> uniqueIdxs) {
        Map.Entry<String, Set<String>> uniqueIdxAsPk = null;
        for (Map.Entry<String, Set<String>> uniqueIdx : uniqueIdxs.entrySet()) {
            if (uniqueIdxAsPk != null && ((Set)uniqueIdxAsPk.getValue()).size() <= uniqueIdx.getValue().size()) continue;
            uniqueIdxAsPk = uniqueIdx;
        }
        return uniqueIdxAsPk;
    }
}

