/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.agent.db;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ignite.console.agent.db.DbTable;
import org.apache.ignite.console.agent.db.dialect.DB2MetadataDialect;
import org.apache.ignite.console.agent.db.dialect.DatabaseMetadataDialect;
import org.apache.ignite.console.agent.db.dialect.JdbcMetadataDialect;
import org.apache.ignite.console.agent.db.dialect.MySQLMetadataDialect;
import org.apache.ignite.console.agent.db.dialect.OracleMetadataDialect;
import org.apache.log4j.Logger;

public class DbMetadataReader {
    private static final Logger log = Logger.getLogger((String)DbMetadataReader.class.getName());
    private final Map<String, Driver> drivers = new HashMap<String, Driver>();

    private DatabaseMetadataDialect dialect(Connection conn) {
        try {
            String dbProductName = conn.getMetaData().getDatabaseProductName();
            if ("Oracle".equals(dbProductName)) {
                return new OracleMetadataDialect();
            }
            if (dbProductName.startsWith("DB2/")) {
                return new DB2MetadataDialect();
            }
            if ("MySQL".equals(dbProductName)) {
                return new MySQLMetadataDialect();
            }
            return new JdbcMetadataDialect();
        }
        catch (SQLException e) {
            log.error((Object)"Failed to resolve dialect (JdbcMetaDataDialect will be used.", (Throwable)e);
            return new JdbcMetadataDialect();
        }
    }

    public Collection<String> schemas(Connection conn, boolean importSamples) throws SQLException {
        return this.dialect(conn).schemas(conn, importSamples);
    }

    public Collection<DbTable> metadata(Connection conn, List<String> schemas, boolean tblsOnly) throws SQLException {
        return this.dialect(conn).tables(conn, schemas, tblsOnly);
    }

    public Connection connect(String jdbcDrvJarPath, String jdbcDrvCls, String jdbcUrl, Properties jdbcInfo) throws SQLException {
        Connection conn;
        Driver drv = this.drivers.get(jdbcDrvCls);
        if (drv == null) {
            if (jdbcDrvJarPath.isEmpty()) {
                throw new IllegalStateException("Driver jar file name is not specified.");
            }
            File drvJar = new File(jdbcDrvJarPath);
            if (!drvJar.exists()) {
                throw new IllegalStateException("Driver jar file is not found.");
            }
            try {
                URL u = new URL("jar:" + drvJar.toURI() + "!/");
                URLClassLoader ucl = URLClassLoader.newInstance(new URL[]{u});
                drv = (Driver)Class.forName(jdbcDrvCls, true, ucl).newInstance();
                this.drivers.put(jdbcDrvCls, drv);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if ((conn = drv.connect(jdbcUrl, jdbcInfo)) == null) {
            throw new IllegalStateException("Connection was not established (JDBC driver returned null value).");
        }
        return conn;
    }
}

