/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.ProtectionDomain;
import java.security.UnrecoverableKeyException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import org.apache.ignite.IgniteException;
import org.apache.ignite.console.agent.AgentLauncher;
import org.apache.ignite.console.utils.Utils;
import org.apache.ignite.console.websocket.WebSocketResponse;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.log4j.Logger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;

public class AgentUtils {
    private static final Logger log = Logger.getLogger((String)AgentUtils.class.getName());
    public static final String[] EMPTY = new String[0];

    private AgentUtils() {
    }

    private static String normalizePath(String path) {
        return path != null ? path.replace('\\', '/') : null;
    }

    public static File getAgentHome() {
        try {
            ProtectionDomain domain = AgentLauncher.class.getProtectionDomain();
            if (domain == null || domain.getCodeSource() == null || domain.getCodeSource().getLocation() == null) {
                log.warn((Object)"Failed to resolve application folder!");
                return null;
            }
            URI classesUri = domain.getCodeSource().getLocation().toURI();
            boolean win = System.getProperty("os.name").toLowerCase().contains("win");
            if (win && classesUri.getAuthority() != null) {
                classesUri = new URI(classesUri.toString().replace("file://", "file:/"));
            }
            return new File(classesUri).getParentFile();
        }
        catch (SecurityException | URISyntaxException ignored) {
            log.warn((Object)"Failed to resolve application folder!");
            return null;
        }
    }

    public static File resolvePath(String path) {
        File file;
        assert (path != null);
        File home = AgentUtils.getAgentHome();
        if (home != null && (file = new File(home, AgentUtils.normalizePath(path))).exists()) {
            return file;
        }
        file = new File(path);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static SslContextFactory sslContextFactory(String keyStore, String keyStorePwd, boolean trustAll, String trustStore, String trustStorePwd, List<String> ciphers) {
        SslContextFactory.Client sslCtxFactory = new SslContextFactory.Client();
        if (!F.isEmpty((String)keyStore)) {
            sslCtxFactory.setKeyStorePath(keyStore);
            if (!F.isEmpty((String)keyStorePwd)) {
                sslCtxFactory.setKeyStorePassword(keyStorePwd);
            }
        }
        if (trustAll) {
            sslCtxFactory.setTrustAll(true);
        } else if (!F.isEmpty((String)trustStore)) {
            sslCtxFactory.setTrustStorePath(trustStore);
            if (!F.isEmpty((String)trustStorePwd)) {
                sslCtxFactory.setTrustStorePassword(trustStorePwd);
            }
        }
        if (!F.isEmpty(ciphers)) {
            sslCtxFactory.setIncludeCipherSuites(ciphers.toArray(EMPTY));
        }
        return sslCtxFactory;
    }

    public static String secured(String s) {
        if (F.isEmpty((String)s)) {
            return "";
        }
        int len = s.length();
        int toShow = len > 4 ? 4 : 1;
        return new String(new char[len - toShow]).replace('\u0000', '*') + s.substring(len - toShow, len);
    }

    public static String secured(Collection<String> c) {
        return c.stream().map(AgentUtils::secured).collect(Collectors.joining(", "));
    }

    private static void addAuthentication(HttpClient httpClient, List<ProxyConfiguration.Proxy> proxies) {
        proxies.forEach(p -> {
            String pwd;
            String user;
            if (p instanceof HttpProxy) {
                String scheme = p.getURI().getScheme();
                user = System.getProperty(scheme + ".proxyUsername");
                pwd = System.getProperty(scheme + ".proxyPassword");
            } else {
                user = System.getProperty("java.net.socks.username");
                pwd = System.getProperty("java.net.socks.password");
            }
            httpClient.getAuthenticationStore().addAuthentication((Authentication)new BasicAuthentication(p.getURI(), "<<ANY_REALM>>", user, pwd));
        });
    }

    public static void configureProxy(HttpClient httpClient, String str) {
        try {
            URI uri = URI.create(str);
            URI proxyUri = new URI("ws".equalsIgnoreCase(uri.getScheme()) ? "http" : "https", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            boolean secure = "https".equalsIgnoreCase(proxyUri.getScheme());
            List<ProxyConfiguration.Proxy> proxies = ProxySelector.getDefault().select(proxyUri).stream().filter(p -> !p.equals(Proxy.NO_PROXY)).map(p -> {
                InetSocketAddress inetAddr = (InetSocketAddress)p.address();
                Origin.Address addr = new Origin.Address(inetAddr.getHostName(), inetAddr.getPort());
                if (p.type() == Proxy.Type.SOCKS) {
                    return new Socks4Proxy(addr, secure);
                }
                return new HttpProxy(addr, secure);
            }).collect(Collectors.toList());
            httpClient.getProxyConfiguration().getProxies().addAll(proxies);
            AgentUtils.addAuthentication(httpClient, proxies);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to configure proxy.", (Throwable)e);
        }
    }

    public static String nid8(Collection<UUID> nids) {
        return nids.stream().map(nid -> U.id8((UUID)nid).toUpperCase()).collect(Collectors.joining(",", "[", "]"));
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V val) {
        return new AbstractMap.SimpleEntry<K, V>(key, val);
    }

    public static <K, U> Collector<Map.Entry<K, U>, ?, Map<K, U>> entriesToMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static void send(Session ses, WebSocketResponse evt, long timeout, TimeUnit unit) throws Exception {
        Future fut = ses.getRemote().sendStringByFuture(Utils.toJson((Object)evt));
        try {
            fut.get(timeout, unit);
        }
        catch (TimeoutException e) {
            fut.cancel(true);
            throw e;
        }
    }

    public static List<String> split(String s) {
        if (F.isEmpty((String)s)) {
            return Collections.emptyList();
        }
        return Arrays.stream(s.trim().split(",")).map(String::trim).filter(item -> !F.isEmpty((String)item)).collect(Collectors.toList());
    }

    public static List<String> trim(List<String> lst) {
        return F.isEmpty(lst) ? lst : lst.stream().map(String::trim).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPasswordFromKeyStore(String name, String keyStorePath, String keyStorePwd) {
        if (F.isEmpty((String)keyStorePath)) {
            throw new IgniteException("Empty path to key store with passwords");
        }
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            try (FileInputStream fis = new FileInputStream(keyStorePath);){
                ks.load(fis, keyStorePwd.toCharArray());
                SecretKey secretKey = (SecretKey)ks.getKey(name, keyStorePwd.toCharArray());
                if (secretKey == null) {
                    throw new IgniteException(String.format("Failed to find password in key store: [name=%s, keyStorePath=%s]", name, keyStorePath));
                }
                String string = new String(secretKey.getEncoded());
                return string;
            }
        }
        catch (IOException e) {
            if (!(e.getCause() instanceof UnrecoverableKeyException)) throw new IgniteException("Failed to open passwords key store: " + keyStorePath, (Throwable)e);
            throw new IgniteException("Failed to read password from key store, please check key store password", (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new IgniteException("Failed to read password from key store", (Throwable)e);
        }
    }
}

