/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.agent;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.apache.ignite.console.agent.AgentConfiguration;
import org.apache.ignite.console.agent.AgentUtils;
import org.apache.ignite.console.agent.handlers.WebSocketRouter;
import org.apache.ignite.internal.util.typedef.F;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class AgentLauncher {
    private static final Logger log = LoggerFactory.getLogger(AgentLauncher.class);

    private static char[] readPassword(String fmt, Object ... args) {
        if (System.console() != null) {
            return System.console().readPassword(fmt, args);
        }
        System.out.print(String.format(fmt, args));
        return new Scanner(System.in).nextLine().toCharArray();
    }

    static AgentConfiguration parseArgs(String[] args) {
        URI uri;
        AgentConfiguration propCfg;
        JCommander jCommander;
        AgentConfiguration cfg;
        block16: {
            log.info("Starting Apache Ignite Web Console Agent...");
            cfg = new AgentConfiguration();
            jCommander = new JCommander((Object)cfg);
            String osName = System.getProperty("os.name").toLowerCase();
            jCommander.setProgramName("ignite-console-web-agent." + (osName.contains("win") ? "bat" : "sh"));
            try {
                jCommander.parse(args);
            }
            catch (ParameterException pe) {
                log.error("Failed to parse command line parameters: " + Arrays.toString(args), (Throwable)pe);
                jCommander.usage();
                return null;
            }
            String prop = cfg.configPath();
            propCfg = new AgentConfiguration();
            try {
                File f = AgentUtils.resolvePath(prop);
                if (f == null) {
                    log.warn("Failed to find properties file: " + prop);
                } else {
                    propCfg.load(f.toURI().toURL());
                }
            }
            catch (IOException e) {
                if ("default.properties".equals(prop)) break block16;
                log.warn("Failed to load properties file: " + prop, (Throwable)e);
            }
        }
        cfg.merge(propCfg);
        if (cfg.help()) {
            jCommander.usage();
            return null;
        }
        System.out.println();
        System.out.println("Web Console Agent configuration :");
        System.out.println(cfg);
        System.out.println();
        try {
            uri = URI.create(cfg.serverUri());
            if (uri.getScheme().startsWith("http")) {
                uri = new URI("http".equalsIgnoreCase(uri.getScheme()) ? "ws" : "wss", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
                cfg.serverUri(uri.toString());
            }
        }
        catch (Exception e) {
            log.error("Failed to parse Ignite Web Console uri", (Throwable)e);
            return null;
        }
        if (cfg.tokens() == null) {
            System.out.println("Security token is required to establish connection to the Web Console.");
            System.out.println(String.format("It is available on the Profile page: https://%s/profile", uri.getHost()));
            String tokens = String.valueOf(AgentLauncher.readPassword("Enter security tokens separated by comma: ", new Object[0]));
            cfg.tokens(AgentUtils.split(tokens));
        }
        if (!F.isEmpty((String)cfg.passwordsStore()) && F.isEmpty((String)cfg.passwordsStorePassword())) {
            System.out.println("The passwords key store path is specified, but password is empty!");
            String pwd = String.valueOf(AgentLauncher.readPassword("Enter password for key store: ", new Object[0]));
            cfg.passwordsStorePassword(pwd);
        }
        List<String> nodeURIs = cfg.nodeURIs();
        for (int i = nodeURIs.size() - 1; i >= 0; --i) {
            String nodeURI = nodeURIs.get(i);
            try {
                new URI(nodeURI);
                continue;
            }
            catch (URISyntaxException ignored) {
                log.warn("Failed to parse Ignite node URI: " + nodeURI);
                nodeURIs.remove(i);
            }
        }
        if (nodeURIs.isEmpty()) {
            log.error("Failed to find valid URIs for connect to Ignite node via REST. Please check settings");
            return null;
        }
        cfg.nodeURIs(nodeURIs);
        return cfg;
    }

    public static void main(String[] args) {
        AgentConfiguration cfg = AgentLauncher.parseArgs(args);
        if (cfg == null) {
            return;
        }
        try (WebSocketRouter websocket = new WebSocketRouter(cfg);){
            websocket.start();
            websocket.awaitClose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(0);
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

