/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.agent;

import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.ignite.console.agent.AgentUtils;
import org.apache.ignite.internal.util.typedef.F;

public class AgentConfiguration {
    public static final String DFLT_CFG_PATH = "default.properties";
    private static final String DFLT_SERVER_URI = "http://localhost:3000";
    private static final String DFLT_NODE_URI = "http://localhost:8080";
    @Parameter(names={"-t", "--tokens"}, description="User's tokens separated by comma used to connect to Ignite Console.")
    private List<String> tokens;
    @Parameter(names={"-s", "--server-uri"}, description="URI of Ignite Console server                 Default value: http://localhost:3000")
    private String srvUri;
    @Parameter(names={"-n", "--node-uri"}, description="Comma-separated list of URIs for connect to Ignite node via REST                              Default value: http://localhost:8080")
    private List<String> nodeURIs;
    @Parameter(names={"-nl", "--node-login"}, description="User name that will be used to connect to secured cluster")
    private String nodeLogin;
    @Parameter(names={"-np", "--node-password"}, description="Password that will be used to connect to secured cluster")
    private String nodePwd;
    private String demoNodeUri;
    @Parameter(names={"-c", "--config"}, description="Path to properties file                                        Default value: default.properties")
    private String cfgPath;
    @Parameter(names={"-d", "--driver-folder"}, description="Path to folder with JDBC drivers                                   Default value: ./jdbc-drivers")
    private String driversFolder;
    @Parameter(names={"-dd", "--disable-demo"}, description="Disable demo mode on this agent")
    private boolean disableDemo;
    @Parameter(names={"-nks", "--node-key-store"}, description="Path to key store that will be used to connect to cluster")
    private String nodeKeyStore;
    @Parameter(names={"-nksp", "--node-key-store-password"}, description="Optional password for node key store")
    private String nodeKeyStorePass;
    @Parameter(names={"-nts", "--node-trust-store"}, description="Path to trust store that will be used to connect to cluster")
    private String nodeTrustStore;
    @Parameter(names={"-ntsp", "--node-trust-store-password"}, description="Optional password for node trust store")
    private String nodeTrustStorePass;
    @Parameter(names={"-sks", "--server-key-store"}, description="Path to key store that will be used to connect to Web server")
    private String srvKeyStore;
    @Parameter(names={"-sksp", "--server-key-store-password"}, description="Optional password for server key store")
    private String srvKeyStorePass;
    @Parameter(names={"-sts", "--server-trust-store"}, description="Path to trust store that will be used to connect to Web server")
    private String srvTrustStore;
    @Parameter(names={"-stsp", "--server-trust-store-password"}, description="Optional password for server trust store")
    private String srvTrustStorePass;
    @Parameter(names={"-cs", "--cipher-suites"}, description="Optional comma-separated list of SSL cipher suites to be used to connect to server and cluster")
    private List<String> cipherSuites;
    @Parameter(names={"-pks", "--passwords-key-store"}, description="Path to key store that keeps encrypted passwords")
    private String passwordsStore;
    @Parameter(names={"-pksp", "--passwords-key-store-password"}, description="Password for passwords key store")
    private String passwordsStorePass;
    @Parameter(names={"-h", "--help"}, help=true, description="Print this help message")
    private boolean help;

    public List<String> tokens() {
        return this.tokens;
    }

    public AgentConfiguration tokens(List<String> tokens) {
        this.tokens = tokens;
        return this;
    }

    public String serverUri() {
        return this.srvUri;
    }

    public AgentConfiguration serverUri(String srvUri) {
        this.srvUri = srvUri;
        return this;
    }

    public List<String> nodeURIs() {
        return this.nodeURIs;
    }

    public AgentConfiguration nodeURIs(List<String> nodeURIs) {
        this.nodeURIs = nodeURIs;
        return this;
    }

    public String nodeLogin() {
        return this.nodeLogin;
    }

    public AgentConfiguration nodeLogin(String nodeLogin) {
        this.nodeLogin = nodeLogin;
        return this;
    }

    public String nodePassword() {
        return F.isEmpty((String)this.nodePwd) ? this.getPasswordFromKeyStore("node-password") : this.nodePwd;
    }

    public AgentConfiguration nodePassword(String nodePwd) {
        this.nodePwd = nodePwd;
        return this;
    }

    public String demoNodeUri() {
        return this.demoNodeUri;
    }

    public AgentConfiguration demoNodeUri(String demoNodeUri) {
        this.demoNodeUri = demoNodeUri;
        return this;
    }

    public String configPath() {
        return this.cfgPath == null ? DFLT_CFG_PATH : this.cfgPath;
    }

    public String driversFolder() {
        return this.driversFolder;
    }

    public AgentConfiguration driversFolder(String driversFolder) {
        this.driversFolder = driversFolder;
        return this;
    }

    public boolean disableDemo() {
        return this.disableDemo;
    }

    public AgentConfiguration disableDemo(boolean disableDemo) {
        this.disableDemo = disableDemo;
        return this;
    }

    public String nodeKeyStore() {
        return this.nodeKeyStore;
    }

    public AgentConfiguration nodeKeyStore(String nodeKeyStore) {
        this.nodeKeyStore = nodeKeyStore;
        return this;
    }

    public String nodeKeyStorePassword() {
        return F.isEmpty((String)this.nodeKeyStorePass) ? this.getPasswordFromKeyStore("node-key-store-password") : this.nodeKeyStorePass;
    }

    public AgentConfiguration nodeKeyStorePassword(String nodeKeyStorePass) {
        this.nodeKeyStorePass = nodeKeyStorePass;
        return this;
    }

    public String nodeTrustStore() {
        return this.nodeTrustStore;
    }

    public AgentConfiguration nodeTrustStore(String nodeTrustStore) {
        this.nodeTrustStore = nodeTrustStore;
        return this;
    }

    public String nodeTrustStorePassword() {
        return F.isEmpty((String)this.nodeTrustStorePass) ? this.getPasswordFromKeyStore("node-trust-store-password") : this.nodeTrustStorePass;
    }

    public AgentConfiguration nodeTrustStorePassword(String nodeTrustStorePass) {
        this.nodeTrustStorePass = nodeTrustStorePass;
        return this;
    }

    public String serverKeyStore() {
        return this.srvKeyStore;
    }

    public AgentConfiguration serverKeyStore(String srvKeyStore) {
        this.srvKeyStore = srvKeyStore;
        return this;
    }

    public String serverKeyStorePassword() {
        return F.isEmpty((String)this.srvKeyStorePass) ? this.getPasswordFromKeyStore("server-key-store-password") : this.srvKeyStorePass;
    }

    public AgentConfiguration serverKeyStorePassword(String srvKeyStorePass) {
        this.srvKeyStorePass = srvKeyStorePass;
        return this;
    }

    public String serverTrustStore() {
        return this.srvTrustStore;
    }

    public AgentConfiguration serverTrustStore(String srvTrustStore) {
        this.srvTrustStore = srvTrustStore;
        return this;
    }

    public String serverTrustStorePassword() {
        return F.isEmpty((String)this.srvTrustStorePass) ? this.getPasswordFromKeyStore("server-trust-store-password") : this.srvTrustStorePass;
    }

    public AgentConfiguration serverTrustStorePassword(String srvTrustStorePass) {
        this.srvTrustStorePass = srvTrustStorePass;
        return this;
    }

    public String passwordsStore() {
        return this.passwordsStore;
    }

    public AgentConfiguration passwordsStore(String passwordsStore) {
        this.passwordsStore = passwordsStore;
        return this;
    }

    public String passwordsStorePassword() {
        return this.passwordsStorePass;
    }

    public AgentConfiguration passwordsStorePassword(String passwordsStorePass) {
        this.passwordsStorePass = passwordsStorePass;
        return this;
    }

    public List<String> cipherSuites() {
        return this.cipherSuites;
    }

    public AgentConfiguration cipherSuites(List<String> cipherSuites) {
        this.cipherSuites = cipherSuites;
        return this;
    }

    public boolean help() {
        return this.help;
    }

    public void load(URL cfgUrl) throws IOException {
        String val;
        Properties props = new Properties();
        try (InputStreamReader reader = new InputStreamReader(cfgUrl.openStream(), StandardCharsets.UTF_8);){
            props.load(reader);
        }
        List<String> items = AgentUtils.split(props.getProperty("tokens"));
        if (!F.isEmpty(items)) {
            this.tokens(items);
        }
        if (!F.isEmpty((String)(val = props.getProperty("server-uri")))) {
            this.serverUri(val);
        }
        if (!F.isEmpty(items = AgentUtils.split(props.getProperty("node-uri")))) {
            this.nodeURIs(items);
        }
        if (!F.isEmpty((String)(val = props.getProperty("node-login")))) {
            this.nodeLogin(val);
        }
        if (!F.isEmpty((String)(val = props.getProperty("node-password")))) {
            this.nodePassword(val);
        }
        if (!F.isEmpty((String)(val = props.getProperty("driver-folder")))) {
            this.driversFolder(val);
        }
        if (!F.isEmpty((String)(val = props.getProperty("node-key-store")))) {
            this.nodeKeyStore(val);
        }
        if (!F.isEmpty((String)(val = props.getProperty("node-key-store-password")))) {
            this.nodeKeyStorePassword(val);
        }
        if (!F.isEmpty((String)(val = props.getProperty("node-trust-store")))) {
            this.nodeTrustStore(val);
        }
        if (!F.isEmpty((String)(val = props.getProperty("node-trust-store-password")))) {
            this.nodeTrustStorePassword(val);
        }
        if (!F.isEmpty((String)(val = props.getProperty("server-key-store")))) {
            this.serverKeyStore(val);
        }
        if (!F.isEmpty((String)(val = props.getProperty("server-key-store-password")))) {
            this.serverKeyStorePassword(val);
        }
        if (!F.isEmpty((String)(val = props.getProperty("server-trust-store")))) {
            this.serverTrustStore(val);
        }
        if (!F.isEmpty((String)(val = props.getProperty("server-trust-store-password")))) {
            this.serverTrustStorePassword(val);
        }
        if (!F.isEmpty((String)(val = props.getProperty("passwords-key-store")))) {
            this.passwordsStore(val);
        }
        if (!F.isEmpty(items = AgentUtils.split(props.getProperty("cipher-suites")))) {
            this.cipherSuites(items);
        }
    }

    public void merge(AgentConfiguration cfg) {
        if (this.tokens == null) {
            this.tokens(cfg.tokens());
        }
        if (this.srvUri == null) {
            this.serverUri(cfg.serverUri());
        }
        if (this.srvUri == null) {
            this.serverUri(DFLT_SERVER_URI);
        }
        if (this.nodeURIs == null) {
            this.nodeURIs(cfg.nodeURIs());
        }
        if (this.nodeURIs == null) {
            this.nodeURIs(Collections.singletonList(DFLT_NODE_URI));
        }
        if (this.nodeLogin == null) {
            this.nodeLogin(cfg.nodeLogin());
        }
        if (this.nodePwd == null) {
            this.nodePassword(cfg.nodePassword());
        }
        if (this.driversFolder == null) {
            this.driversFolder(cfg.driversFolder());
        }
        this.disableDemo(this.disableDemo || cfg.disableDemo());
        if (this.nodeKeyStore == null) {
            this.nodeKeyStore(cfg.nodeKeyStore());
        }
        if (this.nodeKeyStorePass == null) {
            this.nodeKeyStorePassword(cfg.nodeKeyStorePassword());
        }
        if (this.nodeTrustStore == null) {
            this.nodeTrustStore(cfg.nodeTrustStore());
        }
        if (this.nodeTrustStorePass == null) {
            this.nodeTrustStorePassword(cfg.nodeTrustStorePassword());
        }
        if (this.srvKeyStore == null) {
            this.serverKeyStore(cfg.serverKeyStore());
        }
        if (this.srvKeyStorePass == null) {
            this.serverKeyStorePassword(cfg.serverKeyStorePassword());
        }
        if (this.srvTrustStore == null) {
            this.serverTrustStore(cfg.serverTrustStore());
        }
        if (this.srvTrustStorePass == null) {
            this.serverTrustStorePassword(cfg.serverTrustStorePassword());
        }
        if (this.passwordsStore == null) {
            this.passwordsStore(cfg.passwordsStore());
        }
        if (this.passwordsStorePass == null) {
            this.passwordsStorePassword(cfg.passwordsStorePassword());
        }
        if (this.cipherSuites == null) {
            this.cipherSuites(cfg.cipherSuites());
        }
        this.tokens = AgentUtils.trim(this.tokens);
        this.nodeURIs = AgentUtils.trim(this.nodeURIs);
        this.cipherSuites = AgentUtils.trim(this.cipherSuites);
    }

    public String toString() {
        File agentHome;
        StringBuilder sb = new StringBuilder();
        String nl = System.lineSeparator();
        if (!F.isEmpty(this.tokens)) {
            sb.append("User's security tokens          : ");
            sb.append(AgentUtils.secured(this.tokens)).append(nl);
        }
        sb.append("URI to Ignite node REST server  : ").append(this.nodeURIs == null ? DFLT_NODE_URI : String.join((CharSequence)", ", this.nodeURIs)).append(nl);
        if (this.nodeLogin != null) {
            sb.append("Login to Ignite node REST server: ").append(this.nodeLogin).append(nl);
        }
        sb.append("URI to Ignite Console server    : ").append(this.srvUri == null ? DFLT_SERVER_URI : this.srvUri).append(nl);
        sb.append("Path to properties file         : ").append(this.configPath()).append(nl);
        String drvFld = this.driversFolder();
        if (drvFld == null && (agentHome = AgentUtils.getAgentHome()) != null) {
            drvFld = new File(agentHome, "jdbc-drivers").getPath();
        }
        sb.append("Path to JDBC drivers folder     : ").append(drvFld).append(nl);
        sb.append("Demo mode                       : ").append(this.disableDemo() ? "disabled" : "enabled").append(nl);
        if (!F.isEmpty((String)this.nodeKeyStore)) {
            sb.append("Node key store                  : ").append(this.nodeKeyStore).append(nl);
        }
        if (!F.isEmpty((String)this.nodeKeyStorePass)) {
            sb.append("Node key store password         : ").append(AgentUtils.secured(this.nodeKeyStorePass)).append(nl);
        }
        if (!F.isEmpty((String)this.nodeTrustStore)) {
            sb.append("Node trust store                : ").append(this.nodeTrustStore).append(nl);
        }
        if (!F.isEmpty((String)this.nodeTrustStorePass)) {
            sb.append("Node trust store password       : ").append(AgentUtils.secured(this.nodeTrustStorePass)).append(nl);
        }
        if (!F.isEmpty((String)this.srvKeyStore)) {
            sb.append("Server key store                : ").append(this.srvKeyStore).append(nl);
        }
        if (!F.isEmpty((String)this.srvKeyStorePass)) {
            sb.append("Server key store password       : ").append(AgentUtils.secured(this.srvKeyStorePass)).append(nl);
        }
        if (!F.isEmpty((String)this.srvTrustStore)) {
            sb.append("Server trust store              : ").append(this.srvTrustStore).append(nl);
        }
        if (!F.isEmpty((String)this.srvTrustStorePass)) {
            sb.append("Server trust store password     : ").append(AgentUtils.secured(this.srvTrustStorePass)).append(nl);
        }
        if (!F.isEmpty((String)this.passwordsStore)) {
            sb.append("Passwords key store             : ").append(this.passwordsStore).append(nl);
        }
        if (!F.isEmpty(this.cipherSuites)) {
            sb.append("Cipher suites                   : ").append(String.join((CharSequence)", ", this.cipherSuites)).append(nl);
        }
        return sb.toString();
    }

    private String getPasswordFromKeyStore(String name) {
        if (!F.isEmpty((String)this.passwordsStore) && !F.isEmpty((String)this.passwordsStorePass)) {
            return AgentUtils.getPasswordFromKeyStore(name, this.passwordsStore, this.passwordsStorePass);
        }
        return null;
    }
}

