/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.PN;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.jetbrains.annotations.Nullable;

public class TcpDiscoveryNodesRing {
    public static final IgnitePredicate<TcpDiscoveryNode> VISIBLE_NODES = new P1<TcpDiscoveryNode>(){

        @Override
        public boolean apply(TcpDiscoveryNode node) {
            if (node.visible()) {
                assert (node.order() > 0L) : "Invalid node order: " + node;
                return true;
            }
            return false;
        }
    };
    private static final PN CLIENT_NODES = new PN(){

        @Override
        public boolean apply(ClusterNode node) {
            assert (node instanceof TcpDiscoveryNode) : node;
            return ((TcpDiscoveryNode)node).clientRouterNodeId() != null;
        }
    };
    private volatile TcpDiscoveryNode locNode;
    @GridToStringInclude
    private NavigableSet<TcpDiscoveryNode> nodes = new TreeSet<TcpDiscoveryNode>();
    @GridToStringExclude
    private Map<UUID, TcpDiscoveryNode> nodesMap = new HashMap<UUID, TcpDiscoveryNode>();
    private long topVer;
    private long nodeOrder;
    private long maxInternalOrder;
    @GridToStringExclude
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private IgniteProductVersion minNodeVer;

    public IgniteProductVersion minimumNodeVersion() {
        this.rwLock.readLock().lock();
        try {
            IgniteProductVersion igniteProductVersion = this.minNodeVer;
            return igniteProductVersion;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void localNode(TcpDiscoveryNode locNode) {
        assert (locNode != null);
        this.rwLock.writeLock().lock();
        try {
            this.locNode = locNode;
            this.clear();
            this.maxInternalOrder = locNode.internalOrder();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public Collection<TcpDiscoveryNode> allNodes() {
        return this.nodes(new IgnitePredicate[0]);
    }

    public Collection<TcpDiscoveryNode> visibleNodes() {
        return this.nodes(VISIBLE_NODES);
    }

    public Collection<TcpDiscoveryNode> remoteNodes() {
        return this.nodes(F.remoteNodes(this.locNode.id()));
    }

    public Collection<TcpDiscoveryNode> visibleRemoteNodes() {
        return this.nodes(F.remoteNodes(this.locNode.id()), VISIBLE_NODES);
    }

    public Collection<TcpDiscoveryNode> clientNodes() {
        return this.nodes(CLIENT_NODES);
    }

    public boolean hasRemoteNodes() {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.nodes.size() > 1;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRemoteServerNodes() {
        this.rwLock.readLock().lock();
        try {
            if (this.nodes.size() < 2) {
                boolean bl = false;
                return bl;
            }
            for (TcpDiscoveryNode node : this.nodes) {
                if (node.clientRouterNodeId() != null || node.id().equals(this.locNode.id())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(TcpDiscoveryNode node) {
        assert (node != null);
        assert (node.internalOrder() > 0L);
        this.rwLock.writeLock().lock();
        try {
            if (this.nodesMap.containsKey(node.id())) {
                boolean bl = false;
                return bl;
            }
            long maxInternalOrder0 = this.maxInternalOrder();
            assert (node.internalOrder() > maxInternalOrder0) : "Adding node to the middle of the ring [ring=" + this + ", node=" + node + ']';
            this.nodesMap.put(node.id(), node);
            this.nodes = new TreeSet<TcpDiscoveryNode>((SortedSet<TcpDiscoveryNode>)this.nodes);
            node.lastUpdateTime(U.currentTimeMillis());
            this.nodes.add(node);
            this.nodeOrder = node.internalOrder();
            this.maxInternalOrder = node.internalOrder();
            this.initializeMinimumVersion();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long maxInternalOrder() {
        this.rwLock.readLock().lock();
        try {
            if (this.maxInternalOrder == 0L) {
                TcpDiscoveryNode last = (TcpDiscoveryNode)this.nodes.last();
                long l = last != null ? (this.maxInternalOrder = last.internalOrder()) : -1L;
                return l;
            }
            long l = this.maxInternalOrder;
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreTopology(Iterable<TcpDiscoveryNode> nodes, long topVer) {
        assert (!F.isEmpty(nodes));
        assert (topVer > 0L);
        this.rwLock.writeLock().lock();
        try {
            this.locNode.internalOrder(topVer);
            this.clear();
            boolean firstAdd = true;
            for (TcpDiscoveryNode node : nodes) {
                if (this.nodesMap.containsKey(node.id())) continue;
                this.nodesMap.put(node.id(), node);
                if (firstAdd) {
                    this.nodes = new TreeSet<TcpDiscoveryNode>((SortedSet<TcpDiscoveryNode>)this.nodes);
                    firstAdd = false;
                }
                node.lastUpdateTime(U.currentTimeMillis());
                this.nodes.add(node);
            }
            this.nodeOrder = topVer;
            this.initializeMinimumVersion();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Nullable
    public TcpDiscoveryNode node(UUID nodeId) {
        assert (nodeId != null);
        this.rwLock.readLock().lock();
        try {
            TcpDiscoveryNode tcpDiscoveryNode = this.nodesMap.get(nodeId);
            return tcpDiscoveryNode;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TcpDiscoveryNode removeNode(UUID nodeId) {
        assert (nodeId != null);
        assert (!this.locNode.id().equals(nodeId));
        this.rwLock.writeLock().lock();
        try {
            TcpDiscoveryNode rmv = this.nodesMap.remove(nodeId);
            if (rmv != null) {
                this.nodes = new TreeSet<TcpDiscoveryNode>((SortedSet<TcpDiscoveryNode>)this.nodes);
                this.nodes.remove(rmv);
            }
            this.initializeMinimumVersion();
            TcpDiscoveryNode tcpDiscoveryNode = rmv;
            return tcpDiscoveryNode;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void clear() {
        this.rwLock.writeLock().lock();
        try {
            this.nodes = new TreeSet<TcpDiscoveryNode>();
            if (this.locNode != null) {
                this.nodes.add(this.locNode);
            }
            this.nodesMap = new HashMap<UUID, TcpDiscoveryNode>();
            if (this.locNode != null) {
                this.nodesMap.put(this.locNode.id(), this.locNode);
            }
            this.nodeOrder = 0L;
            this.maxInternalOrder = 0L;
            this.topVer = 0L;
            if (this.locNode != null) {
                this.minNodeVer = this.locNode.version();
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Nullable
    public TcpDiscoveryNode coordinator() {
        this.rwLock.readLock().lock();
        try {
            if (F.isEmpty(this.nodes)) {
                TcpDiscoveryNode tcpDiscoveryNode = null;
                return tcpDiscoveryNode;
            }
            TcpDiscoveryNode tcpDiscoveryNode = this.coordinator(null);
            return tcpDiscoveryNode;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TcpDiscoveryNode coordinator(@Nullable Collection<TcpDiscoveryNode> excluded) {
        this.rwLock.readLock().lock();
        try {
            Collection<TcpDiscoveryNode> filtered = this.serverNodes(excluded);
            if (F.isEmpty(filtered)) {
                TcpDiscoveryNode tcpDiscoveryNode = null;
                return tcpDiscoveryNode;
            }
            TcpDiscoveryNode tcpDiscoveryNode = Collections.min(filtered);
            return tcpDiscoveryNode;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Nullable
    public TcpDiscoveryNode nextNode() {
        this.rwLock.readLock().lock();
        try {
            if (this.nodes.size() < 2) {
                TcpDiscoveryNode tcpDiscoveryNode = null;
                return tcpDiscoveryNode;
            }
            TcpDiscoveryNode tcpDiscoveryNode = this.nextNode(null);
            return tcpDiscoveryNode;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TcpDiscoveryNode nextNode(@Nullable Collection<TcpDiscoveryNode> excluded) {
        assert (this.locNode.internalOrder() > 0L) : this.locNode;
        assert (excluded == null || excluded.isEmpty() || !excluded.contains(this.locNode)) : excluded;
        this.rwLock.readLock().lock();
        try {
            TcpDiscoveryNode node;
            Collection<TcpDiscoveryNode> filtered = this.serverNodes(excluded);
            if (filtered.size() < 2) {
                TcpDiscoveryNode tcpDiscoveryNode = null;
                return tcpDiscoveryNode;
            }
            Iterator<TcpDiscoveryNode> iter = filtered.iterator();
            while (iter.hasNext() && !this.locNode.equals(node = iter.next())) {
            }
            TcpDiscoveryNode tcpDiscoveryNode = iter.hasNext() ? iter.next() : F.first(filtered);
            return tcpDiscoveryNode;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TcpDiscoveryNode previousNode(@Nullable Collection<TcpDiscoveryNode> excluded) {
        this.rwLock.readLock().lock();
        try {
            Collection<TcpDiscoveryNode> filtered = this.serverNodes(excluded);
            if (filtered.size() < 2) {
                TcpDiscoveryNode tcpDiscoveryNode = null;
                return tcpDiscoveryNode;
            }
            TcpDiscoveryNode previous = null;
            for (TcpDiscoveryNode node : filtered) {
                if (this.locNode.equals(node) && previous != null) break;
                previous = node;
            }
            Iterator<TcpDiscoveryNode> iterator = previous;
            return iterator;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public TcpDiscoveryNode previousNodeOf(TcpDiscoveryNode ringNode) {
        this.rwLock.readLock().lock();
        try {
            TcpDiscoveryNode prev = null;
            for (TcpDiscoveryNode node : this.nodes) {
                if (node.equals(ringNode)) {
                    if (prev == null) {
                        TcpDiscoveryNode tcpDiscoveryNode = (TcpDiscoveryNode)this.nodes.last();
                        return tcpDiscoveryNode;
                    }
                    TcpDiscoveryNode tcpDiscoveryNode = prev;
                    return tcpDiscoveryNode;
                }
                prev = node;
            }
            throw new IllegalArgumentException("Failed to find previous node (ringNode is not in the ring) [ring=" + this + ", ringNode=" + ringNode + ']');
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public long topologyVersion() {
        this.rwLock.readLock().lock();
        try {
            long l = this.topVer;
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean topologyVersion(long topVer) {
        this.rwLock.writeLock().lock();
        try {
            if (this.topVer < topVer) {
                this.topVer = topVer;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public long incrementTopologyVersion() {
        this.rwLock.writeLock().lock();
        try {
            long l = ++this.topVer;
            return l;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public long nextNodeOrder() {
        this.rwLock.writeLock().lock();
        try {
            if (this.nodeOrder == 0L) {
                this.nodeOrder = this.maxInternalOrder();
            }
            long l = ++this.nodeOrder;
            return l;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<TcpDiscoveryNode> nodes(IgnitePredicate<? super TcpDiscoveryNode> ... p) {
        this.rwLock.readLock().lock();
        try {
            List list = U.arrayList(this.nodes, p);
            Collection<TcpDiscoveryNode> collection = Collections.unmodifiableCollection(list);
            return collection;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private Collection<TcpDiscoveryNode> serverNodes(final @Nullable Collection<TcpDiscoveryNode> excluded) {
        final boolean excludedEmpty = F.isEmpty(excluded);
        return F.view(this.nodes, new P1<TcpDiscoveryNode>(){

            @Override
            public boolean apply(TcpDiscoveryNode node) {
                return node.clientRouterNodeId() == null && (excludedEmpty || !excluded.contains(node));
            }
        });
    }

    private void initializeMinimumVersion() {
        this.minNodeVer = null;
        for (TcpDiscoveryNode node : this.nodes) {
            if (this.minNodeVer != null && node.version().compareTo(this.minNodeVer) >= 0) continue;
            this.minNodeVer = node.version();
        }
    }

    public String toString() {
        this.rwLock.readLock().lock();
        try {
            String string = S.toString(TcpDiscoveryNodesRing.class, this);
            return string;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }
}

