/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.internal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;

public class DiscoveryDataPacket
implements Serializable {
    private static int ZIP_HEADER_SIGNATURE = 67324752;
    private static final long serialVersionUID = 0L;
    private final UUID joiningNodeId;
    private Map<Integer, byte[]> joiningNodeData = new HashMap<Integer, byte[]>();
    private transient Map<Integer, Serializable> unmarshalledJoiningNodeData;
    private Map<Integer, byte[]> commonData = new HashMap<Integer, byte[]>();
    private Map<UUID, Map<Integer, byte[]>> nodeSpecificData = new LinkedHashMap<UUID, Map<Integer, byte[]>>();
    private transient boolean joiningNodeClient;

    public DiscoveryDataPacket(UUID joiningNodeId) {
        this.joiningNodeId = joiningNodeId;
    }

    public UUID joiningNodeId() {
        return this.joiningNodeId;
    }

    public void marshalGridNodeData(DiscoveryDataBag bag, UUID nodeId, Marshaller marsh, boolean isCompressionEnabled, int compressionLevel, IgniteLogger log) {
        this.marshalData(bag.commonData(), this.commonData, marsh, isCompressionEnabled, compressionLevel, log);
        Map<Integer, Serializable> locNodeSpecificData = bag.localNodeSpecificData();
        if (locNodeSpecificData != null) {
            HashMap<Integer, byte[]> marshLocNodeSpecificData = U.newHashMap(locNodeSpecificData.size());
            this.marshalData(locNodeSpecificData, marshLocNodeSpecificData, marsh, isCompressionEnabled, compressionLevel, log);
            this.filterDuplicatedData(marshLocNodeSpecificData);
            if (!marshLocNodeSpecificData.isEmpty()) {
                this.nodeSpecificData.put(nodeId, marshLocNodeSpecificData);
            }
        }
    }

    public void marshalJoiningNodeData(DiscoveryDataBag bag, Marshaller marsh, boolean isCompressionEnabled, int compressionLevel, IgniteLogger log) {
        this.marshalData(bag.joiningNodeData(), this.joiningNodeData, marsh, isCompressionEnabled, compressionLevel, log);
    }

    public boolean hasZippedJoiningData() {
        Set<Map.Entry<Integer, byte[]>> datas;
        if (this.joiningNodeData == null || (datas = this.joiningNodeData.entrySet()) == null) {
            return false;
        }
        for (Map.Entry<Integer, byte[]> entry : datas) {
            if (!this.isZipped(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public DiscoveryDataBag unmarshalGridData(Marshaller marsh, ClassLoader clsLdr, boolean clientNode, IgniteLogger log) {
        DiscoveryDataBag dataBag = new DiscoveryDataBag(this.joiningNodeId, this.joiningNodeClient);
        if (this.commonData != null && !this.commonData.isEmpty()) {
            dataBag.commonData(this.unmarshalData(this.commonData, marsh, clsLdr, clientNode, log));
        }
        if (this.nodeSpecificData != null && !this.nodeSpecificData.isEmpty()) {
            LinkedHashMap<UUID, Map<Integer, Serializable>> unmarshNodeSpecData = U.newLinkedHashMap(this.nodeSpecificData.size());
            for (Map.Entry<UUID, Map<Integer, byte[]>> nodeBinEntry : this.nodeSpecificData.entrySet()) {
                Map<Integer, byte[]> nodeBinData = nodeBinEntry.getValue();
                if (nodeBinData == null || nodeBinData.isEmpty()) continue;
                unmarshNodeSpecData.put(nodeBinEntry.getKey(), this.unmarshalData(nodeBinData, marsh, clsLdr, clientNode, log));
            }
            dataBag.nodeSpecificData(unmarshNodeSpecData);
        }
        return dataBag;
    }

    public DiscoveryDataBag unmarshalJoiningNodeData(Marshaller marsh, ClassLoader clsLdr, boolean clientNode, IgniteLogger log) {
        DiscoveryDataBag dataBag = new DiscoveryDataBag(this.joiningNodeId, this.joiningNodeClient);
        if (this.joiningNodeData != null && !this.joiningNodeData.isEmpty()) {
            this.unmarshalledJoiningNodeData = this.unmarshalData(this.joiningNodeData, marsh, clsLdr, clientNode, log);
            dataBag.joiningNodeData(this.unmarshalledJoiningNodeData);
        }
        return dataBag;
    }

    public boolean hasJoiningNodeData() {
        return this.joiningNodeData != null && !this.joiningNodeData.isEmpty();
    }

    public boolean hasDataFromNode(UUID nodeId) {
        return this.nodeSpecificData.containsKey(nodeId);
    }

    public boolean mergeDataFrom(DiscoveryDataPacket existingDataPacket, Collection<Integer> mrgdCmnDataKeys, Collection<UUID> mrgdSpecifDataKeys) {
        boolean add;
        Object data;
        if (this.commonData.size() != mrgdCmnDataKeys.size()) {
            for (Map.Entry<Integer, byte[]> entry : this.commonData.entrySet()) {
                if (mrgdCmnDataKeys.contains(entry.getKey()) || (data = existingDataPacket.commonData.get(entry.getKey())) == null || !Arrays.equals(entry.getValue(), data)) continue;
                entry.setValue((byte[])data);
                add = mrgdCmnDataKeys.add(entry.getKey());
                assert (add);
                if (mrgdCmnDataKeys.size() != this.commonData.size()) continue;
                break;
            }
        }
        if (this.nodeSpecificData.size() != mrgdSpecifDataKeys.size()) {
            for (Map.Entry<Comparable<Integer>, Object> entry : this.nodeSpecificData.entrySet()) {
                if (mrgdSpecifDataKeys.contains(entry.getKey()) || (data = (Object)existingDataPacket.nodeSpecificData.get(entry.getKey())) == null || !this.mapsEqual((Map)entry.getValue(), (Map<Integer, byte[]>)data)) continue;
                entry.setValue(data);
                add = mrgdSpecifDataKeys.add((UUID)entry.getKey());
                assert (add);
                if (mrgdSpecifDataKeys.size() != this.nodeSpecificData.size()) continue;
                break;
            }
        }
        return mrgdCmnDataKeys.size() == this.commonData.size() && mrgdSpecifDataKeys.size() == this.nodeSpecificData.size();
    }

    private boolean mapsEqual(Map<Integer, byte[]> m1, Map<Integer, byte[]> m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1.size() == m2.size()) {
            for (Map.Entry<Integer, byte[]> e : m1.entrySet()) {
                byte[] data = m2.get(e.getKey());
                if (Arrays.equals(e.getValue(), data)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Map<Integer, Serializable> unmarshalData(Map<Integer, byte[]> src, Marshaller marsh, ClassLoader clsLdr, boolean clientNode, IgniteLogger log) {
        HashMap<Integer, Serializable> res = U.newHashMap(src.size());
        for (Map.Entry<Integer, byte[]> binEntry : src.entrySet()) {
            try {
                Serializable compData = this.isZipped(binEntry.getValue()) ? (Serializable)U.unmarshalZip(marsh, binEntry.getValue(), clsLdr) : (Serializable)U.unmarshal(marsh, binEntry.getValue(), clsLdr);
                res.put(binEntry.getKey(), compData);
            }
            catch (IgniteCheckedException e) {
                if (GridComponent.DiscoveryDataExchangeType.CONTINUOUS_PROC.ordinal() == binEntry.getKey().intValue() && X.hasCause((Throwable)e, ClassNotFoundException.class) && clientNode) {
                    U.warn(log, "Failed to unmarshal continuous query remote filter on client node. Can be ignored.");
                    continue;
                }
                U.error(log, "Failed to unmarshal discovery data for component: " + binEntry.getKey(), e);
            }
        }
        return res;
    }

    private boolean isZipped(byte[] value) {
        return value != null && value.length > 3 && DiscoveryDataPacket.makeInt(value) == ZIP_HEADER_SIGNATURE;
    }

    private static int makeInt(byte[] b) {
        return b[3] << 24 | (b[2] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[0] & 0xFF;
    }

    private void marshalData(Map<Integer, Serializable> src, Map<Integer, byte[]> target, Marshaller marsh, boolean isCompressionEnabled, int compressionLevel, IgniteLogger log) {
        if (src == null) {
            return;
        }
        for (Map.Entry<Integer, Serializable> entry : src.entrySet()) {
            try {
                target.put(entry.getKey(), isCompressionEnabled ? U.zip(U.marshal(marsh, (Object)entry.getValue()), compressionLevel) : U.marshal(marsh, (Object)entry.getValue()));
            }
            catch (IgniteCheckedException e) {
                U.error(log, "Failed to marshal discovery data [comp=" + entry.getKey() + ", data=" + entry.getValue() + ']', e);
            }
        }
    }

    public void unzipZippedData(IgniteLogger log) {
        for (Map.Entry<Integer, byte[]> entry : this.joiningNodeData.entrySet()) {
            try {
                if (!this.isZipped(entry.getValue())) continue;
                entry.setValue(U.unzip(entry.getValue()));
            }
            catch (IgniteCheckedException e) {
                U.error(log, "Failed to unzip discovery data [comp=" + entry.getKey() + ']', e);
            }
        }
    }

    private void filterDuplicatedData(Map<Integer, byte[]> discoData) {
        for (Map<Integer, byte[]> existingData : this.nodeSpecificData.values()) {
            Iterator<Map.Entry<Integer, byte[]>> it = discoData.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, byte[]> discoDataEntry = it.next();
                byte[] curData = existingData.get(discoDataEntry.getKey());
                if (!Arrays.equals(curData, discoDataEntry.getValue())) continue;
                it.remove();
            }
            if (!discoData.isEmpty()) continue;
            break;
        }
    }

    public DiscoveryDataBag bagForDataCollection() {
        DiscoveryDataBag dataBag = new DiscoveryDataBag(this.joiningNodeId, this.commonData.keySet(), this.joiningNodeClient);
        if (this.unmarshalledJoiningNodeData != null) {
            dataBag.joiningNodeData(this.unmarshalledJoiningNodeData);
        }
        return dataBag;
    }

    public void joiningNodeClient(boolean joiningNodeClient) {
        this.joiningNodeClient = joiningNodeClient;
    }
}

