/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi;

import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiOperationTimeoutException;
import org.apache.ignite.spi.TimeoutStrategy;

public class ExponentialBackoffTimeoutStrategy
implements TimeoutStrategy {
    private static final double DLFT_BACKOFF_COEFF = 2.0;
    private final long maxTimeout;
    private final long totalTimeout;
    private final long start;
    private long currTimeout;

    public static long totalBackoffTimeout(long initTimeout, long maxTimeout, long reconCnt) {
        long totalBackoffTimeout = initTimeout;
        int i = 1;
        while ((long)i < reconCnt && totalBackoffTimeout < maxTimeout) {
            totalBackoffTimeout += ExponentialBackoffTimeoutStrategy.backoffTimeout(totalBackoffTimeout, maxTimeout);
            ++i;
        }
        return totalBackoffTimeout;
    }

    public static long backoffTimeout(long timeout, long maxTimeout) {
        return (long)Math.min((double)timeout * 2.0, (double)maxTimeout);
    }

    public ExponentialBackoffTimeoutStrategy(long totalTimeout, long startTimeout, long maxTimeout) {
        this.totalTimeout = totalTimeout;
        this.maxTimeout = maxTimeout;
        this.currTimeout = startTimeout;
        this.start = U.currentTimeMillis();
    }

    @Override
    public long nextTimeout(long timeout) throws IgniteSpiOperationTimeoutException {
        long remainingTime = this.remainingTime(U.currentTimeMillis());
        if (remainingTime <= 0L) {
            throw new IgniteSpiOperationTimeoutException("Operation timed out [timeoutStrategy= " + this + "]");
        }
        if (timeout == 0L) {
            long prevTimeout = this.currTimeout;
            this.currTimeout = ExponentialBackoffTimeoutStrategy.backoffTimeout(this.currTimeout, this.maxTimeout);
            return Math.min(prevTimeout, remainingTime);
        }
        return Math.min(timeout, remainingTime);
    }

    public long remainingTime(long curTs) {
        return this.totalTimeout - (curTs - this.start);
    }

    @Override
    public boolean checkTimeout(long timeInFut) {
        return this.remainingTime(U.currentTimeMillis() + timeInFut) <= 0L;
    }

    public String toString() {
        return S.toString(ExponentialBackoffTimeoutStrategy.class, this);
    }
}

