/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorIdleVerifyTaskArg
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private Set<String> caches;
    private Set<String> excludeCaches;
    private boolean checkCrc;

    public VisorIdleVerifyTaskArg() {
    }

    public VisorIdleVerifyTaskArg(Set<String> caches, Set<String> excludeCaches, boolean checkCrc) {
        this.caches = caches;
        this.excludeCaches = excludeCaches;
        this.checkCrc = checkCrc;
    }

    public VisorIdleVerifyTaskArg(Set<String> caches, boolean checkCrc) {
        this.caches = caches;
        this.checkCrc = checkCrc;
    }

    public VisorIdleVerifyTaskArg(Set<String> caches) {
        this.caches = caches;
    }

    public boolean isCheckCrc() {
        return this.checkCrc;
    }

    public Set<String> getCaches() {
        return this.caches;
    }

    public Set<String> getExcludeCaches() {
        return this.excludeCaches;
    }

    @Override
    public byte getProtocolVersion() {
        return 3;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCollection(out, this.caches);
        if (this.instanceOfCurrentClass()) {
            U.writeCollection(out, this.excludeCaches);
            out.writeBoolean(this.checkCrc);
        }
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.caches = U.readSet(in);
        if (this.instanceOfCurrentClass()) {
            if (protoVer >= 2) {
                this.excludeCaches = U.readSet(in);
            }
            if (protoVer >= 3) {
                this.checkCrc = in.readBoolean();
            }
        }
    }

    protected void excludeCaches(Set<String> excludeCaches) {
        this.excludeCaches = excludeCaches;
    }

    protected void checkCrc(boolean checkCrc) {
        this.checkCrc = checkCrc;
    }

    public String toString() {
        return S.toString(VisorIdleVerifyTaskArg.class, this);
    }

    private boolean instanceOfCurrentClass() {
        return VisorIdleVerifyTaskArg.class == this.getClass();
    }
}

