/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.baseline;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.discovery.IgniteClusterNode;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.jetbrains.annotations.Nullable;

public class VisorBaselineNode
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String consistentId;
    private Map<String, Object> attrs;
    @Nullable
    private Long order;

    public VisorBaselineNode() {
    }

    public VisorBaselineNode(BaselineNode node) {
        this.consistentId = String.valueOf(node.consistentId());
        this.attrs = node.attributes();
        if (node instanceof IgniteClusterNode) {
            this.order = ((ClusterNode)node).order();
        }
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    public String getConsistentId() {
        return this.consistentId;
    }

    public Map<String, Object> getAttributes() {
        return this.attrs;
    }

    @Nullable
    public Long getOrder() {
        return this.order;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.consistentId);
        U.writeMap(out, this.attrs);
        out.writeObject(this.order);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.consistentId = U.readString(in);
        this.attrs = U.readMap(in);
        if (protoVer >= 2) {
            this.order = (Long)in.readObject();
        }
    }

    public String toString() {
        return S.toString(VisorBaselineNode.class, this);
    }
}

