/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.Nullable;

public abstract class VisorMultiNodeTask<A, R, J>
implements ComputeTask<VisorTaskArgument<A>, R> {
    @IgniteInstanceResource
    protected transient IgniteEx ignite;
    protected boolean debug;
    protected A taskArg;
    protected long start;

    protected abstract VisorJob<A, J> job(A var1);

    @Override
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, VisorTaskArgument<A> arg) {
        assert (arg != null);
        this.start = U.currentTimeMillis();
        this.debug = arg.isDebug();
        this.taskArg = arg.getArgument();
        if (this.debug) {
            VisorTaskUtils.logStart(this.ignite.log(), this.getClass(), this.start);
        }
        return this.map0(subgrid, arg);
    }

    protected Collection<UUID> jobNodes(VisorTaskArgument<A> arg) {
        return arg.getNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<? extends ComputeJob, ClusterNode> map0(List<ClusterNode> subgrid, VisorTaskArgument<A> arg) {
        Collection<UUID> nodeIds = this.jobNodes(arg);
        HashMap<VisorJob<A, J>, ClusterNode> map = U.newHashMap(nodeIds.size());
        try {
            for (ClusterNode node : subgrid) {
                if (!nodeIds.contains(node.id())) continue;
                map.put(this.job(this.taskArg), node);
            }
            if (map.isEmpty()) {
                this.ignite.log().warning("No mapped jobs: [task=" + this.getClass().getName() + ", topVer=" + this.ignite.cluster().topologyVersion() + ", jobNids=" + nodeIds + ", subGrid=" + U.toShortString(subgrid) + "]");
            }
            HashMap<VisorJob<A, J>, ClusterNode> hashMap = map;
            return hashMap;
        }
        finally {
            if (this.debug) {
                VisorTaskUtils.logMapped(this.ignite.log(), this.getClass(), map.values());
            }
        }
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        return ComputeJobResultPolicy.WAIT;
    }

    @Nullable
    protected abstract R reduce0(List<ComputeJobResult> var1) throws IgniteException;

    @Override
    @Nullable
    public final R reduce(List<ComputeJobResult> results) {
        try {
            R r = this.reduce0(results);
            return r;
        }
        finally {
            if (this.debug) {
                VisorTaskUtils.logFinish(this.ignite.log(), this.getClass(), this.start);
            }
        }
    }
}

