/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.U;

public class BlockingSslHandler {
    private IgniteLogger log;
    private SocketChannel ch;
    private final ByteOrder order;
    private final SSLEngine sslEngine;
    private boolean handshakeFinished;
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private ByteBuffer outNetBuf;
    private ByteBuffer inNetBuf;
    private ByteBuffer handshakeBuf = ByteBuffer.allocate(0);
    private ByteBuffer appBuf;

    public BlockingSslHandler(SSLEngine sslEngine, SocketChannel ch, boolean directBuf, ByteOrder order, IgniteLogger log) throws SSLException {
        this.ch = ch;
        this.log = log;
        this.sslEngine = sslEngine;
        this.order = order;
        int netBufSize = Integer.getInteger("BlockingSslHandler.netBufSize", sslEngine.getSession().getPacketBufferSize() + 50);
        this.outNetBuf = directBuf ? ByteBuffer.allocateDirect(netBufSize) : ByteBuffer.allocate(netBufSize);
        this.outNetBuf.order(order);
        this.outNetBuf.position(0);
        this.outNetBuf.limit(0);
        this.inNetBuf = directBuf ? ByteBuffer.allocateDirect(netBufSize) : ByteBuffer.allocate(netBufSize);
        this.inNetBuf.order(order);
        this.appBuf = this.allocateAppBuff();
        this.handshakeStatus = sslEngine.getHandshakeStatus();
        if (log.isDebugEnabled()) {
            log.debug("Started SSL session [netBufSize=" + netBufSize + ", appBufSize=" + this.appBuf.capacity() + ']');
        }
    }

    public ByteBuffer inputBuffer() {
        return this.inNetBuf;
    }

    public boolean handshake() throws IgniteCheckedException, SSLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entered handshake. Handshake status: " + (Object)((Object)this.handshakeStatus) + '.');
        }
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        boolean loop = true;
        block6: while (loop) {
            switch (this.handshakeStatus) {
                case NOT_HANDSHAKING: 
                case FINISHED: {
                    this.handshakeFinished = true;
                    loop = false;
                    continue block6;
                }
                case NEED_TASK: {
                    this.handshakeStatus = this.runTasks();
                    continue block6;
                }
                case NEED_UNWRAP: {
                    SSLEngineResult.Status status = this.unwrapHandshake();
                    this.handshakeStatus = this.sslEngine.getHandshakeStatus();
                    if (status != SSLEngineResult.Status.BUFFER_UNDERFLOW || !this.sslEngine.isInboundDone()) continue block6;
                    loop = false;
                    continue block6;
                }
                case NEED_WRAP: {
                    if (this.outNetBuf.hasRemaining()) {
                        U.warn(this.log, "Output net buffer has unsent bytes during handshake (will clear). ");
                    }
                    this.outNetBuf.clear();
                    SSLEngineResult res = this.sslEngine.wrap(this.handshakeBuf, this.outNetBuf);
                    if (res.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        this.outNetBuf = this.expandBuffer(this.outNetBuf, this.outNetBuf.capacity() * 2);
                        this.outNetBuf.flip();
                    } else {
                        this.outNetBuf.flip();
                        this.writeNetBuffer();
                    }
                    this.handshakeStatus = res.getHandshakeStatus();
                    if (!this.log.isDebugEnabled()) continue block6;
                    this.log.debug("Wrapped handshake data [status=" + (Object)((Object)res.getStatus()) + ", handshakeStatus=" + (Object)((Object)this.handshakeStatus) + ']');
                    continue block6;
                }
            }
            throw new IllegalStateException("Invalid handshake status in handshake method [handshakeStatus=" + (Object)((Object)this.handshakeStatus) + ']');
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaved handshake. Handshake status:" + (Object)((Object)this.handshakeStatus) + '.');
        }
        return this.handshakeFinished;
    }

    public ByteBuffer applicationBuffer() {
        this.appBuf.flip();
        return this.appBuf;
    }

    public ByteBuffer encrypt(ByteBuffer src) throws SSLException {
        assert (this.handshakeFinished);
        this.outNetBuf.clear();
        while (src.hasRemaining()) {
            int outNetRemaining = this.outNetBuf.capacity() - this.outNetBuf.position();
            if (outNetRemaining < src.remaining() * 2) {
                this.outNetBuf = this.expandBuffer(this.outNetBuf, Math.max(this.outNetBuf.position() + src.remaining() * 2, this.outNetBuf.capacity() * 2));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Expanded output net buffer: " + this.outNetBuf.capacity());
                }
            }
            SSLEngineResult res = this.sslEngine.wrap(src, this.outNetBuf);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Encrypted data [status=" + (Object)((Object)res.getStatus()) + ", handshakeStaus=" + (Object)((Object)res.getHandshakeStatus()) + ']');
            }
            if (res.getStatus() == SSLEngineResult.Status.OK) {
                if (res.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                this.runTasks();
                continue;
            }
            throw new SSLException("Failed to encrypt data (SSL engine error) [status=" + (Object)((Object)res.getStatus()) + ", handshakeStatus=" + (Object)((Object)res.getHandshakeStatus()) + ']');
        }
        this.outNetBuf.flip();
        return this.outNetBuf;
    }

    public ByteBuffer decode(ByteBuffer buf) throws IgniteCheckedException, SSLException {
        this.appBuf.clear();
        if (buf.limit() > this.inNetBuf.remaining()) {
            this.inNetBuf = this.expandBuffer(this.inNetBuf, this.inNetBuf.capacity() + buf.limit() * 2);
            this.appBuf = this.expandBuffer(this.appBuf, this.inNetBuf.capacity() * 2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Expanded buffers [inNetBufCapacity=" + this.inNetBuf.capacity() + ", appBufCapacity=" + this.appBuf.capacity() + ']');
            }
        }
        this.inNetBuf.put(buf);
        if (!this.handshakeFinished) {
            this.handshake();
        } else {
            this.unwrapData();
        }
        if (this.isInboundDone()) {
            int newPosition = buf.position() - this.inNetBuf.position();
            if (newPosition >= 0) {
                buf.position(newPosition);
                if (buf.hasRemaining()) {
                    U.warn(this.log, "Got unread bytes after receiving close_notify message (will ignore).");
                }
            }
            this.inNetBuf.clear();
        }
        this.appBuf.flip();
        return this.appBuf;
    }

    boolean isInboundDone() {
        return this.sslEngine.isInboundDone();
    }

    private void unwrapData() throws IgniteCheckedException, SSLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unwrapping received data.");
        }
        this.inNetBuf.flip();
        SSLEngineResult res = this.unwrap0();
        this.inNetBuf.compact();
        this.checkStatus(res);
        this.renegotiateIfNeeded(res);
    }

    private SSLEngineResult.HandshakeStatus runTasks() {
        Runnable runnable;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Running SSL engine task: " + runnable + '.');
            }
            runnable.run();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finished running SSL engine tasks. HandshakeStatus: " + (Object)((Object)this.sslEngine.getHandshakeStatus()));
        }
        return this.sslEngine.getHandshakeStatus();
    }

    private SSLEngineResult.Status unwrapHandshake() throws SSLException, IgniteCheckedException {
        if (!this.inNetBuf.hasRemaining()) {
            this.readFromNet();
        }
        this.inNetBuf.flip();
        SSLEngineResult res = this.unwrap0();
        this.handshakeStatus = res.getHandshakeStatus();
        this.checkStatus(res);
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED && res.getStatus() == SSLEngineResult.Status.OK && this.inNetBuf.hasRemaining()) {
            res = this.unwrap0();
            this.handshakeStatus = res.getHandshakeStatus();
            this.inNetBuf.compact();
            this.renegotiateIfNeeded(res);
        } else if (res.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            this.inNetBuf.compact();
            if (this.inNetBuf.capacity() == this.inNetBuf.limit()) {
                this.inNetBuf = this.expandBuffer(this.inNetBuf, this.inNetBuf.capacity() * 2);
            }
            this.readFromNet();
        } else {
            this.inNetBuf.compact();
        }
        return res.getStatus();
    }

    private SSLEngineResult unwrap0() throws SSLException {
        SSLEngineResult res;
        do {
            res = this.sslEngine.unwrap(this.inNetBuf, this.appBuf);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unwrapped raw data [status=" + (Object)((Object)res.getStatus()) + ", handshakeStatus=" + (Object)((Object)res.getHandshakeStatus()) + ']');
            }
            if (res.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
            this.appBuf = this.expandBuffer(this.appBuf, this.appBuf.capacity() * 2);
        } while ((res.getStatus() == SSLEngineResult.Status.OK || res.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) && (this.handshakeFinished && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP));
        return res;
    }

    private void checkStatus(SSLEngineResult res) throws SSLException {
        SSLEngineResult.Status status = res.getStatus();
        if (status != SSLEngineResult.Status.OK && status != SSLEngineResult.Status.CLOSED && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            throw new SSLException("Failed to unwrap incoming data (SSL engine error). Status: " + (Object)((Object)status));
        }
    }

    private void renegotiateIfNeeded(SSLEngineResult res) throws IgniteCheckedException, SSLException {
        if (res.getStatus() != SSLEngineResult.Status.CLOSED && res.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW && res.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.handshakeStatus = res.getHandshakeStatus();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Renegotiation requested [status=" + (Object)((Object)res.getStatus()) + ", handshakeStatus = " + (Object)((Object)this.handshakeStatus) + ']');
            }
            this.handshakeFinished = false;
            this.handshake();
        }
    }

    private ByteBuffer allocateAppBuff() {
        int netBufSize = this.sslEngine.getSession().getPacketBufferSize() + 50;
        int appBufSize = Math.max(this.sslEngine.getSession().getApplicationBufferSize() + 50, netBufSize * 2);
        ByteBuffer buf = ByteBuffer.allocate(appBufSize);
        buf.order(this.order);
        return buf;
    }

    private void readFromNet() throws IgniteCheckedException {
        try {
            int read = this.ch.read(this.inNetBuf);
            if (read == -1) {
                throw new IgniteCheckedException("Failed to read remote node response (connection closed).");
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to write byte to socket.", e);
        }
    }

    private void writeNetBuffer() throws IgniteCheckedException {
        try {
            U.writeFully(this.ch, this.outNetBuf);
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to write byte to socket.", e);
        }
    }

    private ByteBuffer expandBuffer(ByteBuffer original, int cap) {
        ByteBuffer res = original.isDirect() ? ByteBuffer.allocateDirect(cap) : ByteBuffer.allocate(cap);
        res.order(original.order());
        original.flip();
        res.put(original);
        return res;
    }
}

