/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.ipc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.ipc.IpcEndpoint;
import org.apache.ignite.internal.util.nio.GridNioFilter;
import org.apache.ignite.internal.util.nio.GridNioFilterAdapter;
import org.apache.ignite.internal.util.nio.GridNioFilterChain;
import org.apache.ignite.internal.util.nio.GridNioFinishedFuture;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioMessageWriterFactory;
import org.apache.ignite.internal.util.nio.GridNioMetricsListener;
import org.apache.ignite.internal.util.nio.GridNioServerListener;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionImpl;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;

public class IpcToNioAdapter<T> {
    private final IpcEndpoint endp;
    private final GridNioFilterChain<T> chain;
    private final GridNioSessionImpl ses;
    private final AtomicReference<CountDownLatch> latchRef = new AtomicReference();
    private final ByteBuffer writeBuf;
    private final GridNioMetricsListener metricsLsnr;
    private final GridNioMessageWriterFactory writerFactory;

    public IpcToNioAdapter(GridNioMetricsListener metricsLsnr, IgniteLogger log, IpcEndpoint endp, GridNioServerListener<T> lsnr, GridNioMessageWriterFactory writerFactory, GridNioFilter ... filters) {
        assert (metricsLsnr != null);
        this.metricsLsnr = metricsLsnr;
        this.endp = endp;
        this.writerFactory = writerFactory;
        this.chain = new GridNioFilterChain<T>(log, lsnr, new HeadFilter(), filters);
        this.ses = new GridNioSessionImpl(this.chain, null, null, true);
        this.writeBuf = ByteBuffer.allocate(8192);
        this.writeBuf.order(ByteOrder.nativeOrder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serve() throws InterruptedException {
        try {
            this.chain.onSessionOpened(this.ses);
            InputStream in = this.endp.inputStream();
            ByteBuffer readBuf = ByteBuffer.allocate(8192);
            readBuf.order(ByteOrder.nativeOrder());
            assert (readBuf.hasArray());
            while (!Thread.interrupted()) {
                int pos = readBuf.position();
                int read = in.read(readBuf.array(), pos, readBuf.remaining());
                if (read > 0) {
                    CountDownLatch latch;
                    this.metricsLsnr.onBytesReceived(read);
                    readBuf.position(0);
                    readBuf.limit(pos + read);
                    this.chain.onMessageReceived(this.ses, readBuf);
                    if (readBuf.hasRemaining()) {
                        readBuf.compact();
                    } else {
                        readBuf.clear();
                    }
                    if ((latch = this.latchRef.get()) == null) continue;
                    latch.await();
                    continue;
                }
                if (read >= 0) continue;
                this.endp.close();
                break;
            }
        }
        catch (Exception e) {
            this.chain.onExceptionCaught(this.ses, new IgniteCheckedException("Failed to read from IPC endpoint.", e));
        }
        finally {
            try {
                this.chain.onSessionClosed(this.ses);
            }
            catch (IgniteCheckedException e) {
                this.chain.onExceptionCaught(this.ses, new IgniteCheckedException("Failed to process session close event for IPC endpoint.", e));
            }
        }
    }

    private GridNioFuture<?> send(Message msg) {
        assert (this.writeBuf.hasArray());
        try {
            int cnt = U.writeMessageFully(msg, this.endp.outputStream(), this.writeBuf, this.writerFactory.writer(this.ses));
            this.metricsLsnr.onBytesSent(cnt);
        }
        catch (IOException | IgniteCheckedException e) {
            return new GridNioFinishedFuture(e);
        }
        return new GridNioFinishedFuture<Object>(null);
    }

    private class HeadFilter
    extends GridNioFilterAdapter {
        protected HeadFilter() {
            super("HeadFilter");
        }

        @Override
        public void onSessionOpened(GridNioSession ses) throws IgniteCheckedException {
            this.proceedSessionOpened(ses);
        }

        @Override
        public void onSessionClosed(GridNioSession ses) throws IgniteCheckedException {
            this.proceedSessionClosed(ses);
        }

        @Override
        public void onExceptionCaught(GridNioSession ses, IgniteCheckedException ex) throws IgniteCheckedException {
            this.proceedExceptionCaught(ses, ex);
        }

        @Override
        public GridNioFuture<?> onSessionWrite(GridNioSession ses, Object msg, boolean fut, IgniteInClosure<IgniteException> ackC) {
            assert (ses == IpcToNioAdapter.this.ses);
            return IpcToNioAdapter.this.send((Message)msg);
        }

        @Override
        public void onMessageReceived(GridNioSession ses, Object msg) throws IgniteCheckedException {
            this.proceedMessageReceived(ses, msg);
        }

        @Override
        public GridNioFuture<?> onPauseReads(GridNioSession ses) throws IgniteCheckedException {
            boolean b = IpcToNioAdapter.this.latchRef.compareAndSet(null, new CountDownLatch(1));
            assert (b);
            return new GridNioFinishedFuture<Boolean>(b);
        }

        @Override
        public GridNioFuture<?> onResumeReads(GridNioSession ses) throws IgniteCheckedException {
            CountDownLatch latch = IpcToNioAdapter.this.latchRef.getAndSet(null);
            if (latch != null) {
                latch.countDown();
            }
            return new GridNioFinishedFuture<Boolean>(latch != null);
        }

        @Override
        public GridNioFuture<Boolean> onSessionClose(GridNioSession ses) {
            assert (ses == IpcToNioAdapter.this.ses);
            boolean closed = IpcToNioAdapter.this.ses.setClosed();
            if (closed) {
                IpcToNioAdapter.this.endp.close();
            }
            return new GridNioFinishedFuture<Boolean>(closed);
        }

        @Override
        public void onSessionIdleTimeout(GridNioSession ses) throws IgniteCheckedException {
            this.proceedSessionIdleTimeout(ses);
        }

        @Override
        public void onSessionWriteTimeout(GridNioSession ses) throws IgniteCheckedException {
            this.proceedSessionWriteTimeout(ses);
        }
    }
}

