/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.future;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteFutureCancelledCheckedException;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.future.GridFutureChainListener;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class GridFutureAdapter<R>
implements IgniteInternalFuture<R> {
    private static final String DONE = "DONE";
    private static final Node INIT = new Node(null);
    private static final Object CANCELLED = new Object();
    private static final AtomicReferenceFieldUpdater<GridFutureAdapter, Object> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(GridFutureAdapter.class, Object.class, "state");
    private volatile boolean ignoreInterrupts;
    @GridToStringExclude
    private volatile Object state = INIT;

    public void ignoreInterrupts() {
        this.ignoreInterrupts = true;
    }

    @Override
    public Throwable error() {
        Object state0 = this.state;
        if (state0 != null && state0.getClass() == ErrorWrapper.class) {
            return ((ErrorWrapper)state0).error;
        }
        return null;
    }

    @Override
    public R result() {
        Object state0 = this.state;
        if (state0 == null || state0.getClass() != Node.class && state0.getClass() != ErrorWrapper.class && state0 != CANCELLED) {
            return (R)state0;
        }
        return null;
    }

    @Override
    public R get() throws IgniteCheckedException {
        return this.get0(this.ignoreInterrupts);
    }

    @Override
    public R getUninterruptibly() throws IgniteCheckedException {
        return this.get0(true);
    }

    @Override
    public R get(long timeout) throws IgniteCheckedException {
        return this.get(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws IgniteCheckedException {
        A.ensure(timeout >= 0L, "timeout cannot be negative: " + timeout);
        A.notNull((Object)unit, "unit");
        return this.get0(this.ignoreInterrupts, unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R get0(boolean ignoreInterrupts) throws IgniteCheckedException {
        if (this.isDone() || !this.registerWaiter(Thread.currentThread())) {
            return this.resolve();
        }
        boolean interrupted = false;
        try {
            do {
                LockSupport.park();
                if (!Thread.interrupted()) continue;
                interrupted = true;
                if (ignoreInterrupts) continue;
                this.unregisterWaiter();
                throw new IgniteInterruptedCheckedException("Got interrupted while waiting for future to complete.");
            } while (!this.isDone());
            R r = this.resolve();
            return r;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private R get0(boolean ignoreInterrupts, long nanosTimeout) throws IgniteCheckedException {
        if (this.isDone() || !this.registerWaiter(Thread.currentThread())) {
            return this.resolve();
        }
        long deadlineNanos = System.nanoTime() + nanosTimeout;
        boolean interrupted = false;
        try {
            long nanosTimeout0 = nanosTimeout;
            while (nanosTimeout0 > 0L) {
                LockSupport.parkNanos(nanosTimeout0);
                nanosTimeout0 = deadlineNanos - System.nanoTime();
                if (Thread.interrupted()) {
                    interrupted = true;
                    if (!ignoreInterrupts) {
                        this.unregisterWaiter();
                        throw new IgniteInterruptedCheckedException("Got interrupted while waiting for future to complete.");
                    }
                }
                if (!this.isDone()) continue;
                R r = this.resolve();
                return r;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        this.unregisterWaiter();
        throw new IgniteFutureTimeoutCheckedException("Timeout was reached before computation completed.");
    }

    private R resolve() throws IgniteCheckedException {
        if (this.state == CANCELLED) {
            throw new IgniteFutureCancelledCheckedException("Future was cancelled: " + this);
        }
        if (this.state == null || this.state.getClass() != ErrorWrapper.class) {
            return (R)this.state;
        }
        throw U.cast(((ErrorWrapper)this.state).error);
    }

    private boolean registerWaiter(Object waiter) {
        Object oldState;
        Node node = null;
        do {
            if (this.isDone(oldState = this.state)) {
                return false;
            }
            if (node == null) {
                node = new Node(waiter);
            }
            if (oldState == INIT || oldState.getClass() != Node.class) continue;
            node.next = (Node)oldState;
        } while (!this.compareAndSetState(oldState, node));
        return true;
    }

    private void unregisterWaiter() {
        Node prev = null;
        Object cur = this.state;
        while (cur != null) {
            if (cur.getClass() != Node.class) {
                return;
            }
            Object curWaiter = ((Node)cur).val;
            Node next = ((Node)cur).next;
            if (curWaiter == Thread.currentThread()) {
                if (prev == null) {
                    Node n = next == null ? INIT : next;
                    cur = this.compareAndSetState(cur, n) ? null : this.state;
                    continue;
                }
                prev.next = next;
                cur = null;
                continue;
            }
            prev = (Node)cur;
            cur = next;
        }
    }

    private boolean compareAndSetState(Object exp, Object newState) {
        return stateUpdater.compareAndSet(this, exp, newState);
    }

    private void unblockAll(Node head) {
        while (head != null) {
            this.unblock(head.val);
            head = head.next;
        }
    }

    private void unblock(Object waiter) {
        if (waiter instanceof Thread) {
            LockSupport.unpark((Thread)waiter);
        } else {
            this.notifyListener((IgniteInClosure)waiter);
        }
    }

    @Override
    public void listen(IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) {
        if (!this.registerWaiter(lsnr)) {
            this.notifyListener(lsnr);
        }
    }

    @Override
    public <T> IgniteInternalFuture<T> chain(IgniteClosure<? super IgniteInternalFuture<R>, T> doneCb) {
        ChainFuture fut = new ChainFuture(this, doneCb, null);
        if (this.ignoreInterrupts) {
            fut.ignoreInterrupts();
        }
        return fut;
    }

    @Override
    public <T> IgniteInternalFuture<T> chain(IgniteClosure<? super IgniteInternalFuture<R>, T> doneCb, Executor exec) {
        ChainFuture fut = new ChainFuture(this, doneCb, exec);
        if (this.ignoreInterrupts) {
            fut.ignoreInterrupts();
        }
        return fut;
    }

    @Nullable
    public IgniteLogger logger() {
        return null;
    }

    private void notifyListener(IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) {
        assert (lsnr != null);
        try {
            lsnr.apply(this);
        }
        catch (IllegalStateException e) {
            U.error(this.logger(), "Failed to notify listener (is grid stopped?) [fut=" + this + ", lsnr=" + lsnr + ", err=" + e.getMessage() + ']', e);
        }
        catch (Error | RuntimeException e) {
            U.error(this.logger(), "Failed to notify listener: " + lsnr, e);
            throw e;
        }
    }

    @Override
    public boolean cancel() throws IgniteCheckedException {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.isDone(this.state);
    }

    private boolean isDone(Object state) {
        return state == null || state.getClass() != Node.class;
    }

    public boolean isFailed() {
        Object state0 = this.state;
        return state0 != null && state0.getClass() == ErrorWrapper.class;
    }

    @Override
    public boolean isCancelled() {
        return this.state == CANCELLED;
    }

    public final boolean onDone() {
        return this.onDone(null, null);
    }

    public final boolean onDone(@Nullable R res) {
        return this.onDone(res, null);
    }

    public final boolean onDone(@Nullable Throwable err) {
        return this.onDone(null, err);
    }

    public boolean onDone(@Nullable R res, @Nullable Throwable err) {
        return this.onDone(res, err, false);
    }

    protected boolean onDone(@Nullable R res, @Nullable Throwable err, boolean cancel) {
        Object oldState;
        Object newState;
        Object object = cancel ? CANCELLED : (newState = err != null ? new ErrorWrapper(err) : res);
        do {
            if (!this.isDone(oldState = this.state)) continue;
            return false;
        } while (!this.compareAndSetState(oldState, newState));
        if (oldState != INIT) {
            this.unblockAll((Node)oldState);
        }
        return true;
    }

    public void reset() {
        Object oldState = this.state;
        if (oldState == INIT) {
            return;
        }
        if (!this.isDone(oldState)) {
            throw new IgniteException("Illegal state");
        }
        this.compareAndSetState(oldState, INIT);
    }

    public boolean onCancelled() {
        return this.onDone(null, null, true);
    }

    public String toString() {
        Object state0 = this.state;
        String stateStr = this.stateStr(state0);
        String resStr = stateStr == DONE ? String.valueOf(state0) : null;
        return S.toString(GridFutureAdapter.class, this, "state", stateStr, false, "res", resStr, true, "hash", System.identityHashCode(this), false);
    }

    private String stateStr(Object s) {
        return s == CANCELLED ? "CANCELLED" : (s != null && s.getClass() == Node.class ? "INIT" : DONE);
    }

    static {
        Class<LockSupport> clazz = LockSupport.class;
    }

    private static class ChainFuture<R, T>
    extends GridFutureAdapter<T> {
        private GridFutureAdapter<R> fut;
        private IgniteClosure<? super IgniteInternalFuture<R>, T> doneCb;

        ChainFuture(GridFutureAdapter<R> fut, IgniteClosure<? super IgniteInternalFuture<R>, T> doneCb, @Nullable Executor cbExec) {
            this.fut = fut;
            this.doneCb = doneCb;
            fut.listen(new GridFutureChainListener<T, T>(this, doneCb, cbExec));
        }

        @Override
        public String toString() {
            return "ChainFuture [orig=" + this.fut + ", doneCb=" + this.doneCb + ']';
        }
    }

    private static final class ErrorWrapper {
        private final Throwable error;

        ErrorWrapper(Throwable error) {
            this.error = error;
        }

        public String toString() {
            return String.valueOf(this.error);
        }
    }

    private static final class Node {
        private final Object val;
        private volatile Node next;

        Node(Object val) {
            this.val = val;
        }
    }
}

