/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.ignite.internal.util.GridSerializableCollection;
import org.jetbrains.annotations.NotNull;

public class BitSetIntSet
extends GridSerializableCollection<Integer>
implements Set<Integer> {
    private static final long serialVersionUID = 0L;
    private final BitSet bitSet;
    private int size;

    public BitSetIntSet() {
        this.bitSet = new BitSet();
    }

    public BitSetIntSet(int initCap) {
        this.bitSet = new BitSet(initCap);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new UnsupportedOperationException("Null values are not supported!");
        }
        int val = (Integer)o;
        if (val < 0) {
            throw new UnsupportedOperationException("Negative values are not supported!");
        }
        return this.bitSet.get(val);
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int next = -1;

            @Override
            public boolean hasNext() {
                int nextBit = BitSetIntSet.this.bitSet.nextSetBit(this.next + 1);
                if (nextBit != -1) {
                    this.next = nextBit;
                    return true;
                }
                return false;
            }

            @Override
            public Integer next() {
                if (this.next == -1) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }
        };
    }

    @Override
    public boolean add(Integer integer) {
        if (integer == null || integer < 0) {
            throw new UnsupportedOperationException("Negative or null values are not supported!");
        }
        boolean alreadySet = this.bitSet.get(integer);
        if (!alreadySet) {
            this.bitSet.set(integer);
            ++this.size;
        }
        return !alreadySet;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            throw new UnsupportedOperationException("Null values are not supported!");
        }
        int val = (Integer)o;
        if (val < 0) {
            throw new UnsupportedOperationException("Negative values are not supported!");
        }
        boolean alreadySet = this.bitSet.get(val);
        if (alreadySet) {
            this.bitSet.clear(val);
            --this.size;
        }
        return alreadySet;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Integer> c) {
        boolean atLeastOneAdded = false;
        for (Integer n : c) {
            if (!this.add(n)) continue;
            atLeastOneAdded = true;
        }
        return atLeastOneAdded;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        boolean atLeastOneRemoved = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            atLeastOneRemoved = true;
        }
        return atLeastOneRemoved;
    }

    @Override
    public void clear() {
        this.bitSet.clear();
        this.size = 0;
    }
}

