/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheAffinityChangeMessage;
import org.apache.ignite.internal.processors.cache.CacheIteratorConverter;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.binary.MetadataUpdateAcceptedMessage;
import org.apache.ignite.internal.processors.cache.binary.MetadataUpdateProposedMessage;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.query.CacheQuery;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.service.GridServiceAssignments;
import org.apache.ignite.internal.processors.service.GridServiceAssignmentsKey;
import org.apache.ignite.internal.processors.service.GridServiceDeployment;
import org.apache.ignite.internal.processors.service.GridServiceDeploymentCompoundFuture;
import org.apache.ignite.internal.processors.service.GridServiceDeploymentFuture;
import org.apache.ignite.internal.processors.service.GridServiceDeploymentKey;
import org.apache.ignite.internal.processors.service.GridServiceProxy;
import org.apache.ignite.internal.processors.service.LazyServiceConfiguration;
import org.apache.ignite.internal.processors.service.PreparedConfigurations;
import org.apache.ignite.internal.processors.service.ServiceContextImpl;
import org.apache.ignite.internal.processors.service.ServiceDescriptorImpl;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.util.GridEmptyIterator;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.JobContextResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceConfiguration;
import org.apache.ignite.services.ServiceDeploymentException;
import org.apache.ignite.services.ServiceDescriptor;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.apache.ignite.thread.OomExceptionHandler;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class GridServiceProcessor
extends GridProcessorAdapter
implements IgniteChangeGlobalStateSupport {
    private final Boolean srvcCompatibilitySysProp;
    private static final long RETRY_TIMEOUT = 1000L;
    private static final int[] EVTS = new int[]{10, 11, 12, 18};
    private final Map<String, Collection<ServiceContextImpl>> locSvcs = new HashMap<String, Collection<ServiceContextImpl>>();
    private final ConcurrentMap<String, GridServiceDeploymentFuture> depFuts = new ConcurrentHashMap<String, GridServiceDeploymentFuture>();
    private final ConcurrentMap<String, GridFutureAdapter<?>> undepFuts = new ConcurrentHashMap();
    private final List<ComputeJobContext> pendingJobCtxs = new ArrayList<ComputeJobContext>(0);
    private volatile ExecutorService depExe;
    private volatile GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private final Thread.UncaughtExceptionHandler oomeHnd = new OomExceptionHandler(this.ctx);
    private ThreadFactory threadFactory = new IgniteThreadFactory(this.ctx.igniteInstanceName(), "service", this.oomeHnd);
    private ThreadLocal<String> svcName = new ThreadLocal();
    private volatile IgniteInternalCache<Object, Object> serviceCache;
    private DiscoveryEventListener topLsnr = new TopologyListener();
    private final CountDownLatch startLatch = new CountDownLatch(1);

    public GridServiceProcessor(GridKernalContext ctx) {
        super(ctx);
        this.depExe = Executors.newSingleThreadExecutor(new IgniteThreadFactory(ctx.igniteInstanceName(), "srvc-deploy", this.oomeHnd));
        String servicesCompatibilityMode = IgniteSystemProperties.getString("IGNITE_SERVICES_COMPATIBILITY_MODE");
        this.srvcCompatibilitySysProp = servicesCompatibilityMode == null ? null : Boolean.valueOf(servicesCompatibilityMode);
    }

    public void onContinuousProcessorStarted(GridKernalContext ctx) throws IgniteCheckedException {
        if (ctx.clientNode()) {
            assert (!ctx.isDaemon());
            ctx.continuous().registerStaticRoutine("ignite-sys-cache", new ServiceEntriesListener(), null, null);
        }
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.ctx.addNodeAttribute("org.apache.ignite.services.compatibility.enabled", this.srvcCompatibilitySysProp);
        if (this.ctx.isDaemon()) {
            return;
        }
        IgniteConfiguration cfg = this.ctx.config();
        DeploymentMode depMode = cfg.getDeploymentMode();
        if (cfg.isPeerClassLoadingEnabled() && (depMode == DeploymentMode.PRIVATE || depMode == DeploymentMode.ISOLATED) && !F.isEmpty(cfg.getServiceConfiguration())) {
            throw new IgniteCheckedException("Cannot deploy services in PRIVATE or ISOLATED deployment mode: " + (Object)((Object)depMode));
        }
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        if (this.ctx.isDaemon() || !active) {
            return;
        }
        this.onKernalStart0();
    }

    private void onKernalStart0() throws IgniteCheckedException {
        if (!this.ctx.clientNode()) {
            this.ctx.event().addDiscoveryEventListener(this.topLsnr, EVTS);
        }
        this.updateUtilityCache();
        this.startLatch.countDown();
        try {
            if (this.ctx.deploy().enabled()) {
                this.ctx.cache().context().deploy().ignoreOwnership(true);
            }
            if (!this.ctx.clientNode()) {
                DiscoveryDataClusterState clusterState = this.ctx.state().clusterState();
                boolean isLocLsnr = !clusterState.hasBaselineTopology() || CU.baselineNode(this.ctx.cluster().get().localNode(), clusterState);
                this.serviceCache.context().continuousQueries().executeInternalQuery(new ServiceEntriesListener(), null, isLocLsnr, true, false, false);
            } else {
                assert (!this.ctx.isDaemon());
                this.ctx.closure().runLocalSafe(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Iterable<CacheEntryEvent<?, ?>> entries = GridServiceProcessor.this.serviceCache.context().continuousQueries().existingEntries(false, null);
                            GridServiceProcessor.this.onSystemCacheUpdated(entries);
                        }
                        catch (IgniteCheckedException e) {
                            U.error(GridServiceProcessor.this.log, "Failed to load service entries: " + e, e);
                        }
                    }
                });
            }
        }
        finally {
            if (this.ctx.deploy().enabled()) {
                this.ctx.cache().context().deploy().ignoreOwnership(false);
            }
        }
        ServiceConfiguration[] cfgs = this.ctx.config().getServiceConfiguration();
        if (cfgs != null) {
            this.deployAll(Arrays.asList(cfgs), this.ctx.cluster().get().forServers().predicate()).get();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Started service processor.");
        }
    }

    public void updateUtilityCache() {
        this.serviceCache = this.ctx.cache().utilityCache();
    }

    private IgniteInternalCache<Object, Object> serviceCache() {
        if (this.serviceCache == null) {
            U.awaitQuiet(this.startLatch);
        }
        return this.serviceCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onKernalStop(boolean cancel) {
        if (this.ctx.isDaemon()) {
            return;
        }
        GridSpinBusyLock busyLock = this.busyLock;
        if (busyLock != null) {
            busyLock.block();
            this.busyLock = null;
        }
        this.startLatch.countDown();
        U.shutdownNow(GridServiceProcessor.class, this.depExe, this.log);
        if (!this.ctx.clientNode()) {
            this.ctx.event().removeDiscoveryEventListener(this.topLsnr, new int[0]);
        }
        ArrayList<ServiceContextImpl> ctxs = new ArrayList<ServiceContextImpl>();
        Iterator iterator = this.locSvcs;
        synchronized (iterator) {
            for (Collection<ServiceContextImpl> ctxs0 : this.locSvcs.values()) {
                ctxs.addAll(ctxs0);
            }
            this.locSvcs.clear();
        }
        for (ServiceContextImpl ctx : ctxs) {
            block16: {
                ctx.setCancelled(true);
                Service svc = ctx.service();
                if (svc != null) {
                    try {
                        svc.cancel(ctx);
                    }
                    catch (Throwable e) {
                        this.log.error("Failed to cancel service (ignoring) [name=" + ctx.name() + ", execId=" + ctx.executionId() + ']', e);
                        if (!(e instanceof Error)) break block16;
                        throw e;
                    }
                }
            }
            ctx.executor().shutdownNow();
        }
        for (ServiceContextImpl ctx : ctxs) {
            try {
                if (this.log.isInfoEnabled() && !ctxs.isEmpty()) {
                    this.log.info("Shutting down distributed service [name=" + ctx.name() + ", execId8=" + U.id8(ctx.executionId()) + ']');
                }
                ctx.executor().awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                U.error(this.log, "Got interrupted while waiting for service to shutdown (will continue stopping node): " + ctx.name());
            }
        }
        IgniteCheckedException err = new IgniteCheckedException("Operation has been cancelled (node is stopping).");
        this.cancelFutures(this.depFuts, err);
        this.cancelFutures(this.undepFuts, err);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopped service processor.");
        }
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Activate service processor [nodeId=" + this.ctx.localNodeId() + " topVer=" + this.ctx.discovery().topologyVersionEx() + " ]");
        }
        this.busyLock = new GridSpinBusyLock();
        this.depExe = Executors.newSingleThreadExecutor(new IgniteThreadFactory(this.ctx.igniteInstanceName(), "srvc-deploy", this.oomeHnd));
        this.start();
        this.onKernalStart0();
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DeActivate service processor [nodeId=" + this.ctx.localNodeId() + " topVer=" + this.ctx.discovery().topologyVersionEx() + " ]");
        }
        this.cancelFutures(this.depFuts, new IgniteCheckedException("Failed to deploy service, cluster in active."));
        this.cancelFutures(this.undepFuts, new IgniteCheckedException("Failed to undeploy service, cluster in active."));
        this.onKernalStop(true);
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        this.cancelFutures(this.depFuts, new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to deploy service, client node disconnected."));
        this.cancelFutures(this.undepFuts, new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to undeploy service, client node disconnected."));
    }

    private void cancelFutures(ConcurrentMap<String, ? extends GridFutureAdapter<?>> futs, Exception err) {
        for (Map.Entry entry : futs.entrySet()) {
            GridFutureAdapter fut = (GridFutureAdapter)entry.getValue();
            fut.onDone(err);
            futs.remove(entry.getKey(), fut);
        }
    }

    private void validate(ServiceConfiguration c) throws IgniteException {
        IgniteConfiguration cfg = this.ctx.config();
        DeploymentMode depMode = cfg.getDeploymentMode();
        if (cfg.isPeerClassLoadingEnabled() && (depMode == DeploymentMode.PRIVATE || depMode == DeploymentMode.ISOLATED)) {
            throw new IgniteException("Cannot deploy services in PRIVATE or ISOLATED deployment mode: " + (Object)((Object)depMode));
        }
        this.ensure(c.getName() != null, "getName() != null", null);
        this.ensure(c.getTotalCount() >= 0, "getTotalCount() >= 0", c.getTotalCount());
        this.ensure(c.getMaxPerNodeCount() >= 0, "getMaxPerNodeCount() >= 0", c.getMaxPerNodeCount());
        this.ensure(c.getService() != null, "getService() != null", c.getService());
        this.ensure(c.getTotalCount() > 0 || c.getMaxPerNodeCount() > 0, "c.getTotalCount() > 0 || c.getMaxPerNodeCount() > 0", null);
    }

    private void ensure(boolean cond, String desc, @Nullable Object v) {
        if (!cond) {
            if (v != null) {
                throw new IgniteException("Service configuration check failed (" + desc + "): " + v);
            }
            throw new IgniteException("Service configuration check failed (" + desc + ")");
        }
    }

    public IgniteInternalFuture<?> deployNodeSingleton(ClusterGroup prj, String name, Service svc) {
        return this.deployMultiple(prj, name, svc, 0, 1);
    }

    public IgniteInternalFuture<?> deployClusterSingleton(ClusterGroup prj, String name, Service svc) {
        return this.deployMultiple(prj, name, svc, 1, 1);
    }

    public IgniteInternalFuture<?> deployMultiple(ClusterGroup prj, String name, Service svc, int totalCnt, int maxPerNodeCnt) {
        ServiceConfiguration cfg = new ServiceConfiguration();
        cfg.setName(name);
        cfg.setService(svc);
        cfg.setTotalCount(totalCnt);
        cfg.setMaxPerNodeCount(maxPerNodeCnt);
        return this.deployAll(prj, Collections.singleton(cfg));
    }

    public IgniteInternalFuture<?> deployKeyAffinitySingleton(String name, Service svc, String cacheName, Object affKey) {
        A.notNull(affKey, "affKey");
        ServiceConfiguration cfg = new ServiceConfiguration();
        cfg.setName(name);
        cfg.setService(svc);
        cfg.setCacheName(cacheName);
        cfg.setAffinityKey(affKey);
        cfg.setTotalCount(1);
        cfg.setMaxPerNodeCount(1);
        return this.deployAll(Collections.singleton(cfg), null);
    }

    private PreparedConfigurations prepareServiceConfigurations(Collection<ServiceConfiguration> cfgs, IgnitePredicate<ClusterNode> dfltNodeFilter) {
        ArrayList<ServiceConfiguration> cfgsCp = new ArrayList<ServiceConfiguration>(cfgs.size());
        Marshaller marsh = this.ctx.config().getMarshaller();
        ArrayList<GridServiceDeploymentFuture> failedFuts = null;
        for (ServiceConfiguration cfg : cfgs) {
            Exception err = null;
            if (cfg.getNodeFilter() == null && dfltNodeFilter != null) {
                cfg.setNodeFilter(dfltNodeFilter);
            }
            try {
                this.validate(cfg);
            }
            catch (Exception e) {
                U.error(this.log, "Failed to validate service configuration [name=" + cfg.getName() + ", srvc=" + cfg.getService() + ']', e);
                err = e;
            }
            if (err == null) {
                try {
                    this.ctx.security().authorize(cfg.getName(), SecurityPermission.SERVICE_DEPLOY, null);
                }
                catch (Exception e) {
                    U.error(this.log, "Failed to authorize service creation [name=" + cfg.getName() + ", srvc=" + cfg.getService() + ']', e);
                    err = e;
                }
            }
            if (err == null) {
                try {
                    byte[] srvcBytes = U.marshal(marsh, (Object)cfg.getService());
                    cfgsCp.add(new LazyServiceConfiguration(cfg, srvcBytes));
                }
                catch (Exception e) {
                    U.error(this.log, "Failed to marshal service with configured marshaller [name=" + cfg.getName() + ", srvc=" + cfg.getService() + ", marsh=" + marsh + "]", e);
                    err = e;
                }
            }
            if (err == null) continue;
            if (failedFuts == null) {
                failedFuts = new ArrayList<GridServiceDeploymentFuture>();
            }
            GridServiceDeploymentFuture fut = new GridServiceDeploymentFuture(cfg);
            fut.onDone(err);
            failedFuts.add(fut);
        }
        return new PreparedConfigurations(cfgsCp, failedFuts);
    }

    public IgniteInternalFuture<?> deployAll(ClusterGroup prj, Collection<ServiceConfiguration> cfgs) {
        if (prj == null) {
            return this.deployAll(cfgs, this.ctx.cluster().get().forServers().predicate());
        }
        if (prj.predicate() == F.alwaysTrue()) {
            return this.deployAll(cfgs, null);
        }
        return this.deployAll(cfgs, prj.predicate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture<?> deployAll(Collection<ServiceConfiguration> cfgs, @Nullable IgnitePredicate<ClusterNode> dfltNodeFilter) {
        GridServiceDeploymentCompoundFuture res;
        assert (cfgs != null);
        PreparedConfigurations srvCfg = this.prepareServiceConfigurations(cfgs, dfltNodeFilter);
        List<ServiceConfiguration> cfgsCp = srvCfg.cfgs;
        List<GridServiceDeploymentFuture> failedFuts = srvCfg.failedFuts;
        Collections.sort(cfgsCp, new Comparator<ServiceConfiguration>(){

            @Override
            public int compare(ServiceConfiguration cfg1, ServiceConfiguration cfg2) {
                return cfg1.getName().compareTo(cfg2.getName());
            }
        });
        while (true) {
            Iterator<String> iterator;
            res = new GridServiceDeploymentCompoundFuture();
            if (this.ctx.deploy().enabled()) {
                this.ctx.cache().context().deploy().ignoreOwnership(true);
            }
            try {
                if (cfgsCp.size() == 1) {
                    this.writeServiceToCache(res, cfgsCp.get(0));
                    break;
                }
                if (cfgsCp.size() <= 1) break;
                Transaction tx = this.serviceCache().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.READ_COMMITTED);
                iterator = null;
                try {
                    for (ServiceConfiguration cfg : cfgsCp) {
                        try {
                            this.writeServiceToCache(res, cfg);
                        }
                        catch (IgniteCheckedException e) {
                            if (X.hasCause((Throwable)e, ClusterTopologyCheckedException.class)) {
                                throw e;
                            }
                            U.error(this.log, e.getMessage());
                        }
                    }
                    tx.commit();
                }
                catch (Throwable throwable) {
                    iterator = throwable;
                    throw throwable;
                }
                finally {
                    if (tx != null) {
                        if (iterator != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)((Object)iterator)).addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            catch (IgniteCheckedException | IgniteException e) {
                for (String name : res.servicesToRollback()) {
                    ((GridServiceDeploymentFuture)this.depFuts.remove(name)).onDone(e);
                }
                if (X.hasCause((Throwable)e, ClusterTopologyCheckedException.class)) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Topology changed while deploying services (will retry): " + e.getMessage());
                    continue;
                }
                res.onDone(new IgniteCheckedException(new ServiceDeploymentException("Failed to deploy provided services.", e, cfgs)));
                iterator = res;
                return iterator;
            }
            finally {
                if (!this.ctx.deploy().enabled()) continue;
                this.ctx.cache().context().deploy().ignoreOwnership(false);
                continue;
            }
            break;
        }
        if (this.ctx.clientDisconnected()) {
            IgniteClientDisconnectedCheckedException err = new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to deploy services, client node disconnected: " + cfgs);
            for (String name : res.servicesToRollback()) {
                GridServiceDeploymentFuture fut = (GridServiceDeploymentFuture)this.depFuts.remove(name);
                if (fut == null) continue;
                fut.onDone(err);
            }
            return new GridFinishedFuture(err);
        }
        if (failedFuts != null) {
            for (GridServiceDeploymentFuture fut : failedFuts) {
                res.add(fut, false);
            }
        }
        res.markInitialized();
        return res;
    }

    private void writeServiceToCache(GridServiceDeploymentCompoundFuture res, ServiceConfiguration cfg) throws IgniteCheckedException {
        block7: {
            String name = cfg.getName();
            GridServiceDeploymentFuture fut = new GridServiceDeploymentFuture(cfg);
            GridServiceDeploymentFuture old = this.depFuts.putIfAbsent(name, fut);
            try {
                if (old != null) {
                    if (!old.configuration().equalsIgnoreNodeFilter(cfg)) {
                        throw new IgniteCheckedException("Failed to deploy service (service already exists with different configuration) [deployed=" + old.configuration() + ", new=" + cfg + ']');
                    }
                    res.add(old, false);
                    return;
                }
                GridServiceDeploymentKey key = new GridServiceDeploymentKey(name);
                GridServiceDeployment dep = (GridServiceDeployment)this.serviceCache().getAndPutIfAbsent(key, new GridServiceDeployment(this.ctx.localNodeId(), cfg));
                if (dep != null) {
                    if (!dep.configuration().equalsIgnoreNodeFilter(cfg)) {
                        throw new IgniteCheckedException("Failed to deploy service (service already exists with different configuration) [deployed=" + dep.configuration() + ", new=" + cfg + ']');
                    }
                    res.add(fut, false);
                    Iterator<Cache.Entry<Object, Object>> it = this.serviceEntries(ServiceAssignmentsPredicate.INSTANCE);
                    while (it.hasNext()) {
                        Cache.Entry<Object, Object> e = it.next();
                        GridServiceAssignments assigns = (GridServiceAssignments)e.getValue();
                        if (!assigns.name().equals(name)) continue;
                        fut.onDone();
                        this.depFuts.remove(name, fut);
                        break block7;
                    }
                    break block7;
                }
                res.add(fut, true);
            }
            catch (IgniteCheckedException e) {
                fut.onDone(e);
                res.add(fut, false);
                this.depFuts.remove(name, fut);
                throw e;
            }
        }
    }

    public IgniteInternalFuture<?> cancel(String name) {
        while (true) {
            try {
                return this.removeServiceFromCache((String)name).fut;
            }
            catch (IgniteCheckedException | IgniteException e) {
                if (X.hasCause((Throwable)e, ClusterTopologyCheckedException.class)) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Topology changed while cancelling service (will retry): " + e.getMessage());
                    continue;
                }
                U.error(this.log, "Failed to undeploy service: " + name, e);
                return new GridFinishedFuture(e);
            }
            break;
        }
    }

    public IgniteInternalFuture<?> cancelAll() {
        Iterator<Cache.Entry<Object, Object>> it = this.serviceEntries(ServiceDeploymentPredicate.INSTANCE);
        ArrayList<String> svcNames = new ArrayList<String>();
        while (it.hasNext()) {
            GridServiceDeployment dep = (GridServiceDeployment)it.next().getValue();
            svcNames.add(dep.configuration().getName());
        }
        return this.cancelAll(svcNames);
    }

    public IgniteInternalFuture<?> cancelAll(Collection<String> svcNames) {
        GridCompoundFuture res;
        ArrayList<String> svcNamesCp = new ArrayList<String>(svcNames);
        Collections.sort(svcNamesCp);
        while (true) {
            res = null;
            ArrayList<String> toRollback = new ArrayList<String>();
            try {
                Transaction tx = this.serviceCache().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.READ_COMMITTED);
                Object object = null;
                try {
                    for (String name : svcNames) {
                        if (res == null) {
                            res = new GridCompoundFuture();
                        }
                        try {
                            CancelResult cr = this.removeServiceFromCache(name);
                            if (cr.rollback) {
                                toRollback.add(name);
                            }
                            res.add(cr.fut);
                        }
                        catch (IgniteCheckedException | IgniteException e) {
                            if (X.hasCause((Throwable)e, ClusterTopologyCheckedException.class)) {
                                throw e;
                            }
                            U.error(this.log, "Failed to undeploy service: " + name, e);
                            res.add(new GridFinishedFuture(e));
                        }
                    }
                    tx.commit();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (tx != null) {
                        if (object != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            catch (IgniteCheckedException | IgniteException e) {
                for (String name : toRollback) {
                    ((GridFutureAdapter)this.undepFuts.remove(name)).onDone(e);
                }
                if (X.hasCause((Throwable)e, ClusterTopologyCheckedException.class)) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Topology changed while cancelling service (will retry): " + e.getMessage());
                    continue;
                }
                return new GridFinishedFuture(e);
            }
            break;
        }
        if (res != null) {
            res.markInitialized();
            return res;
        }
        return new GridFinishedFuture();
    }

    private CancelResult removeServiceFromCache(String name) throws IgniteCheckedException {
        try {
            this.ctx.security().authorize(name, SecurityPermission.SERVICE_CANCEL, null);
        }
        catch (SecurityException e) {
            return new CancelResult(new GridFinishedFuture(e), false);
        }
        GridFutureAdapter fut = new GridFutureAdapter();
        GridFutureAdapter old = this.undepFuts.putIfAbsent(name, fut);
        if (old != null) {
            return new CancelResult(old, false);
        }
        GridServiceDeploymentKey key = new GridServiceDeploymentKey(name);
        try {
            if (this.serviceCache().getAndRemove(key) == null) {
                this.undepFuts.remove(name, fut);
                fut.onDone();
                return new CancelResult(fut, false);
            }
            return new CancelResult(fut, true);
        }
        catch (IgniteCheckedException e) {
            this.undepFuts.remove(name, fut);
            fut.onDone(e);
            throw e;
        }
    }

    public Map<UUID, Integer> serviceTopology(String name, long timeout) throws IgniteCheckedException {
        IgniteInternalCache<Object, Object> cache = this.serviceCache();
        ClusterNode node = cache.affinity().mapKeyToNode(name);
        ServiceTopologyCallable call = new ServiceTopologyCallable(name);
        return this.ctx.closure().callAsyncNoFailover(GridClosureCallMode.BROADCAST, call, Collections.singletonList(node), false, timeout, true).get();
    }

    private static Map<UUID, Integer> serviceTopology(IgniteInternalCache<Object, Object> cache, String svcName) throws IgniteCheckedException {
        GridServiceAssignments val = (GridServiceAssignments)cache.get(new GridServiceAssignmentsKey(svcName));
        return val != null ? val.assigns() : null;
    }

    public Collection<ServiceDescriptor> serviceDescriptors() {
        ArrayList<ServiceDescriptor> descs = new ArrayList<ServiceDescriptor>();
        Iterator<Cache.Entry<Object, Object>> it = this.serviceEntries(ServiceDeploymentPredicate.INSTANCE);
        while (it.hasNext()) {
            Cache.Entry<Object, Object> e = it.next();
            GridServiceDeployment dep = (GridServiceDeployment)e.getValue();
            ServiceDescriptorImpl desc = new ServiceDescriptorImpl(dep);
            try {
                GridServiceAssignments assigns = (GridServiceAssignments)this.serviceCache().getForcePrimary(new GridServiceAssignmentsKey(dep.configuration().getName()));
                if (assigns == null) continue;
                desc.topologySnapshot(assigns.assigns());
                descs.add(desc);
            }
            catch (IgniteCheckedException ex) {
                this.log.error("Failed to get assignments from replicated cache for service: " + dep.configuration().getName(), ex);
            }
        }
        return descs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T service(String name) {
        Collection<ServiceContextImpl> ctxs;
        this.ctx.security().authorize(name, SecurityPermission.SERVICE_INVOKE, null);
        Object object = this.locSvcs;
        synchronized (object) {
            ctxs = this.locSvcs.get(name);
        }
        if (ctxs == null) {
            return null;
        }
        object = ctxs;
        synchronized (object) {
            if (ctxs.isEmpty()) {
                return null;
            }
            for (ServiceContextImpl ctx : ctxs) {
                Service svc = ctx.service();
                if (svc == null) continue;
                return (T)svc;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceContextImpl serviceContext(String name) {
        Collection<ServiceContextImpl> ctxs;
        Object object = this.locSvcs;
        synchronized (object) {
            ctxs = this.locSvcs.get(name);
        }
        if (ctxs == null) {
            return null;
        }
        object = ctxs;
        synchronized (object) {
            if (ctxs.isEmpty()) {
                return null;
            }
            for (ServiceContextImpl ctx : ctxs) {
                if (ctx.service() == null) continue;
                return ctx;
            }
            return null;
        }
    }

    public <T> T serviceProxy(ClusterGroup prj, String name, Class<? super T> svcItf, boolean sticky, long timeout) throws IgniteException {
        Service svc;
        ServiceContextImpl ctx;
        this.ctx.security().authorize(name, SecurityPermission.SERVICE_INVOKE, null);
        if (this.hasLocalNode(prj) && (ctx = this.serviceContext(name)) != null && (svc = ctx.service()) != null) {
            if (!svcItf.isAssignableFrom(svc.getClass())) {
                throw new IgniteException("Service does not implement specified interface [svcItf=" + svcItf.getName() + ", svcCls=" + svc.getClass().getName() + ']');
            }
            return (T)svc;
        }
        return new GridServiceProxy<T>(prj, name, svcItf, sticky, timeout, this.ctx).proxy();
    }

    private boolean hasLocalNode(ClusterGroup prj) {
        for (ClusterNode n : prj.nodes()) {
            if (!n.isLocal()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Collection<T> services(String name) {
        Collection<ServiceContextImpl> ctxs;
        this.ctx.security().authorize(name, SecurityPermission.SERVICE_INVOKE, null);
        Object object = this.locSvcs;
        synchronized (object) {
            ctxs = this.locSvcs.get(name);
        }
        if (ctxs == null) {
            return null;
        }
        object = ctxs;
        synchronized (object) {
            ArrayList<Service> res = new ArrayList<Service>(ctxs.size());
            for (ServiceContextImpl ctx : ctxs) {
                Service svc = ctx.service();
                if (svc == null) continue;
                res.add(svc);
            }
            return res;
        }
    }

    private void reassign(GridServiceDeployment dep, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        IgniteInternalCache<Object, Object> cache = this.serviceCache();
        ServiceConfiguration cfg = dep.configuration();
        IgnitePredicate<ClusterNode> nodeFilter = cfg.getNodeFilter();
        if (nodeFilter != null) {
            this.ctx.resource().injectGeneric(nodeFilter);
        }
        int totalCnt = cfg.getTotalCount();
        int maxPerNodeCnt = cfg.getMaxPerNodeCount();
        String cacheName = cfg.getCacheName();
        Object affKey = cfg.getAffinityKey();
        while (true) {
            Collection<ClusterNode> nodes;
            GridServiceAssignments assigns = new GridServiceAssignments(cfg, dep.nodeId(), topVer.topologyVersion());
            if (affKey == null) {
                nodes = this.ctx.discovery().nodes(topVer);
                if (assigns.nodeFilter() != null) {
                    ArrayList<ClusterNode> nodes0 = new ArrayList<ClusterNode>();
                    for (ClusterNode node : nodes) {
                        if (!assigns.nodeFilter().apply(node)) continue;
                        nodes0.add(node);
                    }
                    nodes = nodes0;
                }
            } else {
                nodes = null;
            }
            try {
                GridNearTxLocal tx = cache.txStartEx(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
                Object object = null;
                try {
                    GridServiceAssignmentsKey key = new GridServiceAssignmentsKey(cfg.getName());
                    GridServiceAssignments oldAssigns = (GridServiceAssignments)cache.get(key);
                    HashMap<UUID, Integer> cnts = new HashMap<UUID, Integer>();
                    if (affKey != null) {
                        ClusterNode n = this.ctx.affinity().mapKeyToNode(cacheName, affKey, topVer);
                        if (n != null) {
                            int cnt = maxPerNodeCnt == 0 ? (totalCnt == 0 ? 1 : totalCnt) : maxPerNodeCnt;
                            cnts.put(n.id(), cnt);
                        }
                    } else if (!nodes.isEmpty()) {
                        int remainder;
                        int size = nodes.size();
                        int perNodeCnt = totalCnt != 0 ? totalCnt / size : maxPerNodeCnt;
                        int n = remainder = totalCnt != 0 ? totalCnt % size : 0;
                        if (perNodeCnt >= maxPerNodeCnt && maxPerNodeCnt != 0) {
                            perNodeCnt = maxPerNodeCnt;
                            remainder = 0;
                        }
                        for (ClusterNode n2 : nodes) {
                            cnts.put(n2.id(), perNodeCnt);
                        }
                        assert (perNodeCnt >= 0);
                        assert (remainder >= 0);
                        if (remainder > 0) {
                            int cnt = perNodeCnt + 1;
                            if (oldAssigns != null) {
                                HashSet<UUID> used = new HashSet<UUID>();
                                for (Map.Entry<UUID, Integer> entry : oldAssigns.assigns().entrySet()) {
                                    if (this.ctx.discovery().node(entry.getKey()) == null || entry.getValue() != cnt) continue;
                                    cnts.put(entry.getKey(), cnt);
                                    used.add(entry.getKey());
                                    if (--remainder != 0) continue;
                                    break;
                                }
                                if (remainder > 0) {
                                    ArrayList entries = new ArrayList(cnts.entrySet());
                                    Collections.shuffle(entries);
                                    for (Map.Entry entry : entries) {
                                        if (used.contains(entry.getKey()) || (Integer)entry.getValue() >= maxPerNodeCnt && maxPerNodeCnt != 0) continue;
                                        entry.setValue((Integer)entry.getValue() + 1);
                                        if (--remainder != 0) continue;
                                        break;
                                    }
                                }
                            } else {
                                ArrayList entries = new ArrayList(cnts.entrySet());
                                Collections.shuffle(entries);
                                for (Map.Entry entry : entries) {
                                    entry.setValue((Integer)entry.getValue() + 1);
                                    if (--remainder != 0) continue;
                                    break;
                                }
                            }
                        }
                    }
                    assigns.assigns(cnts);
                    cache.put(key, assigns);
                    tx.commit();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (tx != null) {
                        if (object != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            catch (ClusterTopologyCheckedException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Topology changed while reassigning (will retry): " + e.getMessage());
                }
                U.sleep(10L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redeploy(GridServiceAssignments assigns) {
        Collection<ServiceContextImpl> ctxs;
        if (assigns.topologyVersion() < this.ctx.discovery().topologyVersion()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Skip outdated assignment [assigns=" + assigns + ", topVer=" + this.ctx.discovery().topologyVersion() + ']');
            }
            return;
        }
        String svcName = assigns.name();
        Integer assignCnt = assigns.assigns().get(this.ctx.localNodeId());
        if (assignCnt == null) {
            assignCnt = 0;
        }
        Map<String, Collection<ServiceContextImpl>> map = this.locSvcs;
        synchronized (map) {
            ctxs = this.locSvcs.get(svcName);
            if (ctxs == null) {
                ctxs = new ArrayList<ServiceContextImpl>();
                this.locSvcs.put(svcName, ctxs);
            }
        }
        ArrayList<ServiceContextImpl> toInit = new ArrayList<ServiceContextImpl>();
        Collection<ServiceContextImpl> collection = ctxs;
        synchronized (collection) {
            if (ctxs.size() > assignCnt) {
                int cancelCnt = ctxs.size() - assignCnt;
                this.cancel(ctxs, cancelCnt);
            } else if (ctxs.size() < assignCnt) {
                int createCnt = assignCnt - ctxs.size();
                for (int i = 0; i < createCnt; ++i) {
                    ServiceContextImpl svcCtx = new ServiceContextImpl(assigns.name(), UUID.randomUUID(), assigns.cacheName(), assigns.affinityKey(), Executors.newSingleThreadExecutor(this.threadFactory));
                    ctxs.add(svcCtx);
                    toInit.add(svcCtx);
                }
            }
        }
        for (final ServiceContextImpl svcCtx : toInit) {
            Service svc;
            try {
                svc = this.copyAndInject(assigns.configuration());
                svc.init(svcCtx);
                svcCtx.service(svc);
            }
            catch (Throwable e) {
                U.error(this.log, "Failed to initialize service (service will not be deployed): " + assigns.name(), e);
                Collection<ServiceContextImpl> collection2 = ctxs;
                synchronized (collection2) {
                    ctxs.removeAll(toInit);
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                return;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Starting service instance [name=" + svcCtx.name() + ", execId=" + svcCtx.executionId() + ']');
            }
            final ExecutorService exe = svcCtx.executor();
            exe.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        svc.execute(svcCtx);
                    }
                    catch (InterruptedException | IgniteInterruptedCheckedException ignore) {
                        if (GridServiceProcessor.this.log.isDebugEnabled()) {
                            GridServiceProcessor.this.log.debug("Service thread was interrupted [name=" + svcCtx.name() + ", execId=" + svcCtx.executionId() + ']');
                        }
                    }
                    catch (IgniteException e) {
                        if (e.hasCause(InterruptedException.class) || e.hasCause(IgniteInterruptedCheckedException.class)) {
                            if (GridServiceProcessor.this.log.isDebugEnabled()) {
                                GridServiceProcessor.this.log.debug("Service thread was interrupted [name=" + svcCtx.name() + ", execId=" + svcCtx.executionId() + ']');
                            }
                        } else {
                            U.error(GridServiceProcessor.this.log, "Service execution stopped with error [name=" + svcCtx.name() + ", execId=" + svcCtx.executionId() + ']', e);
                        }
                    }
                    catch (Throwable e) {
                        GridServiceProcessor.this.log.error("Service execution stopped with error [name=" + svcCtx.name() + ", execId=" + svcCtx.executionId() + ']', e);
                        if (e instanceof Error) {
                            throw (Error)e;
                        }
                    }
                    finally {
                        exe.shutdownNow();
                    }
                }
            });
        }
    }

    private Service copyAndInject(ServiceConfiguration cfg) throws IgniteCheckedException {
        Marshaller m = this.ctx.config().getMarshaller();
        if (cfg instanceof LazyServiceConfiguration) {
            LazyServiceConfiguration srvcCfg = (LazyServiceConfiguration)cfg;
            GridDeployment srvcDep = this.ctx.deploy().getDeployment(srvcCfg.serviceClassName());
            byte[] bytes = ((LazyServiceConfiguration)cfg).serviceBytes();
            Service srvc = (Service)U.unmarshal(m, bytes, U.resolveClassLoader(srvcDep != null ? srvcDep.classLoader() : null, this.ctx.config()));
            this.ctx.resource().inject(srvc);
            return srvc;
        }
        Service svc = cfg.getService();
        try {
            byte[] bytes = U.marshal(m, (Object)svc);
            Service cp = (Service)U.unmarshal(m, bytes, U.resolveClassLoader(svc.getClass().getClassLoader(), this.ctx.config()));
            this.ctx.resource().inject(cp);
            return cp;
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to copy service (will reuse same instance): " + svc.getClass(), e);
            return svc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(Iterable<ServiceContextImpl> ctxs, int cancelCnt) {
        Iterator<ServiceContextImpl> it = ctxs.iterator();
        while (it.hasNext()) {
            ServiceContextImpl svcCtx = it.next();
            svcCtx.setCancelled(true);
            Service svc = svcCtx.service();
            if (svc != null) {
                try {
                    svc.cancel(svcCtx);
                }
                catch (Throwable e) {
                    this.log.error("Failed to cancel service (ignoring) [name=" + svcCtx.name() + ", execId=" + svcCtx.executionId() + ']', e);
                    if (e instanceof Error) {
                        throw e;
                    }
                }
                finally {
                    try {
                        this.ctx.resource().cleanup(svc);
                    }
                    catch (IgniteCheckedException e) {
                        U.error(this.log, "Failed to clean up service (will ignore): " + svcCtx.name(), e);
                    }
                }
            }
            svcCtx.executor().shutdownNow();
            it.remove();
            if (this.log.isInfoEnabled()) {
                this.log.info("Cancelled service instance [name=" + svcCtx.name() + ", execId=" + svcCtx.executionId() + ']');
            }
            if (--cancelCnt != 0) continue;
            break;
        }
    }

    private Iterator<Cache.Entry<Object, Object>> serviceEntries(IgniteBiPredicate<Object, Object> p) {
        try {
            IgniteInternalCache<Object, Object> cache = this.serviceCache();
            GridCacheQueryManager<Object, Object> qryMgr = cache.context().queries();
            CacheQuery qry = qryMgr.createScanQuery(p, null, false);
            DiscoveryDataClusterState clusterState = this.ctx.state().clusterState();
            if (clusterState.hasBaselineTopology() && !CU.baselineNode(this.ctx.cluster().get().localNode(), clusterState) || !cache.context().affinityNode()) {
                ClusterNode oldestSrvNode = this.ctx.discovery().oldestAliveServerNode(AffinityTopologyVersion.NONE);
                if (oldestSrvNode == null) {
                    return new GridEmptyIterator<Cache.Entry<Object, Object>>();
                }
                qry.projection(this.ctx.cluster().get().forNode(oldestSrvNode, new ClusterNode[0]));
            } else {
                qry.projection(this.ctx.cluster().get().forLocal());
            }
            GridCloseableIterator iter = qry.executeScanQuery();
            return cache.context().itHolder().iterator(iter, new CacheIteratorConverter<Cache.Entry<Object, Object>, Map.Entry<Object, Object>>(){

                @Override
                protected Cache.Entry<Object, Object> convert(Map.Entry<Object, Object> e) {
                    return (Cache.Entry)e;
                }

                @Override
                protected void remove(Cache.Entry<Object, Object> item) {
                    throw new UnsupportedOperationException();
                }
            });
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUtilityCacheStarted() {
        List<ComputeJobContext> list = this.pendingJobCtxs;
        synchronized (list) {
            if (this.pendingJobCtxs.isEmpty()) {
                return;
            }
            Iterator<ComputeJobContext> iter = this.pendingJobCtxs.iterator();
            while (iter.hasNext()) {
                iter.next().callcc();
                iter.remove();
            }
        }
    }

    private void onSystemCacheUpdated(Iterable<CacheEntryEvent<?, ?>> evts) {
        for (CacheEntryEvent<?, ?> e : evts) {
            if (e.getKey() instanceof GridServiceDeploymentKey) {
                this.processDeployment(e);
                continue;
            }
            if (!(e.getKey() instanceof GridServiceAssignmentsKey)) continue;
            this.processAssignment(e);
        }
    }

    private void processDeployment(CacheEntryEvent<GridServiceDeploymentKey, GridServiceDeployment> e) {
        GridServiceDeployment dep;
        try {
            dep = (GridServiceDeployment)e.getValue();
        }
        catch (IgniteException ex) {
            if (X.hasCause((Throwable)ex, ClassNotFoundException.class)) {
                return;
            }
            throw ex;
        }
        if (e.getEventType() != EventType.REMOVED) {
            this.svcName.set(dep.configuration().getName());
            AffinityTopologyVersion topVer = this.ctx.discovery().topologyVersionEx();
            ClusterNode oldest = U.oldest(this.ctx.discovery().nodes(topVer), null);
            if (oldest.isLocal()) {
                this.onDeployment(dep, topVer);
            }
        } else {
            String name = ((GridServiceDeploymentKey)e.getKey()).name();
            this.undeploy(name);
            GridFutureAdapter fut = (GridFutureAdapter)this.depFuts.remove(name);
            if (fut != null) {
                fut.onDone();
            }
            if ((fut = (GridFutureAdapter)this.undepFuts.remove(name)) != null) {
                fut.onDone();
            }
            GridServiceAssignmentsKey key = new GridServiceAssignmentsKey(name);
            IgniteInternalCache<Object, Object> cache = this.serviceCache();
            if (cache.cache().affinity().isPrimary(this.ctx.discovery().localNode(), key)) {
                try {
                    cache.getAndRemove(key);
                }
                catch (IgniteCheckedException ex) {
                    U.error(this.log, "Failed to remove assignments for undeployed service: " + name, ex);
                }
            }
        }
    }

    private void onDeployment(final GridServiceDeployment dep, final AffinityTopologyVersion topVer) {
        try {
            AffinityTopologyVersion newTopVer = this.ctx.discovery().topologyVersionEx();
            if (newTopVer.equals(topVer)) {
                this.reassign(dep, topVer);
            }
        }
        catch (IgniteCheckedException e) {
            AffinityTopologyVersion newTopVer;
            if (!(e instanceof ClusterTopologyCheckedException)) {
                this.log.error("Failed to do service reassignment (will retry): " + dep.configuration().getName(), e);
            }
            if (!(newTopVer = this.ctx.discovery().topologyVersionEx()).equals(topVer)) {
                assert (newTopVer.compareTo(topVer) > 0);
                return;
            }
            this.ctx.timeout().addTimeoutObject(new GridTimeoutObject(){
                private IgniteUuid id = IgniteUuid.randomUuid();
                private long start = System.currentTimeMillis();

                @Override
                public IgniteUuid timeoutId() {
                    return this.id;
                }

                @Override
                public long endTime() {
                    return this.start + 1000L;
                }

                @Override
                public void onTimeout() {
                    GridServiceProcessor.this.depExe.execute(new DepRunnable(){

                        @Override
                        public void run0() {
                            GridServiceProcessor.this.onDeployment(dep, topVer);
                        }
                    });
                }
            });
        }
    }

    private void processAssignment(CacheEntryEvent<GridServiceAssignmentsKey, GridServiceAssignments> e) {
        GridServiceAssignments assigns;
        try {
            assigns = (GridServiceAssignments)e.getValue();
        }
        catch (IgniteException ex) {
            if (X.hasCause((Throwable)ex, ClassNotFoundException.class)) {
                return;
            }
            throw ex;
        }
        if (e.getEventType() != EventType.REMOVED) {
            this.svcName.set(assigns.name());
            Throwable t = null;
            try {
                this.redeploy(assigns);
            }
            catch (Error | RuntimeException th) {
                t = th;
            }
            GridServiceDeploymentFuture fut = (GridServiceDeploymentFuture)this.depFuts.get(assigns.name());
            if (fut != null && fut.configuration().equalsIgnoreNodeFilter(assigns.configuration())) {
                this.depFuts.remove(assigns.name(), fut);
                fut.onDone(null, t);
            }
        } else {
            this.undeploy(((GridServiceAssignmentsKey)e.getKey()).name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeploy(String name) {
        Collection<ServiceContextImpl> ctxs;
        this.svcName.set(name);
        Object object = this.locSvcs;
        synchronized (object) {
            ctxs = this.locSvcs.remove(name);
        }
        if (ctxs != null) {
            object = ctxs;
            synchronized (object) {
                this.cancel(ctxs, ctxs.size());
            }
        }
    }

    @GridInternal
    private static class ServiceTopologyCallable
    implements IgniteCallable<Map<UUID, Integer>> {
        private static final long serialVersionUID = 0L;
        private final String svcName;
        private transient boolean waitedCacheInit;
        @IgniteInstanceResource
        private IgniteEx ignite;
        @JobContextResource
        private transient ComputeJobContext jCtx;
        @LoggerResource
        private transient IgniteLogger log;

        public ServiceTopologyCallable(String svcName) {
            this.svcName = svcName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<UUID, Integer> call() throws Exception {
            IgniteInternalCache cache = this.ignite.context().cache().utilityCache();
            if (cache == null) {
                List pendingCtxs;
                List list = pendingCtxs = this.ignite.context().service().pendingJobCtxs;
                synchronized (list) {
                    cache = this.ignite.context().cache().utilityCache();
                    if (cache == null) {
                        if (!this.waitedCacheInit) {
                            this.log.debug("Utility cache hasn't been initialized yet. Waiting.");
                            this.jCtx.holdcc(60000L);
                            pendingCtxs.add(this.jCtx);
                            this.waitedCacheInit = true;
                            return null;
                        }
                        this.log.error("Failed to gather service topology. Utility cache initialization is stuck.");
                        throw new IgniteCheckedException("Failed to gather service topology. Utility cache initialization is stuck.");
                    }
                }
            }
            return GridServiceProcessor.serviceTopology(cache, this.svcName);
        }
    }

    static class ServiceAssignmentsPredicate
    implements IgniteBiPredicate<Object, Object> {
        static final ServiceAssignmentsPredicate INSTANCE = new ServiceAssignmentsPredicate();
        private static final long serialVersionUID = 0L;

        ServiceAssignmentsPredicate() {
        }

        @Override
        public boolean apply(Object key, Object val) {
            return key instanceof GridServiceAssignmentsKey;
        }

        public String toString() {
            return S.toString(ServiceAssignmentsPredicate.class, this);
        }
    }

    static class ServiceDeploymentPredicate
    implements IgniteBiPredicate<Object, Object> {
        static final ServiceDeploymentPredicate INSTANCE = new ServiceDeploymentPredicate();
        private static final long serialVersionUID = 0L;

        ServiceDeploymentPredicate() {
        }

        @Override
        public boolean apply(Object key, Object val) {
            return key instanceof GridServiceDeploymentKey;
        }

        public String toString() {
            return S.toString(ServiceDeploymentPredicate.class, this);
        }
    }

    private abstract class DepRunnable
    implements Runnable {
        private DepRunnable() {
        }

        @Override
        public void run() {
            GridSpinBusyLock busyLock = GridServiceProcessor.this.busyLock;
            if (busyLock == null || !busyLock.enterBusy()) {
                return;
            }
            busyLock.leaveBusy();
            GridServiceProcessor.this.svcName.set(null);
            try {
                this.run0();
            }
            catch (Throwable t) {
                GridServiceProcessor.this.log.error("Error when executing service: " + (String)GridServiceProcessor.this.svcName.get(), t);
                if (t instanceof Error) {
                    throw t;
                }
            }
            finally {
                GridServiceProcessor.this.svcName.set(null);
            }
        }

        public abstract void run0();
    }

    private static class CancelResult {
        IgniteInternalFuture<?> fut;
        boolean rollback;

        CancelResult(IgniteInternalFuture<?> fut, boolean rollback) {
            this.fut = fut;
            this.rollback = rollback;
        }
    }

    private class TopologyListener
    implements DiscoveryEventListener {
        private volatile AffinityTopologyVersion currTopVer = null;

        private TopologyListener() {
        }

        private boolean skipExchange(AffinityTopologyVersion initTopVer) {
            boolean skipExchange;
            AffinityTopologyVersion pendingTopVer = null;
            AffinityTopologyVersion newTopVer = this.currTopVer;
            if (!initTopVer.equals(newTopVer)) {
                pendingTopVer = newTopVer;
            } else {
                IgniteInternalFuture<AffinityTopologyVersion> affReadyFut = GridServiceProcessor.this.ctx.cache().context().exchange().affinityReadyFuture(initTopVer);
                if (affReadyFut != null) {
                    try {
                        affReadyFut.get();
                    }
                    catch (IgniteCheckedException e) {
                        U.warn(GridServiceProcessor.this.log, "Failed to wait for affinity ready future (the assignment will be recalculated anyway):" + e.toString());
                    }
                }
                if (!initTopVer.equals(newTopVer = this.currTopVer)) {
                    pendingTopVer = newTopVer;
                }
            }
            boolean bl = skipExchange = pendingTopVer != null;
            if (skipExchange && GridServiceProcessor.this.log.isInfoEnabled()) {
                GridServiceProcessor.this.log.info("Service processor detected a topology change during assignments calculation (will abort current iteration and re-calculate on the newer version): [topVer=" + initTopVer + ", newTopVer=" + pendingTopVer + ']');
            }
            return skipExchange;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(DiscoveryEvent evt, final DiscoCache discoCache) {
            GridSpinBusyLock busyLock = GridServiceProcessor.this.busyLock;
            if (busyLock == null || !busyLock.enterBusy()) {
                return;
            }
            try {
                AffinityTopologyVersion topVer;
                if (evt instanceof DiscoveryCustomEvent) {
                    DiscoveryCustomMessage msg = ((DiscoveryCustomEvent)evt).customMessage();
                    if (msg instanceof CacheAffinityChangeMessage) {
                        if (!((CacheAffinityChangeMessage)msg).exchangeNeeded()) {
                            return;
                        }
                    } else if (msg instanceof DynamicCacheChangeBatch) {
                        if (!((DynamicCacheChangeBatch)msg).exchangeNeeded()) {
                            return;
                        }
                    } else {
                        return;
                    }
                    if (msg instanceof MetadataUpdateProposedMessage || msg instanceof MetadataUpdateAcceptedMessage) {
                        return;
                    }
                    topVer = ((DiscoveryCustomEvent)evt).affinityTopologyVersion();
                } else {
                    topVer = new AffinityTopologyVersion(evt.topologyVersion(), 0);
                }
                this.currTopVer = topVer;
                GridServiceProcessor.this.depExe.execute(new DepRunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run0() {
                        Cache.Entry e;
                        discoCache.updateAlives(GridServiceProcessor.this.ctx.discovery());
                        ClusterNode oldest = discoCache.oldestAliveServerNode();
                        if (oldest != null && oldest.isLocal()) {
                            ConcurrentLinkedQueue<GridServiceDeployment> retries = new ConcurrentLinkedQueue<GridServiceDeployment>();
                            if (GridServiceProcessor.this.ctx.deploy().enabled()) {
                                GridServiceProcessor.this.ctx.cache().context().deploy().ignoreOwnership(true);
                            }
                            try {
                                Iterator it = GridServiceProcessor.this.serviceEntries(ServiceDeploymentPredicate.INSTANCE);
                                while (it.hasNext()) {
                                    if (TopologyListener.this.skipExchange(topVer)) {
                                        return;
                                    }
                                    e = (Cache.Entry)it.next();
                                    GridServiceDeployment dep = (GridServiceDeployment)e.getValue();
                                    try {
                                        GridServiceProcessor.this.svcName.set(dep.configuration().getName());
                                        GridServiceProcessor.this.reassign(dep, topVer);
                                    }
                                    catch (IgniteCheckedException ex) {
                                        if (!(ex instanceof ClusterTopologyCheckedException)) {
                                            LT.error(GridServiceProcessor.this.log, ex, "Failed to do service reassignment (will retry): " + dep.configuration().getName());
                                        }
                                        retries.add(dep);
                                    }
                                }
                            }
                            finally {
                                if (GridServiceProcessor.this.ctx.deploy().enabled()) {
                                    GridServiceProcessor.this.ctx.cache().context().deploy().ignoreOwnership(false);
                                }
                            }
                            if (!retries.isEmpty()) {
                                TopologyListener.this.onReassignmentFailed(topVer, retries);
                            }
                        }
                        Iterator it = GridServiceProcessor.this.serviceEntries(ServiceAssignmentsPredicate.INSTANCE);
                        IgniteInternalCache cache = GridServiceProcessor.this.serviceCache();
                        while (it.hasNext()) {
                            if (TopologyListener.this.skipExchange(topVer)) {
                                return;
                            }
                            e = (Cache.Entry)it.next();
                            if (!cache.context().affinity().primaryByKey(GridServiceProcessor.this.ctx.grid().localNode(), e.getKey(), topVer)) continue;
                            String name = ((GridServiceAssignmentsKey)e.getKey()).name();
                            try {
                                if (cache.get(new GridServiceDeploymentKey(name)) != null) continue;
                                if (GridServiceProcessor.this.log.isDebugEnabled()) {
                                    GridServiceProcessor.this.log.debug("Removed zombie assignments: " + e.getValue());
                                }
                                cache.getAndRemove(e.getKey());
                            }
                            catch (IgniteCheckedException ex) {
                                U.error(GridServiceProcessor.this.log, "Failed to clean up zombie assignments for service: " + name, ex);
                            }
                        }
                    }
                });
            }
            finally {
                busyLock.leaveBusy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onReassignmentFailed(final AffinityTopologyVersion topVer, final Collection<GridServiceDeployment> retries) {
            GridSpinBusyLock busyLock = GridServiceProcessor.this.busyLock;
            if (busyLock == null || !busyLock.enterBusy()) {
                return;
            }
            try {
                if (GridServiceProcessor.this.ctx.discovery().topologyVersionEx().equals(topVer)) {
                    return;
                }
                Iterator<GridServiceDeployment> it = retries.iterator();
                while (it.hasNext()) {
                    GridServiceDeployment dep = it.next();
                    try {
                        GridServiceProcessor.this.svcName.set(dep.configuration().getName());
                        GridServiceProcessor.this.reassign(dep, topVer);
                        it.remove();
                    }
                    catch (IgniteCheckedException e) {
                        if (e instanceof ClusterTopologyCheckedException) continue;
                        LT.error(GridServiceProcessor.this.log, e, "Failed to do service reassignment (will retry): " + dep.configuration().getName());
                    }
                }
                if (!retries.isEmpty()) {
                    GridServiceProcessor.this.ctx.timeout().addTimeoutObject(new GridTimeoutObject(){
                        private IgniteUuid id = IgniteUuid.randomUuid();
                        private long start = System.currentTimeMillis();

                        @Override
                        public IgniteUuid timeoutId() {
                            return this.id;
                        }

                        @Override
                        public long endTime() {
                            return this.start + 1000L;
                        }

                        @Override
                        public void onTimeout() {
                            GridServiceProcessor.this.depExe.execute(new Runnable(){

                                @Override
                                public void run() {
                                    TopologyListener.this.onReassignmentFailed(topVer, retries);
                                }
                            });
                        }
                    });
                }
            }
            finally {
                busyLock.leaveBusy();
            }
        }
    }

    private class ServiceEntriesListener
    implements CacheEntryUpdatedListener<Object, Object> {
        private ServiceEntriesListener() {
        }

        public void onUpdated(final Iterable<CacheEntryEvent<?, ?>> deps) {
            GridSpinBusyLock busyLock = GridServiceProcessor.this.busyLock;
            if (busyLock == null || !busyLock.enterBusy()) {
                return;
            }
            try {
                GridServiceProcessor.this.depExe.execute(new DepRunnable(){

                    @Override
                    public void run0() {
                        GridServiceProcessor.this.onSystemCacheUpdated(deps);
                    }
                });
            }
            finally {
                busyLock.leaveBusy();
            }
        }
    }
}

