/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.IgniteAuthenticationException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.ConnectorMessageInterceptor;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestProtocol;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientTaskResultBean;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.auth.AuthenticationCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.cache.GridCacheCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.cluster.GridBaselineCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.cluster.GridChangeStateCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.datastructures.DataStructuresCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.log.GridLogCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.query.QueryCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.task.GridTaskCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.top.GridTopologyCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.user.UserActionCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.version.GridVersionCommandHandler;
import org.apache.ignite.internal.processors.rest.protocols.tcp.GridTcpRestProtocol;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestTaskRequest;
import org.apache.ignite.internal.processors.rest.request.RestQueryRequest;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.util.GridSpinReadWriteLock;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.util.worker.GridWorkerFuture;
import org.apache.ignite.internal.visor.compute.VisorGatewayTask;
import org.apache.ignite.internal.visor.util.VisorClusterGroupEmptyException;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecuritySubjectType;
import org.apache.ignite.thread.IgniteThread;

public class GridRestProcessor
extends GridProcessorAdapter {
    private static final String HTTP_PROTO_CLS = "org.apache.ignite.internal.processors.rest.protocols.http.jetty.GridJettyRestProtocol";
    private static final int SES_TIMEOUT_CHECK_DELAY = 1000;
    private static final int DFLT_SES_TIMEOUT = 30;
    private static final int DFLT_SES_TOKEN_INVALIDATE_INTERVAL = 300;
    private static final int WRAPPED_TASK_IDX = 1;
    private final Collection<GridRestProtocol> protos = new ArrayList<GridRestProtocol>();
    protected final Map<GridRestCommand, GridRestCommandHandler> handlers = new EnumMap<GridRestCommand, GridRestCommandHandler>(GridRestCommand.class);
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final GridSpinReadWriteLock busyLock = new GridSpinReadWriteLock();
    private final LongAdder workersCnt = new LongAdder();
    private final ConcurrentMap<UUID, UUID> clientId2SesId = new ConcurrentHashMap<UUID, UUID>();
    private final ConcurrentMap<UUID, Session> sesId2Ses = new ConcurrentHashMap<UUID, Session>();
    private final Thread sesTimeoutCheckerThread;
    private final GridRestProtocolHandler protoHnd = new GridRestProtocolHandler(){

        @Override
        public GridRestResponse handle(GridRestRequest req) throws IgniteCheckedException {
            return this.handleAsync(req).get();
        }

        @Override
        public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest req) {
            return GridRestProcessor.this.handleAsync0(req);
        }
    };
    private final long sesTtl = IgniteSystemProperties.getLong("IGNITE_REST_SESSION_TIMEOUT", 30L) * 1000L;
    private final long sesTokTtl = IgniteSystemProperties.getLong("IGNITE_REST_SECURITY_TOKEN_TIMEOUT", 300L) * 100L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture<GridRestResponse> handleAsync0(final GridRestRequest req) {
        if (!this.busyLock.tryReadLock()) {
            return new GridFinishedFuture<GridRestResponse>(new IgniteCheckedException("Failed to handle request (received request while stopping grid)."));
        }
        try {
            final GridWorkerFuture<GridRestResponse> fut = new GridWorkerFuture<GridRestResponse>();
            this.workersCnt.increment();
            GridWorker w = new GridWorker(this.ctx.igniteInstanceName(), "rest-proc-worker", this.log){

                @Override
                protected void body() {
                    try {
                        IgniteInternalFuture res = GridRestProcessor.this.handleRequest(req);
                        res.listen(new IgniteInClosure<IgniteInternalFuture<GridRestResponse>>(){

                            @Override
                            public void apply(IgniteInternalFuture<GridRestResponse> f) {
                                try {
                                    fut.onDone(f.get());
                                }
                                catch (IgniteCheckedException e) {
                                    fut.onDone(e);
                                }
                            }
                        });
                    }
                    catch (Throwable e) {
                        if (e instanceof Error) {
                            U.error(this.log, "Client request execution failed with error.", e);
                        }
                        fut.onDone(U.cast(e));
                        if (e instanceof Error) {
                            throw e;
                        }
                    }
                    finally {
                        GridRestProcessor.this.workersCnt.decrement();
                    }
                }
            };
            fut.setWorker(w);
            try {
                this.ctx.getRestExecutorService().execute(w);
            }
            catch (RejectedExecutionException e) {
                U.error(this.log, "Failed to execute worker due to execution rejection (increase upper bound on REST executor service). Will attempt to process request in the current thread instead.", e);
                w.run();
            }
            GridWorkerFuture<GridRestResponse> gridWorkerFuture = fut;
            return gridWorkerFuture;
        }
        finally {
            this.busyLock.readUnlock();
        }
    }

    private IgniteInternalFuture<GridRestResponse> handleRequest(final GridRestRequest req) {
        IgniteInternalFuture<GridRestResponse> res;
        if (this.startLatch.getCount() > 0L) {
            try {
                this.startLatch.await();
            }
            catch (InterruptedException e) {
                return new GridFinishedFuture<GridRestResponse>(new IgniteCheckedException("Failed to handle request (protocol handler was interrupted when awaiting grid start).", e));
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received request from client: " + req);
        }
        final boolean authenticationEnabled = this.ctx.authentication().enabled();
        final boolean securityEnabled = this.ctx.security().enabled();
        if (authenticationEnabled || securityEnabled) {
            Session ses;
            try {
                ses = this.session(req);
            }
            catch (IgniteAuthenticationException e) {
                return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(2, e.getMessage()));
            }
            catch (IgniteCheckedException e) {
                return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(1, e.getMessage()));
            }
            assert (ses != null);
            req.clientId(ses.clientId);
            req.sessionToken(U.uuidToBytes(ses.sesId));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Next clientId and sessionToken were extracted according to request: [clientId=" + req.clientId() + ", sesTok=" + Arrays.toString(req.sessionToken()) + "]");
            }
            if (securityEnabled) {
                SecurityContext secCtx0 = ses.secCtx;
                try {
                    if (secCtx0 == null || ses.isTokenExpired(this.sesTokTtl)) {
                        secCtx0 = this.authenticate(req, ses);
                        ses.secCtx = secCtx0;
                    }
                    this.authorize(req, secCtx0);
                }
                catch (SecurityException e) {
                    assert (secCtx0 != null);
                    return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(3, e.getMessage()));
                }
                catch (IgniteCheckedException e) {
                    return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(2, e.getMessage()));
                }
            }
            AuthorizationContext authCtx0 = ses.authCtx;
            try {
                if (authCtx0 == null) {
                    SecurityCredentials creds = this.credentials(req);
                    String login = null;
                    if (creds.getLogin() instanceof String) {
                        login = (String)creds.getLogin();
                    }
                    String pwd = null;
                    if (creds.getPassword() instanceof String) {
                        pwd = (String)creds.getPassword();
                    }
                    if (F.isEmpty(login) || F.isEmpty(pwd)) {
                        throw new IgniteAuthenticationException("The user name or password is incorrect");
                    }
                    ses.authCtx = this.ctx.authentication().authenticate(login, pwd);
                }
                req.authorizationContext(ses.authCtx);
            }
            catch (IgniteCheckedException e) {
                return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(2, e.getMessage()));
            }
        }
        this.interceptRequest(req);
        GridRestCommandHandler hnd = this.handlers.get((Object)req.command());
        IgniteInternalFuture<GridRestResponse> igniteInternalFuture = res = hnd == null ? null : hnd.handleAsync(req);
        if (res == null) {
            return new GridFinishedFuture<GridRestResponse>(new IgniteCheckedException("Failed to find registered handler for command: " + (Object)((Object)req.command())));
        }
        return res.chain(new C1<IgniteInternalFuture<GridRestResponse>, GridRestResponse>(){

            @Override
            public GridRestResponse apply(IgniteInternalFuture<GridRestResponse> f) {
                GridRestResponse res;
                boolean failed = false;
                try {
                    res = f.get();
                }
                catch (Exception e) {
                    failed = true;
                    if (!X.hasCause((Throwable)e, VisorClusterGroupEmptyException.class)) {
                        LT.error(GridRestProcessor.this.log, e, "Failed to handle request: " + (Object)((Object)req.command()));
                    }
                    if (GridRestProcessor.this.log.isDebugEnabled()) {
                        GridRestProcessor.this.log.debug("Failed to handle request [req=" + req + ", e=" + e + "]");
                    }
                    SB sb = new SB(256);
                    sb.a("Failed to handle request: [req=").a((Object)req.command());
                    if (req instanceof GridRestTaskRequest) {
                        GridRestTaskRequest tskReq = (GridRestTaskRequest)req;
                        sb.a(", taskName=").a(tskReq.taskName()).a(", params=").a(tskReq.params());
                    }
                    sb.a(", err=").a(e.getMessage() != null ? e.getMessage() : e.getClass().getName()).a(", trace=").a(GridRestProcessor.this.getErrorMessage(e)).a(']');
                    res = new GridRestResponse(1, sb.toString());
                }
                assert (res != null);
                if ((authenticationEnabled || securityEnabled) && !failed) {
                    res.sessionTokenBytes(req.sessionToken());
                }
                GridRestProcessor.this.interceptResponse(res, req);
                return res;
            }
        });
    }

    private String getErrorMessage(Throwable th) {
        if (th == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        th.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private Session session(GridRestRequest req) throws IgniteCheckedException {
        UUID clientId = req.clientId();
        byte[] sesTok = req.sessionToken();
        while (true) {
            Session ses;
            UUID sesId;
            if (F.isEmpty(sesTok) && clientId == null) {
                if (this.ctx.authentication().enabled() && req.command() != GridRestCommand.AUTHENTICATE && req.credentials() == null) {
                    throw new IgniteAuthenticationException("Failed to handle request - session token not found or invalid");
                }
                Session ses2 = Session.random();
                UUID oldSesId = this.clientId2SesId.put(ses2.clientId, ses2.sesId);
                assert (oldSesId == null) : "Got an illegal state for request: " + req;
                Session oldSes = this.sesId2Ses.put(ses2.sesId, ses2);
                assert (oldSes == null) : "Got an illegal state for request: " + req;
                return ses2;
            }
            if (F.isEmpty(sesTok) && clientId != null) {
                sesId = (UUID)this.clientId2SesId.get(clientId);
                if (sesId == null) {
                    ses = Session.fromClientId(clientId);
                    if (this.clientId2SesId.putIfAbsent(ses.clientId, ses.sesId) != null) continue;
                    Session prevSes = this.sesId2Ses.put(ses.sesId, ses);
                    assert (prevSes == null) : "Got an illegal state for request: " + req;
                    return ses;
                }
                ses = (Session)this.sesId2Ses.get(sesId);
                if (ses == null || !ses.touch()) continue;
                return ses;
            }
            if (!F.isEmpty(sesTok) && clientId == null) {
                sesId = U.bytesToUuid(sesTok, 0);
                ses = (Session)this.sesId2Ses.get(sesId);
                if (ses == null) {
                    throw new IgniteCheckedException("Failed to handle request - unknown session token (maybe expired session) [sesTok=" + U.byteArray2HexString(sesTok) + "]");
                }
                if (!ses.touch()) continue;
                return ses;
            }
            if (!F.isEmpty(sesTok) && clientId != null) {
                sesId = (UUID)this.clientId2SesId.get(clientId);
                if (sesId == null || !sesId.equals(U.bytesToUuid(sesTok, 0))) {
                    throw new IgniteCheckedException("Failed to handle request - unsupported case (mismatched clientId and session token) [clientId=" + clientId + ", sesTok=" + U.byteArray2HexString(sesTok) + "]");
                }
                ses = (Session)this.sesId2Ses.get(sesId);
                if (ses == null) {
                    throw new IgniteCheckedException("Failed to handle request - unknown session token (maybe expired session) [sesTok=" + U.byteArray2HexString(sesTok) + "]");
                }
                if (!ses.touch()) continue;
                return ses;
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError((Object)"Got an unreachable state.");
    }

    public GridRestProcessor(final GridKernalContext ctx) {
        super(ctx);
        this.sesTimeoutCheckerThread = new IgniteThread(ctx.igniteInstanceName(), "session-timeout-worker", new GridWorker(ctx.igniteInstanceName(), "session-timeout-worker", this.log){

            @Override
            protected void body() throws InterruptedException {
                while (!this.isCancelled()) {
                    Thread.sleep(1000L);
                    for (Map.Entry e : GridRestProcessor.this.sesId2Ses.entrySet()) {
                        Session ses = (Session)e.getValue();
                        if (!ses.isTimedOut(GridRestProcessor.this.sesTtl)) continue;
                        GridRestProcessor.this.clientId2SesId.remove(ses.clientId, ses.sesId);
                        GridRestProcessor.this.sesId2Ses.remove(ses.sesId, ses);
                        if (!ctx.security().enabled() || ses.secCtx == null || ses.secCtx.subject() == null) continue;
                        ctx.security().onSessionExpired(ses.secCtx.subject().id());
                    }
                }
            }
        });
    }

    @Override
    public void start() throws IgniteCheckedException {
        if (this.isRestEnabled()) {
            if (this.notStartOnClient()) {
                U.quietAndInfo(this.log, "REST protocols do not start on client node. To start the protocols on client node set '-DIGNITE_REST_START_ON_CLIENT=true' system property.");
                return;
            }
            this.addHandler(new GridCacheCommandHandler(this.ctx));
            this.addHandler(new GridTaskCommandHandler(this.ctx));
            this.addHandler(new GridTopologyCommandHandler(this.ctx));
            this.addHandler(new GridVersionCommandHandler(this.ctx));
            this.addHandler(new DataStructuresCommandHandler(this.ctx));
            this.addHandler(new QueryCommandHandler(this.ctx));
            this.addHandler(new GridLogCommandHandler(this.ctx));
            this.addHandler(new GridChangeStateCommandHandler(this.ctx));
            this.addHandler(new AuthenticationCommandHandler(this.ctx));
            this.addHandler(new UserActionCommandHandler(this.ctx));
            this.addHandler(new GridBaselineCommandHandler(this.ctx));
            this.startTcpProtocol();
            this.startHttpProtocol();
            for (GridRestProtocol proto : this.protos) {
                Collection<IgniteBiTuple<String, Object>> props = proto.getProperties();
                if (props == null) continue;
                for (IgniteBiTuple<String, Object> p : props) {
                    String key = p.getKey();
                    if (key == null) continue;
                    if (this.ctx.hasNodeAttribute(key)) {
                        throw new IgniteCheckedException("Node attribute collision for attribute [processor=GridRestProcessor, attr=" + key + ']');
                    }
                    this.ctx.addNodeAttribute(key, p.getValue());
                }
            }
        }
    }

    private boolean notStartOnClient() {
        return this.ctx.clientNode() && !IgniteSystemProperties.getBoolean("IGNITE_REST_START_ON_CLIENT");
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        if (this.isRestEnabled()) {
            for (GridRestProtocol proto : this.protos) {
                proto.onKernalStart();
            }
            this.sesTimeoutCheckerThread.setDaemon(true);
            this.sesTimeoutCheckerThread.start();
            this.startLatch.countDown();
            if (this.log.isDebugEnabled()) {
                this.log.debug("REST processor started.");
            }
        }
    }

    @Override
    public void onKernalStop(boolean cancel) {
        if (this.isRestEnabled()) {
            this.busyLock.writeLock();
            boolean interrupted = Thread.interrupted();
            while (this.workersCnt.sum() != 0L) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                }
            }
            U.interrupt(this.sesTimeoutCheckerThread);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            for (GridRestProtocol proto : this.protos) {
                proto.stop();
            }
            this.startLatch.countDown();
            if (this.log.isDebugEnabled()) {
                this.log.debug("REST processor stopped.");
            }
        }
    }

    private void interceptRequest(GridRestRequest req) {
        GridRestTaskRequest req0;
        List<Object> oldParams;
        ConnectorMessageInterceptor interceptor = this.config().getMessageInterceptor();
        if (interceptor == null) {
            return;
        }
        if (req instanceof GridRestCacheRequest) {
            GridRestCacheRequest req02 = (GridRestCacheRequest)req;
            req02.key(interceptor.onReceive(req02.key()));
            req02.value(interceptor.onReceive(req02.value()));
            req02.value2(interceptor.onReceive(req02.value2()));
            Map<Object, Object> oldVals = req02.values();
            if (oldVals != null) {
                HashMap<Object, Object> newVals = U.newHashMap(oldVals.size());
                for (Map.Entry<Object, Object> e : oldVals.entrySet()) {
                    newVals.put(interceptor.onReceive(e.getKey()), interceptor.onReceive(e.getValue()));
                }
                req02.values(U.sealMap(newVals));
            }
        } else if (req instanceof GridRestTaskRequest && (oldParams = (req0 = (GridRestTaskRequest)req).params()) != null) {
            ArrayList<Object> newParams = new ArrayList<Object>(oldParams.size());
            for (Object o : oldParams) {
                newParams.add(interceptor.onReceive(o));
            }
            req0.params(U.sealList(newParams));
        }
    }

    private void interceptResponse(GridRestResponse res, GridRestRequest req) {
        ConnectorMessageInterceptor interceptor = this.config().getMessageInterceptor();
        if (interceptor != null && res.getResponse() != null) {
            switch (req.command()) {
                case CACHE_CONTAINS_KEYS: 
                case CACHE_CONTAINS_KEY: 
                case CACHE_GET: 
                case CACHE_GET_ALL: 
                case CACHE_PUT: 
                case CACHE_ADD: 
                case CACHE_PUT_ALL: 
                case CACHE_REMOVE: 
                case CACHE_REMOVE_ALL: 
                case CACHE_CLEAR: 
                case CACHE_REPLACE: 
                case ATOMIC_INCREMENT: 
                case ATOMIC_DECREMENT: 
                case CACHE_CAS: 
                case CACHE_APPEND: 
                case CACHE_PREPEND: {
                    res.setResponse(GridRestProcessor.interceptSendObject(res.getResponse(), interceptor));
                    break;
                }
                case EXE: {
                    if (!(res.getResponse() instanceof GridClientTaskResultBean)) break;
                    GridClientTaskResultBean taskRes = (GridClientTaskResultBean)res.getResponse();
                    taskRes.setResult(interceptor.onSend(taskRes.getResult()));
                    break;
                }
            }
        }
    }

    private static Object interceptSendObject(Object obj, ConnectorMessageInterceptor interceptor) {
        if (obj instanceof Map) {
            Map original = (Map)obj;
            HashMap<Object, Object> m = new HashMap<Object, Object>();
            for (Map.Entry e : original.entrySet()) {
                m.put(interceptor.onSend(e.getKey()), interceptor.onSend(e.getValue()));
            }
            return m;
        }
        if (obj instanceof Collection) {
            Collection original = (Collection)obj;
            ArrayList<Object> c = new ArrayList<Object>(original.size());
            for (Object e : original) {
                c.add(interceptor.onSend(e));
            }
            return c;
        }
        return interceptor.onSend(obj);
    }

    private SecurityCredentials credentials(GridRestRequest req) {
        Object creds = req.credentials();
        if (creds instanceof SecurityCredentials) {
            return (SecurityCredentials)creds;
        }
        if (creds instanceof String) {
            String credStr = (String)creds;
            int idx = credStr.indexOf(58);
            return idx >= 0 && idx < credStr.length() ? new SecurityCredentials(credStr.substring(0, idx), credStr.substring(idx + 1)) : new SecurityCredentials(credStr, null);
        }
        SecurityCredentials cred = new SecurityCredentials();
        cred.setUserObject(creds);
        return cred;
    }

    private SecurityContext authenticate(GridRestRequest req, Session ses) throws IgniteCheckedException {
        assert (req.clientId() != null);
        AuthenticationContext authCtx = new AuthenticationContext();
        authCtx.subjectType(SecuritySubjectType.REMOTE_CLIENT);
        authCtx.subjectId(req.clientId());
        authCtx.nodeAttributes(Collections.emptyMap());
        authCtx.address(req.address());
        SecurityCredentials creds = this.credentials(req);
        if (creds.getLogin() == null) {
            SecurityCredentials sesCreds = ses.creds;
            if (sesCreds != null) {
                creds = ses.creds;
            }
        } else {
            ses.creds = creds;
        }
        authCtx.credentials(creds);
        SecurityContext subjCtx = this.ctx.security().authenticate(authCtx);
        ses.lastInvalidateTime.set(U.currentTimeMillis());
        if (subjCtx == null) {
            if (req.credentials() == null) {
                throw new IgniteCheckedException("Failed to authenticate remote client (secure session SPI not set?): " + req);
            }
            throw new IgniteCheckedException("Failed to authenticate remote client (invalid credentials?): " + req);
        }
        return subjCtx;
    }

    private void authorize(GridRestRequest req, SecurityContext sCtx) throws SecurityException {
        SecurityPermission perm = null;
        String name = null;
        switch (req.command()) {
            case CACHE_CONTAINS_KEYS: 
            case CACHE_CONTAINS_KEY: 
            case CACHE_GET: 
            case CACHE_GET_ALL: {
                perm = SecurityPermission.CACHE_READ;
                name = ((GridRestCacheRequest)req).cacheName();
                break;
            }
            case EXECUTE_SQL_QUERY: 
            case EXECUTE_SQL_FIELDS_QUERY: 
            case EXECUTE_SCAN_QUERY: 
            case CLOSE_SQL_QUERY: 
            case FETCH_SQL_QUERY: {
                perm = SecurityPermission.CACHE_READ;
                name = ((RestQueryRequest)req).cacheName();
                break;
            }
            case CACHE_PUT: 
            case CACHE_ADD: 
            case CACHE_PUT_ALL: 
            case CACHE_REPLACE: 
            case CACHE_CAS: 
            case CACHE_APPEND: 
            case CACHE_PREPEND: 
            case CACHE_GET_AND_PUT: 
            case CACHE_GET_AND_REPLACE: 
            case CACHE_GET_AND_PUT_IF_ABSENT: 
            case CACHE_PUT_IF_ABSENT: 
            case CACHE_REPLACE_VALUE: {
                perm = SecurityPermission.CACHE_PUT;
                name = ((GridRestCacheRequest)req).cacheName();
                break;
            }
            case CACHE_REMOVE: 
            case CACHE_REMOVE_ALL: 
            case CACHE_CLEAR: 
            case CACHE_GET_AND_REMOVE: 
            case CACHE_REMOVE_VALUE: {
                perm = SecurityPermission.CACHE_REMOVE;
                name = ((GridRestCacheRequest)req).cacheName();
                break;
            }
            case EXE: 
            case RESULT: {
                perm = SecurityPermission.TASK_EXECUTE;
                GridRestTaskRequest taskReq = (GridRestTaskRequest)req;
                name = taskReq.taskName();
                if (!VisorGatewayTask.class.getName().equals(name)) break;
                name = (String)taskReq.params().get(1);
                break;
            }
            case GET_OR_CREATE_CACHE: 
            case DESTROY_CACHE: {
                perm = SecurityPermission.ADMIN_CACHE;
                name = ((GridRestCacheRequest)req).cacheName();
                break;
            }
            case CLUSTER_ACTIVE: 
            case CLUSTER_INACTIVE: 
            case CLUSTER_ACTIVATE: 
            case CLUSTER_DEACTIVATE: 
            case BASELINE_SET: 
            case BASELINE_ADD: 
            case BASELINE_REMOVE: {
                perm = SecurityPermission.ADMIN_OPS;
                break;
            }
            case ATOMIC_INCREMENT: 
            case ATOMIC_DECREMENT: 
            case CACHE_METRICS: 
            case CACHE_SIZE: 
            case CACHE_METADATA: 
            case TOPOLOGY: 
            case NODE: 
            case VERSION: 
            case NOOP: 
            case QUIT: 
            case NAME: 
            case LOG: 
            case CLUSTER_CURRENT_STATE: 
            case BASELINE_CURRENT_STATE: 
            case AUTHENTICATE: 
            case ADD_USER: 
            case REMOVE_USER: 
            case UPDATE_USER: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected command: " + (Object)((Object)req.command())));
            }
        }
        if (perm != null) {
            this.ctx.security().authorize(name, perm, sCtx);
        }
    }

    private boolean isRestEnabled() {
        return !this.ctx.config().isDaemon() && this.ctx.config().getConnectorConfiguration() != null;
    }

    private void addHandler(GridRestCommandHandler hnd) {
        assert (!this.handlers.containsValue(hnd));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Added REST command handler: " + hnd);
        }
        for (GridRestCommand cmd : hnd.supportedCommands()) {
            assert (!this.handlers.containsKey((Object)cmd)) : cmd;
            this.handlers.put(cmd, hnd);
        }
    }

    private void startTcpProtocol() throws IgniteCheckedException {
        this.startProtocol(new GridTcpRestProtocol(this.ctx));
    }

    private void startHttpProtocol() throws IgniteCheckedException {
        try {
            Class<?> cls = Class.forName(HTTP_PROTO_CLS);
            Constructor<?> ctor = cls.getConstructor(GridKernalContext.class);
            GridRestProtocol proto = (GridRestProtocol)ctor.newInstance(this.ctx);
            this.startProtocol(proto);
        }
        catch (ClassNotFoundException ignored) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to initialize HTTP REST protocol (consider adding ignite-rest-http module to classpath).");
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IgniteCheckedException("Failed to initialize HTTP REST protocol.", e);
        }
    }

    private ConnectorConfiguration config() {
        return this.ctx.config().getConnectorConfiguration();
    }

    private void startProtocol(GridRestProtocol proto) throws IgniteCheckedException {
        assert (proto != null);
        assert (!this.protos.contains(proto));
        this.protos.add(proto);
        proto.start(this.protoHnd);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Added REST protocol: " + proto);
        }
    }

    @Override
    public void printMemoryStats() {
        X.println(">>>", new Object[0]);
        X.println(">>> REST processor memory stats [igniteInstanceName=" + this.ctx.igniteInstanceName() + ']', new Object[0]);
        X.println(">>>   protosSize: " + this.protos.size(), new Object[0]);
        X.println(">>>   handlersSize: " + this.handlers.size(), new Object[0]);
    }

    private static class Session {
        private static final Long TIMEDOUT_FLAG = 0L;
        private final UUID clientId;
        private final UUID sesId;
        private final AtomicLong lastTouchTime = new AtomicLong(U.currentTimeMillis());
        private final AtomicLong lastInvalidateTime = new AtomicLong(U.currentTimeMillis());
        private volatile SecurityContext secCtx;
        private volatile AuthorizationContext authCtx;
        private volatile SecurityCredentials creds;

        private Session(UUID clientId, UUID sesId) {
            this.clientId = clientId;
            this.sesId = sesId;
        }

        static Session random() {
            return new Session(UUID.randomUUID(), UUID.randomUUID());
        }

        static Session fromClientId(UUID clientId) {
            return new Session(clientId, UUID.randomUUID());
        }

        static Session fromSessionToken(UUID sesTokId) {
            return new Session(UUID.randomUUID(), sesTokId);
        }

        boolean isTimedOut(long sesTimeout) {
            long time0 = this.lastTouchTime.get();
            if (time0 == TIMEDOUT_FLAG) {
                return true;
            }
            return U.currentTimeMillis() - time0 > sesTimeout && this.lastTouchTime.compareAndSet(time0, TIMEDOUT_FLAG);
        }

        boolean isTokenExpired(long sesTokTtl) {
            return U.currentTimeMillis() - this.lastInvalidateTime.get() > sesTokTtl;
        }

        boolean touch() {
            long time0;
            boolean success;
            do {
                if ((time0 = this.lastTouchTime.get()) != TIMEDOUT_FLAG) continue;
                return false;
            } while (!(success = this.lastTouchTime.compareAndSet(time0, U.currentTimeMillis())));
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Session)) {
                return false;
            }
            Session ses = (Session)o;
            if (this.clientId != null ? !this.clientId.equals(ses.clientId) : ses.clientId != null) {
                return false;
            }
            return !(this.sesId != null ? !this.sesId.equals(ses.sesId) : ses.sesId != null);
        }

        public int hashCode() {
            int res = this.clientId != null ? this.clientId.hashCode() : 0;
            res = 31 * res + (this.sesId != null ? this.sesId.hashCode() : 0);
            return res;
        }

        public String toString() {
            return S.toString(Session.class, this);
        }
    }
}

