/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.GridAffinityProcessor;
import org.apache.ignite.internal.processors.odbc.ClientConnectableNodePartitions;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheNodePartitionsResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheRequest;

public class ClientCacheNodePartitionsRequest
extends ClientCacheRequest {
    public ClientCacheNodePartitionsRequest(BinaryRawReader reader) {
        super(reader);
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        IgniteCache cache = this.cache(ctx);
        GridDiscoveryManager discovery = ctx.kernalContext().discovery();
        List<ClusterNode> nodes = discovery.discoCache().cacheNodes(cache.getName());
        GridAffinityProcessor.CacheAffinityProxy aff = ctx.kernalContext().affinity().affinityProxy(cache.getName());
        ArrayList<ClientConnectableNodePartitions> res = new ArrayList<ClientConnectableNodePartitions>();
        for (ClusterNode node : nodes) {
            Integer port = (Integer)node.attribute("clientListenerPort");
            if (port == null) continue;
            Collection<String> addrs = node.addresses();
            int[] parts = aff.primaryPartitions(node);
            res.add(new ClientConnectableNodePartitions(port, addrs, parts));
        }
        return new ClientCacheNodePartitionsResponse(this.requestId(), res);
    }
}

