/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequest;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.plugin.security.SecurityException;

public class ClientRequestHandler
implements ClientListenerRequestHandler {
    private final ClientConnectionContext ctx;
    private final AuthorizationContext authCtx;

    ClientRequestHandler(ClientConnectionContext ctx, AuthorizationContext authCtx) {
        assert (ctx != null);
        this.ctx = ctx;
        this.authCtx = authCtx;
    }

    @Override
    public ClientListenerResponse handle(ClientListenerRequest req) {
        try {
            return ((ClientRequest)req).process(this.ctx);
        }
        catch (SecurityException ex) {
            throw new IgniteClientException(1012, "Client is not authorized to perform this operation", ex);
        }
    }

    @Override
    public ClientListenerResponse handleException(Exception e, ClientListenerRequest req) {
        assert (req != null);
        assert (e != null);
        int status = e instanceof IgniteClientException ? ((IgniteClientException)e).statusCode() : 1;
        return new ClientResponse(req.requestId(), status, e.getMessage());
    }

    @Override
    public void writeHandshake(BinaryWriterExImpl writer) {
        writer.writeBoolean(true);
    }
}

