/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerAbstractConnectionContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerMessageParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.platform.client.ClientMessageParser;
import org.apache.ignite.internal.processors.platform.client.ClientRequestHandler;
import org.apache.ignite.internal.processors.platform.client.ClientResourceRegistry;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;

public class ClientConnectionContext
extends ClientListenerAbstractConnectionContext {
    public static final ClientListenerProtocolVersion VER_1_0_0 = ClientListenerProtocolVersion.create(1, 0, 0);
    public static final ClientListenerProtocolVersion VER_1_1_0 = ClientListenerProtocolVersion.create(1, 1, 0);
    public static final ClientListenerProtocolVersion VER_1_2_0;
    public static final ClientListenerProtocolVersion CURRENT_VER;
    private static final Collection<ClientListenerProtocolVersion> SUPPORTED_VERS;
    private ClientMessageParser parser;
    private ClientRequestHandler handler;
    private final ClientResourceRegistry resReg = new ClientResourceRegistry();
    private final int maxCursors;
    private final AtomicLong curCnt = new AtomicLong();

    public ClientConnectionContext(GridKernalContext ctx, long connId, int maxCursors) {
        super(ctx, connId);
        this.maxCursors = maxCursors;
    }

    public ClientResourceRegistry resources() {
        return this.resReg;
    }

    @Override
    public boolean isVersionSupported(ClientListenerProtocolVersion ver) {
        return SUPPORTED_VERS.contains(ver);
    }

    @Override
    public ClientListenerProtocolVersion currentVersion() {
        return CURRENT_VER;
    }

    @Override
    public void initializeFromHandshake(ClientListenerProtocolVersion ver, BinaryReaderExImpl reader) throws IgniteCheckedException {
        String user = null;
        String pwd = null;
        if (ver.compareTo(VER_1_1_0) >= 0) {
            boolean hasMore;
            try {
                hasMore = reader.available() > 0;
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Handshake error: " + e.getMessage(), e);
            }
            if (hasMore) {
                user = reader.readString();
                pwd = reader.readString();
            }
        }
        AuthorizationContext authCtx = this.authenticate(user, pwd);
        this.handler = new ClientRequestHandler(this, authCtx);
        this.parser = new ClientMessageParser(this.kernalContext(), ver);
    }

    @Override
    public ClientListenerRequestHandler handler() {
        return this.handler;
    }

    @Override
    public ClientListenerMessageParser parser() {
        return this.parser;
    }

    @Override
    public void onDisconnected() {
        this.resReg.clean();
        super.onDisconnected();
    }

    public void incrementCursors() {
        long curCnt0 = this.curCnt.get();
        if (curCnt0 >= (long)this.maxCursors) {
            throw new IgniteClientException(1010, "Too many open cursors (either close other open cursors or increase the limit through ClientConnectorConfiguration.maxOpenCursorsPerConnection) [maximum=" + this.maxCursors + ", current=" + curCnt0 + ']');
        }
        this.curCnt.incrementAndGet();
    }

    public void decrementCursors() {
        this.curCnt.decrementAndGet();
    }

    static {
        CURRENT_VER = VER_1_2_0 = ClientListenerProtocolVersion.create(1, 2, 0);
        SUPPORTED_VERS = Arrays.asList(VER_1_2_0, VER_1_1_0, VER_1_0_0);
    }
}

