/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ParameterMetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.configuration.Factory;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.BulkLoadContextCursor;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.bulkload.BulkLoadAckClientParameters;
import org.apache.ignite.internal.processors.bulkload.BulkLoadProcessor;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequest;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponseSender;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBatchExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadAckResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadBatchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadProcessor;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcColumnMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcColumnMetaV2;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcColumnMetaV3;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcColumnMetaV4;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcIndexMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsResultV2;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsResultV3;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsResultV4;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaIndexesRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaIndexesResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaParamsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaParamsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaPrimaryKeysRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaPrimaryKeysResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaSchemasRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaSchemasResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaTablesRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaTablesResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcOrderedBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcOrderedBatchExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcParameterMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcPrimaryKeyMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQuery;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCloseRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCursor;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteMultipleStatementsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryFetchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryFetchResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryMetadataRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryMetadataResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequestHandlerWorker;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResponse;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResultInfo;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcStatementType;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcTableMeta;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.NestedTxMode;
import org.apache.ignite.internal.processors.query.SqlClientContext;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.transactions.TransactionAlreadyCompletedException;
import org.apache.ignite.transactions.TransactionDuplicateKeyException;
import org.apache.ignite.transactions.TransactionMixedModeException;
import org.apache.ignite.transactions.TransactionSerializationException;
import org.apache.ignite.transactions.TransactionUnsupportedConcurrencyException;

public class JdbcRequestHandler
implements ClientListenerRequestHandler {
    private static final AtomicLong QRY_ID_GEN = new AtomicLong();
    private final GridKernalContext ctx;
    private final SqlClientContext cliCtx;
    private final IgniteLogger log;
    private final GridSpinBusyLock busyLock;
    private final JdbcRequestHandlerWorker worker;
    private final int maxCursors;
    private final ConcurrentHashMap<Long, JdbcQueryCursor> qryCursors = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, JdbcBulkLoadProcessor> bulkLoadRequests = new ConcurrentHashMap();
    private final PriorityQueue<JdbcOrderedBatchExecuteRequest> orderedBatchesQueue = new PriorityQueue();
    private final Object orderedBatchesMux = new Object();
    private final ClientListenerResponseSender sender;
    private final boolean autoCloseCursors;
    private final NestedTxMode nestedTxMode;
    private ClientListenerProtocolVersion protocolVer;
    private AuthorizationContext actx;

    public JdbcRequestHandler(GridKernalContext ctx, GridSpinBusyLock busyLock, ClientListenerResponseSender sender, int maxCursors, boolean distributedJoins, boolean enforceJoinOrder, boolean collocated, boolean replicatedOnly, boolean autoCloseCursors, boolean lazy, boolean skipReducerOnUpdate, NestedTxMode nestedTxMode, AuthorizationContext actx, ClientListenerProtocolVersion protocolVer) {
        this.ctx = ctx;
        this.sender = sender;
        Factory<GridWorker> orderedFactory = new Factory<GridWorker>(){

            public GridWorker create() {
                return new OrderedBatchWorker();
            }
        };
        this.cliCtx = new SqlClientContext(ctx, orderedFactory, distributedJoins, enforceJoinOrder, collocated, replicatedOnly, lazy, skipReducerOnUpdate);
        this.busyLock = busyLock;
        this.maxCursors = maxCursors;
        this.autoCloseCursors = autoCloseCursors;
        this.nestedTxMode = nestedTxMode;
        this.protocolVer = protocolVer;
        this.actx = actx;
        this.log = ctx.log(this.getClass());
        this.worker = new JdbcRequestHandlerWorker(ctx.igniteInstanceName(), this.log, this, ctx);
    }

    @Override
    public ClientListenerResponse handle(ClientListenerRequest req0) {
        assert (req0 != null);
        assert (req0 instanceof JdbcRequest);
        JdbcRequest req = (JdbcRequest)req0;
        if (!MvccUtils.mvccEnabled(this.ctx)) {
            return this.doHandle(req);
        }
        GridFutureAdapter<ClientListenerResponse> fut = this.worker.process(req);
        try {
            return fut.get();
        }
        catch (IgniteCheckedException e) {
            return this.exceptionToResult(e);
        }
    }

    void start() {
        if (this.worker != null) {
            this.worker.start();
        }
    }

    ClientListenerResponse doHandle(JdbcRequest req) {
        if (!this.busyLock.enterBusy()) {
            return new JdbcResponse(1, "Failed to handle JDBC request because node is stopping.");
        }
        if (this.actx != null) {
            AuthorizationContext.context(this.actx);
        }
        try {
            switch (req.type()) {
                case 2: {
                    JdbcResponse jdbcResponse = this.executeQuery((JdbcQueryExecuteRequest)req);
                    return jdbcResponse;
                }
                case 3: {
                    JdbcResponse jdbcResponse = this.fetchQuery((JdbcQueryFetchRequest)req);
                    return jdbcResponse;
                }
                case 4: {
                    JdbcResponse jdbcResponse = this.closeQuery((JdbcQueryCloseRequest)req);
                    return jdbcResponse;
                }
                case 5: {
                    JdbcResponse jdbcResponse = this.getQueryMeta((JdbcQueryMetadataRequest)req);
                    return jdbcResponse;
                }
                case 6: {
                    ClientListenerResponse clientListenerResponse = this.executeBatch((JdbcBatchExecuteRequest)req);
                    return clientListenerResponse;
                }
                case 14: {
                    ClientListenerResponse clientListenerResponse = this.dispatchBatchOrdered((JdbcOrderedBatchExecuteRequest)req);
                    return clientListenerResponse;
                }
                case 7: {
                    JdbcResponse jdbcResponse = this.getTablesMeta((JdbcMetaTablesRequest)req);
                    return jdbcResponse;
                }
                case 8: {
                    JdbcResponse jdbcResponse = this.getColumnsMeta((JdbcMetaColumnsRequest)req);
                    return jdbcResponse;
                }
                case 9: {
                    ClientListenerResponse clientListenerResponse = this.getIndexesMeta((JdbcMetaIndexesRequest)req);
                    return clientListenerResponse;
                }
                case 10: {
                    ClientListenerResponse clientListenerResponse = this.getParametersMeta((JdbcMetaParamsRequest)req);
                    return clientListenerResponse;
                }
                case 11: {
                    ClientListenerResponse clientListenerResponse = this.getPrimaryKeys((JdbcMetaPrimaryKeysRequest)req);
                    return clientListenerResponse;
                }
                case 12: {
                    ClientListenerResponse clientListenerResponse = this.getSchemas((JdbcMetaSchemasRequest)req);
                    return clientListenerResponse;
                }
                case 13: {
                    ClientListenerResponse clientListenerResponse = this.processBulkLoadFileBatch((JdbcBulkLoadBatchRequest)req);
                    return clientListenerResponse;
                }
            }
            JdbcResponse jdbcResponse = new JdbcResponse(1002, "Unsupported JDBC request [req=" + req + ']');
            return jdbcResponse;
        }
        finally {
            AuthorizationContext.clear();
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientListenerResponse dispatchBatchOrdered(JdbcOrderedBatchExecuteRequest req) {
        Object object = this.orderedBatchesMux;
        synchronized (object) {
            this.orderedBatchesQueue.add(req);
            this.orderedBatchesMux.notify();
        }
        if (!this.cliCtx.isStreamOrdered()) {
            this.executeBatchOrdered(req);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientListenerResponse executeBatchOrdered(JdbcOrderedBatchExecuteRequest req) {
        try {
            JdbcResponse resp;
            if (req.isLastStreamBatch()) {
                this.cliCtx.waitTotalProcessedOrderedRequests(req.order());
            }
            if ((resp = (JdbcResponse)this.executeBatch(req)).response() instanceof JdbcBatchExecuteResult) {
                resp = new JdbcResponse(new JdbcOrderedBatchExecuteResult((JdbcBatchExecuteResult)resp.response(), req.order()));
            }
            this.sender.send(resp);
        }
        catch (Exception e) {
            U.error(null, "Error processing file batch", e);
            this.sender.send(new JdbcResponse(1, "Server error: " + e));
        }
        Object object = this.orderedBatchesMux;
        synchronized (object) {
            this.orderedBatchesQueue.poll();
        }
        this.cliCtx.orderedRequestProcessed();
        return null;
    }

    private ClientListenerResponse processBulkLoadFileBatch(JdbcBulkLoadBatchRequest req) {
        JdbcBulkLoadProcessor processor = this.bulkLoadRequests.get(req.queryId());
        if (this.ctx == null) {
            return new JdbcResponse(2001, "Unknown query ID: " + req.queryId() + ". Bulk load session may have been reclaimed due to timeout.");
        }
        try {
            processor.processBatch(req);
            switch (req.cmd()) {
                case 1: 
                case 2: {
                    this.bulkLoadRequests.remove(req.queryId());
                    processor.close();
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return new JdbcResponse(new JdbcQueryExecuteResult(req.queryId(), processor.updateCnt()));
        }
        catch (Exception e) {
            U.error(null, "Error processing file batch", e);
            return new JdbcResponse(1, "Server error: " + e);
        }
    }

    @Override
    public ClientListenerResponse handleException(Exception e, ClientListenerRequest req) {
        return this.exceptionToResult(e);
    }

    @Override
    public void writeHandshake(BinaryWriterExImpl writer) {
        writer.writeBoolean(true);
        writer.writeByte(IgniteVersionUtils.VER.major());
        writer.writeByte(IgniteVersionUtils.VER.minor());
        writer.writeByte(IgniteVersionUtils.VER.maintenance());
        writer.writeString(IgniteVersionUtils.VER.stage());
        writer.writeLong(IgniteVersionUtils.VER.revisionTimestamp());
        writer.writeByteArray(IgniteVersionUtils.VER.revisionHash());
    }

    public void onDisconnect() {
        if (this.worker != null) {
            this.worker.cancel();
            try {
                this.worker.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (JdbcQueryCursor cursor : this.qryCursors.values()) {
            cursor.close();
        }
        for (JdbcBulkLoadProcessor processor : this.bulkLoadRequests.values()) {
            try {
                processor.close();
            }
            catch (Exception e) {
                U.error(null, "Error closing JDBC bulk load processor.", e);
            }
        }
        this.bulkLoadRequests.clear();
        U.close(this.cliCtx, this.log);
    }

    private JdbcResponse executeQuery(JdbcQueryExecuteRequest req) {
        int cursorCnt = this.qryCursors.size();
        if (this.maxCursors > 0 && cursorCnt >= this.maxCursors) {
            return new JdbcResponse(1, "Too many open cursors (either close other open cursors or increase the limit through ClientConnectorConfiguration.maxOpenCursorsPerConnection) [maximum=" + this.maxCursors + ", current=" + cursorCnt + ']');
        }
        long qryId = QRY_ID_GEN.getAndIncrement();
        assert (!this.cliCtx.isStream());
        try {
            SqlFieldsQueryEx qry;
            String sql = req.sqlQuery();
            switch (req.expectedStatementType()) {
                case ANY_STATEMENT_TYPE: {
                    qry = new SqlFieldsQueryEx(sql, null);
                    break;
                }
                case SELECT_STATEMENT_TYPE: {
                    qry = new SqlFieldsQueryEx(sql, (Boolean)true);
                    break;
                }
                default: {
                    assert (req.expectedStatementType() == JdbcStatementType.UPDATE_STMT_TYPE);
                    qry = new SqlFieldsQueryEx(sql, (Boolean)false);
                    if (!this.cliCtx.isSkipReducerOnUpdate()) break;
                    qry.setSkipReducerOnUpdate(true);
                }
            }
            qry.setArgs(req.arguments());
            qry.setDistributedJoins(this.cliCtx.isDistributedJoins());
            qry.setEnforceJoinOrder(this.cliCtx.isEnforceJoinOrder());
            qry.setCollocated(this.cliCtx.isCollocated());
            qry.setReplicatedOnly(this.cliCtx.isReplicatedOnly());
            qry.setLazy(this.cliCtx.isLazy());
            qry.setNestedTxMode(this.nestedTxMode);
            qry.setAutoCommit(req.autoCommit());
            if (req.pageSize() <= 0) {
                return new JdbcResponse(1, "Invalid fetch size: " + req.pageSize());
            }
            qry.setPageSize(req.pageSize());
            String schemaName = req.schemaName();
            if (F.isEmpty(schemaName)) {
                schemaName = "PUBLIC";
            }
            qry.setSchema(schemaName);
            List<FieldsQueryCursor<List<?>>> results = this.ctx.query().querySqlFields(null, qry, this.cliCtx, true, this.protocolVer.compareTo(JdbcConnectionContext.VER_2_3_0) < 0);
            FieldsQueryCursor<List<?>> fieldsCur = results.get(0);
            if (fieldsCur instanceof BulkLoadContextCursor) {
                BulkLoadContextCursor blCur = (BulkLoadContextCursor)fieldsCur;
                BulkLoadProcessor blProcessor = blCur.bulkLoadProcessor();
                BulkLoadAckClientParameters clientParams = blCur.clientParams();
                this.bulkLoadRequests.put(qryId, new JdbcBulkLoadProcessor(blProcessor));
                return new JdbcResponse(new JdbcBulkLoadAckResult(qryId, clientParams));
            }
            if (results.size() == 1) {
                JdbcQueryExecuteResult res;
                JdbcQueryCursor cur = new JdbcQueryCursor(qryId, req.pageSize(), req.maxRows(), (QueryCursorImpl)fieldsCur);
                if (cur.isQuery()) {
                    res = new JdbcQueryExecuteResult(qryId, cur.fetchRows(), !cur.hasNext());
                } else {
                    List<List<Object>> items = cur.fetchRows();
                    assert (items != null && items.size() == 1 && items.get(0).size() == 1 && items.get(0).get(0) instanceof Long) : "Invalid result set for not-SELECT query. [qry=" + sql + ", res=" + S.toString(List.class, items) + ']';
                    res = new JdbcQueryExecuteResult(qryId, (Long)items.get(0).get(0));
                }
                if (res.last() && (!res.isQuery() || this.autoCloseCursors)) {
                    cur.close();
                } else {
                    this.qryCursors.put(qryId, cur);
                }
                return new JdbcResponse(res);
            }
            ArrayList<JdbcResultInfo> jdbcResults = new ArrayList<JdbcResultInfo>(results.size());
            List<List<Object>> items = null;
            boolean last = true;
            for (FieldsQueryCursor<List<?>> c : results) {
                JdbcResultInfo jdbcRes;
                QueryCursorImpl qryCur = (QueryCursorImpl)c;
                if (qryCur.isQuery()) {
                    jdbcRes = new JdbcResultInfo(true, -1L, qryId);
                    JdbcQueryCursor cur = new JdbcQueryCursor(qryId, req.pageSize(), req.maxRows(), qryCur);
                    this.qryCursors.put(qryId, cur);
                    qryId = QRY_ID_GEN.getAndIncrement();
                    if (items == null) {
                        items = cur.fetchRows();
                        last = cur.hasNext();
                    }
                } else {
                    jdbcRes = new JdbcResultInfo(false, (Long)((List)qryCur.getAll().get(0)).get(0), -1L);
                }
                jdbcResults.add(jdbcRes);
            }
            return new JdbcResponse(new JdbcQueryExecuteMultipleStatementsResult(jdbcResults, items, last));
        }
        catch (Exception e) {
            this.qryCursors.remove(qryId);
            U.error(this.log, "Failed to execute SQL query [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private JdbcResponse closeQuery(JdbcQueryCloseRequest req) {
        try {
            JdbcQueryCursor cur = this.qryCursors.remove(req.queryId());
            if (cur == null) {
                return new JdbcResponse(1, "Failed to find query cursor with ID: " + req.queryId());
            }
            cur.close();
            return new JdbcResponse(null);
        }
        catch (Exception e) {
            this.qryCursors.remove(req.queryId());
            U.error(this.log, "Failed to close SQL query [reqId=" + req.requestId() + ", req=" + req.queryId() + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private JdbcResponse fetchQuery(JdbcQueryFetchRequest req) {
        try {
            JdbcQueryCursor cur = this.qryCursors.get(req.queryId());
            if (cur == null) {
                return new JdbcResponse(1, "Failed to find query cursor with ID: " + req.queryId());
            }
            if (req.pageSize() <= 0) {
                return new JdbcResponse(1, "Invalid fetch size : [fetchSize=" + req.pageSize() + ']');
            }
            cur.pageSize(req.pageSize());
            JdbcQueryFetchResult res = new JdbcQueryFetchResult(cur.fetchRows(), !cur.hasNext());
            if (res.last() && (!cur.isQuery() || this.autoCloseCursors)) {
                this.qryCursors.remove(req.queryId());
                cur.close();
            }
            return new JdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to fetch SQL query result [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private JdbcResponse getQueryMeta(JdbcQueryMetadataRequest req) {
        try {
            JdbcQueryCursor cur = this.qryCursors.get(req.queryId());
            if (cur == null) {
                return new JdbcResponse(1, "Failed to find query with ID: " + req.queryId());
            }
            JdbcQueryMetadataResult res = new JdbcQueryMetadataResult(req.queryId(), cur.meta());
            return new JdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to fetch SQL query result [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private ClientListenerResponse executeBatch(JdbcBatchExecuteRequest req) {
        String schemaName = req.schemaName();
        if (F.isEmpty(schemaName)) {
            schemaName = "PUBLIC";
        }
        int qryCnt = req.queries().size();
        ArrayList<Integer> updCntsAcc = new ArrayList<Integer>(qryCnt);
        IgniteBiTuple<Integer, String> firstErr = new IgniteBiTuple<Integer, String>();
        SqlFieldsQueryEx qry = null;
        for (JdbcQuery q : req.queries()) {
            if (q.sql() != null) {
                if (qry != null) {
                    this.executeBatchedQuery(qry, updCntsAcc, firstErr);
                }
                qry = new SqlFieldsQueryEx(q.sql(), (Boolean)false);
                qry.setDistributedJoins(this.cliCtx.isDistributedJoins());
                qry.setEnforceJoinOrder(this.cliCtx.isEnforceJoinOrder());
                qry.setCollocated(this.cliCtx.isCollocated());
                qry.setReplicatedOnly(this.cliCtx.isReplicatedOnly());
                qry.setLazy(this.cliCtx.isLazy());
                qry.setNestedTxMode(this.nestedTxMode);
                qry.setAutoCommit(req.autoCommit());
                qry.setSchema(schemaName);
            }
            assert (qry != null);
            qry.addBatchedArgs(q.args());
        }
        if (qry != null) {
            this.executeBatchedQuery(qry, updCntsAcc, firstErr);
        }
        if (req.isLastStreamBatch()) {
            this.cliCtx.disableStreaming();
        }
        int[] updCnts = U.toIntArray(updCntsAcc);
        if (firstErr.isEmpty()) {
            return new JdbcResponse(new JdbcBatchExecuteResult(updCnts, 0, null));
        }
        return new JdbcResponse(new JdbcBatchExecuteResult(updCnts, firstErr.getKey(), firstErr.getValue()));
    }

    private void executeBatchedQuery(SqlFieldsQueryEx qry, List<Integer> updCntsAcc, IgniteBiTuple<Integer, String> firstErr) {
        try {
            if (this.cliCtx.isStream()) {
                List<Long> cnt = this.ctx.query().streamBatchedUpdateQuery(qry.getSchema(), this.cliCtx, qry.getSql(), qry.batchedArguments());
                for (int i = 0; i < cnt.size(); ++i) {
                    updCntsAcc.add(cnt.get(i).intValue());
                }
                return;
            }
            List<FieldsQueryCursor<List<?>>> qryRes = this.ctx.query().querySqlFields(null, qry, this.cliCtx, true, true);
            for (FieldsQueryCursor<List<?>> cur : qryRes) {
                if (cur instanceof BulkLoadContextCursor) {
                    throw new IgniteSQLException("COPY command cannot be executed in batch mode.");
                }
                assert (!((QueryCursorImpl)cur).isQuery());
                Iterator it = cur.iterator();
                if (!it.hasNext()) continue;
                int val = ((Long)((List)it.next()).get(0)).intValue();
                updCntsAcc.add(val);
            }
        }
        catch (Exception e) {
            int code;
            String msg;
            if (e instanceof IgniteSQLException) {
                BatchUpdateException batchCause = X.cause(e, BatchUpdateException.class);
                if (batchCause != null) {
                    int[] updCntsOnErr = batchCause.getUpdateCounts();
                    for (int i = 0; i < updCntsOnErr.length; ++i) {
                        updCntsAcc.add(updCntsOnErr[i]);
                    }
                    msg = batchCause.getMessage();
                    code = batchCause.getErrorCode();
                } else {
                    for (int i = 0; i < qry.batchedArguments().size(); ++i) {
                        updCntsAcc.add(-3);
                    }
                    msg = e.getMessage();
                    code = ((IgniteSQLException)e).statusCode();
                }
            } else {
                for (int i = 0; i < qry.batchedArguments().size(); ++i) {
                    updCntsAcc.add(-3);
                }
                msg = e.getMessage();
                code = 1;
            }
            if (firstErr.isEmpty()) {
                firstErr.set(code, msg);
            }
            U.error(this.log, "Failed to execute batch query [qry=" + qry + ']', e);
        }
    }

    private JdbcResponse getTablesMeta(JdbcMetaTablesRequest req) {
        try {
            ArrayList<JdbcTableMeta> meta = new ArrayList<JdbcTableMeta>();
            for (String cacheName : this.ctx.cache().publicCacheNames()) {
                for (GridQueryTypeDescriptor table : this.ctx.query().types(cacheName)) {
                    JdbcTableMeta tableMeta;
                    if (!JdbcRequestHandler.matches(table.schemaName(), req.schemaName()) || !JdbcRequestHandler.matches(table.tableName(), req.tableName()) || meta.contains(tableMeta = new JdbcTableMeta(table.schemaName(), table.tableName(), "TABLE"))) continue;
                    meta.add(tableMeta);
                }
            }
            JdbcMetaTablesResult res = new JdbcMetaTablesResult(meta);
            return new JdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get tables metadata [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private JdbcResponse getColumnsMeta(JdbcMetaColumnsRequest req) {
        try {
            LinkedHashSet<JdbcColumnMeta> meta = new LinkedHashSet<JdbcColumnMeta>();
            for (String cacheName : this.ctx.cache().publicCacheNames()) {
                for (GridQueryTypeDescriptor table : this.ctx.query().types(cacheName)) {
                    if (!JdbcRequestHandler.matches(table.schemaName(), req.schemaName()) || !JdbcRequestHandler.matches(table.tableName(), req.tableName())) continue;
                    for (Map.Entry<String, Class<?>> field : table.fields().entrySet()) {
                        JdbcColumnMeta columnMeta;
                        GridQueryProperty prop;
                        String colName = field.getKey();
                        if (!JdbcRequestHandler.matches(colName, req.columnName())) continue;
                        if (this.protocolVer.compareTo(JdbcConnectionContext.VER_2_7_0) >= 0) {
                            prop = table.property(colName);
                            columnMeta = new JdbcColumnMetaV4(table.schemaName(), table.tableName(), field.getKey(), field.getValue(), !prop.notNull(), prop.defaultValue(), prop.precision(), prop.scale());
                        } else if (this.protocolVer.compareTo(JdbcConnectionContext.VER_2_4_0) >= 0) {
                            prop = table.property(colName);
                            columnMeta = new JdbcColumnMetaV3(table.schemaName(), table.tableName(), field.getKey(), field.getValue(), !prop.notNull(), prop.defaultValue());
                        } else if (this.protocolVer.compareTo(JdbcConnectionContext.VER_2_3_0) >= 0) {
                            prop = table.property(colName);
                            columnMeta = new JdbcColumnMetaV2(table.schemaName(), table.tableName(), field.getKey(), field.getValue(), !prop.notNull());
                        } else {
                            columnMeta = new JdbcColumnMeta(table.schemaName(), table.tableName(), field.getKey(), field.getValue());
                        }
                        if (meta.contains(columnMeta)) continue;
                        meta.add(columnMeta);
                    }
                }
            }
            JdbcMetaColumnsResult res = this.protocolVer.compareTo(JdbcConnectionContext.VER_2_7_0) >= 0 ? new JdbcMetaColumnsResultV4(meta) : (this.protocolVer.compareTo(JdbcConnectionContext.VER_2_4_0) >= 0 ? new JdbcMetaColumnsResultV3(meta) : (this.protocolVer.compareTo(JdbcConnectionContext.VER_2_3_0) >= 0 ? new JdbcMetaColumnsResultV2(meta) : new JdbcMetaColumnsResult(meta)));
            return new JdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get columns metadata [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private ClientListenerResponse getIndexesMeta(JdbcMetaIndexesRequest req) {
        try {
            HashSet<JdbcIndexMeta> meta = new HashSet<JdbcIndexMeta>();
            for (String cacheName : this.ctx.cache().publicCacheNames()) {
                for (GridQueryTypeDescriptor table : this.ctx.query().types(cacheName)) {
                    if (!JdbcRequestHandler.matches(table.schemaName(), req.schemaName()) || !JdbcRequestHandler.matches(table.tableName(), req.tableName())) continue;
                    for (GridQueryIndexDescriptor idxDesc : table.indexes().values()) {
                        meta.add(new JdbcIndexMeta(table.schemaName(), table.tableName(), idxDesc));
                    }
                }
            }
            return new JdbcResponse(new JdbcMetaIndexesResult(meta));
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get parameters metadata [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private ClientListenerResponse getParametersMeta(JdbcMetaParamsRequest req) {
        try {
            ParameterMetaData paramMeta = this.ctx.query().prepareNativeStatement(req.schemaName(), req.sql()).getParameterMetaData();
            int size = paramMeta.getParameterCount();
            ArrayList<JdbcParameterMeta> meta = new ArrayList<JdbcParameterMeta>(size);
            for (int i = 0; i < size; ++i) {
                meta.add(new JdbcParameterMeta(paramMeta, i + 1));
            }
            JdbcMetaParamsResult res = new JdbcMetaParamsResult(meta);
            return new JdbcResponse(res);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get parameters metadata [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private ClientListenerResponse getPrimaryKeys(JdbcMetaPrimaryKeysRequest req) {
        try {
            HashSet<JdbcPrimaryKeyMeta> meta = new HashSet<JdbcPrimaryKeyMeta>();
            for (String cacheName : this.ctx.cache().publicCacheNames()) {
                for (GridQueryTypeDescriptor table : this.ctx.query().types(cacheName)) {
                    String keyName;
                    if (!JdbcRequestHandler.matches(table.schemaName(), req.schemaName()) || !JdbcRequestHandler.matches(table.tableName(), req.tableName())) continue;
                    ArrayList<String> fields = new ArrayList<String>();
                    for (String field : table.fields().keySet()) {
                        if (!table.property(field).key()) continue;
                        fields.add(field);
                    }
                    String string = keyName = table.keyFieldName() == null ? "PK_" + table.schemaName() + "_" + table.tableName() : table.keyFieldName();
                    if (fields.isEmpty()) {
                        String keyColName = table.keyFieldName() == null ? "_KEY" : table.keyFieldName();
                        meta.add(new JdbcPrimaryKeyMeta(table.schemaName(), table.tableName(), keyName, Collections.singletonList(keyColName)));
                        continue;
                    }
                    meta.add(new JdbcPrimaryKeyMeta(table.schemaName(), table.tableName(), keyName, fields));
                }
            }
            return new JdbcResponse(new JdbcMetaPrimaryKeysResult(meta));
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get parameters metadata [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private ClientListenerResponse getSchemas(JdbcMetaSchemasRequest req) {
        try {
            String schemaPtrn = req.schemaName();
            HashSet<String> schemas = new HashSet<String>();
            for (String cacheName : this.ctx.cache().publicCacheNames()) {
                for (GridQueryTypeDescriptor table : this.ctx.query().types(cacheName)) {
                    if (!JdbcRequestHandler.matches(table.schemaName(), schemaPtrn)) continue;
                    schemas.add(table.schemaName());
                }
            }
            return new JdbcResponse(new JdbcMetaSchemasResult(schemas));
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get schemas metadata [reqId=" + req.requestId() + ", req=" + req + ']', e);
            return this.exceptionToResult(e);
        }
    }

    private static boolean matches(String str, String ptrn) {
        return str != null && (F.isEmpty(ptrn) || str.matches(ptrn.replace("%", ".*").replace("_", ".")));
    }

    private JdbcResponse exceptionToResult(Exception e) {
        if (e instanceof TransactionSerializationException) {
            return new JdbcResponse(5005, e.getMessage());
        }
        if (e instanceof TransactionAlreadyCompletedException) {
            return new JdbcResponse(5004, e.getMessage());
        }
        if (e instanceof TransactionDuplicateKeyException) {
            return new JdbcResponse(4001, e.getMessage());
        }
        if (e instanceof TransactionMixedModeException) {
            return new JdbcResponse(5003, e.getMessage());
        }
        if (e instanceof TransactionUnsupportedConcurrencyException) {
            return new JdbcResponse(1002, e.getMessage());
        }
        if (e instanceof IgniteSQLException) {
            return new JdbcResponse(((IgniteSQLException)e).statusCode(), e.getMessage());
        }
        return new JdbcResponse(1, e.getMessage());
    }

    private class OrderedBatchWorker
    extends GridWorker {
        OrderedBatchWorker() {
            super(JdbcRequestHandler.this.ctx.igniteInstanceName(), "ordered-batch", JdbcRequestHandler.this.log);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            long nextBatchOrder = 0L;
            while (JdbcRequestHandler.this.cliCtx.isStream()) {
                JdbcOrderedBatchExecuteRequest req;
                Object object = JdbcRequestHandler.this.orderedBatchesMux;
                synchronized (object) {
                    req = (JdbcOrderedBatchExecuteRequest)JdbcRequestHandler.this.orderedBatchesQueue.peek();
                    if (req == null || req.order() != nextBatchOrder) {
                        JdbcRequestHandler.this.orderedBatchesMux.wait();
                        continue;
                    }
                }
                JdbcRequestHandler.this.executeBatchOrdered(req);
                ++nextBatchOrder;
            }
            return;
        }
    }
}

