/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastreamer;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import javax.cache.CacheException;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteDataStreamerTimeoutException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityProcessor;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheGateway;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteCacheFutureImpl;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.datastreamer.DataStreamProcessor;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerCacheUpdaters;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerEntry;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerFuture;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerRequest;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerResponse;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerUpdateJob;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridSpinReadWriteLock;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridPeerDeployAware;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.GPC;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.stream.StreamReceiver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataStreamerImpl<K, V>
implements IgniteDataStreamer<K, V>,
Delayed {
    private int bufLdrSzPerThread = 4096;
    private final Map<Long, ThreadBuffer> threadBufMap = new ConcurrentHashMap<Long, ThreadBuffer>();
    private static final StreamReceiver ISOLATED_UPDATER = new IsolatedUpdater();
    private static final int REMAP_SEMAPHORE_PERMISSIONS_COUNT = Integer.MAX_VALUE;
    private StreamReceiver<K, V> rcvr = ISOLATED_UPDATER;
    private byte[] updaterBytes;
    private IgniteClosure<ClusterNode, Byte> ioPlcRslvr;
    private static final int DFLT_MAX_REMAP_CNT = 32;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private final String cacheName;
    private int bufSize = 512;
    private int parallelOps;
    private long timeout = -1L;
    private long autoFlushFreq;
    @GridToStringInclude
    private ConcurrentMap<UUID, Buffer> bufMappings = new ConcurrentHashMap<UUID, Buffer>();
    private final GridLocalEventListener discoLsnr;
    private final GridKernalContext ctx;
    private final IgniteCacheObjectProcessor cacheObjProc;
    private final CacheObjectContext cacheObjCtx;
    private final Object topic;
    private byte[] topicBytes;
    private volatile boolean cancelled;
    private volatile Throwable cancellationReason = null;
    private final LongAdder failCntr = new LongAdder();
    @GridToStringInclude
    private final Collection<IgniteInternalFuture<?>> activeFuts = new GridConcurrentHashSet();
    @GridToStringExclude
    private final IgniteInClosure<IgniteInternalFuture<?>> rmvActiveFut = new IgniteInClosure<IgniteInternalFuture<?>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(IgniteInternalFuture<?> t) {
            boolean rmv = DataStreamerImpl.this.activeFuts.remove(t);
            assert (rmv);
            Throwable err = t.error();
            if (err != null && !(err instanceof IgniteClientDisconnectedCheckedException)) {
                LT.error(log, t.error(), "DataStreamer operation failed.", true);
                DataStreamerImpl.this.failCntr.increment();
                DataStreamerImpl dataStreamerImpl = DataStreamerImpl.this;
                synchronized (dataStreamerImpl) {
                    if (DataStreamerImpl.this.cancellationReason == null) {
                        DataStreamerImpl.this.cancellationReason = err;
                    }
                    DataStreamerImpl.this.cancelled = true;
                }
            }
        }
    };
    private volatile GridPeerDeployAware jobPda;
    private Class<?> depCls;
    private final GridFutureAdapter<?> fut;
    private final IgniteFuture<?> publicFut;
    private final GridSpinReadWriteLock busyLock = new GridSpinReadWriteLock();
    private CacheException disconnectErr;
    private final AtomicBoolean closed = new AtomicBoolean();
    private volatile long lastFlushTime = U.currentTimeMillis();
    private final DelayQueue<DataStreamerImpl<K, V>> flushQ;
    private boolean skipStore;
    private boolean keepBinary;
    private int maxRemapCnt = 32;
    private static boolean isWarningPrinted;
    private final Semaphore remapSem = new Semaphore(Integer.MAX_VALUE);
    private final ConcurrentLinkedDeque<Runnable> dataToRemap = new ConcurrentLinkedDeque();
    private final AtomicBoolean remapOwning = new AtomicBoolean();

    public DataStreamerImpl(GridKernalContext ctx, @Nullable String cacheName, DelayQueue<DataStreamerImpl<K, V>> flushQ) {
        assert (ctx != null);
        this.ctx = ctx;
        this.cacheObjProc = ctx.cacheObjects();
        if (log == null) {
            log = U.logger(ctx, logRef, DataStreamerImpl.class);
        }
        CacheConfiguration ccfg = ctx.cache().cacheConfiguration(cacheName);
        try {
            this.cacheObjCtx = ctx.cacheObjects().contextForCache(ccfg);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to initialize cache context.", e);
        }
        this.cacheName = cacheName;
        this.flushQ = flushQ;
        this.discoLsnr = new GridLocalEventListener(){

            @Override
            public void onEvent(Event evt) {
                assert (evt.type() == 12 || evt.type() == 11);
                DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
                UUID id = discoEvt.eventNode().id();
                final Buffer buf = (Buffer)DataStreamerImpl.this.bufMappings.remove(id);
                if (buf != null) {
                    DataStreamerImpl.this.waitAffinityAndRun(new Runnable(){

                        @Override
                        public void run() {
                            buf.onNodeLeft();
                        }
                    }, discoEvt.topologyVersion(), true);
                }
            }
        };
        ctx.event().addLocalEventListener(this.discoLsnr, 12, 11);
        this.topic = GridTopic.TOPIC_DATASTREAM.topic(IgniteUuid.fromUuid(ctx.localNodeId()));
        ctx.io().addMessageListener(this.topic, new GridMessageListener(){

            @Override
            public void onMessage(UUID nodeId, Object msg, byte plc) {
                Buffer buf;
                assert (msg instanceof DataStreamerResponse);
                DataStreamerResponse res = (DataStreamerResponse)msg;
                if (log.isDebugEnabled()) {
                    log.debug("Received data load response: " + res);
                }
                if ((buf = (Buffer)DataStreamerImpl.this.bufMappings.get(nodeId)) != null) {
                    buf.onResponse(res, nodeId);
                } else if (log.isDebugEnabled()) {
                    log.debug("Ignoring response since node has left [nodeId=" + nodeId + ", ");
                }
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Added response listener within topic: " + this.topic);
        }
        this.fut = new DataStreamerFuture(this);
        this.publicFut = new IgniteCacheFutureImpl(this.fut);
        GridCacheAdapter cache = ctx.cache().internalCache(cacheName);
        if (cache == null) {
            assert (ccfg != null);
            if (ccfg.getCacheMode() == CacheMode.LOCAL) {
                throw new CacheException("Impossible to load Local cache configured remotely.");
            }
            ctx.grid().getOrCreateCache(ccfg);
        }
        this.ensureCacheStarted();
    }

    @Override
    public void perThreadBufferSize(int size) {
        this.bufLdrSzPerThread = size;
    }

    @Override
    public int perThreadBufferSize() {
        return this.bufLdrSzPerThread;
    }

    private void waitAffinityAndRun(final Runnable c, long topVer, boolean async) {
        AffinityTopologyVersion topVer0 = new AffinityTopologyVersion(topVer, 0);
        IgniteInternalFuture<AffinityTopologyVersion> fut = this.ctx.cache().context().exchange().affinityReadyFuture(topVer0);
        if (fut != null && !fut.isDone()) {
            fut.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> fut) {
                    DataStreamerImpl.this.ctx.closure().runLocalSafe(c, true);
                }
            });
        } else if (async) {
            this.ctx.closure().runLocalSafe(c, true);
        } else {
            c.run();
        }
    }

    public CacheObjectContext cacheObjectContext() {
        return this.cacheObjCtx;
    }

    private void lock(boolean writeLock) {
        if (writeLock) {
            this.busyLock.writeLock();
        } else {
            this.busyLock.readLock();
        }
        if (this.closed.get() || this.cancelled) {
            this.unlock(writeLock);
            if (this.disconnectErr != null) {
                throw this.disconnectErr;
            }
            this.closedException();
        }
    }

    private void unlock(boolean writeLock) {
        if (writeLock) {
            this.busyLock.writeUnlock();
        } else {
            this.busyLock.readUnlock();
        }
    }

    @Override
    public IgniteFuture<?> future() {
        return this.publicFut;
    }

    public IgniteInternalFuture<?> internalFuture() {
        return this.fut;
    }

    @Override
    public void deployClass(Class<?> depCls) {
        this.depCls = depCls;
    }

    @Override
    public void receiver(StreamReceiver<K, V> rcvr) {
        A.notNull(rcvr, "rcvr");
        this.rcvr = rcvr;
    }

    @Override
    public boolean allowOverwrite() {
        return this.rcvr != ISOLATED_UPDATER;
    }

    @Override
    public void allowOverwrite(boolean allow) {
        if (allow == this.allowOverwrite()) {
            return;
        }
        ClusterNode node = F.first(this.ctx.grid().cluster().forCacheNodes(this.cacheName).nodes());
        if (node == null) {
            throw new CacheException("Failed to get node for cache: " + this.cacheName);
        }
        this.rcvr = allow ? DataStreamerCacheUpdaters.individual() : ISOLATED_UPDATER;
    }

    @Override
    public boolean skipStore() {
        return this.skipStore;
    }

    @Override
    public void skipStore(boolean skipStore) {
        this.skipStore = skipStore;
    }

    @Override
    public boolean keepBinary() {
        return this.keepBinary;
    }

    @Override
    public void keepBinary(boolean keepBinary) {
        this.keepBinary = keepBinary;
    }

    @Override
    @Nullable
    public String cacheName() {
        return this.cacheName;
    }

    @Override
    public int perNodeBufferSize() {
        return this.bufSize;
    }

    @Override
    public void perNodeBufferSize(int bufSize) {
        A.ensure(bufSize > 0, "bufSize > 0");
        this.bufSize = bufSize;
    }

    @Override
    public int perNodeParallelOperations() {
        return this.parallelOps;
    }

    @Override
    public void perNodeParallelOperations(int parallelOps) {
        this.parallelOps = parallelOps;
    }

    @Override
    public void timeout(long timeout) {
        if (timeout < -1L || timeout == 0L) {
            throw new IllegalArgumentException();
        }
        this.timeout = timeout;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public long autoFlushFrequency() {
        return this.autoFlushFreq;
    }

    @Override
    public void autoFlushFrequency(long autoFlushFreq) {
        A.ensure(autoFlushFreq >= 0L, "autoFlushFreq >= 0");
        long old = this.autoFlushFreq;
        if (autoFlushFreq != old) {
            this.autoFlushFreq = autoFlushFreq;
            if (autoFlushFreq != 0L && old == 0L) {
                this.flushQ.add(this);
            } else if (autoFlushFreq == 0L) {
                this.flushQ.remove(this);
            }
        }
    }

    @Override
    public IgniteFuture<?> addData(Map<K, V> entries) throws IllegalStateException {
        A.notNull(entries, "entries");
        return this.addData(entries.entrySet());
    }

    @Override
    public IgniteFuture<?> addData(Collection<? extends Map.Entry<K, V>> entries) {
        A.notEmpty(entries, "entries");
        this.checkSecurityPermission(SecurityPermission.CACHE_PUT);
        ArrayList<DataStreamerEntry> batch = new ArrayList<DataStreamerEntry>(entries.size());
        for (Map.Entry<K, V> entry : entries) {
            KeyCacheObject key = this.cacheObjProc.toCacheKeyObject(this.cacheObjCtx, null, entry.getKey(), true);
            CacheObject val = this.cacheObjProc.toCacheObject(this.cacheObjCtx, entry.getValue(), true);
            batch.add(new DataStreamerEntry(key, val));
        }
        return this.addDataInternal(batch);
    }

    public IgniteFuture<?> addDataInternal(KeyCacheObject key, CacheObject val) {
        return this.addDataInternal(Collections.singleton(new DataStreamerEntry(key, val)));
    }

    public IgniteFuture<?> removeDataInternal(KeyCacheObject key) {
        return this.addDataInternal(Collections.singleton(new DataStreamerEntry(key, null)));
    }

    public IgniteFuture<?> addDataInternal(Collection<? extends DataStreamerEntry> entries) {
        return this.addDataInternal(entries, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteFuture<?> addDataInternal(Collection<? extends DataStreamerEntry> entries, boolean useThreadBuffer) {
        IgniteCacheFutureImpl fut = null;
        GridFutureAdapter internalFut = null;
        this.lock(false);
        try {
            List entriesList;
            long threadId = Thread.currentThread().getId();
            if (useThreadBuffer) {
                ThreadBuffer threadBuf = this.threadBufMap.get(threadId);
                if (threadBuf == null) {
                    fut = this.createDataLoadFuture();
                    threadBuf = new ThreadBuffer(fut, new ArrayList(this.bufLdrSzPerThread + (this.bufLdrSzPerThread >> 3)));
                    this.threadBufMap.put(threadId, threadBuf);
                } else {
                    fut = threadBuf.getFuture();
                }
                entriesList = threadBuf.getEntries();
                entriesList.addAll(entries);
            } else {
                entriesList = entries;
                fut = this.createDataLoadFuture();
            }
            internalFut = (GridFutureAdapter)fut.internalFuture();
            if (!useThreadBuffer || entriesList.size() >= this.bufLdrSzPerThread) {
                this.loadData(entriesList, internalFut);
                if (useThreadBuffer) {
                    this.threadBufMap.remove(threadId);
                }
            }
            IgniteCacheFutureImpl igniteCacheFutureImpl = fut;
            return igniteCacheFutureImpl;
        }
        catch (Throwable e) {
            if (internalFut != null) {
                internalFut.onDone(e);
            }
            if (e instanceof Error || e instanceof IgniteDataStreamerTimeoutException) {
                throw e;
            }
            IgniteCacheFutureImpl igniteCacheFutureImpl = fut;
            return igniteCacheFutureImpl;
        }
        finally {
            this.unlock(false);
        }
    }

    @NotNull
    protected IgniteCacheFutureImpl createDataLoadFuture() {
        GridFutureAdapter internalFut0 = new GridFutureAdapter();
        IgniteCacheFutureImpl fut = new IgniteCacheFutureImpl(internalFut0);
        internalFut0.listen(this.rmvActiveFut);
        this.activeFuts.add(internalFut0);
        return fut;
    }

    private void loadData(Collection<? extends DataStreamerEntry> entries, GridFutureAdapter fut) {
        GridConcurrentHashSet<KeyCacheObjectWrapper> keys = null;
        if (entries.size() > 1) {
            keys = new GridConcurrentHashSet<KeyCacheObjectWrapper>(entries.size());
            for (DataStreamerEntry dataStreamerEntry : entries) {
                keys.add(new KeyCacheObjectWrapper(dataStreamerEntry.getKey()));
            }
        }
        this.load0(entries, fut, keys, 0, null, null);
    }

    @Override
    public IgniteFuture<?> addData(Map.Entry<K, V> entry) {
        A.notNull(entry, "entry");
        return this.addData(F.asList(entry));
    }

    @Override
    public IgniteFuture<?> addData(K key, V val) {
        A.notNull(key, "key");
        if (val == null) {
            this.checkSecurityPermission(SecurityPermission.CACHE_REMOVE);
        } else {
            this.checkSecurityPermission(SecurityPermission.CACHE_PUT);
        }
        KeyCacheObject key0 = this.cacheObjProc.toCacheKeyObject(this.cacheObjCtx, null, key, true);
        CacheObject val0 = this.cacheObjProc.toCacheObject(this.cacheObjCtx, val, true);
        return this.addDataInternal(Collections.singleton(new DataStreamerEntry(key0, val0)));
    }

    @Override
    public IgniteFuture<?> removeData(K key) {
        return this.addData(key, null);
    }

    public void ioPolicyResolver(IgniteClosure<ClusterNode, Byte> ioPlcRslvr) {
        this.ioPlcRslvr = ioPlcRslvr;
    }

    private void acquireRemapSemaphore() throws IgniteInterruptedCheckedException {
        block4: {
            try {
                if (this.remapSem.availablePermits() == Integer.MAX_VALUE) break block4;
                if (this.timeout == -1L) {
                    this.remapSem.acquire(Integer.MAX_VALUE);
                    this.remapSem.release(Integer.MAX_VALUE);
                    break block4;
                }
                boolean res = this.remapSem.tryAcquire(Integer.MAX_VALUE, this.timeout, TimeUnit.MILLISECONDS);
                if (res) {
                    this.remapSem.release(Integer.MAX_VALUE);
                    break block4;
                }
                throw new IgniteDataStreamerTimeoutException("Data streamer exceeded timeout while was waiting for failed data resending finished.");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IgniteInterruptedCheckedException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load0(Collection<? extends DataStreamerEntry> entries, final GridFutureAdapter<Object> resFut, final @Nullable Collection<KeyCacheObjectWrapper> activeKeys, final int remaps, ClusterNode remapNode, AffinityTopologyVersion remapTopVer) {
        try {
            boolean remap;
            assert (entries != null);
            boolean bl = remap = remaps > 0;
            if (!remap) {
                this.acquireRemapSemaphore();
            }
            if (!isWarningPrinted) {
                DataStreamerImpl dataStreamerImpl = this;
                synchronized (dataStreamerImpl) {
                    if (!this.allowOverwrite() && !isWarningPrinted) {
                        U.warn(log, "Data streamer will not overwrite existing cache entries for better performance (to change, set allowOverwrite to true)");
                    }
                    isWarningPrinted = true;
                }
            }
            HashMap<ClusterNode, ArrayList<DataStreamerEntry>> mappings = new HashMap<ClusterNode, ArrayList<DataStreamerEntry>>();
            boolean initPda = this.ctx.deploy().enabled() && this.jobPda == null;
            GridCacheAdapter cache = this.ctx.cache().internalCache(this.cacheName);
            if (cache == null) {
                throw new IgniteCheckedException("Cache not created or already destroyed.");
            }
            GridCacheContext cctx = cache.context();
            GridCacheGateway gate = null;
            final AffinityTopologyVersion topVer = !cctx.isLocal() ? (AffinityTopologyVersion)this.ctx.cache().context().exchange().lastTopologyFuture().get() : this.ctx.cache().context().exchange().readyAffinityVersion();
            List<List<ClusterNode>> assignments = cctx.affinity().assignments(topVer);
            if (!this.allowOverwrite() && !cctx.isLocal()) {
                gate = cctx.gate();
                gate.enter();
            }
            try {
                for (DataStreamerEntry dataStreamerEntry : entries) {
                    List<ClusterNode> nodes;
                    try {
                        KeyCacheObject key = dataStreamerEntry.getKey();
                        assert (key != null);
                        if (initPda) {
                            if (this.cacheObjCtx.addDeploymentInfo()) {
                                this.jobPda = new DataStreamerPda(new Object[]{key.value(this.cacheObjCtx, false), dataStreamerEntry.getValue() != null ? dataStreamerEntry.getValue().value(this.cacheObjCtx, false) : null, this.rcvr});
                            } else if (this.rcvr != null) {
                                this.jobPda = new DataStreamerPda(new Object[]{this.rcvr});
                            }
                            initPda = false;
                        }
                        if (key.partition() == -1) {
                            key.partition(cctx.affinity().partition(key, false));
                        }
                        nodes = !this.allowOverwrite() && remapNode != null && F.eq(topVer, remapTopVer) ? Collections.singletonList(remapNode) : this.nodes(key, topVer, cctx);
                    }
                    catch (IgniteCheckedException e) {
                        resFut.onDone(e);
                        if (gate != null) {
                            gate.leave();
                        }
                        return;
                    }
                    if (F.isEmpty(nodes)) {
                        resFut.onDone(new ClusterTopologyException("Failed to map key to node (no nodes with cache found in topology) [infos=" + entries.size() + ", cacheName=" + this.cacheName + ']'));
                        return;
                    }
                    for (ClusterNode node : nodes) {
                        ArrayList<DataStreamerEntry> col = (ArrayList<DataStreamerEntry>)mappings.get(node);
                        if (col == null) {
                            col = new ArrayList<DataStreamerEntry>();
                            mappings.put(node, col);
                        }
                        col.add(dataStreamerEntry);
                    }
                }
                for (Map.Entry<KeyCacheObject, CacheObject> entry : mappings.entrySet()) {
                    List<GridFutureAdapter<?>> futs;
                    Buffer old;
                    final ClusterNode node = (ClusterNode)((Object)entry.getKey());
                    final UUID nodeId = ((ClusterNode)((Object)entry.getKey())).id();
                    Buffer buf = (Buffer)this.bufMappings.get(nodeId);
                    if (buf == null && (old = this.bufMappings.putIfAbsent(nodeId, buf = new Buffer((ClusterNode)((Object)entry.getKey())))) != null) {
                        buf = old;
                    }
                    final Collection entriesForNode = (Collection)((Object)entry.getValue());
                    IgniteInClosure lsnr = new IgniteInClosure<IgniteInternalFuture<?>>(){

                        @Override
                        public void apply(IgniteInternalFuture<?> t) {
                            try {
                                t.get();
                                if (activeKeys != null) {
                                    for (DataStreamerEntry e : entriesForNode) {
                                        activeKeys.remove(new KeyCacheObjectWrapper(e.getKey()));
                                    }
                                    if (activeKeys.isEmpty()) {
                                        resFut.onDone();
                                    }
                                } else {
                                    assert (entriesForNode.size() == 1);
                                    resFut.onDone();
                                }
                            }
                            catch (IgniteClientDisconnectedCheckedException e1) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Future finished with disconnect error [nodeId=" + nodeId + ", err=" + e1 + ']');
                                }
                                resFut.onDone(e1);
                            }
                            catch (IgniteCheckedException e1) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Future finished with error [nodeId=" + nodeId + ", err=" + e1 + ']');
                                }
                                if (DataStreamerImpl.this.cancelled) {
                                    resFut.onDone(new IgniteCheckedException("Data streamer has been cancelled: " + DataStreamerImpl.this, e1));
                                }
                                if (remaps + 1 > DataStreamerImpl.this.maxRemapCnt) {
                                    resFut.onDone(new IgniteCheckedException("Failed to finish operation (too many remaps): " + remaps, e1));
                                }
                                try {
                                    DataStreamerImpl.this.remapSem.acquire();
                                    Runnable r = new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                if (DataStreamerImpl.this.cancelled) {
                                                    DataStreamerImpl.this.closedException();
                                                }
                                                DataStreamerImpl.this.load0(entriesForNode, resFut, activeKeys, remaps + 1, node, topVer);
                                            }
                                            catch (Throwable ex) {
                                                resFut.onDone(new IgniteCheckedException("DataStreamer remapping failed. ", ex));
                                            }
                                            finally {
                                                DataStreamerImpl.this.remapSem.release();
                                            }
                                        }
                                    };
                                    DataStreamerImpl.this.dataToRemap.add(r);
                                    if (!DataStreamerImpl.this.remapOwning.get() && DataStreamerImpl.this.remapOwning.compareAndSet(false, true)) {
                                        DataStreamerImpl.this.ctx.closure().callLocalSafe(new GPC<Boolean>(){

                                            @Override
                                            public Boolean call() {
                                                boolean locked = true;
                                                while (locked || !DataStreamerImpl.this.dataToRemap.isEmpty()) {
                                                    if (!locked && !DataStreamerImpl.this.remapOwning.compareAndSet(false, true)) {
                                                        return false;
                                                    }
                                                    try {
                                                        Runnable r = (Runnable)DataStreamerImpl.this.dataToRemap.poll();
                                                        if (r == null) continue;
                                                        r.run();
                                                    }
                                                    finally {
                                                        if (!DataStreamerImpl.this.dataToRemap.isEmpty()) {
                                                            locked = true;
                                                            continue;
                                                        }
                                                        DataStreamerImpl.this.remapOwning.set(false);
                                                        locked = false;
                                                    }
                                                }
                                                return true;
                                            }
                                        }, true);
                                    }
                                }
                                catch (InterruptedException e2) {
                                    resFut.onDone(e2);
                                }
                            }
                        }
                    };
                    SilentCompoundFuture opFut = new SilentCompoundFuture();
                    opFut.listen(lsnr);
                    try {
                        futs = buf.update(entriesForNode, topVer, assignments, opFut, remap);
                        opFut.markInitialized();
                    }
                    catch (IgniteInterruptedCheckedException e1) {
                        resFut.onDone(e1);
                        if (gate != null) {
                            gate.leave();
                        }
                        return;
                    }
                    if (this.ctx.discovery().node(nodeId) != null || !this.bufMappings.remove(nodeId, buf)) continue;
                    final Buffer buf0 = buf;
                    this.waitAffinityAndRun(new Runnable(){

                        @Override
                        public void run() {
                            buf0.onNodeLeft();
                            if (futs != null) {
                                ClusterTopologyCheckedException ex = new ClusterTopologyCheckedException("Failed to wait for request completion (node has left): " + nodeId);
                                for (int i = 0; i < futs.size(); ++i) {
                                    ((GridFutureAdapter)futs.get(i)).onDone(ex);
                                }
                            }
                        }
                    }, this.ctx.discovery().topologyVersion(), false);
                }
            }
            finally {
                if (gate != null) {
                    gate.leave();
                }
            }
        }
        catch (Exception ex) {
            resFut.onDone(new IgniteCheckedException("DataStreamer data loading failed.", ex));
        }
    }

    private void closedException() {
        throw new IllegalStateException("Data streamer has been closed.", this.cancellationReason);
    }

    private List<ClusterNode> nodes(KeyCacheObject key, AffinityTopologyVersion topVer, GridCacheContext cctx) throws IgniteCheckedException {
        GridAffinityProcessor aff = this.ctx.affinity();
        List<ClusterNode> res = null;
        if (!this.allowOverwrite()) {
            res = cctx.isLocal() ? aff.mapKeyToPrimaryAndBackups(this.cacheName, key, topVer) : cctx.topology().nodes(cctx.affinity().partition(key), topVer);
        } else {
            ClusterNode node = aff.mapKeyToNode(this.cacheName, key, topVer);
            if (node != null) {
                res = Collections.singletonList(node);
            }
        }
        if (F.isEmpty(res)) {
            throw new ClusterTopologyServerNotFoundException("Failed to find server node for cache (all affinity nodes have left the grid or cache was stopped): " + this.cacheName);
        }
        return res;
    }

    private void doFlush() throws IgniteCheckedException {
        this.lastFlushTime = U.currentTimeMillis();
        ArrayList activeFuts0 = null;
        int doneCnt = 0;
        this.flushAllThreadsBufs();
        for (IgniteInternalFuture<?> f : this.activeFuts) {
            if (!f.isDone()) {
                if (activeFuts0 == null) {
                    activeFuts0 = new ArrayList((int)((double)this.activeFuts.size() * 1.2));
                }
                activeFuts0.add(f);
                continue;
            }
            f.get();
            ++doneCnt;
        }
        if (activeFuts0 == null || activeFuts0.isEmpty()) {
            return;
        }
        while (true) {
            if (this.disconnectErr != null) {
                throw this.disconnectErr;
            }
            ArrayDeque q = null;
            for (Buffer buf : this.bufMappings.values()) {
                IgniteInternalFuture<?> flushFut = buf.flush();
                if (flushFut == null) continue;
                if (q == null) {
                    q = new ArrayDeque(this.bufMappings.size() * 2);
                }
                q.add(flushFut);
            }
            if (q != null) {
                assert (!q.isEmpty());
                boolean err = false;
                long startTimeMillis = U.currentTimeMillis();
                IgniteInternalFuture fut = (IgniteInternalFuture)q.poll();
                while (fut != null) {
                    try {
                        if (this.timeout == -1L) {
                            fut.get();
                        } else {
                            long timeRemain = this.timeout - U.currentTimeMillis() + startTimeMillis;
                            if (timeRemain <= 0L) {
                                throw new IgniteDataStreamerTimeoutException("Data streamer exceeded timeout on flush.");
                            }
                            fut.get(timeRemain);
                        }
                    }
                    catch (IgniteClientDisconnectedCheckedException e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Failed to flush buffer: " + e);
                        }
                        throw CU.convertToCacheException(e);
                    }
                    catch (IgniteFutureTimeoutCheckedException e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Failed to flush buffer: " + e);
                        }
                        throw new IgniteDataStreamerTimeoutException("Data streamer exceeded timeout on flush.", e);
                    }
                    catch (IgniteCheckedException e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Failed to flush buffer: " + e);
                        }
                        err = true;
                    }
                    fut = (IgniteInternalFuture)q.poll();
                }
                if (err) continue;
            }
            doneCnt = 0;
            for (int i = 0; i < activeFuts0.size(); ++i) {
                IgniteInternalFuture f = (IgniteInternalFuture)activeFuts0.get(i);
                if (f == null) {
                    ++doneCnt;
                    continue;
                }
                if (!f.isDone()) break;
                f.get();
                ++doneCnt;
                activeFuts0.set(i, null);
            }
            if (doneCnt == activeFuts0.size()) break;
        }
    }

    @Override
    public void flush() throws CacheException {
        this.lock(true);
        try {
            this.doFlush();
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unlock(true);
        }
    }

    @Override
    public void tryFlush() throws IgniteInterruptedException {
        if (!this.busyLock.tryWriteLock()) {
            return;
        }
        try {
            this.flushAllThreadsBufs();
            for (Buffer buf : this.bufMappings.values()) {
                buf.flush();
            }
            this.lastFlushTime = U.currentTimeMillis();
        }
        catch (IgniteInterruptedCheckedException e) {
            throw GridCacheUtils.convertToCacheException(e);
        }
        finally {
            this.unlock(true);
        }
    }

    private void flushAllThreadsBufs() {
        assert (this.busyLock.writeLockedByCurrentThread());
        for (ThreadBuffer buf : this.threadBufMap.values()) {
            this.loadData(buf.getEntries(), (GridFutureAdapter)buf.getFuture().internalFuture());
        }
        this.threadBufMap.clear();
    }

    @Override
    public void close(boolean cancel) throws CacheException {
        try {
            this.closeEx(cancel);
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
    }

    public void closeEx(boolean cancel) throws IgniteCheckedException {
        IgniteCheckedException err = this.closeEx(cancel, null);
        if (err != null) {
            throw err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteCheckedException closeEx(boolean cancel, IgniteCheckedException err) throws IgniteCheckedException {
        if (!this.closed.compareAndSet(false, true)) {
            return null;
        }
        this.busyLock.writeLock();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Closing data streamer [ldr=" + this + ", cancel=" + cancel + ']');
            }
            try {
                if (cancel) {
                    this.cancelled = true;
                    IgniteCheckedException cancellationErr = err;
                    if (cancellationErr == null) {
                        cancellationErr = new IgniteCheckedException("Data streamer has been cancelled: " + this);
                    }
                    for (ThreadBuffer igniteCheckedException : this.threadBufMap.values()) {
                        GridFutureAdapter internalFut = (GridFutureAdapter)igniteCheckedException.getFuture().internalFuture();
                        internalFut.onDone(cancellationErr);
                    }
                    for (Buffer buffer : this.bufMappings.values()) {
                        buffer.cancelAll(cancellationErr);
                    }
                } else {
                    this.doFlush();
                }
                this.ctx.event().removeLocalEventListener(this.discoLsnr, new int[0]);
                this.ctx.io().removeMessageListener(this.topic);
            }
            catch (IgniteCheckedException | IgniteDataStreamerTimeoutException e) {
                this.fut.onDone(e);
                throw e;
            }
            long failed = this.failCntr.longValue();
            if (failed > 0L && err == null) {
                err = new IgniteCheckedException("Some of DataStreamer operations failed [failedCount=" + failed + "]");
            }
            this.fut.onDone(err);
            IgniteCheckedException igniteCheckedException = err;
            return igniteCheckedException;
        }
        finally {
            this.busyLock.writeUnlock();
        }
    }

    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        IgniteClientDisconnectedCheckedException err = new IgniteClientDisconnectedCheckedException(reconnectFut, "Data streamer has been closed, client node disconnected.");
        this.disconnectErr = (CacheException)((Object)CU.convertToCacheException(err));
        for (Buffer buf : this.bufMappings.values()) {
            buf.cancelAll(err);
        }
        this.closeEx(true, err);
    }

    boolean isClosed() {
        return this.fut.isDone();
    }

    @Override
    public void close() throws CacheException {
        this.close(false);
    }

    public int maxRemapCount() {
        return this.maxRemapCnt;
    }

    public void maxRemapCount(int maxRemapCnt) {
        this.maxRemapCnt = maxRemapCnt;
    }

    public String toString() {
        return S.toString(DataStreamerImpl.class, this);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.nextFlushTime() - U.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    private long nextFlushTime() {
        return this.lastFlushTime + this.autoFlushFreq;
    }

    @Override
    public int compareTo(Delayed o) {
        return this.nextFlushTime() > ((DataStreamerImpl)o).nextFlushTime() ? 1 : -1;
    }

    private void checkSecurityPermission(SecurityPermission perm) throws SecurityException {
        if (!this.ctx.security().enabled()) {
            return;
        }
        this.ctx.security().authorize(this.cacheName, perm, null);
    }

    private void ensureCacheStarted() {
        DynamicCacheDescriptor desc = this.ctx.cache().cacheDescriptor(this.cacheName);
        assert (desc != null);
        if (desc.startTopologyVersion() == null) {
            return;
        }
        IgniteInternalFuture<AffinityTopologyVersion> affReadyFut = this.ctx.cache().context().exchange().affinityReadyFuture(desc.startTopologyVersion());
        if (affReadyFut != null) {
            try {
                affReadyFut.get();
            }
            catch (IgniteCheckedException ex) {
                throw new IgniteException(ex);
            }
        }
    }

    static /* synthetic */ byte[] access$3602(DataStreamerImpl x0, byte[] x1) {
        x0.updaterBytes = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$3702(DataStreamerImpl x0, byte[] x1) {
        x0.topicBytes = x1;
        return x1;
    }

    private static final class SilentCompoundFuture<T, R>
    extends GridCompoundFuture<T, R> {
        private SilentCompoundFuture() {
        }

        @Override
        protected void logError(IgniteLogger log, String msg, Throwable e) {
        }

        @Override
        protected void logDebug(IgniteLogger log, String msg) {
        }
    }

    private class PerStripeBuffer {
        private final int partId;
        private List<DataStreamerEntry> entries;
        private GridFutureAdapter<Object> curFut;
        private AffinityTopologyVersion batchTopVer;
        private final IgniteInClosure<? super IgniteInternalFuture<Object>> signalC;
        public List<List<ClusterNode>> assignments;

        public PerStripeBuffer(int partId, IgniteInClosure<? super IgniteInternalFuture<Object>> c) {
            this.partId = partId;
            this.signalC = c;
            this.renewBatch(false);
        }

        synchronized void renewBatch(boolean remap) {
            this.entries = this.newEntries();
            this.curFut = new GridFutureAdapter();
            this.batchTopVer = null;
            if (!remap) {
                this.curFut.listen(this.signalC);
            }
        }

        private List<DataStreamerEntry> newEntries() {
            return new ArrayList<DataStreamerEntry>((int)((double)DataStreamerImpl.this.bufSize * 1.2));
        }

        public String toString() {
            return S.toString(PerStripeBuffer.class, this, super.toString());
        }
    }

    private static class KeyCacheObjectWrapper {
        private final KeyCacheObject key;

        KeyCacheObjectWrapper(KeyCacheObject key) {
            assert (key != null);
            this.key = key;
        }

        public boolean equals(Object o) {
            return o instanceof KeyCacheObjectWrapper && this.key == ((KeyCacheObjectWrapper)o).key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return S.toString(KeyCacheObjectWrapper.class, this);
        }
    }

    protected static class IsolatedUpdater
    implements StreamReceiver<KeyCacheObject, CacheObject>,
    DataStreamerCacheUpdaters.InternalUpdater {
        private static final long serialVersionUID = 0L;

        protected IsolatedUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void receive(IgniteCache<KeyCacheObject, CacheObject> cache, Collection<Map.Entry<KeyCacheObject, CacheObject>> entries) {
            IgniteCacheProxy proxy = (IgniteCacheProxy)cache;
            GridCacheAdapter internalCache = proxy.context().cache();
            if (internalCache.isNear()) {
                internalCache = internalCache.context().near().dht();
            }
            GridCacheContext cctx = internalCache.context();
            GridDhtTopologyFuture topFut = cctx.shared().exchange().lastFinishedFuture();
            AffinityTopologyVersion topVer = topFut.topologyVersion();
            GridCacheVersion ver = cctx.versions().isolatedStreamerVersion();
            long ttl = 0L;
            long expiryTime = 0L;
            ExpiryPolicy plc = cctx.expiry();
            HashSet<Integer> reservedParts = new HashSet<Integer>();
            HashSet<Integer> ignoredParts = new HashSet<Integer>();
            try {
                for (Map.Entry<KeyCacheObject, CacheObject> e : entries) {
                    cctx.shared().database().checkpointReadLock();
                    try {
                        boolean primary;
                        Throwable err;
                        e.getKey().finishUnmarshal(cctx.cacheObjectContext(), cctx.deploy().globalLoader());
                        if (!cctx.isLocal()) {
                            int p = cctx.affinity().partition(e.getKey());
                            if (ignoredParts.contains(p)) continue;
                            if (!reservedParts.contains(p)) {
                                GridDhtLocalPartition part = cctx.topology().localPartition(p, topVer, true);
                                if (!part.reserve()) {
                                    ignoredParts.add(p);
                                    continue;
                                }
                                if (part.state() == GridDhtPartitionState.RENTING) {
                                    part.release();
                                    ignoredParts.add(p);
                                    continue;
                                }
                                reservedParts.add(p);
                            }
                        }
                        GridCacheEntryEx entry = internalCache.entryEx(e.getKey(), topVer);
                        if (plc != null) {
                            ttl = CU.toTtl(plc.getExpiryForCreation());
                            if (ttl == -2L) continue;
                            if (ttl == -1L) {
                                ttl = 0L;
                            }
                            expiryTime = CU.toExpireTime(ttl);
                        }
                        if (topFut != null && (err = topFut.validateCache(cctx, false, false, entry.key(), null)) != null) {
                            throw new IgniteCheckedException(err);
                        }
                        entry.initialValue(e.getValue(), ver, ttl, expiryTime, false, topVer, (primary = cctx.affinity().primaryByKey(cctx.localNode(), entry.key(), topVer)) ? GridDrType.DR_LOAD : GridDrType.DR_PRELOAD, false);
                        entry.touch();
                        CU.unwindEvicts(cctx);
                        entry.onUnlock();
                    }
                    catch (GridDhtInvalidPartitionException ignored) {
                        ignoredParts.add(cctx.affinity().partition(e.getKey()));
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                    }
                    catch (IgniteCheckedException ex) {
                        IgniteLogger log = ((Ignite)cache.unwrap(Ignite.class)).log();
                        U.error(log, "Failed to set initial value for cache entry: " + e, ex);
                        throw new IgniteException("Failed to set initial value for cache entry.", ex);
                    }
                    finally {
                        cctx.shared().database().checkpointReadUnlock();
                    }
                }
                return;
            }
            finally {
                for (Integer part : reservedParts) {
                    GridDhtLocalPartition locPart = cctx.topology().localPartition(part, topVer, false);
                    assert (locPart != null) : "Evicted reserved partition: " + locPart;
                    locPart.release();
                }
                try {
                    if (!cctx.isNear() && cctx.shared().wal() != null) {
                        cctx.shared().wal().flush(null, false);
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(log, "Failed to write preloaded entries into write-ahead log.", e);
                    throw new IgniteException("Failed to write preloaded entries into write-ahead log.", e);
                }
            }
        }
    }

    private class DataStreamerPda
    implements GridPeerDeployAware {
        private static final long serialVersionUID = 0L;
        private Class<?> cls;
        private ClassLoader ldr;
        private Collection<Object> objs;

        private DataStreamerPda(Object ... objs) {
            this.objs = Arrays.asList(objs);
        }

        @Override
        public Class<?> deployClass() {
            if (this.cls == null) {
                Class cls0 = null;
                if (DataStreamerImpl.this.depCls != null) {
                    cls0 = DataStreamerImpl.this.depCls;
                } else {
                    Iterator<Object> it = this.objs.iterator();
                    while ((cls0 == null || U.isJdk(cls0)) && it.hasNext()) {
                        Object o = it.next();
                        if (o == null) continue;
                        cls0 = U.detectClass(o);
                    }
                    if (cls0 == null || U.isJdk(cls0)) {
                        cls0 = DataStreamerImpl.class;
                    }
                }
                assert (cls0 != null) : "Failed to detect deploy class [objs=" + this.objs + ']';
                this.cls = cls0;
            }
            return this.cls;
        }

        @Override
        public ClassLoader classLoader() {
            if (this.ldr == null) {
                ClassLoader ldr0 = this.deployClass().getClassLoader();
                if (ldr0 == null) {
                    ldr0 = U.gridClassLoader();
                }
                assert (ldr0 != null) : "Failed to detect classloader [objs=" + this.objs + ']';
                this.ldr = ldr0;
            }
            return this.ldr;
        }
    }

    private class Buffer {
        private final ClusterNode node;
        private final Collection<IgniteInternalFuture<Object>> locFuts;
        private final PerStripeBuffer[] stripes;
        private final boolean isLocNode;
        private final AtomicLong idGen = new AtomicLong();
        private final ConcurrentMap<Long, GridFutureAdapter<Object>> reqs;
        private final Semaphore sem;
        private final int perNodeParallelOps;
        @GridToStringExclude
        private final IgniteInClosure<IgniteInternalFuture<Object>> signalC = new IgniteInClosure<IgniteInternalFuture<Object>>(){

            @Override
            public void apply(IgniteInternalFuture<Object> t) {
                Buffer.this.signalTaskFinished(t);
            }
        };

        Buffer(ClusterNode node) {
            assert (node != null);
            this.node = node;
            this.locFuts = new GridConcurrentHashSet<IgniteInternalFuture<Object>>();
            this.reqs = new ConcurrentHashMap<Long, GridFutureAdapter<Object>>();
            this.isLocNode = node.equals(DataStreamerImpl.this.ctx.discovery().localNode());
            Integer attrStreamerPoolSize = (Integer)node.attribute("org.apache.ignite.data.streamer.pool.size");
            int streamerPoolSize = attrStreamerPoolSize != null ? attrStreamerPoolSize.intValue() : node.metrics().getTotalCpus();
            this.perNodeParallelOps = DataStreamerImpl.this.parallelOps != 0 ? DataStreamerImpl.this.parallelOps : streamerPoolSize * 8;
            this.sem = new Semaphore(this.perNodeParallelOps);
            this.stripes = (PerStripeBuffer[])Array.newInstance(PerStripeBuffer.class, streamerPoolSize);
            for (int i = 0; i < this.stripes.length; ++i) {
                this.stripes[i] = new PerStripeBuffer(i, this.signalC);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        List<GridFutureAdapter<?>> update(Iterable<DataStreamerEntry> newEntries, AffinityTopologyVersion topVer, List<List<ClusterNode>> assignments, GridCompoundFuture opFut, boolean remap) throws IgniteInterruptedCheckedException {
            ArrayList<GridFutureAdapter> res = null;
            GridFutureAdapter[] futs = new GridFutureAdapter[this.stripes.length];
            for (DataStreamerEntry entry : newEntries) {
                AffinityTopologyVersion curBatchTopVer;
                GridFutureAdapter curFut0;
                PerStripeBuffer b;
                List entries0 = null;
                int part = entry.getKey().partition();
                PerStripeBuffer perStripeBuffer = b = this.stripes[part % this.stripes.length];
                synchronized (perStripeBuffer) {
                    curFut0 = b.curFut;
                    if (futs[b.partId] != curFut0) {
                        opFut.add(curFut0);
                        if (res == null) {
                            res = new ArrayList<GridFutureAdapter>();
                        }
                        res.add(curFut0);
                        futs[((PerStripeBuffer)b).partId] = curFut0;
                    }
                    if (b.batchTopVer == null) {
                        b.batchTopVer = topVer;
                        b.assignments = assignments;
                    }
                    if (!topVer.equals(b.batchTopVer) && b.assignments.equals(assignments)) {
                        b.batchTopVer = topVer;
                        b.assignments = assignments;
                    }
                    curBatchTopVer = b.batchTopVer;
                    b.entries.add(entry);
                    if (b.entries.size() >= DataStreamerImpl.this.bufSize) {
                        entries0 = b.entries;
                        b.renewBatch(remap);
                    }
                }
                if (!DataStreamerImpl.this.allowOverwrite() && !topVer.equals(curBatchTopVer)) {
                    for (int i = 0; i < this.stripes.length; ++i) {
                        PerStripeBuffer b0;
                        PerStripeBuffer perStripeBuffer2 = b0 = this.stripes[i];
                        synchronized (perStripeBuffer2) {
                            AffinityTopologyVersion bTopVer = b0.batchTopVer;
                            if (bTopVer != null && topVer.compareTo(bTopVer) > 0) {
                                GridFutureAdapter bFut = b0.curFut;
                                b0.renewBatch(remap);
                                bFut.onDone(null, new IgniteCheckedException("Topology changed during batch preparation [batchTopVer=" + bTopVer + ", topVer=" + topVer + "]"));
                            }
                            continue;
                        }
                    }
                    curFut0.onDone(null, new IgniteCheckedException("Topology changed during batch preparation.[batchTopVer=" + curBatchTopVer + ", topVer=" + topVer + "]"));
                    continue;
                }
                if (entries0 == null) continue;
                this.submit(entries0, curBatchTopVer, curFut0, remap, b.partId);
                if (DataStreamerImpl.this.cancelled) {
                    curFut0.onDone(new IgniteCheckedException("Data streamer has been cancelled: " + DataStreamerImpl.this));
                    continue;
                }
                if (!DataStreamerImpl.this.ctx.clientDisconnected()) continue;
                curFut0.onDone(new IgniteClientDisconnectedCheckedException(DataStreamerImpl.this.ctx.cluster().clientReconnectFuture(), "Client node disconnected."));
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        IgniteInternalFuture<?> flush() throws IgniteInterruptedCheckedException {
            DataStreamerImpl.this.acquireRemapSemaphore();
            for (PerStripeBuffer b : this.stripes) {
                AffinityTopologyVersion batchTopVer = null;
                List entries0 = null;
                GridFutureAdapter curFut0 = null;
                PerStripeBuffer perStripeBuffer = b;
                synchronized (perStripeBuffer) {
                    if (!b.entries.isEmpty()) {
                        entries0 = b.entries;
                        curFut0 = b.curFut;
                        batchTopVer = b.batchTopVer;
                        b.renewBatch(false);
                    }
                }
                if (entries0 == null) continue;
                this.submit(entries0, batchTopVer, curFut0, false, b.partId);
            }
            GridCompoundFuture res = null;
            for (IgniteInternalFuture<Object> f : this.locFuts) {
                if (res == null) {
                    res = new GridCompoundFuture();
                }
                res.add(f);
            }
            for (IgniteInternalFuture<Object> f : this.reqs.values()) {
                if (res == null) {
                    res = new GridCompoundFuture();
                }
                res.add(f);
            }
            if (res != null) {
                res.markInitialized();
            }
            return res;
        }

        private void incrementActiveTasks() throws IgniteInterruptedCheckedException {
            if (DataStreamerImpl.this.timeout == -1L) {
                U.acquire(this.sem);
            } else if (!U.tryAcquire(this.sem, DataStreamerImpl.this.timeout, TimeUnit.MILLISECONDS)) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to add parallel operation.");
                }
                throw new IgniteDataStreamerTimeoutException("Data streamer exceeded timeout when starts parallel operation.");
            }
        }

        private void signalTaskFinished(IgniteInternalFuture<Object> f) {
            assert (f != null);
            this.sem.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void localUpdate(final Collection<DataStreamerEntry> entries, final AffinityTopologyVersion reqTopVer, final GridFutureAdapter<Object> curFut, final byte plc) {
            try {
                GridCacheContext cctx = DataStreamerImpl.this.ctx.cache().internalCache(DataStreamerImpl.this.cacheName).context();
                boolean lockTop = !cctx.isLocal() && !DataStreamerImpl.this.allowOverwrite();
                IgniteInternalFuture topWaitFut = null;
                if (lockTop) {
                    cctx.topology().readLock();
                }
                try {
                    AffinityTopologyVersion streamerFutTopVer = null;
                    if (lockTop) {
                        AffinityTopologyVersion topVer;
                        GridDhtTopologyFuture topFut = cctx.topologyVersionFuture();
                        AffinityTopologyVersion affinityTopologyVersion = topVer = topFut.isDone() ? topFut.topologyVersion() : topFut.initialVersion();
                        if (topVer.compareTo(reqTopVer) > 0) {
                            curFut.onDone(new IgniteCheckedException("DataStreamer will retry data transfer at stable topology. reqTop=" + reqTopVer + ", topVer=" + topFut.initialVersion() + ", node=local]"));
                            return;
                        }
                        if (!topFut.isDone()) {
                            topWaitFut = topFut;
                        } else {
                            streamerFutTopVer = topFut.topologyVersion();
                        }
                    }
                    if (topWaitFut == null) {
                        IgniteInternalFuture<Object> callFut = DataStreamerImpl.this.ctx.closure().callLocalSafe(new DataStreamerUpdateJob(DataStreamerImpl.this.ctx, log, DataStreamerImpl.this.cacheName, entries, false, DataStreamerImpl.this.skipStore, DataStreamerImpl.this.keepBinary, DataStreamerImpl.this.rcvr), plc);
                        this.locFuts.add(callFut);
                        final GridFutureAdapter waitFut = lockTop ? cctx.mvcc().addDataStreamerFuture(streamerFutTopVer) : null;
                        callFut.listen(new IgniteInClosure<IgniteInternalFuture<Object>>(){

                            @Override
                            public void apply(IgniteInternalFuture<Object> t) {
                                try {
                                    boolean rmv = Buffer.this.locFuts.remove(t);
                                    assert (rmv);
                                    curFut.onDone(t.get());
                                }
                                catch (IgniteCheckedException e) {
                                    curFut.onDone(e);
                                }
                                finally {
                                    if (waitFut != null) {
                                        waitFut.onDone();
                                    }
                                }
                            }
                        });
                    }
                }
                finally {
                    if (lockTop) {
                        cctx.topology().readUnlock();
                    }
                }
                if (topWaitFut != null) {
                    topWaitFut.listen(new IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>(){

                        @Override
                        public void apply(IgniteInternalFuture<AffinityTopologyVersion> e) {
                            Buffer.this.localUpdate(entries, reqTopVer, curFut, plc);
                        }
                    });
                }
            }
            catch (Throwable ex) {
                curFut.onDone(new IgniteCheckedException("DataStreamer data handling failed.", ex));
            }
        }

        private void submit(Collection<DataStreamerEntry> entries, @Nullable AffinityTopologyVersion topVer, GridFutureAdapter<Object> curFut, boolean remap, int partId) throws IgniteInterruptedCheckedException {
            assert (entries != null);
            assert (!entries.isEmpty());
            assert (curFut != null);
            if (!remap) {
                try {
                    this.incrementActiveTasks();
                }
                catch (IgniteDataStreamerTimeoutException e) {
                    curFut.onDone(e);
                    throw e;
                }
            }
            byte plc = DataStreamProcessor.ioPolicy(DataStreamerImpl.this.ioPlcRslvr, this.node);
            if (this.isLocNode) {
                this.localUpdate(entries, topVer, curFut, plc);
            } else {
                try {
                    for (DataStreamerEntry e : entries) {
                        e.getKey().prepareMarshal(DataStreamerImpl.this.cacheObjCtx);
                        CacheObject val = e.getValue();
                        if (val == null) continue;
                        val.prepareMarshal(DataStreamerImpl.this.cacheObjCtx);
                    }
                    if (DataStreamerImpl.this.updaterBytes == null) {
                        assert (DataStreamerImpl.this.rcvr != null);
                        DataStreamerImpl.access$3602(DataStreamerImpl.this, U.marshal(DataStreamerImpl.this.ctx, (Object)DataStreamerImpl.this.rcvr));
                    }
                    if (DataStreamerImpl.this.topicBytes == null) {
                        DataStreamerImpl.access$3702(DataStreamerImpl.this, U.marshal(DataStreamerImpl.this.ctx, DataStreamerImpl.this.topic));
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(log, "Failed to marshal.", e);
                    curFut.onDone(new IgniteException("Failed to marshal.", e));
                    return;
                }
                GridDeployment dep = null;
                GridPeerDeployAware jobPda0 = DataStreamerImpl.this.jobPda;
                if (DataStreamerImpl.this.ctx.deploy().enabled() && jobPda0 != null) {
                    try {
                        dep = DataStreamerImpl.this.ctx.deploy().deploy(jobPda0.deployClass(), jobPda0.classLoader());
                        GridCacheAdapter cache = DataStreamerImpl.this.ctx.cache().internalCache(DataStreamerImpl.this.cacheName);
                        if (cache != null) {
                            cache.context().deploy().onEnter();
                        }
                    }
                    catch (IgniteCheckedException e) {
                        U.error(log, "Failed to deploy class: " + jobPda0.deployClass(), e);
                        curFut.onDone(new IgniteException("Failed to deploy class: " + jobPda0.deployClass(), e));
                        return;
                    }
                    if (dep == null) {
                        U.warn(log, "Failed to deploy class (request will be sent): " + jobPda0.deployClass());
                    }
                }
                long reqId = this.idGen.incrementAndGet();
                GridFutureAdapter<Object> fut = curFut;
                this.reqs.put(reqId, fut);
                if (topVer == null) {
                    topVer = DataStreamerImpl.this.ctx.cache().context().exchange().readyAffinityVersion();
                }
                DataStreamerRequest req = new DataStreamerRequest(reqId, DataStreamerImpl.this.topicBytes, DataStreamerImpl.this.cacheName, DataStreamerImpl.this.updaterBytes, entries, true, DataStreamerImpl.this.skipStore, DataStreamerImpl.this.keepBinary, dep != null ? dep.deployMode() : null, dep != null ? jobPda0.deployClass().getName() : null, dep != null ? dep.userVersion() : null, dep != null ? dep.participants() : null, dep != null ? dep.classLoaderId() : null, dep == null, topVer, DataStreamerImpl.this.rcvr == ISOLATED_UPDATER ? partId : GridIoMessage.STRIPE_DISABLED_PART);
                try {
                    DataStreamerImpl.this.ctx.io().sendToGridTopic(this.node, GridTopic.TOPIC_DATASTREAM, (Message)req, plc);
                    if (log.isDebugEnabled()) {
                        log.debug("Sent request to node [nodeId=" + this.node.id() + ", req=" + req + ']');
                    }
                }
                catch (ClusterTopologyCheckedException e) {
                    GridFutureAdapter<Object> fut0 = fut;
                    fut0.onDone(e);
                }
                catch (IgniteCheckedException e) {
                    GridFutureAdapter<Object> fut0 = fut;
                    if (X.hasCause((Throwable)e, IgniteClientDisconnectedCheckedException.class, IgniteClientDisconnectedException.class)) {
                        fut0.onDone(e);
                    }
                    try {
                        if (DataStreamerImpl.this.ctx.discovery().alive(this.node) && DataStreamerImpl.this.ctx.discovery().pingNode(this.node.id())) {
                            fut0.onDone(e);
                        } else {
                            fut0.onDone(new ClusterTopologyCheckedException("Failed to send request (node has left): " + this.node.id()));
                        }
                    }
                    catch (IgniteClientDisconnectedCheckedException e0) {
                        fut0.onDone(e0);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onNodeLeft() {
            assert (!this.isLocNode);
            assert (DataStreamerImpl.this.bufMappings.get(this.node.id()) != this);
            if (log.isDebugEnabled()) {
                log.debug("Forcibly completing futures (node has left): " + this.node.id());
            }
            ClusterTopologyCheckedException e = new ClusterTopologyCheckedException("Failed to wait for request completion (node has left): " + this.node.id());
            for (GridFutureAdapter f : this.reqs.values()) {
                f.onDone(e);
            }
            PerStripeBuffer[] perStripeBufferArray = this.stripes;
            int n = perStripeBufferArray.length;
            for (int i = 0; i < n; ++i) {
                GridFutureAdapter curFut0;
                PerStripeBuffer b;
                PerStripeBuffer perStripeBuffer = b = perStripeBufferArray[i];
                synchronized (perStripeBuffer) {
                    curFut0 = b.curFut;
                }
                curFut0.onDone(e);
            }
        }

        void onResponse(DataStreamerResponse res, UUID nodeId) {
            GridFutureAdapter f;
            if (log.isDebugEnabled()) {
                log.debug("Received data load response: " + res);
            }
            if ((f = (GridFutureAdapter)this.reqs.remove(res.requestId())) == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Future for request has not been found: " + res.requestId());
                }
                return;
            }
            IgniteCheckedException err = null;
            byte[] errBytes = res.errorBytes();
            if (errBytes != null) {
                try {
                    GridPeerDeployAware jobPda0 = DataStreamerImpl.this.jobPda;
                    Throwable cause = (Throwable)U.unmarshal(DataStreamerImpl.this.ctx, errBytes, U.resolveClassLoader(jobPda0 != null ? jobPda0.classLoader() : null, DataStreamerImpl.this.ctx.config()));
                    String msg = "DataStreamer request failed [node=" + nodeId + "]";
                    err = cause instanceof ClusterTopologyCheckedException ? new ClusterTopologyCheckedException(msg, cause) : new IgniteCheckedException(msg, cause);
                }
                catch (IgniteCheckedException e) {
                    f.onDone(null, new IgniteCheckedException("Failed to unmarshal response.", e));
                    return;
                }
            }
            f.onDone(null, err);
            if (log.isDebugEnabled()) {
                log.debug("Finished future [fut=" + f + ", reqId=" + res.requestId() + ", err=" + err + ']');
            }
        }

        void cancelAll(IgniteCheckedException err) {
            for (IgniteInternalFuture<Object> igniteInternalFuture : this.locFuts) {
                try {
                    igniteInternalFuture.cancel();
                }
                catch (IgniteCheckedException e) {
                    U.error(log, "Failed to cancel mini-future.", e);
                }
            }
            for (GridFutureAdapter gridFutureAdapter : this.reqs.values()) {
                gridFutureAdapter.onDone(err);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            int size = 0;
            for (int i = 0; i < this.stripes.length; ++i) {
                PerStripeBuffer b;
                PerStripeBuffer perStripeBuffer = b = this.stripes[i];
                synchronized (perStripeBuffer) {
                    size += b.entries.size();
                    continue;
                }
            }
            return S.toString(Buffer.class, this, "entriesCnt", (Object)size, "locFutsSize", this.locFuts.size(), "reqsSize", this.reqs.size());
        }
    }

    private class ThreadBuffer {
        private final List<DataStreamerEntry> entries;
        private final IgniteCacheFutureImpl fut;

        private ThreadBuffer(IgniteCacheFutureImpl fut, List<DataStreamerEntry> entries) {
            assert (fut != null);
            assert (entries != null);
            this.fut = fut;
            this.entries = entries;
        }

        private List<DataStreamerEntry> getEntries() {
            return this.entries;
        }

        private IgniteCacheFutureImpl getFuture() {
            return this.fut;
        }
    }
}

