/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.version;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridCacheVersionManager
extends GridCacheSharedManagerAdapter {
    public static final GridCacheVersion EVICT_VER = new GridCacheVersion(Integer.MAX_VALUE, 0L, 0, 0);
    public static final long TOP_VER_BASE_TIME = 1388520000000L;
    private final AtomicLong order = new AtomicLong(U.currentTimeMillis());
    private final AtomicLong loadOrder = new AtomicLong(0L);
    private GridCacheVersion startVer;
    private volatile GridCacheVersion last;
    private byte dataCenterId;
    private long gridStartTime;
    private GridCacheVersion ISOLATED_STREAMER_VER;
    private final GridLocalEventListener discoLsnr = new GridLocalEventListener(){

        @Override
        public void onEvent(Event evt) {
            assert (evt.type() == 13);
            DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
            ClusterNode node = GridCacheVersionManager.this.cctx.discovery().node(discoEvt.node().id());
            if (node != null && !node.id().equals(GridCacheVersionManager.this.cctx.localNodeId())) {
                GridCacheVersionManager.this.onReceived(discoEvt.eventNode().id(), node.metrics().getLastDataVersion());
            }
        }
    };

    @Override
    public void start0() throws IgniteCheckedException {
        this.last = new GridCacheVersion(0, this.order.get(), 0, this.dataCenterId);
        this.startVer = new GridCacheVersion(0, 0L, 0, this.dataCenterId);
        this.cctx.gridEvents().addLocalEventListener(this.discoLsnr, 13, new int[0]);
    }

    @Override
    protected void stop0(boolean cancel) {
        this.cctx.gridEvents().removeLocalEventListener(this.discoLsnr, 13);
    }

    public void dataCenterId(byte dataCenterId) {
        this.dataCenterId = dataCenterId;
        this.last = new GridCacheVersion(0, this.order.get(), 0, dataCenterId);
        this.startVer = new GridCacheVersion(0, 0L, 0, dataCenterId);
    }

    public void onReceived(UUID nodeId, GridCacheVersion ver) {
        this.onReceived(nodeId, ver.order());
    }

    public void onReceived(UUID nodeId, long ver) {
        block3: {
            long order;
            if (ver <= 0L) break block3;
            while (ver > (order = this.order.get())) {
                if (!this.order.compareAndSet(order, ver)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Updated version from node [nodeId=" + nodeId + ", ver=" + ver + ']');
                }
                break block3;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Did not update version from node (version has lower order) [nodeId=" + nodeId + ", ver=" + ver + ", curOrder=" + this.order + ']');
            }
        }
    }

    public void onExchange(long rcvOrder) {
        long order;
        while (rcvOrder > (order = this.order.get()) && !this.order.compareAndSet(order, rcvOrder)) {
        }
    }

    public GridCacheVersion onReceivedAndNext(UUID nodeId, GridCacheVersion ver) {
        this.onReceived(nodeId, ver);
        return this.next(ver);
    }

    public GridCacheVersion isolatedStreamerVersion() {
        if (this.ISOLATED_STREAMER_VER == null) {
            long topVer = 1L;
            if (this.gridStartTime == 0L) {
                this.gridStartTime = this.cctx.kernalContext().discovery().gridStartTime();
            }
            this.ISOLATED_STREAMER_VER = new GridCacheVersion((int)(topVer += (this.gridStartTime - 1388520000000L) / 1000L), 0L, 1, this.dataCenterId);
        }
        return this.ISOLATED_STREAMER_VER;
    }

    public GridCacheVersion next() {
        return this.next(this.cctx.kernalContext().discovery().topologyVersion(), true, false, this.dataCenterId);
    }

    public GridCacheVersion next(byte dataCenterId) {
        return this.next(this.cctx.kernalContext().discovery().topologyVersion(), true, false, dataCenterId);
    }

    public GridCacheVersion next(AffinityTopologyVersion topVer) {
        return this.next(topVer.topologyVersion(), true, false, this.dataCenterId);
    }

    public GridCacheVersion nextForLoad() {
        return this.next(this.cctx.kernalContext().discovery().topologyVersion(), true, true, this.dataCenterId);
    }

    public GridCacheVersion nextForLoad(AffinityTopologyVersion topVer) {
        return this.next(topVer.topologyVersion(), true, true, this.dataCenterId);
    }

    public GridCacheVersion nextForLoad(GridCacheVersion ver) {
        return this.next(ver.topologyVersion(), false, true, this.dataCenterId);
    }

    public GridCacheVersion next(GridCacheVersion ver) {
        return this.next(ver.topologyVersion(), false, false, this.dataCenterId);
    }

    private GridCacheVersion next(long topVer, boolean addTime, boolean forLoad, byte dataCenterId) {
        GridCacheVersion next;
        if (topVer == -1L) {
            topVer = this.cctx.kernalContext().discovery().topologyVersion();
        }
        if (addTime) {
            if (this.gridStartTime == 0L) {
                this.gridStartTime = this.cctx.kernalContext().discovery().gridStartTime();
            }
            topVer += (this.gridStartTime - 1388520000000L) / 1000L;
        }
        int locNodeOrder = (int)this.cctx.localNode().order();
        long ord = forLoad ? this.loadOrder.incrementAndGet() : this.order.incrementAndGet();
        this.last = next = new GridCacheVersion((int)topVer, ord, locNodeOrder, dataCenterId);
        return next;
    }

    public GridCacheVersion last() {
        return this.last;
    }

    public GridCacheVersion startVersion() {
        assert (this.startVer != null);
        return this.startVer;
    }

    public boolean isStartVersion(GridCacheVersion ver) {
        return this.startVer.equals(ver);
    }
}

