/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.processors.cache.distributed.dht.PartitionUpdateCountersMessage;
import org.jetbrains.annotations.Nullable;

public class TxCounters {
    private final Map<Integer, Map<Integer, AtomicLong>> sizeDeltas = new ConcurrentHashMap<Integer, Map<Integer, AtomicLong>>();
    private final Map<Integer, Map<Integer, AtomicLong>> updCntrsAcc = new HashMap<Integer, Map<Integer, AtomicLong>>();
    private volatile Collection<PartitionUpdateCountersMessage> updCntrs;
    private final AtomicInteger lockCntr = new AtomicInteger();

    public void accumulateSizeDelta(int cacheId, int part, long delta) {
        AtomicLong accDelta = this.accumulator(this.sizeDeltas, cacheId, part);
        accDelta.set(accDelta.get() + delta);
    }

    public Map<Integer, Map<Integer, AtomicLong>> sizeDeltas() {
        return this.sizeDeltas;
    }

    public void updateCounters(Collection<PartitionUpdateCountersMessage> updCntrs) {
        this.updCntrs = updCntrs;
    }

    @Nullable
    public Collection<PartitionUpdateCountersMessage> updateCounters() {
        return this.updCntrs;
    }

    public Map<Integer, Map<Integer, AtomicLong>> accumulatedUpdateCounters() {
        return this.updCntrsAcc;
    }

    public void incrementUpdateCounter(int cacheId, int part) {
        this.accumulator(this.updCntrsAcc, cacheId, part).incrementAndGet();
    }

    public void decrementUpdateCounter(int cacheId, int part) {
        long acc = this.accumulator(this.updCntrsAcc, cacheId, part).decrementAndGet();
        assert (acc >= 0L);
    }

    private AtomicLong accumulator(Map<Integer, Map<Integer, AtomicLong>> accMap, int cacheId, int part) {
        AtomicLong acc;
        Map cacheAccs = accMap.get(cacheId);
        if (cacheAccs == null) {
            cacheAccs = new ConcurrentHashMap<Integer, AtomicLong>();
            Map cacheAccs0 = accMap.putIfAbsent(cacheId, cacheAccs);
            if (cacheAccs0 != null) {
                cacheAccs = cacheAccs0;
            }
        }
        if ((acc = cacheAccs.get(part)) == null) {
            acc = new AtomicLong();
            AtomicLong accDelta0 = cacheAccs.putIfAbsent(part, acc);
            if (accDelta0 != null) {
                acc = accDelta0;
            }
        }
        return acc;
    }

    public void incrementLockCounter() {
        this.lockCntr.incrementAndGet();
    }

    public int lockCounter() {
        return this.lockCntr.get();
    }
}

