/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.continuous;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteDeploymentCheckedException;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfo;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfoBean;
import org.apache.ignite.internal.util.typedef.internal.U;

class CacheContinuousQueryDeployableObject
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private byte[] bytes;
    private String clsName;
    private GridDeploymentInfo depInfo;

    public CacheContinuousQueryDeployableObject() {
    }

    protected CacheContinuousQueryDeployableObject(Object obj, GridKernalContext ctx) throws IgniteCheckedException {
        assert (obj != null);
        assert (ctx != null);
        Class<?> cls = U.detectClass(obj);
        this.clsName = cls.getName();
        GridDeployment dep = ctx.deploy().deploy(cls, U.detectClassLoader(cls));
        if (dep == null) {
            throw new IgniteDeploymentCheckedException("Failed to deploy object: " + obj);
        }
        this.depInfo = new GridDeploymentInfoBean(dep);
        this.bytes = U.marshal(ctx, obj);
    }

    <T> T unmarshal(UUID nodeId, GridKernalContext ctx) throws IgniteCheckedException {
        assert (ctx != null);
        GridDeployment dep = ctx.deploy().getGlobalDeployment(this.depInfo.deployMode(), this.clsName, this.clsName, this.depInfo.userVersion(), nodeId, this.depInfo.classLoaderId(), this.depInfo.participants(), null);
        if (dep == null) {
            throw new IgniteDeploymentCheckedException("Failed to obtain deployment for class: " + this.clsName);
        }
        return U.unmarshal(ctx, this.bytes, U.resolveClassLoader(dep.classLoader(), ctx.config()));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeByteArray(out, this.bytes);
        U.writeString(out, this.clsName);
        out.writeObject(this.depInfo);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.bytes = U.readByteArray(in);
        this.clsName = U.readString(in);
        this.depInfo = (GridDeploymentInfo)in.readObject();
    }
}

