/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.filehandle;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.pagemem.wal.record.SwitchSegmentRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentedRingByteBuffer;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.AbstractFileHandle;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.FileHandleManagerImpl;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.FileWriteHandle;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactoryImpl;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

class FileWriteHandleImpl
extends AbstractFileHandle
implements FileWriteHandle {
    private static final Method force0 = IgniteUtils.findNonPublicMethod(MappedByteBuffer.class, "force0", FileDescriptor.class, Long.TYPE, Long.TYPE);
    private static final AtomicLongFieldUpdater<FileWriteHandleImpl> WRITTEN_UPD = AtomicLongFieldUpdater.newUpdater(FileWriteHandleImpl.class, "written");
    private static final Method mappingOffset = IgniteUtils.findNonPublicMethod(MappedByteBuffer.class, "mappingOffset", new Class[0]);
    private static final Method mappingAddress = IgniteUtils.findNonPublicMethod(MappedByteBuffer.class, "mappingAddress", Long.TYPE);
    private static final Field fd = IgniteUtils.findField(MappedByteBuffer.class, "fd");
    private static final int PAGE_SIZE = GridUnsafe.pageSize();
    private final int serializerVer = IgniteSystemProperties.getInteger("IGNITE_WAL_SERIALIZER_VERSION", 2);
    private final boolean mmap;
    private volatile boolean resume;
    volatile long written;
    protected volatile long lastFsyncPos;
    protected final AtomicBoolean stop = new AtomicBoolean(false);
    private final Lock lock = new ReentrantLock();
    private final Condition fsync = this.lock.newCondition();
    private final Condition nextSegment = this.lock.newCondition();
    protected final SegmentedRingByteBuffer buf;
    private final WALMode mode;
    private final long fsyncDelay;
    private final DataStorageMetricsImpl metrics;
    private final long maxWalSegmentSize;
    protected final IgniteLogger log;
    private final RecordSerializer serializer;
    protected final GridCacheSharedContext cctx;
    private final FileHandleManagerImpl.WALWriter walWriter;
    private int switchSegmentRecordOffset;

    FileWriteHandleImpl(GridCacheSharedContext cctx, SegmentIO fileIO, SegmentedRingByteBuffer rbuf, RecordSerializer serializer, DataStorageMetricsImpl metrics, FileHandleManagerImpl.WALWriter writer, long pos, WALMode mode, boolean mmap, boolean resume, long fsyncDelay, long maxWalSegmentSize) throws IOException {
        super(fileIO);
        assert (serializer != null);
        this.mmap = mmap;
        this.mode = mode;
        this.fsyncDelay = fsyncDelay;
        this.metrics = metrics;
        this.maxWalSegmentSize = maxWalSegmentSize;
        this.log = cctx.logger(FileWriteHandleImpl.class);
        this.cctx = cctx;
        this.walWriter = writer;
        this.serializer = serializer;
        this.written = pos;
        this.lastFsyncPos = pos;
        this.resume = resume;
        this.buf = rbuf;
        if (!mmap) {
            fileIO.position(pos);
        }
    }

    @Override
    public int serializerVersion() {
        return this.serializer.version();
    }

    @Override
    public void finishResumeLogging() {
        this.resume = false;
    }

    private void checkNode() throws StorageException {
        if (this.cctx.kernalContext().invalid()) {
            throw new StorageException("Failed to perform WAL operation (environment was invalidated by a previous error)");
        }
    }

    @Override
    public void writeHeader() {
        SegmentedRingByteBuffer.WriteSegment seg = this.buf.offer(29);
        assert (seg != null && seg.position() > 0L);
        FileWriteAheadLogManager.prepareSerializerVersionBuffer(this.getSegmentId(), this.serializerVer, false, seg.buffer());
        seg.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public WALPointer addRecord(WALRecord rec) throws StorageException, IgniteCheckedException {
        assert (rec.size() > 0) : rec;
        while (true) {
            this.checkNode();
            SegmentedRingByteBuffer.WriteSegment seg = rec.type() == WALRecord.RecordType.SWITCH_SEGMENT_RECORD && !this.resume ? this.buf.offerSafe(rec.size()) : this.buf.offer(rec.size());
            FileWALPointer ptr = null;
            if (seg != null) {
                FileWALPointer fileWALPointer;
                ByteBuffer buf;
                int pos;
                block11: {
                    pos = (int)(seg.position() - (long)rec.size());
                    buf = seg.buffer();
                    if (buf != null) break block11;
                    WALPointer wALPointer = null;
                    seg.release();
                    if (this.mode == WALMode.BACKGROUND && rec instanceof CheckpointRecord) {
                        this.flushOrWait(ptr);
                    }
                    return wALPointer;
                }
                try {
                    ptr = new FileWALPointer(this.getSegmentId(), pos, rec.size());
                    rec.position(ptr);
                    this.fillBuffer(buf, rec);
                    if (this.mmap) {
                        long written0;
                        do {
                            written0 = this.written;
                        } while (seg.position() > written0 && !WRITTEN_UPD.compareAndSet(this, written0, seg.position()));
                    }
                    fileWALPointer = ptr;
                    seg.release();
                }
                catch (Throwable throwable) {
                    seg.release();
                    if (this.mode == WALMode.BACKGROUND && rec instanceof CheckpointRecord) {
                        this.flushOrWait(ptr);
                    }
                    throw throwable;
                }
                if (this.mode == WALMode.BACKGROUND && rec instanceof CheckpointRecord) {
                    this.flushOrWait(ptr);
                }
                return fileWALPointer;
            }
            this.walWriter.flushAll();
        }
    }

    public void flushOrWait(FileWALPointer ptr) throws IgniteCheckedException {
        if (ptr != null && ptr.index() != this.getSegmentId()) {
            return;
        }
        this.flush(ptr);
    }

    @Override
    public void flushAll() throws IgniteCheckedException {
        this.flush(null);
    }

    public void flush(FileWALPointer ptr) throws IgniteCheckedException {
        if (ptr == null) {
            this.walWriter.flushAll();
            return;
        }
        assert (ptr.index() == this.getSegmentId());
        this.walWriter.flushBuffer(ptr.fileOffset());
    }

    private void fillBuffer(ByteBuffer buf, WALRecord rec) throws IgniteCheckedException {
        try {
            this.serializer.writeRecord(rec, buf);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Failed to write record: " + rec, e);
        }
    }

    @Override
    public boolean needFsync(FileWALPointer ptr) {
        return this.getSegmentId() == ptr.index() && this.lastFsyncPos <= (long)ptr.fileOffset();
    }

    @Override
    public FileWALPointer position() {
        this.lock.lock();
        try {
            FileWALPointer fileWALPointer = new FileWALPointer(this.getSegmentId(), (int)this.written, 0);
            return fileWALPointer;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fsync(FileWALPointer ptr) throws StorageException, IgniteCheckedException {
        this.lock.lock();
        try {
            if (ptr != null) {
                if (!this.needFsync(ptr)) {
                    return;
                }
                if (this.fsyncDelay > 0L && !this.stop.get()) {
                    U.await(this.fsync, this.fsyncDelay, TimeUnit.NANOSECONDS);
                    if (!this.needFsync(ptr)) {
                        return;
                    }
                }
            }
            this.flushOrWait(ptr);
            if (this.stop.get()) {
                return;
            }
            long lastFsyncPos0 = this.lastFsyncPos;
            long written0 = this.written;
            if (lastFsyncPos0 != written0) {
                long end;
                long start;
                assert (lastFsyncPos0 < written0) : "lastFsyncPos=" + lastFsyncPos0 + ", written=" + written0;
                boolean metricsEnabled = this.metrics.metricsEnabled();
                long l = start = metricsEnabled ? System.nanoTime() : 0L;
                if (this.mmap) {
                    long pos = ptr == null ? -1L : (long)ptr.fileOffset();
                    List<SegmentedRingByteBuffer.ReadSegment> segs = this.buf.poll(pos);
                    if (segs != null) {
                        assert (segs.size() == 1);
                        SegmentedRingByteBuffer.ReadSegment seg = segs.get(0);
                        int off = seg.buffer().position();
                        int len = seg.buffer().limit() - off;
                        this.fsync((MappedByteBuffer)this.buf.buf, off, len);
                        seg.release();
                    }
                } else {
                    this.walWriter.force();
                }
                this.lastFsyncPos = this.written;
                if (this.fsyncDelay > 0L) {
                    this.fsync.signalAll();
                }
                long l2 = end = metricsEnabled ? System.nanoTime() : 0L;
                if (metricsEnabled) {
                    this.metrics.onFsync(end - start);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void fsync(MappedByteBuffer buf, int off, int len) throws IgniteCheckedException {
        try {
            long mappedOff = (Long)mappingOffset.invoke((Object)buf, new Object[0]);
            assert (mappedOff == 0L) : mappedOff;
            long addr = (Long)mappingAddress.invoke((Object)buf, mappedOff);
            long delta = (addr + (long)off) % (long)PAGE_SIZE;
            long alignedAddr = addr + (long)off - delta;
            force0.invoke((Object)buf, fd.get(buf), alignedAddr, (long)len + delta);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IgniteCheckedException(e);
        }
    }

    @Override
    public void closeBuffer() {
        this.buf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close(boolean rollOver) throws IgniteCheckedException, StorageException {
        if (this.stop.compareAndSet(false, true)) {
            this.lock.lock();
            try {
                this.flushOrWait(null);
                try {
                    List<SegmentedRingByteBuffer.ReadSegment> segs;
                    RecordSerializer backwardSerializer = new RecordSerializerFactoryImpl(this.cctx).createSerializer(this.serializerVer);
                    SwitchSegmentRecord segmentRecord = new SwitchSegmentRecord();
                    int switchSegmentRecSize = backwardSerializer.size(segmentRecord);
                    if (rollOver && this.written < this.maxWalSegmentSize - (long)switchSegmentRecSize) {
                        segmentRecord.size(switchSegmentRecSize);
                        WALPointer segRecPtr = this.addRecord(segmentRecord);
                        if (segRecPtr != null) {
                            FileWALPointer filePtr = (FileWALPointer)segRecPtr;
                            this.fsync(filePtr);
                            this.switchSegmentRecordOffset = filePtr.fileOffset() + switchSegmentRecSize;
                        }
                    }
                    if (this.mmap && (segs = this.buf.poll(this.maxWalSegmentSize)) != null) {
                        assert (segs.size() == 1);
                        segs.get(0).release();
                    }
                    if (this.mode != WALMode.NONE) {
                        if (this.mmap) {
                            ((MappedByteBuffer)this.buf.buf).force();
                        } else {
                            this.fileIO.force();
                        }
                        this.lastFsyncPos = this.written;
                    }
                    if (this.mmap) {
                        try {
                            this.fileIO.close();
                        }
                        catch (IOException iOException) {}
                    } else {
                        this.walWriter.close();
                        if (!rollOver) {
                            this.buf.free();
                        }
                    }
                }
                catch (IOException e) {
                    throw new StorageException("Failed to close WAL write handle [idx=" + this.getSegmentId() + "]", e);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Closed WAL write handle [idx=" + this.getSegmentId() + "]");
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (this.mmap) {
                    this.buf.free();
                }
                this.lock.unlock();
            }
        }
        return false;
    }

    @Override
    public void signalNextAvailable() {
        this.lock.lock();
        try {
            assert (this.cctx.kernalContext().invalid() || this.written == this.lastFsyncPos || this.mode != WALMode.FSYNC) : "fsync [written=" + this.written + ", lastFsync=" + this.lastFsyncPos + ", idx=" + this.getSegmentId() + ']';
            this.fileIO = null;
            this.nextSegment.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void awaitNext() {
        this.lock.lock();
        try {
            while (this.fileIO != null) {
                U.awaitQuiet(this.nextSegment);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String safePosition() {
        SegmentIO io = this.fileIO;
        if (io == null) {
            return "null";
        }
        try {
            return String.valueOf(io.position());
        }
        catch (IOException e) {
            return "{Failed to read channel position: " + e.getMessage() + '}';
        }
    }

    @Override
    public int getSwitchSegmentRecordOffset() {
        return this.switchSegmentRecordOffset;
    }
}

