/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal;

import java.io.File;
import java.io.FileNotFoundException;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentAware;

public class SegmentRouter {
    public static final String ZIP_SUFFIX = ".zip";
    private File walWorkDir;
    private File walArchiveDir;
    private SegmentAware segmentAware;
    private DataStorageConfiguration dsCfg;

    public SegmentRouter(File walWorkDir, File walArchiveDir, SegmentAware segmentAware, DataStorageConfiguration dsCfg) {
        this.walWorkDir = walWorkDir;
        this.walArchiveDir = walArchiveDir;
        this.segmentAware = segmentAware;
        this.dsCfg = dsCfg;
    }

    public FileDescriptor findSegment(long segmentId) throws FileNotFoundException {
        FileDescriptor fd = this.segmentAware.lastArchivedAbsoluteIndex() >= segmentId || !this.isArchiverEnabled() ? new FileDescriptor(new File(this.walArchiveDir, FileDescriptor.fileName(segmentId))) : new FileDescriptor(new File(this.walWorkDir, FileDescriptor.fileName(segmentId % (long)this.dsCfg.getWalSegments())), segmentId);
        if (!fd.file().exists()) {
            FileDescriptor zipFile = new FileDescriptor(new File(this.walArchiveDir, FileDescriptor.fileName(fd.idx()) + ZIP_SUFFIX));
            if (!zipFile.file().exists()) {
                throw new FileNotFoundException("Both compressed and raw segment files are missing in archive [segmentIdx=" + fd.idx() + "]");
            }
            fd = zipFile;
        }
        return fd;
    }

    private boolean isArchiverEnabled() {
        if (this.walArchiveDir != null && this.walWorkDir != null) {
            return !this.walArchiveDir.equals(this.walWorkDir);
        }
        return !new File(this.dsCfg.getWalArchivePath()).equals(new File(this.dsCfg.getWalPath()));
    }
}

