/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.metastorage;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.Storable;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageSearchRow;

public class MetastorageDataRow
implements MetastorageSearchRow,
Storable {
    private long link;
    private String key;
    private byte[] value;

    public MetastorageDataRow(long link, String key, byte[] value) {
        this.link = link;
        this.key = key;
        this.value = value;
    }

    public MetastorageDataRow(String key, byte[] value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public int hash() {
        return this.key.hashCode();
    }

    @Override
    public int partition() {
        return MetaStorage.PRESERVE_LEGACY_METASTORAGE_PARTITION_ID ? 0 : 1;
    }

    @Override
    public int size() throws IgniteCheckedException {
        return 4 + this.value().length;
    }

    @Override
    public int headerSize() {
        return 0;
    }

    @Override
    public void link(long link) {
        this.link = link;
    }

    @Override
    public long link() {
        return this.link;
    }

    public byte[] value() {
        return this.value;
    }

    public String toString() {
        return "key=" + this.key;
    }
}

