/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.metastorage;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.MetastoreDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageInitRecord;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IncompleteObject;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.DbCheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.freelist.AbstractFreeList;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageDataRow;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageRowStore;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageTree;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPagePayload;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.SimpleDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.jetbrains.annotations.NotNull;

public class MetaStorage
implements DbCheckpointListener,
ReadOnlyMetastorage,
ReadWriteMetastorage {
    public static final String METASTORAGE_CACHE_NAME = "MetaStorage";
    public static final int METASTORAGE_CACHE_ID = CU.cacheId("MetaStorage");
    public static boolean PRESERVE_LEGACY_METASTORAGE_PARTITION_ID = false;
    private static final byte[] TOMBSTONE = new byte[0];
    private static final int TEMPORARY_METASTORAGE_IN_MEMORY_SIZE = 0x8000000;
    private static final int TEMPORARY_METASTORAGE_BUFFER_SIZE = 0x100000;
    private final IgniteWriteAheadLogManager wal;
    private final DataRegion dataRegion;
    private final IgniteLogger log;
    private MetastorageTree tree;
    private AtomicLong rmvId = new AtomicLong();
    private DataRegionMetricsImpl regionMetrics;
    private final boolean readOnly;
    private boolean empty;
    private RootPage treeRoot;
    private RootPage reuseListRoot;
    private FreeListImpl freeList;
    private Map<String, byte[]> lastUpdates;
    private final Marshaller marshaller = new JdkMarshaller();
    private final FailureProcessor failureProcessor;
    private int partId;
    private final GridCacheSharedContext cctx;

    public MetaStorage(GridCacheSharedContext cctx, DataRegion dataRegion, DataRegionMetricsImpl regionMetrics, boolean readOnly) {
        this.cctx = cctx;
        this.wal = cctx.wal();
        this.dataRegion = dataRegion;
        this.regionMetrics = regionMetrics;
        this.readOnly = readOnly;
        this.log = cctx.logger(this.getClass());
        this.failureProcessor = cctx.kernalContext().failure();
    }

    public void init(GridCacheDatabaseSharedManager db) throws IgniteCheckedException {
        this.regionMetrics.clear();
        this.initInternal(db);
        if (!PRESERVE_LEGACY_METASTORAGE_PARTITION_ID) {
            GridCacheProcessor gcProcessor = this.cctx.kernalContext().cache();
            if (this.partId == 0) {
                gcProcessor.setTmpStorage(this.copyDataToTmpStorage());
            } else if (gcProcessor.getTmpStorage() != null) {
                this.restoreDataFromTmpStorage(gcProcessor.getTmpStorage());
                gcProcessor.setTmpStorage(null);
                CacheGroupContext cgc = this.cctx.cache().cacheGroup(METASTORAGE_CACHE_ID);
                if (cgc != null) {
                    db.schedulePartitionDestroy(METASTORAGE_CACHE_ID, 0);
                    db.schedulePartitionDestroy(METASTORAGE_CACHE_ID, 65535);
                }
            }
        }
    }

    private TmpStorage copyDataToTmpStorage() throws IgniteCheckedException {
        TmpStorage tmpStorage = new TmpStorage(0x8000000, this.log);
        GridCursor cur = this.tree.find(null, null);
        while (cur.next()) {
            MetastorageDataRow row = (MetastorageDataRow)cur.get();
            tmpStorage.add(row.key(), row.value());
        }
        return tmpStorage;
    }

    private void restoreDataFromTmpStorage(TmpStorage tmpStorage) throws IgniteCheckedException {
        Iterator it = tmpStorage.stream().iterator();
        while (it.hasNext()) {
            IgniteBiTuple t = (IgniteBiTuple)it.next();
            this.putData((String)t.get1(), (byte[])t.get2());
        }
        try {
            tmpStorage.close();
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), e);
        }
    }

    private void initInternal(IgniteCacheDatabaseSharedManager db) throws IgniteCheckedException {
        block6: {
            block7: {
                block5: {
                    if (!PRESERVE_LEGACY_METASTORAGE_PARTITION_ID) break block5;
                    this.partId = 0;
                    this.getOrAllocateMetas(0);
                    break block6;
                }
                if (!this.readOnly) break block7;
                this.partId = 0;
                if (!this.getOrAllocateMetas(0)) break block6;
            }
            this.partId = 1;
            this.getOrAllocateMetas(1);
        }
        if (!this.empty) {
            this.freeList = new FreeListImpl(METASTORAGE_CACHE_ID, "metastorage", this.regionMetrics, this.dataRegion, null, this.wal, this.reuseListRoot.pageId().pageId(), this.reuseListRoot.isAllocated());
            MetastorageRowStore rowStore = new MetastorageRowStore(this.freeList, db);
            this.tree = new MetastorageTree(METASTORAGE_CACHE_ID, this.dataRegion.pageMemory(), this.wal, this.rmvId, this.freeList, rowStore, this.treeRoot.pageId().pageId(), this.treeRoot.isAllocated(), this.failureProcessor, this.partId);
            if (!this.readOnly) {
                ((GridCacheDatabaseSharedManager)db).addCheckpointListener(this);
            }
        }
    }

    @Override
    public Serializable read(String key) throws IgniteCheckedException {
        byte[] data = this.getData(key);
        Object result = null;
        if (data != null) {
            result = this.marshaller.unmarshal(data, this.getClass().getClassLoader());
        }
        return result;
    }

    @Override
    public Map<String, ? extends Serializable> readForPredicate(IgnitePredicate<String> keyPred) throws IgniteCheckedException {
        Map<String, Serializable> res = null;
        if (this.readOnly) {
            if (this.empty) {
                return Collections.emptyMap();
            }
            if (this.lastUpdates != null) {
                for (Map.Entry<String, byte[]> lastUpdate : this.lastUpdates.entrySet()) {
                    byte[] valBytes;
                    if (!keyPred.apply(lastUpdate.getKey()) || (valBytes = lastUpdate.getValue()) == TOMBSTONE) continue;
                    if (res == null) {
                        res = new HashMap();
                    }
                    Serializable val = (Serializable)this.marshaller.unmarshal(valBytes, this.getClass().getClassLoader());
                    res.put(lastUpdate.getKey(), val);
                }
            }
        }
        GridCursor cur = this.tree.find(null, null);
        while (cur.next()) {
            MetastorageDataRow row = (MetastorageDataRow)cur.get();
            String key = row.key();
            byte[] valBytes = row.value();
            if (!keyPred.apply(key) || this.lastUpdates != null && this.lastUpdates.containsKey(key)) continue;
            if (res == null) {
                res = new HashMap();
            }
            Serializable val = (Serializable)this.marshaller.unmarshal(valBytes, this.getClass().getClassLoader());
            res.put(key, val);
        }
        if (res == null) {
            res = Collections.emptyMap();
        }
        return res;
    }

    public Collection<IgniteBiTuple<String, byte[]>> readAll() throws IgniteCheckedException {
        ArrayList<IgniteBiTuple<String, byte[]>> res = new ArrayList<IgniteBiTuple<String, byte[]>>();
        GridCursor cur = this.tree.find(null, null);
        while (cur.next()) {
            MetastorageDataRow row = (MetastorageDataRow)cur.get();
            res.add(new IgniteBiTuple<String, byte[]>(row.key(), row.value()));
        }
        return res;
    }

    @Override
    public void write(@NotNull String key, @NotNull Serializable val) throws IgniteCheckedException {
        assert (val != null);
        byte[] data = this.marshaller.marshal(val);
        this.putData(key, data);
    }

    @Override
    public void remove(@NotNull String key) throws IgniteCheckedException {
        this.removeData(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putData(String key, byte[] data) throws IgniteCheckedException {
        if (!this.readOnly) {
            WALPointer ptr = this.wal.log(new MetastoreDataRecord(key, data));
            this.wal.flush(ptr, false);
            MetaStorage metaStorage = this;
            synchronized (metaStorage) {
                MetastorageDataRow oldRow = (MetastorageDataRow)this.tree.findOne(new MetastorageDataRow(key, null));
                if (oldRow != null) {
                    this.tree.removex(oldRow);
                    this.tree.rowStore().removeRow(oldRow.link());
                }
                MetastorageDataRow row = new MetastorageDataRow(key, data);
                this.tree.rowStore().addRow(row);
                this.tree.put(row);
            }
        }
    }

    public byte[] getData(String key) throws IgniteCheckedException {
        MetastorageDataRow row;
        if (this.readOnly) {
            byte[] res;
            if (this.lastUpdates != null && (res = this.lastUpdates.get(key)) != null) {
                return (byte[])(res != TOMBSTONE ? res : null);
            }
            if (this.empty) {
                return null;
            }
        }
        if ((row = (MetastorageDataRow)this.tree.findOne(new MetastorageDataRow(key, null))) == null) {
            return null;
        }
        return row.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeData(String key) throws IgniteCheckedException {
        if (!this.readOnly) {
            WALPointer ptr = this.wal.log(new MetastoreDataRecord(key, null));
            this.wal.flush(ptr, false);
            MetaStorage metaStorage = this;
            synchronized (metaStorage) {
                MetastorageDataRow row = new MetastorageDataRow(key, null);
                MetastorageDataRow oldRow = (MetastorageDataRow)this.tree.findOne(row);
                if (oldRow != null) {
                    this.tree.removex(oldRow);
                    this.tree.rowStore().removeRow(oldRow.link());
                }
            }
        }
    }

    private void checkRootsPageIdFlag(long treeRoot, long reuseListRoot) throws StorageException {
        if (PageIdUtils.flag(treeRoot) != 1) {
            throw new StorageException("Wrong tree root page id flag: treeRoot=" + U.hexLong(treeRoot) + ", METASTORAGE_CACHE_ID=" + METASTORAGE_CACHE_ID);
        }
        if (PageIdUtils.flag(reuseListRoot) != 1) {
            throw new StorageException("Wrong reuse list root page id flag: reuseListRoot=" + U.hexLong(reuseListRoot) + ", METASTORAGE_CACHE_ID=" + METASTORAGE_CACHE_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getOrAllocateMetas(int partId) throws IgniteCheckedException {
        block19: {
            this.empty = false;
            PageMemoryEx pageMem = (PageMemoryEx)this.dataRegion.pageMemory();
            long partMetaId = pageMem.partitionMetaPageId(METASTORAGE_CACHE_ID, partId);
            long partMetaPage = pageMem.acquirePage(METASTORAGE_CACHE_ID, partMetaId);
            try {
                if (this.readOnly) {
                    long pageAddr = pageMem.readLock(METASTORAGE_CACHE_ID, partMetaId, partMetaPage);
                    try {
                        if (PageIO.getType(pageAddr) != 14) {
                            this.empty = true;
                            boolean bl = true;
                            return bl;
                        }
                        PagePartitionMetaIO io = (PagePartitionMetaIO)PageIO.getPageIO(pageAddr);
                        long treeRoot = io.getTreeRoot(pageAddr);
                        long reuseListRoot = io.getReuseListRoot(pageAddr);
                        this.checkRootsPageIdFlag(treeRoot, reuseListRoot);
                        this.treeRoot = new RootPage(new FullPageId(treeRoot, METASTORAGE_CACHE_ID), false);
                        this.reuseListRoot = new RootPage(new FullPageId(reuseListRoot, METASTORAGE_CACHE_ID), false);
                        this.rmvId.set(io.getGlobalRemoveId(pageAddr));
                        break block19;
                    }
                    finally {
                        pageMem.readUnlock(METASTORAGE_CACHE_ID, partId, partMetaPage);
                    }
                }
                boolean allocated = false;
                long pageAddr = pageMem.writeLock(METASTORAGE_CACHE_ID, partMetaId, partMetaPage);
                try {
                    long reuseListRoot;
                    long treeRoot;
                    if (PageIO.getType(pageAddr) != 14) {
                        PagePartitionMetaIO io = PagePartitionMetaIO.VERSIONS.latest();
                        io.initNewPage(pageAddr, partMetaId, pageMem.pageSize());
                        treeRoot = pageMem.allocatePage(METASTORAGE_CACHE_ID, partId, (byte)1);
                        reuseListRoot = pageMem.allocatePage(METASTORAGE_CACHE_ID, partId, (byte)1);
                        assert (PageIdUtils.flag(treeRoot) == 1);
                        assert (PageIdUtils.flag(reuseListRoot) == 1);
                        io.setTreeRoot(pageAddr, treeRoot);
                        io.setReuseListRoot(pageAddr, reuseListRoot);
                        if (PageHandler.isWalDeltaRecordNeeded(pageMem, METASTORAGE_CACHE_ID, partMetaId, partMetaPage, this.wal, null)) {
                            assert (io.getType() == 14);
                            this.wal.log(new MetaPageInitRecord(METASTORAGE_CACHE_ID, partMetaId, io.getType(), io.getVersion(), treeRoot, reuseListRoot));
                        }
                        allocated = true;
                    } else {
                        PagePartitionMetaIO io = (PagePartitionMetaIO)PageIO.getPageIO(pageAddr);
                        treeRoot = io.getTreeRoot(pageAddr);
                        reuseListRoot = io.getReuseListRoot(pageAddr);
                        this.rmvId.set(io.getGlobalRemoveId(pageAddr));
                        this.checkRootsPageIdFlag(treeRoot, reuseListRoot);
                    }
                    this.treeRoot = new RootPage(new FullPageId(treeRoot, METASTORAGE_CACHE_ID), allocated);
                    this.reuseListRoot = new RootPage(new FullPageId(reuseListRoot, METASTORAGE_CACHE_ID), allocated);
                }
                finally {
                    pageMem.writeUnlock(METASTORAGE_CACHE_ID, partMetaId, partMetaPage, null, allocated);
                }
            }
            finally {
                pageMem.releasePage(METASTORAGE_CACHE_ID, partMetaId, partMetaPage);
            }
        }
        return false;
    }

    public PageMemory pageMemory() {
        return this.dataRegion.pageMemory();
    }

    @Override
    public void onMarkCheckpointBegin(DbCheckpointListener.Context ctx) throws IgniteCheckedException {
        Executor executor = ctx.executor();
        if (executor == null) {
            this.freeList.saveMetadata();
            this.saveStoreMetadata();
        } else {
            executor.execute(() -> {
                try {
                    this.freeList.saveMetadata();
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            });
            executor.execute(() -> {
                try {
                    this.saveStoreMetadata();
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            });
        }
    }

    @Override
    public void beforeCheckpointBegin(DbCheckpointListener.Context ctx) throws IgniteCheckedException {
        this.freeList.saveMetadata();
    }

    @Override
    public void onCheckpointBegin(DbCheckpointListener.Context ctx) throws IgniteCheckedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStoreMetadata() throws IgniteCheckedException {
        PageMemoryEx pageMem = (PageMemoryEx)this.pageMemory();
        long partMetaId = pageMem.partitionMetaPageId(METASTORAGE_CACHE_ID, this.partId);
        long partMetaPage = pageMem.acquirePage(METASTORAGE_CACHE_ID, partMetaId);
        try {
            long partMetaPageAddr = pageMem.writeLock(METASTORAGE_CACHE_ID, partMetaId, partMetaPage);
            if (partMetaPageAddr == 0L) {
                U.warn(this.log, "Failed to acquire write lock for meta page [metaPage=" + partMetaPage + ']');
                return;
            }
            boolean changed = false;
            try {
                PagePartitionMetaIO io = (PagePartitionMetaIO)PageIO.getPageIO(partMetaPageAddr);
                changed |= io.setGlobalRemoveId(partMetaPageAddr, this.rmvId.get());
            }
            finally {
                pageMem.writeUnlock(METASTORAGE_CACHE_ID, partMetaId, partMetaPage, null, changed);
            }
        }
        finally {
            pageMem.releasePage(METASTORAGE_CACHE_ID, partMetaId, partMetaPage);
        }
    }

    public void applyUpdate(String key, byte[] value) throws IgniteCheckedException {
        if (this.readOnly) {
            if (this.lastUpdates == null) {
                this.lastUpdates = new HashMap<String, byte[]>();
            }
            this.lastUpdates.put(key, value != null ? value : TOMBSTONE);
        } else if (value != null) {
            this.putData(key, value);
        } else {
            this.removeData(key);
        }
    }

    public static class TmpStorage
    implements Closeable {
        final List<TmpStorageInternal> chain = new ArrayList<TmpStorageInternal>(2);
        TmpStorageInternal current;
        final IgniteLogger log;

        TmpStorage(int memBufSize, IgniteLogger log) {
            this.log = log;
            this.current = new MemoryTmpStorage(memBufSize);
            this.chain.add(this.current);
        }

        public void add(String key, byte[] val) throws IgniteCheckedException {
            try {
                while (!this.current.add(key, val)) {
                    this.current = new FileTmpStorage();
                    this.chain.add(this.current);
                }
            }
            catch (IOException e) {
                throw new IgniteCheckedException(e);
            }
        }

        public Stream<IgniteBiTuple<String, byte[]>> stream() {
            return this.chain.stream().flatMap(storage -> {
                try {
                    return storage.stream();
                }
                catch (IOException e) {
                    throw new IgniteException(e);
                }
            });
        }

        @Override
        public void close() throws IOException {
            for (TmpStorageInternal storage : this.chain) {
                try {
                    storage.close();
                }
                catch (IOException ex) {
                    this.log.error(ex.getMessage(), ex);
                }
            }
        }
    }

    private static class FileTmpStorage
    implements TmpStorageInternal {
        final ByteBuffer cache = ByteBuffer.allocateDirect(0x100000);
        RandomAccessFile file;
        long size;

        private FileTmpStorage() {
        }

        @Override
        public boolean add(String key, byte[] val) throws IOException {
            byte[] keyData;
            if (this.file == null) {
                this.file = new RandomAccessFile(File.createTempFile("m_storage", "bin"), "rw");
            }
            if (val.length + (keyData = key.getBytes(StandardCharsets.UTF_8)).length + 8 > this.cache.remaining()) {
                this.flushCache(false);
            }
            this.cache.putInt(keyData.length).putInt(val.length).put(keyData).put(val);
            ++this.size;
            return true;
        }

        @Override
        public Stream<IgniteBiTuple<String, byte[]>> stream() throws IOException {
            if (this.file == null) {
                return Stream.empty();
            }
            this.flushCache(true);
            this.file.getChannel().position(0L);
            this.readToCache();
            return Stream.generate(() -> {
                if (this.cache.remaining() <= 8) {
                    this.cache.compact();
                    try {
                        this.readToCache();
                    }
                    catch (IOException e) {
                        throw new IgniteException(e);
                    }
                }
                int keyLen = this.cache.getInt();
                int dataLen = this.cache.getInt();
                if (this.cache.remaining() < keyLen + dataLen) {
                    this.cache.compact();
                    try {
                        this.readToCache();
                    }
                    catch (IOException e) {
                        throw new IgniteException(e);
                    }
                }
                byte[] tmpBuf = new byte[Math.max(keyLen, dataLen)];
                this.cache.get(tmpBuf, 0, keyLen);
                String key = new String(tmpBuf, 0, keyLen, StandardCharsets.UTF_8);
                this.cache.get(tmpBuf, 0, dataLen);
                return new IgniteBiTuple<String, byte[]>(key, tmpBuf.length > dataLen ? Arrays.copyOf(tmpBuf, dataLen) : tmpBuf);
            }).limit(this.size);
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }

        private void readToCache() throws IOException {
            for (int len = (int)Math.min(this.file.length() - this.file.getChannel().position(), (long)this.cache.remaining()); len > 0; len -= this.file.getChannel().read(this.cache)) {
            }
            this.cache.flip();
        }

        private void flushCache(boolean force) throws IOException {
            if (this.cache.position() > 0) {
                this.cache.flip();
                while (this.cache.remaining() > 0) {
                    this.file.getChannel().write(this.cache);
                }
                this.cache.clear();
            }
            this.file.getChannel().force(force);
        }
    }

    private static class MemoryTmpStorage
    implements TmpStorageInternal {
        final ByteBuffer buf;
        int size;

        MemoryTmpStorage(int size) {
            this.buf = ByteBuffer.allocateDirect(size);
        }

        @Override
        public boolean add(String key, byte[] val) {
            byte[] keyData = key.getBytes(StandardCharsets.UTF_8);
            if (val.length + keyData.length + 8 > this.buf.remaining()) {
                return false;
            }
            this.buf.putInt(keyData.length).putInt(val.length).put(keyData).put(val);
            ++this.size;
            return true;
        }

        @Override
        public Stream<IgniteBiTuple<String, byte[]>> stream() {
            this.buf.flip();
            return Stream.generate(() -> {
                int keyLen = this.buf.getInt();
                int dataLen = this.buf.getInt();
                byte[] tmpBuf = new byte[Math.max(keyLen, dataLen)];
                this.buf.get(tmpBuf, 0, keyLen);
                String key = new String(tmpBuf, 0, keyLen, StandardCharsets.UTF_8);
                this.buf.get(tmpBuf, 0, dataLen);
                return new IgniteBiTuple<String, byte[]>(key, tmpBuf.length > dataLen ? Arrays.copyOf(tmpBuf, dataLen) : tmpBuf);
            }).limit(this.size);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static interface TmpStorageInternal
    extends Closeable {
        public boolean add(String var1, byte[] var2) throws IOException;

        public Stream<IgniteBiTuple<String, byte[]>> stream() throws IOException;
    }

    public class FreeListImpl
    extends AbstractFreeList<MetastorageDataRow> {
        FreeListImpl(int cacheId, String name, DataRegionMetricsImpl regionMetrics, DataRegion dataRegion, ReuseList reuseList, IgniteWriteAheadLogManager wal, long metaPageId, boolean initNew) throws IgniteCheckedException {
            super(cacheId, name, regionMetrics, dataRegion, reuseList, wal, metaPageId, initNew);
        }

        @Override
        public IOVersions<? extends AbstractDataPageIO<MetastorageDataRow>> ioVersions() {
            return SimpleDataPageIO.VERSIONS;
        }

        @Override
        protected long allocatePageNoReuse() throws IgniteCheckedException {
            return this.pageMem.allocatePage(this.grpId, MetaStorage.this.partId, (byte)1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final MetastorageDataRow readRow(String key, long link) throws IgniteCheckedException {
            assert (link != 0L) : "link";
            long nextLink = link;
            IncompleteObject incomplete = null;
            int size = 0;
            boolean first = true;
            do {
                long pageId = PageIdUtils.pageId(nextLink);
                long page = this.pageMem.acquirePage(this.grpId, pageId);
                try {
                    long pageAddr = this.pageMem.readLock(this.grpId, pageId, page);
                    assert (pageAddr != 0L) : nextLink;
                    try {
                        SimpleDataPageIO io = (SimpleDataPageIO)this.ioVersions().forPage(pageAddr);
                        DataPagePayload data = io.readPayload(pageAddr, PageIdUtils.itemId(nextLink), this.pageMem.pageSize());
                        nextLink = data.nextLink();
                        if (first) {
                            if (nextLink == 0L) {
                                MetastorageDataRow metastorageDataRow = new MetastorageDataRow(link, key, SimpleDataPageIO.readPayload(pageAddr + (long)data.offset()));
                                return metastorageDataRow;
                            }
                            first = false;
                        }
                        ByteBuffer buf = this.pageMem.pageBuffer(pageAddr);
                        buf.position(data.offset());
                        buf.limit(data.offset() + data.payloadSize());
                        if (size == 0) {
                            if (buf.remaining() >= 4 && incomplete == null) {
                                size = buf.getInt();
                                incomplete = new IncompleteObject(new byte[size]);
                            } else {
                                if (incomplete == null) {
                                    incomplete = new IncompleteObject(new byte[4]);
                                }
                                incomplete.readData(buf);
                                if (incomplete.isReady()) {
                                    size = ByteBuffer.wrap(incomplete.data()).order(buf.order()).getInt();
                                    incomplete = new IncompleteObject(new byte[size]);
                                }
                            }
                        }
                        if (size != 0 && buf.remaining() > 0) {
                            incomplete.readData(buf);
                        }
                    }
                    finally {
                        this.pageMem.readUnlock(this.grpId, pageId, page);
                    }
                }
                finally {
                    this.pageMem.releasePage(this.grpId, pageId, page);
                }
            } while (nextLink != 0L);
            assert (incomplete.isReady());
            return new MetastorageDataRow(link, key, incomplete.data());
        }
    }
}

