/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.processors.cache.persistence.AllocatedPageTracker;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.util.typedef.internal.U;

public class FilePageStore
implements PageStore {
    private static final long SIGNATURE = -1037300167331204936L;
    public static final int VERSION = 1;
    public static final int HEADER_SIZE = 17;
    private final File cfgFile;
    private final byte type;
    protected final DataStorageConfiguration dbCfg;
    private final FileIOFactory ioFactory;
    private volatile FileIO fileIO;
    private final AtomicLong allocated;
    private final AllocatedPageTracker allocatedTracker;
    private final int pageSize;
    private volatile boolean inited;
    private volatile boolean recover;
    private volatile int tag;
    private boolean skipCrc = IgniteSystemProperties.getBoolean("IGNITE_PDS_SKIP_CRC", false);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public FilePageStore(byte type, File file, FileIOFactory factory, DataStorageConfiguration cfg, AllocatedPageTracker allocatedTracker) {
        this.type = type;
        this.cfgFile = file;
        this.dbCfg = cfg;
        this.ioFactory = factory;
        this.allocated = new AtomicLong();
        this.pageSize = this.dbCfg.getPageSize();
        this.allocatedTracker = allocatedTracker;
    }

    @Override
    public boolean exists() {
        return this.cfgFile.exists() && this.cfgFile.length() > (long)this.headerSize();
    }

    public int headerSize() {
        return 17;
    }

    @Override
    public int version() {
        return 1;
    }

    public ByteBuffer header(byte type, int pageSize) {
        ByteBuffer hdr = ByteBuffer.allocate(this.headerSize()).order(ByteOrder.LITTLE_ENDIAN);
        hdr.putLong(-1037300167331204936L);
        hdr.putInt(this.version());
        hdr.put(type);
        hdr.putInt(pageSize);
        hdr.rewind();
        return hdr;
    }

    private long initFile(FileIO fileIO) throws IOException {
        try {
            ByteBuffer hdr = this.header(this.type, this.dbCfg.getPageSize());
            fileIO.writeFully(hdr);
            return this.headerSize() + this.dbCfg.getPageSize();
        }
        catch (ClosedByInterruptException e) {
            Files.delete(this.cfgFile.toPath());
            throw e;
        }
    }

    private long checkFile(FileIO fileIO) throws IOException {
        ByteBuffer hdr = ByteBuffer.allocate(this.headerSize()).order(ByteOrder.LITTLE_ENDIAN);
        fileIO.readFully(hdr);
        hdr.rewind();
        long signature = hdr.getLong();
        String prefix = "Failed to verify, file=" + this.cfgFile.getAbsolutePath() + "\" ";
        if (-1037300167331204936L != signature) {
            throw new IOException(prefix + "(invalid file signature) [expectedSignature=" + U.hexLong(-1037300167331204936L) + ", actualSignature=" + U.hexLong(signature) + ']');
        }
        int ver = hdr.getInt();
        if (this.version() != ver) {
            throw new IOException(prefix + "(invalid file version) [expectedVersion=" + this.version() + ", fileVersion=" + ver + "]");
        }
        byte type = hdr.get();
        if (this.type != type) {
            throw new IOException(prefix + "(invalid file type) [expectedFileType=" + this.type + ", actualFileType=" + type + "]");
        }
        int pageSize = hdr.getInt();
        if (this.dbCfg.getPageSize() != pageSize) {
            throw new IOException(prefix + "(invalid page size) [expectedPageSize=" + this.dbCfg.getPageSize() + ", filePageSize=" + pageSize + "]");
        }
        long fileSize = this.cfgFile.length();
        if (fileSize == (long)this.headerSize()) {
            fileSize = pageSize + this.headerSize();
        }
        if ((fileSize - (long)this.headerSize()) % (long)pageSize != 0L) {
            throw new IOException(prefix + "(invalid file size) [fileSize=" + U.hexLong(fileSize) + ", pageSize=" + U.hexLong(pageSize) + ']');
        }
        return fileSize;
    }

    @Override
    public void stop(boolean delete) throws StorageException {
        this.lock.writeLock().lock();
        try {
            if (!this.inited) {
                return;
            }
            this.fileIO.force();
            this.fileIO.close();
            this.fileIO = null;
            if (delete) {
                Files.delete(this.cfgFile.toPath());
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to stop serving partition file [file=" + this.cfgFile.getPath() + ", delete=" + delete + "]", e);
        }
        finally {
            this.allocatedTracker.updateTotalAllocatedPages(-1L * this.allocated.getAndSet(0L) / (long)this.pageSize);
            this.inited = false;
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void truncate(int tag) throws StorageException {
        this.init();
        this.lock.writeLock().lock();
        try {
            this.tag = tag;
            this.fileIO.clear();
            this.fileIO.close();
            this.fileIO = null;
            Files.delete(this.cfgFile.toPath());
        }
        catch (IOException e) {
            throw new StorageException("Failed to truncate partition file [file=" + this.cfgFile.getPath() + "]", e);
        }
        finally {
            this.allocatedTracker.updateTotalAllocatedPages(-1L * this.allocated.getAndSet(0L) / (long)this.pageSize);
            this.inited = false;
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void beginRecover() {
        this.lock.writeLock().lock();
        try {
            this.recover = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void finishRecover() throws StorageException {
        this.lock.writeLock().lock();
        try {
            if (this.inited) {
                long newSize = Math.max((long)this.pageSize, this.fileIO.size() - (long)this.headerSize());
                long delta = newSize - this.allocated.getAndSet(newSize);
                assert (delta % (long)this.pageSize == 0L);
                this.allocatedTracker.updateTotalAllocatedPages(delta / (long)this.pageSize);
            }
            this.recover = false;
        }
        catch (IOException e) {
            throw new StorageException("Failed to finish recover partition file [file=" + this.cfgFile.getAbsolutePath() + "]", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void read(long pageId, ByteBuffer pageBuf, boolean keepCrc) throws IgniteCheckedException {
        this.init();
        try {
            int curCrc32;
            long off = this.pageOffset(pageId);
            assert (pageBuf.capacity() == this.pageSize);
            assert (pageBuf.remaining() == this.pageSize);
            assert (pageBuf.position() == 0);
            assert (pageBuf.order() == ByteOrder.nativeOrder());
            assert (off <= this.allocated.get()) : "calculatedOffset=" + off + ", allocated=" + this.allocated.get() + ", headerSize=" + this.headerSize() + ", cfgFile=" + this.cfgFile;
            int n = this.readWithFailover(pageBuf, off);
            if (n < 0) {
                pageBuf.put(new byte[pageBuf.remaining()]);
                return;
            }
            int savedCrc32 = PageIO.getCrc(pageBuf);
            PageIO.setCrc(pageBuf, 0);
            pageBuf.position(0);
            if (!this.skipCrc && (savedCrc32 ^ (curCrc32 = FastCrc.calcCrc(pageBuf, this.pageSize))) != 0) {
                throw new IgniteDataIntegrityViolationException("Failed to read page (CRC validation failed) [id=" + U.hexLong(pageId) + ", off=" + (off - (long)this.pageSize) + ", file=" + this.cfgFile.getAbsolutePath() + ", fileSize=" + this.fileIO.size() + ", savedCrc=" + U.hexInt(savedCrc32) + ", curCrc=" + U.hexInt(curCrc32) + ", page=" + U.toHexString(pageBuf) + "]");
            }
            assert (PageIO.getCrc(pageBuf) == 0);
            if (keepCrc) {
                PageIO.setCrc(pageBuf, savedCrc32);
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to read page [file=" + this.cfgFile.getAbsolutePath() + ", pageId=" + pageId + "]", e);
        }
    }

    @Override
    public void readHeader(ByteBuffer buf) throws IgniteCheckedException {
        this.init();
        try {
            assert (buf.remaining() == this.headerSize());
            this.readWithFailover(buf, 0L);
        }
        catch (IOException e) {
            throw new StorageException("Failed to read header [file=" + this.cfgFile.getAbsolutePath() + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws StorageException {
        block18: {
            if (!this.inited) {
                this.lock.writeLock().lock();
                try {
                    if (this.inited) break block18;
                    FileIO fileIO = null;
                    Throwable err = null;
                    try {
                        long newSize;
                        boolean interrupted = false;
                        while (true) {
                            try {
                                this.fileIO = fileIO = this.ioFactory.create(this.cfgFile, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
                                newSize = (this.cfgFile.length() == 0L ? this.initFile(fileIO) : this.checkFile(fileIO)) - (long)this.headerSize();
                                if (!interrupted) break;
                                Thread.currentThread().interrupt();
                            }
                            catch (ClosedByInterruptException e) {
                                interrupted = true;
                                Thread.interrupted();
                                continue;
                            }
                            break;
                        }
                        assert (this.allocated.get() == 0L);
                        this.allocated.set(newSize);
                        this.inited = true;
                        this.allocatedTracker.updateTotalAllocatedPages(this.pages());
                    }
                    catch (IOException e) {
                        err = new StorageException("Failed to initialize partition file: " + this.cfgFile.getAbsolutePath(), e);
                        throw err;
                    }
                    finally {
                        if (err != null && fileIO != null) {
                            try {
                                fileIO.close();
                            }
                            catch (IOException e) {
                                err.addSuppressed(e);
                            }
                        }
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinit(FileIO fileIO) throws IOException {
        if (!this.inited) {
            return;
        }
        if (fileIO != this.fileIO) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (fileIO != this.fileIO) {
                return;
            }
            try {
                boolean interrupted = false;
                while (true) {
                    try {
                        fileIO = null;
                        fileIO = this.ioFactory.create(this.cfgFile, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
                        this.checkFile(fileIO);
                        this.fileIO = fileIO;
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    catch (ClosedByInterruptException e) {
                        interrupted = true;
                        Thread.interrupted();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                try {
                    if (fileIO != null) {
                        fileIO.close();
                    }
                }
                catch (IOException e0) {
                    e.addSuppressed(e0);
                }
                throw e;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(long pageId, ByteBuffer pageBuf, int tag, boolean calculateCrc) throws IgniteCheckedException {
        this.init();
        boolean interrupted = false;
        while (true) {
            FileIO fileIO = this.fileIO;
            try {
                this.lock.readLock().lock();
                try {
                    if (tag < this.tag) {
                        return;
                    }
                    long off = this.pageOffset(pageId);
                    assert (off >= 0L && off <= this.allocated.get() || this.recover) : "off=" + U.hexLong(off) + ", allocated=" + U.hexLong(this.allocated.get()) + ", pageId=" + U.hexLong(pageId) + ", file=" + this.cfgFile.getPath();
                    assert (pageBuf.capacity() == this.pageSize);
                    assert (pageBuf.position() == 0);
                    assert (pageBuf.order() == ByteOrder.nativeOrder()) : "Page buffer order " + pageBuf.order() + " should be same with " + ByteOrder.nativeOrder();
                    assert (PageIO.getType(pageBuf) != 0) : "Invalid state. Type is 0! pageId = " + U.hexLong(pageId);
                    assert (PageIO.getVersion(pageBuf) != 0) : "Invalid state. Version is 0! pageId = " + U.hexLong(pageId);
                    if (calculateCrc && !this.skipCrc) {
                        assert (PageIO.getCrc(pageBuf) == 0) : U.hexLong(pageId);
                        PageIO.setCrc(pageBuf, FilePageStore.calcCrc32(pageBuf, this.pageSize));
                    }
                    assert (this.skipCrc || PageIO.getCrc(pageBuf) != 0 || FilePageStore.calcCrc32(pageBuf, this.pageSize) == 0) : "CRC hasn't been calculated, crc=0";
                    assert (pageBuf.position() == 0) : pageBuf.position();
                    fileIO.writeFully(pageBuf, off);
                    PageIO.setCrc(pageBuf, 0);
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return;
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            catch (IOException e) {
                block23: {
                    if (e instanceof ClosedChannelException) {
                        try {
                            if (e instanceof ClosedByInterruptException) {
                                interrupted = true;
                                Thread.interrupted();
                            }
                            this.reinit(fileIO);
                            pageBuf.position(0);
                            PageIO.setCrc(pageBuf, 0);
                        }
                        catch (IOException e0) {
                            e0.addSuppressed(e);
                            e = e0;
                            break block23;
                        }
                        continue;
                    }
                }
                throw new StorageException("Failed to write page [file=" + this.cfgFile.getAbsolutePath() + ", pageId=" + pageId + ", tag=" + tag + "]", e);
            }
            break;
        }
    }

    private static int calcCrc32(ByteBuffer pageBuf, int pageSize) {
        try {
            pageBuf.position(0);
            int n = FastCrc.calcCrc(pageBuf, pageSize);
            return n;
        }
        finally {
            pageBuf.position(0);
        }
    }

    @Override
    public long pageOffset(long pageId) {
        return (long)PageIdUtils.pageIndex(pageId) * (long)this.pageSize + (long)this.headerSize();
    }

    @Override
    public void sync() throws StorageException {
        this.lock.writeLock().lock();
        try {
            this.init();
            FileIO fileIO = this.fileIO;
            if (fileIO != null) {
                fileIO.force();
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to fsync partition file [file=" + this.cfgFile.getAbsolutePath() + ']', e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public synchronized void ensure() throws IgniteCheckedException {
        this.init();
    }

    @Override
    public long allocatePage() throws IgniteCheckedException {
        this.init();
        return this.allocPage() / (long)this.pageSize;
    }

    public String getFileAbsolutePath() {
        return this.cfgFile.getAbsolutePath();
    }

    private long allocPage() {
        long off;
        while (!this.allocated.compareAndSet(off = this.allocated.get(), off + (long)this.pageSize)) {
        }
        this.allocatedTracker.updateTotalAllocatedPages(1L);
        return off;
    }

    @Override
    public int pages() {
        if (!this.inited) {
            return 0;
        }
        return (int)(this.allocated.get() / (long)this.pageSize);
    }

    private int readWithFailover(ByteBuffer destBuf, long position) throws IOException {
        boolean interrupted = false;
        int bufPos = destBuf.position();
        while (true) {
            FileIO fileIO;
            if ((fileIO = this.fileIO) == null) {
                throw new IOException("FileIO has stopped");
            }
            try {
                assert (destBuf.remaining() > 0);
                int bytesRead = fileIO.readFully(destBuf, position);
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return bytesRead;
            }
            catch (ClosedChannelException e) {
                destBuf.position(bufPos);
                if (e instanceof ClosedByInterruptException) {
                    interrupted = true;
                    Thread.interrupted();
                }
                this.reinit(fileIO);
                continue;
            }
            break;
        }
    }
}

