/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.delta.RecycleRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.RotatedIdPartRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseBag;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageLockListener;
import org.apache.ignite.internal.util.typedef.internal.U;

public abstract class DataStructure
implements PageLockListener {
    public static Random rnd;
    protected final int grpId;
    protected final PageMemory pageMem;
    protected final IgniteWriteAheadLogManager wal;
    protected ReuseList reuseList;

    public DataStructure(int cacheId, PageMemory pageMem, IgniteWriteAheadLogManager wal) {
        assert (pageMem != null);
        this.grpId = cacheId;
        this.pageMem = pageMem;
        this.wal = wal;
    }

    public final int groupId() {
        return this.grpId;
    }

    public static int randomInt(int max) {
        Random rnd0 = rnd != null ? rnd : ThreadLocalRandom.current();
        return rnd0.nextInt(max);
    }

    protected final long allocatePage(ReuseBag bag) throws IgniteCheckedException {
        return this.allocatePage(bag, true);
    }

    protected final long allocatePage(ReuseBag bag, boolean useRecycled) throws IgniteCheckedException {
        long pageId;
        long l = pageId = bag != null ? bag.pollFreePage() : 0L;
        if (pageId == 0L && useRecycled && this.reuseList != null) {
            pageId = this.reuseList.takeRecycledPage();
        }
        if (pageId == 0L) {
            pageId = this.allocatePageNoReuse();
        }
        assert (pageId != 0L);
        return pageId;
    }

    protected long allocatePageNoReuse() throws IgniteCheckedException {
        return this.pageMem.allocatePage(this.grpId, 65535, (byte)2);
    }

    protected final long acquirePage(long pageId) throws IgniteCheckedException {
        assert (PageIdUtils.flag(pageId) == 2 && PageIdUtils.partId(pageId) == 65535 || PageIdUtils.flag(pageId) == 1 && PageIdUtils.partId(pageId) <= 65500) : U.hexLong(pageId) + " flag=" + PageIdUtils.flag(pageId) + " part=" + PageIdUtils.partId(pageId);
        return this.pageMem.acquirePage(this.grpId, pageId);
    }

    protected final void releasePage(long pageId, long page) {
        this.pageMem.releasePage(this.grpId, pageId, page);
    }

    protected final long tryWriteLock(long pageId, long page) {
        return PageHandler.writeLock(this.pageMem, this.grpId, pageId, page, this, true);
    }

    protected final long writeLock(long pageId, long page) {
        return PageHandler.writeLock(this.pageMem, this.grpId, pageId, page, this, false);
    }

    protected final void writeUnlock(long pageId, long page, long pageAddr, boolean dirty) {
        this.writeUnlock(pageId, page, pageAddr, null, dirty);
    }

    protected final long readLock(long pageId, long page) {
        return PageHandler.readLock(this.pageMem, this.grpId, pageId, page, this);
    }

    protected final void readUnlock(long pageId, long page, long pageAddr) {
        PageHandler.readUnlock(this.pageMem, this.grpId, pageId, page, pageAddr, this);
    }

    protected final void writeUnlock(long pageId, long page, long pageAddr, Boolean walPlc, boolean dirty) {
        PageHandler.writeUnlock(this.pageMem, this.grpId, pageId, page, pageAddr, this, walPlc, dirty);
    }

    protected final boolean needWalDeltaRecord(long pageId, long page, Boolean walPlc) {
        return PageHandler.isWalDeltaRecordNeeded(this.pageMem, this.grpId, pageId, page, this.wal, walPlc);
    }

    protected final <R> R write(long pageId, PageHandler<?, R> h, int intArg, R lockFailed) throws IgniteCheckedException {
        return PageHandler.writePage(this.pageMem, this.grpId, pageId, this, h, null, null, null, null, intArg, lockFailed);
    }

    protected final <X, R> R write(long pageId, PageHandler<X, R> h, X arg, int intArg, R lockFailed) throws IgniteCheckedException {
        return PageHandler.writePage(this.pageMem, this.grpId, pageId, this, h, null, null, null, arg, intArg, lockFailed);
    }

    protected final <X, R> R write(long pageId, long page, PageHandler<X, R> h, X arg, int intArg, R lockFailed) throws IgniteCheckedException {
        return PageHandler.writePage(this.pageMem, this.grpId, pageId, page, this, h, null, null, null, arg, intArg, lockFailed);
    }

    protected final <X, R> R write(long pageId, PageHandler<X, R> h, PageIO init, X arg, int intArg, R lockFailed) throws IgniteCheckedException {
        return PageHandler.writePage(this.pageMem, this.grpId, pageId, this, h, init, this.wal, null, arg, intArg, lockFailed);
    }

    protected final <X, R> R read(long pageId, PageHandler<X, R> h, X arg, int intArg, R lockFailed) throws IgniteCheckedException {
        return PageHandler.readPage(this.pageMem, this.grpId, pageId, this, h, arg, intArg, lockFailed);
    }

    protected final <X, R> R read(long pageId, long page, PageHandler<X, R> h, X arg, int intArg, R lockFailed) throws IgniteCheckedException {
        return PageHandler.readPage(this.pageMem, this.grpId, pageId, page, this, h, arg, intArg, lockFailed);
    }

    protected final void init(long pageId, PageIO init) throws IgniteCheckedException {
        PageHandler.initPage(this.pageMem, this.grpId, pageId, init, this.wal, this);
    }

    protected final long recyclePage(long pageId, long page, long pageAddr, Boolean walPlc) throws IgniteCheckedException {
        int rotatedIdPart;
        long recycled = 0L;
        boolean needWalDeltaRecord = this.needWalDeltaRecord(pageId, page, walPlc);
        if (PageIdUtils.flag(pageId) == 1 && (rotatedIdPart = PageIO.getRotatedIdPart(pageAddr)) != 0) {
            recycled = PageIdUtils.link(pageId, rotatedIdPart > 254 ? 1 : rotatedIdPart);
            PageIO.setRotatedIdPart(pageAddr, 0);
            if (needWalDeltaRecord) {
                this.wal.log(new RotatedIdPartRecord(this.grpId, pageId, 0));
            }
        }
        if (recycled == 0L) {
            recycled = PageIdUtils.rotatePageId(pageId);
        }
        assert (PageIdUtils.itemId(recycled) > 0 && PageIdUtils.itemId(recycled) <= 254) : U.hexLong(recycled);
        PageIO.setPageId(pageAddr, recycled);
        if (needWalDeltaRecord) {
            this.wal.log(new RecycleRecord(this.grpId, pageId, recycled));
        }
        return recycled;
    }

    protected int pageSize() {
        return this.pageMem.realPageSize(this.grpId);
    }

    @Override
    public void onBeforeWriteLock(int cacheId, long pageId, long page) {
    }

    @Override
    public void onWriteLock(int cacheId, long pageId, long page, long pageAddr) {
    }

    @Override
    public void onWriteUnlock(int cacheId, long pageId, long page, long pageAddr) {
    }

    @Override
    public void onBeforeReadLock(int cacheId, long pageId, long page) {
    }

    @Override
    public void onReadLock(int cacheId, long pageId, long page, long pageAddr) {
    }

    @Override
    public void onReadUnlock(int cacheId, long pageId, long page, long pageAddr) {
    }
}

