/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import org.apache.ignite.DataStorageMetrics;
import org.apache.ignite.internal.util.typedef.internal.S;

public class DataStorageMetricsSnapshot
implements DataStorageMetrics {
    private float walLoggingRate;
    private float walWritingRate;
    private int walArchiveSegments;
    private float walFsyncTimeAvg;
    private long walBuffPollSpinsNum;
    private long lastCpDuration;
    private long lastCpLockWaitDuration;
    private long lastCpMmarkDuration;
    private long lastCpPagesWriteDuration;
    private long lastCpFsyncDuration;
    private long lastCpTotalPages;
    private long lastCpDataPages;
    private long lastCpCowPages;
    private long walTotalSize;
    private long walLastRollOverTime;
    private long checkpointTotalTime;
    private long usedCheckpointBufferSize;
    private long usedCheckpointBufferPages;
    private long checkpointBufferSize;
    private long dirtyPages;
    private long readPages;
    private long writtenPages;
    private long replacedPages;
    private long offHeapSize;
    private long offHeadUsedSize;
    private long totalAllocatedSize;

    public DataStorageMetricsSnapshot(DataStorageMetrics metrics) {
        this.walLoggingRate = metrics.getWalLoggingRate();
        this.walWritingRate = metrics.getWalWritingRate();
        this.walArchiveSegments = metrics.getWalArchiveSegments();
        this.walFsyncTimeAvg = metrics.getWalFsyncTimeAverage();
        this.walBuffPollSpinsNum = metrics.getWalBuffPollSpinsRate();
        this.lastCpDuration = metrics.getLastCheckpointDuration();
        this.lastCpLockWaitDuration = metrics.getLastCheckpointLockWaitDuration();
        this.lastCpMmarkDuration = metrics.getLastCheckpointMarkDuration();
        this.lastCpPagesWriteDuration = metrics.getLastCheckpointPagesWriteDuration();
        this.lastCpFsyncDuration = metrics.getLastCheckpointFsyncDuration();
        this.lastCpTotalPages = metrics.getLastCheckpointTotalPagesNumber();
        this.lastCpDataPages = metrics.getLastCheckpointDataPagesNumber();
        this.lastCpCowPages = metrics.getLastCheckpointCopiedOnWritePagesNumber();
        this.walTotalSize = metrics.getWalTotalSize();
        this.walLastRollOverTime = metrics.getWalLastRollOverTime();
        this.checkpointTotalTime = metrics.getCheckpointTotalTime();
        this.usedCheckpointBufferSize = metrics.getUsedCheckpointBufferSize();
        this.usedCheckpointBufferPages = metrics.getUsedCheckpointBufferPages();
        this.checkpointBufferSize = metrics.getCheckpointBufferSize();
        this.dirtyPages = metrics.getDirtyPages();
        this.readPages = metrics.getPagesRead();
        this.writtenPages = metrics.getPagesWritten();
        this.replacedPages = metrics.getPagesReplaced();
        this.offHeapSize = metrics.getOffHeapSize();
        this.offHeadUsedSize = metrics.getOffheapUsedSize();
        this.totalAllocatedSize = metrics.getTotalAllocatedSize();
    }

    @Override
    public float getWalLoggingRate() {
        return this.walLoggingRate;
    }

    @Override
    public float getWalWritingRate() {
        return this.walWritingRate;
    }

    @Override
    public int getWalArchiveSegments() {
        return this.walArchiveSegments;
    }

    @Override
    public float getWalFsyncTimeAverage() {
        return this.walFsyncTimeAvg;
    }

    @Override
    public long getWalBuffPollSpinsRate() {
        return this.walBuffPollSpinsNum;
    }

    @Override
    public long getLastCheckpointDuration() {
        return this.lastCpDuration;
    }

    @Override
    public long getLastCheckpointLockWaitDuration() {
        return this.lastCpLockWaitDuration;
    }

    @Override
    public long getLastCheckpointMarkDuration() {
        return this.lastCpMmarkDuration;
    }

    @Override
    public long getLastCheckpointPagesWriteDuration() {
        return this.lastCpPagesWriteDuration;
    }

    @Override
    public long getLastCheckpointFsyncDuration() {
        return this.lastCpFsyncDuration;
    }

    @Override
    public long getLastCheckpointTotalPagesNumber() {
        return this.lastCpTotalPages;
    }

    @Override
    public long getLastCheckpointDataPagesNumber() {
        return this.lastCpDataPages;
    }

    @Override
    public long getLastCheckpointCopiedOnWritePagesNumber() {
        return this.lastCpCowPages;
    }

    @Override
    public long getWalTotalSize() {
        return this.walTotalSize;
    }

    @Override
    public long getWalLastRollOverTime() {
        return this.walLastRollOverTime;
    }

    @Override
    public long getCheckpointTotalTime() {
        return this.checkpointTotalTime;
    }

    @Override
    public long getDirtyPages() {
        return this.dirtyPages;
    }

    @Override
    public long getPagesRead() {
        return this.readPages;
    }

    @Override
    public long getPagesWritten() {
        return this.writtenPages;
    }

    @Override
    public long getPagesReplaced() {
        return this.replacedPages;
    }

    @Override
    public long getOffHeapSize() {
        return this.offHeapSize;
    }

    @Override
    public long getOffheapUsedSize() {
        return this.offHeadUsedSize;
    }

    @Override
    public long getTotalAllocatedSize() {
        return this.totalAllocatedSize;
    }

    @Override
    public long getUsedCheckpointBufferPages() {
        return this.usedCheckpointBufferPages;
    }

    @Override
    public long getUsedCheckpointBufferSize() {
        return this.usedCheckpointBufferSize;
    }

    @Override
    public long getCheckpointBufferSize() {
        return this.checkpointBufferSize;
    }

    public String toString() {
        return S.toString(DataStorageMetricsSnapshot.class, this);
    }
}

