/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import org.apache.ignite.IgniteCacheRestartingException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.internal.S;

public class TxTopologyVersionFuture
extends GridFutureAdapter<AffinityTopologyVersion> {
    private final GridNearTxLocal tx;
    private final GridCacheContext<?, ?> cctx;
    private boolean topLocked;

    public TxTopologyVersionFuture(GridNearTxLocal tx, GridCacheContext cctx) {
        this.tx = tx;
        this.cctx = cctx;
        this.init();
    }

    private void init() {
        long threadId = Thread.currentThread().getId();
        AffinityTopologyVersion topVer = this.cctx.mvcc().lastExplicitLockTopologyVersion(threadId);
        if (topVer == null && this.tx.system()) {
            topVer = this.cctx.tm().lockedTopologyVersion(threadId, this.tx);
        }
        if (topVer != null) {
            this.tx.topologyVersion(topVer);
        }
        if (topVer == null) {
            topVer = this.tx.topologyVersionSnapshot();
        }
        if (topVer != null) {
            for (GridDhtTopologyFuture gridDhtTopologyFuture : this.cctx.shared().exchange().exchangeFutures()) {
                if (!gridDhtTopologyFuture.exchangeDone() || !gridDhtTopologyFuture.topologyVersion().equals(topVer)) continue;
                Throwable err = null;
                try {
                    gridDhtTopologyFuture.get();
                }
                catch (IgniteCheckedException e) {
                    err = gridDhtTopologyFuture.error();
                }
                if (err == null) {
                    err = gridDhtTopologyFuture.validateCache(this.cctx, false, false, null, null);
                }
                if (err == null) break;
                this.onDone(err);
                return;
            }
            this.onDone(topVer);
            this.topLocked = true;
            return;
        }
        this.acquireTopologyVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireTopologyVersion() {
        this.cctx.topology().readLock();
        try {
            if (this.cctx.topology().stopping()) {
                this.onDone(this.cctx.shared().cache().isCacheRestarting(this.cctx.name()) ? new IgniteCacheRestartingException(this.cctx.name()) : new CacheStoppedException(this.cctx.name()));
                return;
            }
            GridDhtTopologyFuture fut = this.cctx.topologyVersionFuture();
            if (fut.isDone()) {
                Throwable err = fut.validateCache(this.cctx, false, false, null, null);
                if (err != null) {
                    this.onDone(err);
                    return;
                }
                AffinityTopologyVersion topVer = fut.topologyVersion();
                if (this.tx != null) {
                    this.tx.topologyVersion(topVer);
                }
                this.onDone(topVer);
            } else {
                fut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                    @Override
                    public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                        try {
                            fut.get();
                            TxTopologyVersionFuture.this.acquireTopologyVersion();
                        }
                        catch (IgniteCheckedException e) {
                            TxTopologyVersionFuture.this.onDone(e);
                        }
                        finally {
                            TxTopologyVersionFuture.this.cctx.shared().txContextReset();
                        }
                    }
                });
            }
        }
        finally {
            this.cctx.topology().readUnlock();
        }
    }

    public boolean clientFirst() {
        return this.cctx.localNode().isClient() && !this.topLocked && !this.tx.hasRemoteLocks();
    }

    @Override
    public String toString() {
        return S.toString(TxTopologyVersionFuture.class, this, super.toString());
    }
}

