/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.colocated;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCacheRestartingException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteDiagnosticAware;
import org.apache.ignite.internal.IgniteDiagnosticPrepareContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.GridCacheCompoundIdentityFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheLockTimeoutException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheVersionedFuture;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.colocated.GridDhtDetachedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearLockMapping;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearLockRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearLockResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.TxDeadlock;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.future.GridEmbeddedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.C2;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionDeadlockException;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public final class GridDhtColocatedLockFuture
extends GridCacheCompoundIdentityFuture<Boolean>
implements GridCacheVersionedFuture<Boolean>,
IgniteDiagnosticAware {
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private static IgniteLogger msgLog;
    private static final AtomicIntegerFieldUpdater<GridDhtColocatedLockFuture> DONE_UPD;
    @GridToStringExclude
    private final GridCacheContext<?, ?> cctx;
    @GridToStringInclude
    private final long threadId;
    @GridToStringInclude
    private Collection<KeyCacheObject> keys;
    private final IgniteUuid futId;
    private final GridCacheVersion lockVer;
    private final boolean read;
    private final boolean retval;
    private volatile Throwable err;
    @GridToStringExclude
    private volatile LockTimeoutObject timeoutObj;
    private final long timeout;
    private final CacheEntryPredicate[] filter;
    @GridToStringExclude
    private final GridNearTxLocal tx;
    private volatile AffinityTopologyVersion topVer;
    private final Map<KeyCacheObject, IgniteBiTuple<GridCacheVersion, CacheObject>> valMap;
    private volatile int done;
    private boolean trackable;
    private final long createTtl;
    private final long accessTtl;
    private final boolean skipStore;
    private Deque<GridNearLockMapping> mappings;
    private final boolean keepBinary;
    private final boolean recovery;
    private int miniId;
    private boolean mappingsReady;

    public GridDhtColocatedLockFuture(GridCacheContext<?, ?> cctx, Collection<KeyCacheObject> keys, @Nullable GridNearTxLocal tx, boolean read, boolean retval, long timeout, long createTtl, long accessTtl, CacheEntryPredicate[] filter, boolean skipStore, boolean keepBinary, boolean recovery) {
        super(CU.boolReducer());
        assert (keys != null);
        this.cctx = cctx;
        this.keys = keys;
        this.tx = tx;
        this.read = read;
        this.retval = retval;
        this.timeout = timeout;
        this.createTtl = createTtl;
        this.accessTtl = accessTtl;
        this.filter = filter;
        this.skipStore = skipStore;
        this.keepBinary = keepBinary;
        this.recovery = recovery;
        this.ignoreInterrupts();
        this.threadId = tx == null ? Thread.currentThread().getId() : tx.threadId();
        this.lockVer = tx != null ? tx.xidVersion() : cctx.versions().next();
        this.futId = IgniteUuid.randomUuid();
        if (log == null) {
            msgLog = cctx.shared().txLockMessageLogger();
            log = U.logger(cctx.kernalContext(), logRef, GridDhtColocatedLockFuture.class);
        }
        this.valMap = new ConcurrentHashMap<KeyCacheObject, IgniteBiTuple<GridCacheVersion, CacheObject>>();
        if (tx != null && !tx.updateLockFuture(null, this)) {
            this.onError(tx.timedOut() ? tx.timeoutException() : tx.rollbackException());
            this.onComplete(false, false);
        }
    }

    @Override
    public GridCacheVersion version() {
        return this.lockVer;
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        return false;
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
        this.trackable = false;
    }

    private boolean inTx() {
        return this.tx != null;
    }

    private boolean implicitSingleTx() {
        return this.tx != null && this.tx.implicitSingle();
    }

    private boolean isInvalidate() {
        return this.tx != null && this.tx.isInvalidate();
    }

    @Nullable
    private TransactionIsolation isolation() {
        return this.tx == null ? null : this.tx.isolation();
    }

    private boolean implicitTx() {
        return this.tx != null && this.tx.implicit();
    }

    @Nullable
    private GridCacheMvccCandidate addEntry(GridDistributedCacheEntry entry) throws IgniteCheckedException {
        IgniteTxKey txKey = entry.txKey();
        GridCacheMvccCandidate cand = this.cctx.mvcc().explicitLock(this.threadId, txKey);
        if (this.inTx()) {
            if (cand != null) {
                if (!this.tx.implicit()) {
                    throw new IgniteCheckedException("Cannot access key within transaction if lock is externally held [key=" + entry.key() + ", entry=" + entry + ']');
                }
                return null;
            }
            IgniteTxEntry txEntry = this.tx.entry(txKey);
            assert (txEntry != null);
            txEntry.cached(entry);
            cand = new GridCacheMvccCandidate(entry, this.cctx.localNodeId(), null, null, this.threadId, this.lockVer, true, txEntry.locked(), this.inTx(), this.inTx() && this.tx.implicitSingle(), false, false, null, false);
            cand.topologyVersion(this.topVer);
        } else {
            if (cand == null) {
                cand = new GridCacheMvccCandidate(entry, this.cctx.localNodeId(), null, null, this.threadId, this.lockVer, true, false, this.inTx(), this.inTx() && this.tx.implicitSingle(), false, false, null, false);
                cand.topologyVersion(this.topVer);
            } else {
                cand = cand.reenter();
            }
            this.cctx.mvcc().addExplicitLock(this.threadId, cand, this.topVer);
        }
        return cand;
    }

    private void undoLocks(boolean dist, boolean rollback) {
        if (dist && this.tx == null) {
            this.cctx.colocated().removeLocks(this.threadId, this.lockVer, this.keys);
        } else if (rollback && this.tx != null) {
            if (this.tx.setRollbackOnly()) {
                if (log.isDebugEnabled()) {
                    log.debug("Marked transaction as rollback only because locks could not be acquired: " + this.tx);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Transaction was not marked rollback-only while locks were not acquired: " + this.tx);
            }
        }
        this.cctx.mvcc().recheckPendingLocks();
    }

    public void complete(boolean success) {
        this.onComplete(success, true);
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f;
            if (!this.isMini(fut) || !(f = (MiniFuture)fut).node().id().equals(nodeId)) continue;
            f.onResult(this.newTopologyException(null, nodeId));
            found = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Near lock future does not have mapping for left node (ignoring) [nodeId=" + nodeId + ", fut=" + this + ']');
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onResult(UUID nodeId, GridNearLockResponse res) {
        boolean done = this.isDone();
        if (!done) {
            if (this.timeoutObj == null) {
                this.onResult0(nodeId, res);
                return;
            }
            LockTimeoutObject lockTimeoutObject = this.timeoutObj;
            synchronized (lockTimeoutObject) {
                if (!this.isDone()) {
                    if (this.onResult0(nodeId, res)) {
                        return;
                    }
                } else {
                    done = true;
                }
            }
        }
        if (done && msgLog.isDebugEnabled()) {
            msgLog.debug("Collocated lock fut, response for finished future [txId=" + this.lockVer + ", inTx=" + this.inTx() + ", node=" + nodeId + ']');
        }
    }

    private boolean onResult0(UUID nodeId, GridNearLockResponse res) {
        MiniFuture mini = this.miniFuture(res.miniId());
        if (mini != null) {
            assert (mini.node().id().equals(nodeId));
            mini.onResult(res);
            return true;
        }
        U.warn(msgLog, "Collocated lock fut, failed to find mini future [txId=" + this.lockVer + ", tx=" + (this.inTx() ? CU.txString(this.tx) : "N/A") + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        return false;
    }

    public synchronized Set<IgniteTxKey> requestedKeys() {
        if (this.timeoutObj != null && this.timeoutObj.requestedKeys != null) {
            return this.timeoutObj.requestedKeys;
        }
        return this.requestedKeys0();
    }

    private Set<IgniteTxKey> requestedKeys0() {
        for (IgniteInternalFuture miniFut : this.futures()) {
            if (!this.isMini(miniFut) || miniFut.isDone()) continue;
            MiniFuture mini = (MiniFuture)miniFut;
            HashSet<IgniteTxKey> requestedKeys = U.newHashSet(mini.keys.size());
            for (KeyCacheObject key : mini.keys) {
                requestedKeys.add(new IgniteTxKey(key, this.cctx.cacheId()));
            }
            return requestedKeys;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MiniFuture miniFuture(int miniId) {
        GridDhtColocatedLockFuture gridDhtColocatedLockFuture = this;
        synchronized (gridDhtColocatedLockFuture) {
            int size = this.futuresCountNoLock();
            for (int i = 0; i < size; ++i) {
                MiniFuture mini;
                IgniteInternalFuture fut = this.future(i);
                if (!this.isMini(fut) || (mini = (MiniFuture)fut).futureId() != miniId) continue;
                if (!mini.isDone()) {
                    return mini;
                }
                return null;
            }
        }
        return null;
    }

    private synchronized void onError(Throwable t) {
        if (this.err == null && !(t instanceof GridCacheLockTimeoutException)) {
            this.err = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        if (this.inTx()) {
            this.onError(this.tx.rollbackException());
            GridDhtColocatedLockFuture gridDhtColocatedLockFuture = this;
            synchronized (gridDhtColocatedLockFuture) {
                while (!this.mappingsReady) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return this.onComplete(false, true);
    }

    @Override
    public boolean onDone(Boolean success, Throwable err) {
        if (log.isDebugEnabled()) {
            log.debug("Received onDone(..) callback [success=" + success + ", err=" + err + ", fut=" + this + ']');
        }
        if (this.inTx() && this.err instanceof IgniteTxTimeoutCheckedException && this.cctx.tm().deadlockDetectionEnabled()) {
            return false;
        }
        if (this.isDone()) {
            return false;
        }
        if (err != null) {
            this.onError(err);
        }
        if (err != null) {
            success = false;
        }
        return this.onComplete(success, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onComplete(boolean success, boolean distribute) {
        if (log.isDebugEnabled()) {
            log.debug("Received onComplete(..) callback [success=" + success + ", distribute=" + distribute + ", fut=" + this + ']');
        }
        if (!DONE_UPD.compareAndSet(this, 0, 1)) {
            return false;
        }
        if (!success) {
            this.undoLocks(distribute, true);
        }
        if (this.tx != null) {
            this.cctx.tm().txContext(this.tx);
            if (success) {
                this.tx.clearLockFuture(this);
            }
        }
        if (super.onDone(success, this.err)) {
            if (log.isDebugEnabled()) {
                log.debug("Completing future: " + this);
            }
            this.cctx.mvcc().removeVersionedFuture(this);
            if (this.timeoutObj != null) {
                this.cctx.time().removeTimeoutObject(this.timeoutObj);
            }
            if (this.tx != null) {
                GridDhtColocatedLockFuture gridDhtColocatedLockFuture = this;
                synchronized (gridDhtColocatedLockFuture) {
                    if (!this.mappingsReady) {
                        this.mappingsReady = true;
                        this.notifyAll();
                    }
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.futId.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiagnosticRequest(IgniteDiagnosticPrepareContext ctx) {
        if (!this.isDone()) {
            for (IgniteInternalFuture fut : this.futures()) {
                if (fut.isDone() || !this.isMini(fut)) continue;
                MiniFuture m = (MiniFuture)fut;
                AffinityTopologyVersion topVer = null;
                UUID rmtNodeId = null;
                MiniFuture miniFuture = m;
                synchronized (miniFuture) {
                    if (!m.rcvRes && !m.node.isLocal()) {
                        rmtNodeId = m.node.id();
                        topVer = this.topVer;
                    }
                }
                if (rmtNodeId == null) continue;
                ctx.txKeyInfo(rmtNodeId, this.cctx.cacheId(), m.keys, "GridDhtColocatedLockFuture waiting for response [node=" + rmtNodeId + ", cache=" + this.cctx.name() + ", miniId=" + m.futId + ", topVer=" + topVer + ", keys=" + m.keys + ']');
                return;
            }
        }
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String apply(IgniteInternalFuture<?> f) {
                if (GridDhtColocatedLockFuture.this.isMini(f)) {
                    MiniFuture m;
                    MiniFuture miniFuture = m = (MiniFuture)f;
                    synchronized (miniFuture) {
                        return "[node=" + m.node().id() + ", rcvRes=" + m.rcvRes + ", loc=" + m.node().isLocal() + ", done=" + f.isDone() + "]";
                    }
                }
                return "[loc=true, done=" + f.isDone() + "]";
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridDhtColocatedLockFuture.class, this, "topVer", this.topVer, "innerFuts", futs, "inTx", this.inTx(), "super", super.toString());
    }

    private boolean isMini(IgniteInternalFuture<?> f) {
        return f.getClass().equals(MiniFuture.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void map() {
        AffinityTopologyVersion topVer;
        if (this.isDone()) {
            return;
        }
        if (this.timeout > 0L) {
            this.timeoutObj = new LockTimeoutObject();
            this.cctx.time().addTimeoutObject(this.timeoutObj);
        }
        if ((topVer = this.cctx.mvcc().lastExplicitLockTopologyVersion(this.threadId)) == null && this.tx != null && this.tx.system()) {
            topVer = this.cctx.tm().lockedTopologyVersion(Thread.currentThread().getId(), this.tx);
        }
        if (topVer != null && this.tx != null) {
            this.tx.topologyVersion(topVer);
        }
        if (topVer == null && this.tx != null) {
            topVer = this.tx.topologyVersionSnapshot();
        }
        if (topVer != null) {
            for (GridDhtTopologyFuture gridDhtTopologyFuture : this.cctx.shared().exchange().exchangeFutures()) {
                if (!gridDhtTopologyFuture.exchangeDone() || !gridDhtTopologyFuture.topologyVersion().equals(topVer)) continue;
                Throwable err = null;
                try {
                    gridDhtTopologyFuture.get();
                }
                catch (IgniteCheckedException e) {
                    err = gridDhtTopologyFuture.error();
                }
                if (err == null) {
                    err = gridDhtTopologyFuture.validateCache(this.cctx, this.recovery, this.read, null, this.keys);
                }
                if (err == null) break;
                this.onDone(err);
                return;
            }
            GridDhtColocatedLockFuture gridDhtColocatedLockFuture = this;
            synchronized (gridDhtColocatedLockFuture) {
                if (this.topVer == null) {
                    this.topVer = topVer;
                }
            }
            this.map(this.keys, false, true);
            this.markInitialized();
            return;
        }
        this.mapOnTopology(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapOnTopology(boolean remap, @Nullable Runnable c) {
        block19: {
            this.cctx.topology().readLock();
            try {
                if (this.cctx.topology().stopping()) {
                    this.onDone(this.cctx.shared().cache().isCacheRestarting(this.cctx.name()) ? new IgniteCacheRestartingException(this.cctx.name()) : new CacheStoppedException(this.cctx.name()));
                    return;
                }
                GridDhtTopologyFuture fut = this.cctx.topologyVersionFuture();
                if (fut.isDone()) {
                    Throwable err = fut.validateCache(this.cctx, this.recovery, this.read, null, this.keys);
                    if (err != null) {
                        this.onDone(err);
                        return;
                    }
                    AffinityTopologyVersion topVer = fut.topologyVersion();
                    if (remap) {
                        if (this.tx != null) {
                            this.tx.onRemap(topVer);
                        }
                        GridDhtColocatedLockFuture gridDhtColocatedLockFuture = this;
                        synchronized (gridDhtColocatedLockFuture) {
                            this.topVer = topVer;
                        }
                    }
                    if (this.tx != null) {
                        this.tx.topologyVersion(topVer);
                    }
                    GridDhtColocatedLockFuture gridDhtColocatedLockFuture = this;
                    synchronized (gridDhtColocatedLockFuture) {
                        if (this.topVer == null) {
                            this.topVer = topVer;
                        }
                    }
                    this.map(this.keys, remap, false);
                    if (c != null) {
                        c.run();
                    }
                    this.markInitialized();
                    break block19;
                }
                this.cctx.time().waitAsync(fut, this.tx == null ? 0L : this.tx.remainingTime(), (e, timedOut) -> {
                    if (this.errorOrTimeoutOnTopologyVersion((IgniteCheckedException)e, (boolean)timedOut)) {
                        return;
                    }
                    try {
                        this.mapOnTopology(remap, c);
                    }
                    finally {
                        this.cctx.shared().txContextReset();
                    }
                });
            }
            finally {
                this.cctx.topology().readUnlock();
            }
        }
    }

    private void map(Collection<KeyCacheObject> keys, boolean remap, boolean topLocked) {
        try {
            this.map0(keys, remap, topLocked);
        }
        catch (IgniteCheckedException ex) {
            this.onDone(false, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void map0(Collection<KeyCacheObject> keys, boolean remap, boolean topLocked) throws IgniteCheckedException {
        try {
            AffinityTopologyVersion topVer = this.topVer;
            assert (topVer != null);
            assert (topVer.topologyVersion() > 0L);
            if (CU.affinityNodes(this.cctx, topVer).isEmpty()) {
                this.onDone(new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid): " + this.cctx.name()));
                return;
            }
            boolean clientNode = this.cctx.kernalContext().clientNode();
            assert (!remap || clientNode && (this.tx == null || !this.tx.hasRemoteLocks()));
            if (!clientNode && this.mapAsPrimary(keys, topVer)) {
                return;
            }
            this.mappings = new ArrayDeque<GridNearLockMapping>();
            GridNearLockMapping map = null;
            for (KeyCacheObject key : keys) {
                GridNearLockMapping updated = this.map(key, map, topVer);
                if (updated != map) {
                    this.mappings.add(updated);
                    if (this.tx != null && updated.node().isLocal()) {
                        this.tx.colocatedLocallyMapped(true);
                    }
                }
                map = updated;
            }
            if (this.isDone()) {
                if (log.isDebugEnabled()) {
                    log.debug("Abandoning (re)map because future is done: " + this);
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Starting (re)map for mappings [mappings=" + this.mappings + ", fut=" + this + ']');
            }
            boolean hasRmtNodes = false;
            boolean first = true;
            Iterator<GridNearLockMapping> iter = this.mappings.iterator();
            while (iter.hasNext()) {
                GridNearLockMapping mapping = iter.next();
                ClusterNode node = mapping.node();
                Collection<KeyCacheObject> mappedKeys = mapping.mappedKeys();
                boolean loc = node.equals(this.cctx.localNode());
                assert (!mappedKeys.isEmpty());
                GridNearLockRequest req = null;
                ArrayList<KeyCacheObject> distributedKeys = new ArrayList<KeyCacheObject>(mappedKeys.size());
                for (KeyCacheObject key : mappedKeys) {
                    boolean marked;
                    boolean explicit;
                    IgniteTxEntry txEntry;
                    IgniteTxKey txKey = this.cctx.txKey(key);
                    GridDistributedCacheEntry entry = null;
                    if (this.tx != null && (txEntry = this.tx.entry(txKey)) != null && (entry = (GridDistributedCacheEntry)txEntry.cached()) != null && loc == entry.detached()) {
                        entry = this.cctx.colocated().entryExx(key, topVer, true);
                        txEntry.cached(entry);
                    }
                    while (true) {
                        block43: {
                            try {
                                if (entry == null) {
                                    entry = this.cctx.colocated().entryExx(key, topVer, true);
                                }
                                if (this.cctx.isAll((GridCacheEntryEx)entry, this.filter)) break block43;
                                if (log.isDebugEnabled()) {
                                    log.debug("Entry being locked did not pass filter (will not lock): " + entry);
                                }
                                this.onComplete(false, false);
                                return;
                            }
                            catch (GridCacheEntryRemovedException ignored) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Got removed entry in lockAsync(..) method (will retry): " + entry);
                                }
                                entry = null;
                                continue;
                            }
                        }
                        assert (loc ^ entry.detached()) : "Invalid entry [loc=" + loc + ", entry=" + entry + ']';
                        GridCacheMvccCandidate cand = this.addEntry(entry);
                        IgniteBiTuple<GridCacheVersion, CacheObject> val = entry.detached() ? null : ((GridDhtCacheEntry)entry).versionedValue(topVer);
                        GridCacheVersion dhtVer = null;
                        if (val != null) {
                            dhtVer = val.get1();
                            this.valMap.put(key, val);
                        }
                        if (cand != null && !cand.reentry()) {
                            if (req == null) {
                                boolean clientFirst = false;
                                if (first) {
                                    clientFirst = clientNode && !topLocked && (this.tx == null || !this.tx.hasRemoteLocks());
                                    first = false;
                                }
                                assert (!this.implicitTx() && !this.implicitSingleTx()) : this.tx;
                                req = new GridNearLockRequest(this.cctx.cacheId(), topVer, this.cctx.nodeId(), this.threadId, this.futId, this.lockVer, this.inTx(), this.read, this.retval, this.isolation(), this.isInvalidate(), this.timeout, mappedKeys.size(), this.inTx() ? this.tx.size() : mappedKeys.size(), this.inTx() && this.tx.syncMode() == CacheWriteSynchronizationMode.FULL_SYNC, this.inTx() ? this.tx.subjectId() : null, this.inTx() ? this.tx.taskNameHash() : 0, this.read ? this.createTtl : -1L, this.read ? this.accessTtl : -1L, this.skipStore, this.keepBinary, clientFirst, false, this.cctx.deploymentEnabled(), this.inTx() ? this.tx.label() : null);
                                mapping.request(req);
                            }
                            distributedKeys.add(key);
                            if (this.tx != null) {
                                this.tx.addKeyMapping(txKey, mapping.node());
                            }
                            req.addKeyBytes(key, this.retval, dhtVer, this.cctx);
                        }
                        boolean bl = explicit = this.inTx() && cand == null;
                        if (!explicit) break;
                        this.tx.addKeyMapping(txKey, mapping.node());
                        break;
                    }
                    if (!explicit) continue;
                    boolean bl = marked = this.tx != null && this.tx.markExplicit(node.id());
                    assert (this.tx == null || marked);
                }
                if (!distributedKeys.isEmpty()) {
                    mapping.distributedKeys(distributedKeys);
                    hasRmtNodes |= !mapping.node().isLocal();
                    continue;
                }
                assert (mapping.request() == null);
                iter.remove();
            }
            if (hasRmtNodes) {
                this.trackable = true;
                if (!remap && !this.cctx.mvcc().addFuture(this)) {
                    throw new IllegalStateException("Duplicate future ID: " + this);
                }
            } else {
                this.trackable = false;
            }
        }
        finally {
            if (this.tx != null) {
                this.mappingsReady = true;
                this.notifyAll();
            }
        }
        this.proceedMapping();
    }

    private void proceedMapping() throws IgniteCheckedException {
        boolean set = this.tx != null && this.cctx.shared().tm().setTxTopologyHint(this.tx.topologyVersionSnapshot());
        try {
            this.proceedMapping0();
        }
        finally {
            if (set) {
                this.cctx.tm().setTxTopologyHint(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceedMapping0() throws IgniteCheckedException {
        GridNearLockMapping map;
        if (this.isDone()) {
            this.clear();
            return;
        }
        if (this.tx != null && this.tx.remainingTime() == -1L) {
            this.onDone(false, (Throwable)this.tx.timeoutException());
            this.clear();
            return;
        }
        GridDhtColocatedLockFuture gridDhtColocatedLockFuture = this;
        synchronized (gridDhtColocatedLockFuture) {
            map = this.mappings.poll();
        }
        if (map == null) {
            return;
        }
        final GridNearLockRequest req = map.request();
        Collection<KeyCacheObject> mappedKeys = map.distributedKeys();
        final ClusterNode node = map.node();
        if (this.filter != null && this.filter.length != 0) {
            req.filter(this.filter, this.cctx);
        }
        if (node.isLocal()) {
            this.lockLocally(mappedKeys, req.topologyVersion());
        } else {
            final MiniFuture fut = new MiniFuture(node, mappedKeys, ++this.miniId);
            req.miniId(fut.futureId());
            this.add(fut);
            IgniteInternalFuture<?> txSync = null;
            if (this.inTx()) {
                txSync = this.cctx.tm().awaitFinishAckAsync(node.id(), this.tx.threadId());
            }
            if (txSync == null || txSync.isDone()) {
                try {
                    this.cctx.io().send(node, (GridCacheMessage)req, this.cctx.ioPolicy());
                    if (msgLog.isDebugEnabled()) {
                        msgLog.debug("Collocated lock fut, sent request [txId=" + this.lockVer + ", inTx=" + this.inTx() + ", node=" + node.id() + ']');
                    }
                }
                catch (ClusterTopologyCheckedException ex) {
                    assert (fut != null);
                    fut.onResult(ex);
                }
            } else {
                txSync.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> t) {
                        try {
                            GridDhtColocatedLockFuture.this.cctx.io().send(node, (GridCacheMessage)req, GridDhtColocatedLockFuture.this.cctx.ioPolicy());
                            if (msgLog.isDebugEnabled()) {
                                msgLog.debug("Collocated lock fut, sent request [txId=" + GridDhtColocatedLockFuture.this.lockVer + ", inTx=" + GridDhtColocatedLockFuture.this.inTx() + ", node=" + node.id() + ']');
                            }
                        }
                        catch (ClusterTopologyCheckedException ex) {
                            assert (fut != null);
                            fut.onResult(ex);
                        }
                        catch (IgniteCheckedException e) {
                            if (msgLog.isDebugEnabled()) {
                                msgLog.debug("Collocated lock fut, failed to send request [txId=" + GridDhtColocatedLockFuture.this.lockVer + ", inTx=" + GridDhtColocatedLockFuture.this.inTx() + ", node=" + node.id() + ", err=" + e + ']');
                            }
                            GridDhtColocatedLockFuture.this.onError(e);
                        }
                    }
                });
            }
        }
    }

    private void lockLocally(final Collection<KeyCacheObject> keys, AffinityTopologyVersion topVer) {
        if (log.isDebugEnabled()) {
            log.debug("Before locally locking keys : " + keys);
        }
        IgniteInternalFuture<Exception> fut = this.cctx.colocated().lockAllAsync(this.cctx, this.tx, this.threadId, this.lockVer, topVer, keys, this.read, this.retval, this.timeout, this.createTtl, this.accessTtl, this.filter, this.skipStore, this.keepBinary);
        this.add(new GridEmbeddedFuture<Boolean, Exception>(new C2<Exception, Exception, Boolean>(){

            @Override
            public Boolean apply(Exception resEx, Exception e) {
                if (CU.isLockTimeoutOrCancelled(e) || resEx != null && CU.isLockTimeoutOrCancelled(resEx)) {
                    return false;
                }
                if (e != null) {
                    GridDhtColocatedLockFuture.this.onError(e);
                    return false;
                }
                if (resEx != null) {
                    GridDhtColocatedLockFuture.this.onError(resEx);
                    return false;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Acquired lock for local DHT mapping [locId=" + GridDhtColocatedLockFuture.this.cctx.nodeId() + ", mappedKeys=" + keys + ", fut=" + GridDhtColocatedLockFuture.this + ']');
                }
                if (GridDhtColocatedLockFuture.this.inTx()) {
                    for (KeyCacheObject key : keys) {
                        GridDhtColocatedLockFuture.this.tx.entry(GridDhtColocatedLockFuture.this.cctx.txKey(key)).markLocked();
                    }
                } else {
                    for (KeyCacheObject key : keys) {
                        GridDhtColocatedLockFuture.this.cctx.mvcc().markExplicitOwner(GridDhtColocatedLockFuture.this.cctx.txKey(key), GridDhtColocatedLockFuture.this.threadId);
                    }
                }
                try {
                    if (GridDhtColocatedLockFuture.this.mappings != null) {
                        GridDhtColocatedLockFuture.this.proceedMapping();
                    }
                }
                catch (IgniteCheckedException ex) {
                    GridDhtColocatedLockFuture.this.onError(ex);
                    return false;
                }
                return true;
            }
        }, fut));
    }

    private boolean mapAsPrimary(Collection<KeyCacheObject> keys, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        ArrayList<KeyCacheObject> distributedKeys = new ArrayList<KeyCacheObject>(keys.size());
        boolean explicit = false;
        for (KeyCacheObject key : keys) {
            if (!this.cctx.affinity().primaryByKey(this.cctx.localNode(), key, topVer)) {
                for (KeyCacheObject k : keys) {
                    this.cctx.mvcc().removeExplicitLock(this.threadId, this.cctx.txKey(k), this.lockVer);
                }
                return false;
            }
            explicit |= this.addLocalKey(key, topVer, distributedKeys);
            if (!this.isDone()) continue;
            return true;
        }
        this.trackable = false;
        if (this.tx != null) {
            if (explicit) {
                this.tx.markExplicit(this.cctx.localNodeId());
            }
            this.tx.colocatedLocallyMapped(true);
        }
        if (!distributedKeys.isEmpty()) {
            if (this.tx != null) {
                for (KeyCacheObject key : distributedKeys) {
                    this.tx.addKeyMapping(this.cctx.txKey(key), this.cctx.localNode());
                }
            }
            this.lockLocally(distributedKeys, topVer);
        }
        return true;
    }

    private boolean addLocalKey(KeyCacheObject key, AffinityTopologyVersion topVer, Collection<KeyCacheObject> distributedKeys) throws IgniteCheckedException {
        GridDistributedCacheEntry entry = this.cctx.colocated().entryExx(key, topVer, false);
        assert (!entry.detached());
        if (!this.cctx.isAll((GridCacheEntryEx)entry, this.filter)) {
            if (log.isDebugEnabled()) {
                log.debug("Entry being locked did not pass filter (will not lock): " + entry);
            }
            this.onComplete(false, false);
            return false;
        }
        GridCacheMvccCandidate cand = this.addEntry(entry);
        if (cand != null && !cand.reentry()) {
            distributedKeys.add(key);
        }
        return this.inTx() && cand == null;
    }

    private GridNearLockMapping map(KeyCacheObject key, @Nullable GridNearLockMapping mapping, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        assert (mapping == null || mapping.node() != null);
        ClusterNode primary = this.cctx.affinity().primaryByKey(key, topVer);
        if (primary == null) {
            throw new ClusterTopologyServerNotFoundException("Failed to lock keys (all partition nodes left the grid).");
        }
        if (this.cctx.discovery().node(primary.id()) == null) {
            throw this.newTopologyException(null, primary.id());
        }
        if (mapping == null || !primary.id().equals(mapping.node().id())) {
            mapping = new GridNearLockMapping(primary, key);
        } else {
            mapping.addKey(key);
        }
        return mapping;
    }

    private ClusterTopologyCheckedException newTopologyException(@Nullable Throwable nested, UUID nodeId) {
        ClusterTopologyCheckedException topEx = new ClusterTopologyCheckedException("Failed to acquire lock for keys (primary node left grid, retry transaction if possible) [keys=" + this.keys + ", node=" + nodeId + ']', nested);
        topEx.retryReadyFuture(this.cctx.shared().nextAffinityReadyFuture(this.topVer));
        return topEx;
    }

    private boolean errorOrTimeoutOnTopologyVersion(IgniteCheckedException e, boolean timedOut) {
        if (e != null || timedOut) {
            assert (e != null || this.tx != null) : "Timeout is possible only in transaction";
            this.onDone(e == null ? this.tx.timeoutException() : e);
            return true;
        }
        return false;
    }

    static {
        DONE_UPD = AtomicIntegerFieldUpdater.newUpdater(GridDhtColocatedLockFuture.class, "done");
    }

    private class MiniFuture
    extends GridFutureAdapter<Boolean> {
        private final int futId;
        @GridToStringExclude
        private final ClusterNode node;
        @GridToStringInclude
        private final Collection<KeyCacheObject> keys;
        private boolean rcvRes;
        private AffinityTopologyVersion remapTopVer;

        MiniFuture(ClusterNode node, Collection<KeyCacheObject> keys, int futId) {
            this.node = node;
            this.keys = keys;
            this.futId = futId;
        }

        int futureId() {
            return this.futId;
        }

        public ClusterNode node() {
            return this.node;
        }

        public Collection<KeyCacheObject> keys() {
            return this.keys;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onResult(ClusterTopologyCheckedException e) {
            if (msgLog.isDebugEnabled()) {
                msgLog.debug("Collocated lock fut, mini future node left [txId=" + GridDhtColocatedLockFuture.this.lockVer + ", inTx=" + GridDhtColocatedLockFuture.this.inTx() + ", nodeId=" + this.node.id() + ']');
            }
            if (this.isDone()) {
                return;
            }
            MiniFuture miniFuture = this;
            synchronized (miniFuture) {
                if (this.rcvRes) {
                    return;
                }
                this.rcvRes = true;
            }
            if (GridDhtColocatedLockFuture.this.tx != null) {
                GridDhtColocatedLockFuture.this.tx.removeMapping(this.node.id());
            }
            GridDhtColocatedLockFuture.this.onDone(false, (Throwable)GridDhtColocatedLockFuture.this.newTopologyException(e, this.node.id()));
            this.onDone(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onResult(GridNearLockResponse res) {
            MiniFuture miniFuture = this;
            synchronized (miniFuture) {
                if (this.rcvRes) {
                    return;
                }
                this.rcvRes = true;
                this.remapTopVer = res.clientRemapVersion();
            }
            if (res.error() != null) {
                if (GridDhtColocatedLockFuture.this.inTx() && res.error() instanceof IgniteTxTimeoutCheckedException && GridDhtColocatedLockFuture.this.cctx.tm().deadlockDetectionEnabled()) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Finishing mini future with an error due to error in response [miniFut=" + this + ", res=" + res + ']');
                }
                if (res.error() instanceof GridCacheLockTimeoutException) {
                    this.onDone(false);
                } else {
                    this.onDone(res.error());
                }
                return;
            }
            if (res.clientRemapVersion() != null) {
                assert (GridDhtColocatedLockFuture.this.cctx.kernalContext().clientNode());
                IgniteInternalFuture<AffinityTopologyVersion> affFut = GridDhtColocatedLockFuture.this.cctx.shared().exchange().affinityReadyFuture(res.clientRemapVersion());
                GridDhtColocatedLockFuture.this.cctx.time().waitAsync(affFut, GridDhtColocatedLockFuture.this.tx == null ? 0L : GridDhtColocatedLockFuture.this.tx.remainingTime(), (e, timedOut) -> {
                    if (GridDhtColocatedLockFuture.this.errorOrTimeoutOnTopologyVersion(e, timedOut)) {
                        return;
                    }
                    try {
                        this.remap();
                    }
                    finally {
                        GridDhtColocatedLockFuture.this.cctx.shared().txContextReset();
                    }
                });
            } else {
                int i = 0;
                for (KeyCacheObject k : this.keys) {
                    IgniteBiTuple oldValTup = (IgniteBiTuple)GridDhtColocatedLockFuture.this.valMap.get(k);
                    CacheObject newVal = res.value(i);
                    GridCacheVersion dhtVer = res.dhtVersion(i);
                    if (newVal == null && oldValTup != null && ((GridCacheVersion)oldValTup.get1()).equals(dhtVer)) {
                        newVal = (CacheObject)oldValTup.get2();
                    }
                    if (GridDhtColocatedLockFuture.this.inTx()) {
                        IgniteTxEntry txEntry = GridDhtColocatedLockFuture.this.tx.entry(GridDhtColocatedLockFuture.this.cctx.txKey(k));
                        assert (txEntry.cached().detached()) : txEntry;
                        txEntry.markLocked();
                        GridDhtDetachedCacheEntry entry = (GridDhtDetachedCacheEntry)txEntry.cached();
                        if (res.dhtVersion(i) == null) {
                            this.onDone(new IgniteCheckedException("Failed to receive DHT version from remote node (will fail the lock): " + res));
                            return;
                        }
                        entry.resetFromPrimary(newVal, dhtVer);
                        GridDhtColocatedLockFuture.this.tx.hasRemoteLocks(true);
                        if (log.isDebugEnabled()) {
                            log.debug("Processed response for entry [res=" + res + ", entry=" + entry + ']');
                        }
                    } else {
                        GridDhtColocatedLockFuture.this.cctx.mvcc().markExplicitOwner(GridDhtColocatedLockFuture.this.cctx.txKey(k), GridDhtColocatedLockFuture.this.threadId);
                    }
                    if (GridDhtColocatedLockFuture.this.retval && GridDhtColocatedLockFuture.this.cctx.events().isRecordable(64)) {
                        GridDhtColocatedLockFuture.this.cctx.events().addEvent(GridDhtColocatedLockFuture.this.cctx.affinity().partition(k), k, GridDhtColocatedLockFuture.this.tx, null, 64, newVal, newVal != null, null, false, CU.subjectId(GridDhtColocatedLockFuture.this.tx, GridDhtColocatedLockFuture.this.cctx.shared()), null, GridDhtColocatedLockFuture.this.tx == null ? null : GridDhtColocatedLockFuture.this.tx.resolveTaskName(), GridDhtColocatedLockFuture.this.keepBinary);
                    }
                    ++i;
                }
                try {
                    GridDhtColocatedLockFuture.this.proceedMapping();
                }
                catch (IgniteCheckedException e2) {
                    this.onDone(e2);
                }
                this.onDone(true);
            }
        }

        private void remap() {
            GridDhtColocatedLockFuture.this.undoLocks(false, false);
            for (KeyCacheObject key : GridDhtColocatedLockFuture.this.keys) {
                GridDhtColocatedLockFuture.this.cctx.mvcc().removeExplicitLock(GridDhtColocatedLockFuture.this.threadId, GridDhtColocatedLockFuture.this.cctx.txKey(key), GridDhtColocatedLockFuture.this.lockVer);
            }
            GridDhtColocatedLockFuture.this.mapOnTopology(true, new Runnable(){

                @Override
                public void run() {
                    MiniFuture.this.onDone(true);
                }
            });
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, "node", this.node.id(), "super", super.toString());
        }
    }

    private class LockTimeoutObject
    extends GridTimeoutObjectAdapter {
        private Set<IgniteTxKey> requestedKeys;

        LockTimeoutObject() {
            super(GridDhtColocatedLockFuture.this.timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTimeout() {
            if (log.isDebugEnabled()) {
                log.debug("Timed out waiting for lock response: " + this);
            }
            if (GridDhtColocatedLockFuture.this.inTx()) {
                if (GridDhtColocatedLockFuture.this.cctx.tm().deadlockDetectionEnabled()) {
                    GridDhtColocatedLockFuture gridDhtColocatedLockFuture = GridDhtColocatedLockFuture.this;
                    synchronized (gridDhtColocatedLockFuture) {
                        this.requestedKeys = GridDhtColocatedLockFuture.this.requestedKeys0();
                        GridDhtColocatedLockFuture.this.clear();
                    }
                    HashSet<IgniteTxKey> keys = new HashSet<IgniteTxKey>();
                    for (IgniteTxEntry txEntry : GridDhtColocatedLockFuture.this.tx.allEntries()) {
                        if (txEntry.locked()) continue;
                        keys.add(txEntry.txKey());
                    }
                    IgniteInternalFuture<TxDeadlock> fut = GridDhtColocatedLockFuture.this.cctx.tm().detectDeadlock(GridDhtColocatedLockFuture.this.tx, keys);
                    fut.listen(new IgniteInClosure<IgniteInternalFuture<TxDeadlock>>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void apply(IgniteInternalFuture<TxDeadlock> fut) {
                            try {
                                TxDeadlock deadlock = fut.get();
                                GridDhtColocatedLockFuture.this.err = new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + GridDhtColocatedLockFuture.this.tx.timeout() + ", tx=" + CU.txString(GridDhtColocatedLockFuture.this.tx) + ']', deadlock != null ? new TransactionDeadlockException(deadlock.toString(GridDhtColocatedLockFuture.this.cctx.shared())) : null);
                            }
                            catch (IgniteCheckedException e) {
                                GridDhtColocatedLockFuture.this.err = e;
                                U.warn(log, "Failed to detect deadlock.", e);
                            }
                            LockTimeoutObject lockTimeoutObject = LockTimeoutObject.this;
                            synchronized (lockTimeoutObject) {
                                GridDhtColocatedLockFuture.this.onComplete(false, true);
                            }
                        }
                    });
                } else {
                    GridDhtColocatedLockFuture.this.err = GridDhtColocatedLockFuture.this.tx.timeoutException();
                }
            } else {
                LockTimeoutObject lockTimeoutObject = this;
                synchronized (lockTimeoutObject) {
                    GridDhtColocatedLockFuture.this.onComplete(false, true);
                }
            }
        }

        public String toString() {
            return S.toString(LockTimeoutObject.class, this);
        }
    }
}

