/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryInvalidTypeException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CachePartialUpdateCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheAtomicFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheFutureAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicNearResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicCheckUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateResponse;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public abstract class GridNearAtomicAbstractUpdateFuture
extends GridCacheFutureAdapter<Object>
implements GridCacheAtomicFuture<Object> {
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    protected static IgniteLogger log;
    protected static IgniteLogger msgLog;
    protected final GridCacheContext cctx;
    protected final GridDhtAtomicCache cache;
    protected final CacheWriteSynchronizationMode syncMode;
    protected final GridCacheOperation op;
    protected final Object[] invokeArgs;
    protected final boolean retval;
    protected final boolean rawRetval;
    protected final ExpiryPolicy expiryPlc;
    protected final CacheEntryPredicate[] filter;
    protected final UUID subjId;
    protected final int taskNameHash;
    protected final boolean skipStore;
    protected final boolean keepBinary;
    protected final boolean recovery;
    protected final boolean nearEnabled;
    protected boolean topLocked;
    @GridToStringInclude
    protected int remapCnt;
    @GridToStringInclude
    protected AffinityTopologyVersion topVer = AffinityTopologyVersion.ZERO;
    @GridToStringInclude
    protected AffinityTopologyVersion remapTopVer;
    @GridToStringInclude
    protected CachePartialUpdateCheckedException err;
    @GridToStringInclude
    protected long futId;
    protected GridCacheReturn opRes;

    protected GridNearAtomicAbstractUpdateFuture(GridCacheContext cctx, GridDhtAtomicCache cache, CacheWriteSynchronizationMode syncMode, GridCacheOperation op, @Nullable Object[] invokeArgs, boolean retval, boolean rawRetval, @Nullable ExpiryPolicy expiryPlc, CacheEntryPredicate[] filter, UUID subjId, int taskNameHash, boolean skipStore, boolean keepBinary, boolean recovery, int remapCnt) {
        if (log == null) {
            msgLog = cctx.shared().atomicMessageLogger();
            log = U.logger(cctx.kernalContext(), logRef, GridFutureAdapter.class);
        }
        this.cctx = cctx;
        this.cache = cache;
        this.syncMode = syncMode;
        this.op = op;
        this.invokeArgs = invokeArgs;
        this.retval = retval;
        this.rawRetval = rawRetval;
        this.expiryPlc = expiryPlc;
        this.filter = filter;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.skipStore = skipStore;
        this.keepBinary = keepBinary;
        this.recovery = recovery;
        this.nearEnabled = CU.isNearEnabled(cctx);
        this.remapCnt = remapCnt;
    }

    final boolean futureMapped() {
        return this.topVer != AffinityTopologyVersion.ZERO;
    }

    final boolean checkFutureId(long futId) {
        return this.topVer != AffinityTopologyVersion.ZERO && this.futId == futId;
    }

    @Override
    public final IgniteInternalFuture<Void> completeFuture(AffinityTopologyVersion topVer) {
        return null;
    }

    void sendCheckUpdateRequest(GridNearAtomicCheckUpdateRequest req) {
        try {
            this.cctx.io().send(req.updateRequest().nodeId(), (GridCacheMessage)req, this.cctx.ioPolicy());
        }
        catch (ClusterTopologyCheckedException e) {
            this.onSendError(req, (IgniteCheckedException)e);
        }
        catch (IgniteCheckedException e) {
            this.completeFuture(null, e, req.futureId());
        }
    }

    public final void map() {
        AffinityTopologyVersion topVer = this.cctx.shared().lockedTopologyVersion(null);
        if (topVer == null) {
            this.mapOnTopology();
        } else {
            this.topLocked = true;
            this.remapCnt = 1;
            this.map(topVer);
        }
    }

    protected abstract void map(AffinityTopologyVersion var1);

    protected abstract void mapOnTopology();

    @Override
    public IgniteUuid futureId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean trackable() {
        return true;
    }

    @Override
    public void markNotTrackable() {
    }

    final boolean storeFuture() {
        return this.syncMode != CacheWriteSynchronizationMode.FULL_ASYNC;
    }

    final void sendSingleRequest(UUID nodeId, GridNearAtomicAbstractUpdateRequest req) {
        if (this.cctx.localNodeId().equals(nodeId)) {
            this.cache.updateAllAsyncInternal(this.cctx.localNode(), req, new GridDhtAtomicCache.UpdateReplyClosure(){

                @Override
                public void apply(GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res) {
                    if (GridNearAtomicAbstractUpdateFuture.this.syncMode != CacheWriteSynchronizationMode.FULL_ASYNC) {
                        GridNearAtomicAbstractUpdateFuture.this.onPrimaryResponse(res.nodeId(), res, false);
                    } else if (res.remapTopologyVersion() != null) {
                        ((GridDhtAtomicCache)GridNearAtomicAbstractUpdateFuture.this.cctx.cache()).remapToNewPrimary(req);
                    }
                }
            });
        } else {
            try {
                this.cctx.io().send(req.nodeId(), (GridCacheMessage)req, this.cctx.ioPolicy());
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near update fut, sent request [futId=" + req.futureId() + ", node=" + req.nodeId() + ']');
                }
            }
            catch (IgniteCheckedException e) {
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near update fut, failed to send request [futId=" + req.futureId() + ", node=" + req.nodeId() + ", err=" + e + ']');
                }
                this.onSendError(req, e);
            }
        }
    }

    public abstract void onPrimaryResponse(UUID var1, GridNearAtomicUpdateResponse var2, boolean var3);

    public abstract void onDhtResponse(UUID var1, GridDhtAtomicNearResponse var2);

    final void completeFuture(@Nullable GridCacheReturn ret, Throwable err, @Nullable Long futId) {
        Object retval;
        Object object = ret == null ? null : (this.rawRetval ? ret : (retval = this.retval || this.op == GridCacheOperation.TRANSFORM ? this.cctx.unwrapBinaryIfNeeded(ret.value(), this.keepBinary) : Boolean.valueOf(ret.success())));
        if (this.op == GridCacheOperation.TRANSFORM && retval == null) {
            retval = Collections.emptyMap();
        }
        if (futId != null) {
            this.cctx.mvcc().removeAtomicFuture(futId);
        }
        super.onDone(retval, err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean onDone(@Nullable Object res, @Nullable Throwable err) {
        assert (err != null) : "onDone should be called only to finish future with error on cache/node stop";
        Long futId = null;
        GridNearAtomicAbstractUpdateFuture gridNearAtomicAbstractUpdateFuture = this;
        synchronized (gridNearAtomicAbstractUpdateFuture) {
            if (this.futureMapped()) {
                futId = this.futId;
                this.topVer = AffinityTopologyVersion.ZERO;
                this.futId = 0L;
            }
        }
        if (super.onDone(null, err)) {
            if (futId != null) {
                this.cctx.mvcc().removeAtomicFuture(futId);
            }
            return true;
        }
        return false;
    }

    final void onPrimaryError(GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res) {
        assert (res.error() != null);
        if (this.err == null) {
            this.err = new CachePartialUpdateCheckedException("Failed to update keys (retry update if possible).");
        }
        Collection<KeyCacheObject> keys0 = res.failedKeys() != null ? res.failedKeys() : req.keys();
        ArrayList<Object> keys = new ArrayList<Object>(keys0.size());
        ArrayList<KeyCacheObject> failedToUnwrapKeys = null;
        Exception suppressedErr = null;
        for (KeyCacheObject key : keys0) {
            try {
                keys.add(this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(key, this.keepBinary, false));
            }
            catch (BinaryInvalidTypeException e) {
                keys.add(this.cctx.toCacheKeyObject(key));
                if (log.isDebugEnabled()) {
                    if (failedToUnwrapKeys == null) {
                        failedToUnwrapKeys = new ArrayList<KeyCacheObject>();
                    }
                    if (failedToUnwrapKeys.size() < 5) {
                        failedToUnwrapKeys.add(key);
                    }
                }
                suppressedErr = e;
            }
            catch (Exception e) {
                keys.add(this.cctx.toCacheKeyObject(key));
                suppressedErr = e;
            }
        }
        if (failedToUnwrapKeys != null) {
            log.warning("Failed to unwrap keys: " + failedToUnwrapKeys + " (the binary objects will be used instead).");
        }
        IgniteCheckedException error = res.error();
        if (suppressedErr != null) {
            error.addSuppressed(suppressedErr);
        }
        this.err.add(keys, error, req.topologyVersion());
    }

    final GridNearAtomicUpdateResponse primaryFailedResponse(GridNearAtomicAbstractUpdateRequest req) {
        assert (req.response() == null) : req;
        assert (req.nodeId() != null) : req;
        if (msgLog.isDebugEnabled()) {
            msgLog.debug("Near update fut, node left [futId=" + req.futureId() + ", node=" + req.nodeId() + ']');
        }
        GridNearAtomicUpdateResponse res = new GridNearAtomicUpdateResponse(this.cctx.cacheId(), req.nodeId(), req.futureId(), req.partition(), true, this.cctx.deploymentEnabled());
        ClusterTopologyCheckedException e = new ClusterTopologyCheckedException("Primary node left grid before response is received: " + req.nodeId());
        e.retryReadyFuture(this.cctx.shared().nextAffinityReadyFuture(req.topologyVersion()));
        res.addFailedKeys(req.keys(), e);
        return res;
    }

    final void onSendError(GridNearAtomicAbstractUpdateRequest req, IgniteCheckedException e) {
        GridNearAtomicUpdateResponse res = new GridNearAtomicUpdateResponse(this.cctx.cacheId(), req.nodeId(), req.futureId(), req.partition(), e instanceof ClusterTopologyCheckedException, this.cctx.deploymentEnabled());
        res.addFailedKeys(req.keys(), e);
        this.onPrimaryResponse(req.nodeId(), res, true);
    }

    private void onSendError(GridNearAtomicCheckUpdateRequest req, IgniteCheckedException e) {
        GridNearAtomicUpdateResponse res = new GridNearAtomicUpdateResponse(this.cctx.cacheId(), req.updateRequest().nodeId(), req.futureId(), req.partition(), e instanceof ClusterTopologyCheckedException, this.cctx.deploymentEnabled());
        res.addFailedKeys(req.updateRequest().keys(), e);
        this.onPrimaryResponse(req.updateRequest().nodeId(), res, true);
    }

    @Override
    public String toString() {
        return S.toString(GridNearAtomicAbstractUpdateFuture.class, this, super.toString());
    }

    static enum DhtLeftResult {
        DONE,
        NOT_DONE,
        ALL_RCVD_CHECK_PRIMARY;

    }

    static class PrimaryRequestState {
        final GridNearAtomicAbstractUpdateRequest req;
        @GridToStringInclude
        Map<UUID, NodeResult> mappedNodes;
        @GridToStringInclude
        private int expCnt = -1;
        @GridToStringInclude
        private int rcvdCnt;
        private boolean hasRes;

        PrimaryRequestState(GridNearAtomicAbstractUpdateRequest req, List<ClusterNode> nodes, boolean single) {
            assert (req != null && req.nodeId() != null) : req;
            this.req = req;
            if (req.initMappingLocally()) {
                if (single) {
                    if (nodes.size() > 1) {
                        this.mappedNodes = U.newHashMap(nodes.size() - 1);
                        for (int i = 1; i < nodes.size(); ++i) {
                            this.mappedNodes.put(nodes.get(i).id(), new NodeResult(false));
                        }
                    } else {
                        this.mappedNodes = Collections.emptyMap();
                    }
                } else {
                    this.mappedNodes = new HashMap<UUID, NodeResult>();
                    for (int i = 1; i < nodes.size(); ++i) {
                        this.mappedNodes.put(nodes.get(i).id(), new NodeResult(false));
                    }
                }
                this.expCnt = this.mappedNodes.size();
            }
        }

        void resetLocalMapping() {
            assert (this.req.initMappingLocally()) : this.req;
            this.mappedNodes = null;
            this.expCnt = -1;
            this.req.needPrimaryResponse(true);
        }

        UUID primaryId() {
            return this.req.nodeId();
        }

        void addMapping(List<ClusterNode> nodes) {
            assert (this.req.initMappingLocally());
            for (int i = 1; i < nodes.size(); ++i) {
                this.mappedNodes.put(nodes.get(i).id(), new NodeResult(false));
            }
            this.expCnt = this.mappedNodes.size();
        }

        DhtLeftResult checkDhtNodes(GridCacheContext cctx) {
            assert (this.req.initMappingLocally()) : this.req;
            if (this.finished()) {
                return DhtLeftResult.NOT_DONE;
            }
            boolean finished = false;
            for (Map.Entry<UUID, NodeResult> e : this.mappedNodes.entrySet()) {
                NodeResult res = e.getValue();
                if (res.rcvd) continue;
                UUID nodeId = e.getKey();
                if (cctx.discovery().alive(nodeId)) continue;
                res.rcvd = true;
                ++this.rcvdCnt;
                if (!this.finished()) continue;
                finished = true;
                break;
            }
            if (finished) {
                return DhtLeftResult.DONE;
            }
            if (this.rcvdCnt == this.expCnt) {
                return !this.req.needPrimaryResponse() ? DhtLeftResult.ALL_RCVD_CHECK_PRIMARY : DhtLeftResult.NOT_DONE;
            }
            return DhtLeftResult.NOT_DONE;
        }

        private boolean finished() {
            if (this.req.writeSynchronizationMode() == CacheWriteSynchronizationMode.PRIMARY_SYNC) {
                return this.hasRes;
            }
            return this.expCnt == this.rcvdCnt && this.hasRes;
        }

        @Nullable
        GridNearAtomicAbstractUpdateRequest onPrimaryFail() {
            if (this.finished() || this.req.nodeFailedResponse()) {
                return null;
            }
            if (this.req.fullSync() && !this.req.nodeFailedResponse()) {
                this.req.resetResponse();
                return this.req;
            }
            return this.req.response() == null ? this.req : null;
        }

        @Nullable
        GridNearAtomicAbstractUpdateRequest processPrimaryResponse(UUID nodeId, GridNearAtomicUpdateResponse res) {
            assert (this.req.nodeId().equals(nodeId));
            if (res.nodeLeftResponse()) {
                return this.onPrimaryFail();
            }
            if (this.finished()) {
                return null;
            }
            return this.req.response() == null ? this.req : null;
        }

        DhtLeftResult onDhtNodeLeft(UUID nodeId) {
            if (this.req.writeSynchronizationMode() != CacheWriteSynchronizationMode.FULL_SYNC || this.mappedNodes == null || this.finished()) {
                return DhtLeftResult.NOT_DONE;
            }
            NodeResult res = this.mappedNodes.get(nodeId);
            if (res != null && !res.rcvd) {
                res.rcvd = true;
                ++this.rcvdCnt;
                if (this.rcvdCnt == this.expCnt) {
                    if (this.hasRes) {
                        return DhtLeftResult.DONE;
                    }
                    return !this.req.needPrimaryResponse() ? DhtLeftResult.ALL_RCVD_CHECK_PRIMARY : DhtLeftResult.NOT_DONE;
                }
            }
            return DhtLeftResult.NOT_DONE;
        }

        boolean onDhtResponse(UUID nodeId, GridDhtAtomicNearResponse res) {
            assert (this.req.writeSynchronizationMode() == CacheWriteSynchronizationMode.FULL_SYNC) : this.req;
            if (this.finished()) {
                return false;
            }
            if (res.hasResult()) {
                this.hasRes = true;
            }
            if (this.mappedNodes == null) {
                assert (this.expCnt == -1) : this.expCnt;
                this.mappedNodes = new HashMap<UUID, NodeResult>();
                this.mappedNodes.put(nodeId, new NodeResult(true));
                ++this.rcvdCnt;
                return false;
            }
            NodeResult nodeRes = this.mappedNodes.get(nodeId);
            if (nodeRes != null) {
                if (nodeRes.rcvd) {
                    return false;
                }
                nodeRes.rcvd = true;
                ++this.rcvdCnt;
            } else {
                if (!this.hasRes) {
                    this.expCnt = -1;
                }
                this.mappedNodes.put(nodeId, new NodeResult(true));
                ++this.rcvdCnt;
            }
            return this.finished();
        }

        boolean onPrimaryResponse(GridNearAtomicUpdateResponse res, GridCacheContext cctx) {
            assert (!this.finished()) : this;
            this.hasRes = true;
            boolean onRes = this.req.onResponse(res);
            assert (onRes);
            if (res.error() != null || res.remapTopologyVersion() != null) {
                this.expCnt = -1;
                return true;
            }
            assert (res.returnValue() != null) : res;
            if (res.mapping() != null) {
                this.initMapping(res.mapping(), cctx);
            }
            return this.finished();
        }

        private void initMapping(List<UUID> nodeIds, GridCacheContext cctx) {
            assert (this.rcvdCnt <= nodeIds.size());
            this.expCnt = nodeIds.size();
            if (this.mappedNodes == null) {
                this.mappedNodes = U.newHashMap(nodeIds.size());
            }
            for (int i = 0; i < nodeIds.size(); ++i) {
                UUID nodeId = nodeIds.get(i);
                if (this.mappedNodes.containsKey(nodeId)) continue;
                NodeResult res = new NodeResult(false);
                this.mappedNodes.put(nodeId, res);
                if (cctx.discovery().node(nodeId) != null) continue;
                res.rcvd = true;
                ++this.rcvdCnt;
            }
        }

        public String toString() {
            HashSet<UUID> rcvd = null;
            HashSet<UUID> nonRcvd = null;
            if (this.mappedNodes != null) {
                for (Map.Entry<UUID, NodeResult> e : this.mappedNodes.entrySet()) {
                    if (e.getValue().rcvd) {
                        if (rcvd == null) {
                            rcvd = new HashSet<UUID>();
                        }
                        rcvd.add(e.getKey());
                        continue;
                    }
                    if (nonRcvd == null) {
                        nonRcvd = new HashSet<UUID>();
                    }
                    nonRcvd.add(e.getKey());
                }
            }
            return "Primary [id=" + this.primaryId() + ", opRes=" + this.hasRes + ", expCnt=" + this.expCnt + ", rcvdCnt=" + this.rcvdCnt + ", primaryRes=" + (this.req.response() != null) + ", done=" + this.finished() + ", waitFor=" + nonRcvd + ", rcvd=" + rcvd + ']';
        }
    }

    static class NodeResult {
        boolean rcvd;

        NodeResult(boolean rcvd) {
            this.rcvd = rcvd;
        }

        public String toString() {
            return "Result [rcvd=" + this.rcvd + ']';
        }
    }
}

